<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('online');
global $core, $db, $user, $lang, $online_conf;
$core->loadblockLang('online');
$conclusion = '';
if ($online_conf['on']) {
    foreach ($core->auth->groups_array as $gid => $groups) {
        $color[$gid] = $groups['color'];
        $gname[$gid] = $groups['name'];
    }
    $on = $core->select_data('online', false, false, 'o.*, p.nick', 'AS o LEFT JOIN `' . DB_PREFIX . '_users` AS p ON (o.uid=p.id)');
    while ($online = $db->getRow($on)) {
        $onn[] = array($online['nick'], $online['ip'], $online['url'], $online['uid'], $online['group']);
    }
    if (!empty($onn)) {
        $guests = 0;
        foreach ($onn as $info) {
            $group = $info[4];
            if ($group == $user['guestGroup']) {
                $guests++;
            } elseif ($group != $user['botGroup']) {
                $users[] = $info;
            } elseif ($group == $user['botGroup']) {
                $bots[] = $info;
            }
        }
        if ($online_conf['user'] == "1") {
            if (!empty($users)) {
                $nUs = count($users);
                $perColU = ceil($nUs / 2);
                $conclusion .= '<b>' . $lang['online_user_on'] . '</b>
<table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;">
   <tr>
      <td style="vertical-align: top;">';
                $n = 0;
                foreach ($users as $uInfo) {
                    $n++;
                    $Gname = $gname[$uInfo[4]] ?? '';
                    $Color = $color[$uInfo[4]] ?? '';
                    $conclusion .= '<a href="profile/' . $uInfo[0] . '" title="' . $uInfo[0] . ' - ' . $Gname . '">' . colorSpan($Color, $uInfo[0]) . ' </a>';
                    if ($n == $perColU) {
                        $conclusion .= '</td>
      <td style="vertical-align: top;">';
                    }
                }
                $conclusion .= '</td>
   </tr>
</table>';
            } else {
                $conclusion .= '<b>' . $lang['online_user_empty'] . '</b><br>';
            }
        }
        if ($online_conf['bot'] == "1") {
            if (!empty($bots)) {
                $perColB = ceil(count($bots) / 2);
                $b = 0;
                $conclusion .= '<b>' . $lang['online_bot'] . '</b>
<table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;">
   <tr>
      <td style="vertical-align: top;">';
                foreach ($bots as $bInfo) {
                    $b++;
                    $conclusion .= SpiderDetect(false, $bInfo[3]);
                    if ($b == $perColB) {
                        $conclusion .= '</td>
      <td style="vertical-align: top;">';
                    }
                }
                $conclusion .= '</td>
   </tr>
</table>';
            }
        }
        if ($online_conf['guest'] == "1") $conclusion .= '<b>' . $lang['online_guest_on'] . '</b> ' . $guests;
    }
    if ($online_conf['top'] == "1") {
        $usr = $core->select_data('users', 'last_visit >= "' . (time() - 86400) . '"', ' ORDER BY last_visit DESC LIMIT ' . $online_conf['top_numb']);
        if ($db->numRows($usr) > 0) {
            $conclusion .= '<br /><br /><b>' . $online_conf['top_numb'] . $lang['online_top_on'] . ':</b>
<table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;">
   <tr>
      <td style="vertical-align: top;">';
            $y = 0;
            $perColY = ceil($db->numRows($usr) / 2);
            while ($rows = $db->getRow($usr)) {
                $y++;
                $Gname = $gname[$rows['group']] ?? '';
                $Color = $color[$rows['group']] ?? '';
                $conclusion .= '<a href="profile/' . $rows['nick'] . '" title="' . $rows['nick'] . ' - ' . $Gname . '">' . colorSpan($Color, $rows['nick']) . ' </a><br />';
                if ($y == $perColY) {
                    $conclusion .= '</td>
      <td style="vertical-align: top;">';
                }
            }
            $conclusion .= '</td>
   </tr>
</table>';
        }
    }
    if ($online_conf['old']) {
        echo $conclusion;
    } else {
        $core->tpl->loadFile('blocks/online');
        $core->tpl->setVar('CONTENT', $conclusion);
        $core->tpl->end();
    }
} else {
    if ($online_conf['info_off']) $core->tpl->info($lang['online_off']);
}