<?php

/*
  * @name        JMY CMS
  * @link        https://jmy.su/
  * @copyright   Copyright (C) 2012-2025 JMY LTD
  * @license     LICENSE.txt (see attached file)
  * @version     VERSION.txt (see attached file)
  * @author      Orlov Alexsey
  */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('question');
global $db, $config, $core, $lang, $question_conf;
$core->loadblockLang('question');
$question_reply = $lang['question_reply'];
$question_online = $lang['question_online'];
$question_offline = $lang['question_offline'];
$guestbook_there = $lang['guestbook_there'];
$guestbook_answer = $lang['guestbook_answer'];
$guestbook_answera = $lang['guestbook_answera'];
$guestbook_answerv = $lang['guestbook_answerv'];
$question_reply_0 = $lang['question_reply_0'];
$question_reply_1 = $lang['question_reply_1'];
$query = $db->query("SELECT q.*, u.nick FROM " . DB_PREFIX . "_help AS q LEFT JOIN " . DB_PREFIX . "_users AS u ON (q.uid = u.id)	LIMIT " . $question_conf['num'] . "");
if ($question_conf['on']) {
    if ($db->numRows($query) > 0) {
        while ($row = $db->getRow($query)) {
            $id = $row['id'];
            $rows = $db->getRow($db->query("SELECT * FROM `" . DB_PREFIX . "_users`"));
            $replies = $db->getRow($db->query("SELECT r.*, u.nick FROM " . DB_PREFIX . "_help_replies AS r LEFT JOIN " . DB_PREFIX . "_users AS u ON (r.uid = u.id) WHERE r.to = '" . $row['id'] . "'"));
            list($r_num) = $db->fetchRow($db->query("SELECT COUNT(*)  FROM " . DB_PREFIX . "_help_replies AS r LEFT JOIN " . DB_PREFIX . "_users AS u ON (r.uid = u.id) WHERE r.to = '" . $row['id'] . "'"));
            $r_numb = declension($r_num, array($guestbook_answer, $guestbook_answera, $guestbook_answerv)) . ' ';
            $rep_numb = ($r_num == 0) ? '' : $r_num;
            if (!empty($rows['nick'])) $onn[] = '<a href="profile/' . $rows['nick'] . '" >' . $rows['nick'] . '</a>';
            if ($question_conf['old']) {
                echo '<div class="top"><i><img src="' . avatar($rows['id']) . '" style="width:50px; height: 50px;" style="border:0" alt="' . $rows['nick'] . '"/><a href="help/view/' . $row['id'] . '" title = "' . $question_reply . '">' . $row['title'] . '</a><br/><br/></div>';
            } else {
                $core->tpl->loadFile('blocks/question');
                $core->tpl->setVar('ID', $row['id']);
                $core->tpl->setVar('UID', $row['uid']);
                $core->tpl->setVar('AVATAR', avatar($rows['id']));
                $core->tpl->setVar('AUTHOR', $rows['name']);
                $core->tpl->setVar('NICK', $rows['nick']);
                $core->tpl->setVar('TITLE', $row['title']);
                $core->tpl->setVar('QUESTION', $row['question']);
                $core->tpl->setVar('REPLIES', (!empty($row['replies']) ? $replies['text'] : $question_reply_0));
                $core->tpl->sources = preg_replace_callback("#\\{%MORE%\\}(.*?)\\{/%MORE%\\}#is",
                    function ($matches) use ($id) {
                        if ($id) return format_link($matches[1], '/help/view/"' . $id . '"');
                    }, $core->tpl->sources);
                $core->tpl->setVar('DATE', formatDate($row['time'], true));
                $core->tpl->setVar('REPLY', (!empty($row['replies']) ? $question_reply_1 : $question_reply_0));
                $core->tpl->setVar('ONLINE_USER', (empty($onn) ? ($core->auth->isUser ? '<a href="profile/' . $rows['nick'] . '" title="' . $rows['nick'] . '">' . $rows['nick'] . '</a>' : '...') : implode(', ', $onn)));
                $core->tpl->setVar('USER_URL', 'profile/' . $rows['nick']);
                $core->tpl->setVar('REPLY_URL', '/help/view/' . $row['id']);
                $core->tpl->setVar('EMAIL', $rows['email']);
                $core->tpl->setVar('REPLY_FLAG', (!empty($rep_numb) ? $guestbook_there . $r_numb . '!' : $question_reply_0));
                $core->tpl->setVar('ONLINE', ($core->isOnline($rows['id']) ? $question_online : formatDate($rows['last_visit'], true)));
                $core->tpl->setVar('OFFLINE', ($core->isOffline($rows['id']) ? $question_offline : formatDate($rows['last_visit'], true)));
                $core->tpl->sources = preg_replace_callback("#\\[online\\](.*?)\\[/online\\]#is", function ($matches) use ($rows) {
                    if ($rows['last_visit'] + 500 >= time()) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[offline\\](.*?)\\[/offline\\]#is", function ($matches) use ($core, $rows) {
                    if ($core->isOffline($rows['id'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[reply\\](.*?)\\[/reply\\]#is", function ($matches) use ($row) {
                    if (!empty($row['replies'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[not_reply\\](.*?)\\[/not_reply\\]#is", function ($matches) use ($row) {
                    if (empty($row['replies'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->end();
            }
        }
    } else {
        $core->tpl->info($lang['question_list_empty']);
    }
} else {
    if ($question_conf['info_off']) $core->tpl->info($lang['question_off']);
}