<?php

/*
  * @name        JMY CMS
  * @link        https://jmy.su/
  * @copyright   Copyright (C) 2012-2025 JMY LTD
  * @license     LICENSE.txt (see attached file)
  * @version     VERSION.txt (see attached file)
  * @author      Orlov Alexsey
  */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $core, $config, $db, $lang;
$core->loadblockLang('rss');
$query = $core->select_data('feed', 'active = 1', 'id ASC');
if ($db->numRows($query) > 0) {
    while ($feed = $db->getRow($query)) {
        $tags = '[' . $feed['tags'] . '] {%' . $feed['tags'] . '%} [/' . $feed['tags'] . ']';
        $dir = 'usr/tpl/' . $config['tpl'] . '/informer/' . $feed['templ'];
        if (!search_tags($dir, $tags)) {
            $core->tpl->info(str_replace('[template]', $feed['templ'], $lang['feed_tags_false']));
        } else {
            $templ = str_replace(".tpl", "", $feed['templ']);
            $result = getFeed($feed['url'], $feed['nmax'], $feed['tmax'], $feed['dmax'], $feed['date_format']);
            $core->tpl->loadFile('informer/' . $templ);
            $core->tpl->setVar($feed['tags'], $result);
            if ($feed['tags']) $core->tpl->setVar('SOURSE', $feed['sourse']);
            if ($_SERVER['QUERY_STRING'] == 'url=feed') {
                $core->tpl->setVar('ID', '');
                $core->tpl->setVar('DATE', '');
            }
            $core->tpl->end();
        }
    }
} else {
    $core->tpl->info($lang['feed_list_empty']);
}