<?php

/*
  * @name        JMY CMS
  * @link        https://jmy.su/
  * @copyright   Copyright (C) 2012-2025 JMY LTD
  * @license     LICENSE.txt (see attached file)
  * @version     VERSION.txt (see attached file)
  * @author      Orlov Alexsey
  */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('system');
global $core, $db, $lang, $system_conf;
$core->loadblockLang('system');
include(ROOT . 'etc/db.config.php');
$resource = mysqli_connect($dbhost, $dbuser, $dbpass);
$query = 'SELECT ROUND((SUM(DATA_LENGTH)+SUM(INDEX_LENGTH))/1024/1024,2) AS size FROM information_schema.tables WHERE table_schema = "' . $dbname . '"';
$item = mysqli_fetch_array(mysqli_query($resource, $query));
$dbsize = '' . $item['size'] . ' Mb';
if ($system_conf['on']) {
    /*
     * Установка предупреждений
     */
    $php = phpversion() < '5.1.0' ? 'red' : 'green';
    $MySQLVersion = mysqli_fetch_array(mysqli_query($resource, 'SELECT VERSION()'));
    $mysql = $MySQLVersion[0] < '4.4.4' ? 'red' : 'green';
    $post_size = SubStr(ini_get('post_max_size'), 0, -1) < '8' ? 'red' : 'green';
    $execution = ini_get('max_execution_time') < '30' ? 'red' : 'green';
    $register = ini_get('register_globals') ? 'red' : 'green';
    $safe_mode = !ini_get('safe_mode') ? 'red' : 'green';
    $magic_quotes = !ini_get('magic_quotes_gpc') ? 'red' : 'green';
    $dbSize = formatfilesize($dbsize);
    $db_color = $item > 0 ? 'red' : 'green';
    /*
     * Вывод блока
     */
    if ($system_conf['old']) {
        echo '<div style="text-align:left" class="padding"> ' . $lang['php_version'] . colorSpan($php, phpversion()) . '</div>
              <div style="text-align:left" class="padding"> ' . $lang['mysql_version'] . colorSpan($mysql, $MySQLVersion[0]) . '</div>
              <div style="text-align:left" class="padding">' . $lang['post_size'] . colorSpan($post_size, ini_get('post_max_size')) . '</div>
              <div style="text-align:left" class="padding"> ' . $lang['execution'] . colorSpan($execution, ini_get('max_execution_time')) . '</div>
              <div style="text-align:left" class="padding">' . $lang['glob_reg'] . colorSpan($register, (ini_get('register_globals') ? 'on' : 'off')) . '</div>
              <div style="text-align:left" class="padding">' . $lang['safe_mode'] . colorSpan($safe_mode, (ini_get('safe_mode') ? 'on' : 'off')) . '</div>
              <div style="text-align:left" class="padding">' . $lang['safe_mode'] . colorSpan($safe_mode, (ini_get('safe_mode') ? 'on' : 'off')) . '</div>
              <div style="text-align:left" class="padding">' . $lang['database'] . colorSpan($db_color, $dbSize) . '</div>';
    } else {
        $core->tpl->loadFile('blocks/system');
        $core->tpl->setVar('VPHP', phpversion());
        $core->tpl->setVar('VMYSQL', $MySQLVersion[0]);
        $core->tpl->setVar('SPOST', ini_get('post_max_size'));
        $core->tpl->setVar('TEXECUT', ini_get('max_execution_time'));
        $core->tpl->setVar('GREG', (ini_get('register_globals') ? 'on' : 'off'));
        $core->tpl->setVar('SAFEM', (ini_get('safe_mode') ? 'on' : 'off'));
        $core->tpl->setVar('MQUOT', (ini_get('magic_quotes_gpc') ? 'on' : 'off'));
        $core->tpl->setVar('DBANK', $dbSize);
        $core->tpl->setVar('COLOR_VPHP', $php);
        $core->tpl->setVar('COLOR_VMYSQL', $mysql);
        $core->tpl->setVar('COLOR_SPOST', $post_size);
        $core->tpl->setVar('COLOR_TEXECUT', $execution);
        $core->tpl->setVar('COLOR_GREG', $register);
        $core->tpl->setVar('COLOR_SAFEM', $safe_mode);
        $core->tpl->setVar('COLOR_MQUOT', $magic_quotes);
        $core->tpl->end();
    }
} else {
    if ($system_conf['info_off']) $core->tpl->info($lang['system_off']);
}