<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('tags');
global $core, $db, $lang, $cache, $tags_conf;
$core->loadblockLang('tags');
$tag_query = $core->select_data('tags', 'module = "news"', false, 'tag');
$tags = array();
if ($tags_conf['on']) {
    if ($db->numRows($tag_query) > 0) {
        while ($tag = $db->getRow($tag_query)) {
            $tags[] = $tag['tag'];
        }
        $tag_cloud = new TagsCloud;
        $tags_list = $tag_cloud->get_cloud($tags);
        $tag_count = 0;
        $tagContent = $cache->do_get('tags_block_' . $core->lang);
        $tagContent = '';
        foreach ($tags_list as $tag) {
            $tag_count++;
            if ($tag_count < $tags_conf['num']) $tagContent .= $tag;
        }
        if ($tag_count >= $tags_conf['num']) $tagContent .= '<div style="text-align:right"><a href="/news/tags" title="' . $lang['all_tags'] . '">' . $lang['all_tags'] . '</a></div>';
        $cache->do_put('tags_block_' . $core->lang, $tagContent, 3600);
        if ($tags_conf['old']) {
            echo $tagContent;
        } else {
            $core->tpl->loadFile('blocks/tags');
            $core->tpl->setVar('TAGS', $tagContent);
            $core->tpl->setVar('tcount', $tag_count);
            $core->tpl->end();
        }
    } else {
        $core->tpl->info($lang['tags_list_empty']);
    }
} else {
    if ($tags_conf['info_off']) $core->tpl->info($lang['tags_off']);
}