<?php

/*
  * @name        JMY CMS
  * @link        https://jmy.su/
  * @copyright   Copyright (C) 2012-2025 JMY LTD
  * @license     LICENSE.txt (see attached file)
  * @version     VERSION.txt (see attached file)
  * @author      Orlov Alexsey
  */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('topnews');
global $config, $db, $core, $news_conf, $topnews_conf, $headTag, $lang;
$core->loadblockLang('topnews');
$query = $db->query("SELECT c.*, l.* FROM " . DB_PREFIX . "_news as c LEFT JOIN " . DB_PREFIX . "_langs as l on(l.postId=c.id and l.module='news' and active = 1) WHERE l.lang = '" . $config['lang'] . "'	ORDER BY  " . $topnews_conf['choice'] . " " . $topnews_conf['sort'] . " LIMIT " . $topnews_conf['num']);
if ($db->numRows($query) > 0) {
    while ($news = $db->getRow($query)) {
        if ($topnews_conf['on']) {
            if ($topnews_conf['old']) {
                echo '<div class="top"><i><a href="/news/' . $news['altname'] . '.html">' . $news['title'] . '</a></br></div>';
            } else {
                $tag_list = explode(', ', $news['tags']);
                $tag_count = 0;
                $tags = false;
                foreach ($tag_list as $tag) {
                    $tag_count++;
                    if ($tag_count < ($news_conf['tags_num'] + 1)) $tags .= '<a href="news/tags/' . $tag . '" title="' . $tag . '">' . ($headTag == $tag ? '<strong>' . $tag . '</strong>' : $tag) . '</a>, ';
                }
                if ($topnews_conf['choice'] == 'id') {
                    $sort = $news['id'];
                } elseif ($topnews_conf['choice'] == 'views') {
                    $sort = $news['views'];
                } elseif ($topnews_conf['choice'] == 'votes') {
                    $sort = $news_conf['carma_summ'] ? ((intval($news['score']) - $news['votes']) > 0 ? '<span class="rating_plus">+' . (intval($news['score']) - $news['votes']) . '</span>' : ((intval($news['score']) - $news['votes']) == 0 ? '<span class="rating_zero">0</span>' : '<span class="rating_minus">' . (intval($news['score']) - $news['votes']) . '</span>')) : (($news['score'] + $news['votes']) > 0 ? '<span class="rating_plus">' . ($news['score'] > 0 ? '+' . intval($news['score']) : intval($news['score'])) . '</span> <span class="rating_minus">' . ($news['votes'] > 0 ? '-' . $news['votes'] : $news['votes']) . '</span>' : '<span class="rating_zero">0</span>');
                } else {
                    $sort = '';
                }
                $catInfo = $news['cat'] !== ',0,' ? $core->catInfo('news', $news['cat']) : '';
                $cat = $news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'short', 3) : '';
                $news_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
                $cat_one = $news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'altname', 1) : 'index';
                $core->tpl->loadFile('blocks/topnews');
                $core->tpl->setVar('id', $news['id']);
                $core->tpl->setVar('TITLE', $news['title']);
                $core->tpl->setVar('ATITLE', $news['altname']);
                $core->tpl->setVar('FULL_LINK', $news_link . $news['altname'] . ".html");
                $core->tpl->setVar('CATEGORY', $cat);
                $core->tpl->setVar('CAT_ONE', $cat_one);
                $core->tpl->setVar('TAGS', mb_substr($tags, 0, -2));
                $core->tpl->setVar('AUTHOR', '<a href="profile/' . $news['author'] . '" title="' . $lang['topnews_page'] . ': ' . $news['author'] . '">' . $news['author'] . '</a>');
                $core->tpl->setVar('sort', $sort);
                $core->tpl->setVar('ICON', isset($catInfo['icon']) ? $core->getCatImg($news_link, $catInfo['icon'], $catInfo['title']) : '');
                $core->tpl->sources = preg_replace_callback("#\\[id\\](.*?)\\[/id\\]#is", function ($matches) use ($topnews_conf) {
                    if ($topnews_conf['choice'] == 'id') return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[views\\](.*?)\\[/views\\]#is", function ($matches) use ($topnews_conf) {
                    if ($topnews_conf['choice'] == 'views') return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[votes\\](.*?)\\[/votes\\]#is", function ($matches) use ($topnews_conf) {
                    if ($topnews_conf['choice'] == 'votes') return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->end();
            }
        } else {
            if ($topnews_conf['info_off']) $core->tpl->info($lang['topnews_off']);
        }
    }
} else {
    $core->tpl->info($lang['topnews_list_empty']);
}