<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_SWITCH')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $board_conf, $lang;
switch ($url[3] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = '';
        $order = '';
        $whereC = $where;
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
        $s_active = isset($_POST['s_active']) ? true : false;
        $s_search = isset($_POST['s_search']) ? true : false;
        if ($s_search) {
            if ($_POST['s_search'] == 1) {
                location(ADMIN . '/module/board/');
            } else {
                $s_search = false;
            }
        } else {
            $s_search = true;
        }
        $forum_discovered_fatal = '';
        if ($s_active) {
            if ($_POST['s_active'] == 1) {
                $where .= ' `active` = 1 ';
            } else {
                $s_active = false;
                $where .= ' `active` = 0 ';
            }
        } else {
            $s_active = true;
        }
        if ($s_id) {
            $where .= 'AND `id` LIKE "%' . $db->safesql($s_id) . '%"';
        } else {
            $s_id = '';
        }
        if ($s_title) $where .= 'AND `title` LIKE "%' . $db->safesql($s_title) . '%"';
        if (isset($_POST['s_type'])) $where .= $_POST['s_type'] == false ? 'AND  `pid` = 0' : 'AND `type` LIKE "%' . $db->safesql($_POST['s_type']) . '%"';
        if (isset($url[3]) && $url[3] == 'order') {
            switch ($url[4]) {
                case 'abc':
                    $order .= 'title ASC';
                    break;
                case 'pid':
                    $order .= 'pid DESC';
                    break;
                case 'id':
                    $order .= 'id ASC';
                    break;
            }
        } else {
            $order .= 'id DESC';
        }
        $query = $core->select_data('board_forums', $where, $order . ' LIMIT ' . limit_page(), '`id`, `title`, `type`, `pid`, `position`, `active`, `rulestitle`');
        while ($rows = $db->getRow($query)) {
            $cat_get[$rows['id']] = array($rows['title'], $rows['pid'], $rows['position'], $rows['type'], $rows['active'], $rows['rulestitle']);
        }
        $adminTpl->admin_head($lang['modules'] . ' | ' . $lang['forum']);
        if (isset($cat_get)) {
            foreach ($cat_get as $cid => $sub_arr) {
                if ($cid != $sub_arr[1]) {
                    $cats_arr[$cid] = array($sub_arr[0], $sub_arr[0]);
                    $flag = isset($sub_arr[1]) ? $sub_arr[1] : false;
                    while ($flag > 0) {
                        $cats_arr[$cid] = array($cat_get[$flag][0] . " / " . $cats_arr[$cid][0], $sub_arr[0]);
                        $flag = $cat_get[$flag][1];
                    }
                    $forum_discovered_fatal = false;
                } else {
                    $forum_discovered_fatal = true;
                }
            }
            asort($cats_arr);
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            if ($forum_discovered_fatal) $adminTpl->alert('danger', $lang['error'], $lang['forum_discovered_fatal'] . $lang['forum'] . ' & ensp;' . $cid . $lang['forum_own_subforum'] . ' & ensp; <a href = \'{MOD_LINK}/correction/' . $cid . '\'">' . colorSpan('blue', '<b>Исправить</b>') . '</a>');
            alert_info('board');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['forum_list'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
         <header>
<table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="col-md-2 text-center"></th>
                        <th class="col-md-4 text-left">' . $lang['title'] . '</th>
                        <th class="col-md-2 text-center">' . $lang['type'] . '</th>
                        <th style="position: absolute; left: 87%; top: 5px; "class="text-center">' . faSpan('fa-list', true, false, false, $lang['that']) . '</th>
                        <th style="position: initial; left: 77%; top: 5px;" class="text-center">' . faSpan('fa-comments-o', true, false, false, $lang['message']) . '</th>
                        </tr>
                  </thead>
                  <tbody>
               </table>
</header>
               <div class="dc">
                  <ol class="dc-list">';
            echo ShowTree();
            echo '</ol>
               </div>
            </div>
            <div class="panel-footer-lines"></div>
         <script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
         <script src = "https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
         <script>
            $(\'.sortable-ul\').sortable({
            stop: function() {
                $.ajax({
                    url: \'/administration/module/board/save_position\',
                    method: \'post\',
                    data: $(\'.sortable-ul input\').serialize()
                });
            }
            });
         </script>';
            if ($s_search == false) {
                echo ' <div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['forum_list'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th class="col-md-4 text-center">' . $lang['title'] . '</th>
                        <th class="col-md-2 text-center">' . $lang['forum_type'] . '</th>
                        <th class="text-center">' . faSpan('fa-list', true, false, false, $lang['that']) . '</th>
                        <th class="text-center">' . faSpan('fa-comments-o', true, false, false, $lang['message']) . '</th>
                        <th class="text-center">' . faSpan('fa-map-marker', true, false, false, $lang['forum_position']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
                init_checkbox('th', false, false, true);
                echo '</tr>
                  </thead>
                  <tbody>';
                foreach ($cats_arr as $cid => $arrName) {
                    list($topics, $posts) = $db->fetchRow($db->query("SELECT COUNT(id), (SELECT COUNT(id) FROM " . DB_PREFIX . "_board_posts) as posts FROM " . DB_PREFIX . "_board_threads  WHERE forum='" . intval($cid) . "'"));
                    if ($cat_get[$cid][3] == 'cat') {
                        $type = $lang['cat'];
                        $numtopics = $topics;
                        $numposts = $posts;
                    } elseif ($cat_get[$cid][3] == 'forum') {
                        $type = $lang['forum'];
                        $numtopics = $topics;
                        $numposts = $posts;
                    } else {
                        $type = $lang['forum_parent'];
                        $numtopics = '';
                        $numposts = '';
                    }
                    $name = $arrName[0];
                    $massa = explode(' / ', $name);
                    $status_icon = $cat_get[$cid][4] == 1 ? faSpan('fa-check-circle text-success fa-md', true, false, false, $lang['actively']) : faSpan('fa-circle text-danger fa-md', true, false, false, $lang['not_actively']);
                    $active = (($cat_get[$cid][4] == 0) ? $lang['do_activation'] : $lang['do_deactivation']);
                    $status_rules = $type <> $lang['forum_parent'] ? ($cat_get[$cid][5] == false ? faSpan('fa-info', false, $lang['forum_attach_rules']) : faSpan('fa-info', false, $lang['forum_attach_rules_edit'])) : '';
                    echo '<tr>
                        <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $cid . '</td>
                        <td class="text-center">' . $name . '</td>
                        <td class="text-center">' . $type . '</td>
                        <td class="text-center">' . formatCounter($numtopics) . '</td>
                        <td class="text-center">' . formatCounter($numposts) . '</td>
                        <td class="text-center">' . (count($massa) < 3 ? '<input name="posit[' . $cid . ']" value="' . $cat_get[$cid][2] . '" class="form-control"  style="width: 50px;padding: 20px;" data-parsley-required="true" data-parsley-trigger="change" "' . (!eregStrt(' / ', $name) ? 'font-weight: bold;' : '') . '">' : $lang['forum_no_opt']) . '
                        </td>
                        <td class="text-center">' . $status_icon . '</td>';
                    init_checkbox('td', $cid, false, '<li><a href="{MOD_LINK}/section_add/' . $cid . '">' . faSpan('fa-code-fork', true, $lang['forum_add_section']) . '</a></li>
                                 ' . (($status_rules) ? '<li><a href="{MOD_LINK}/rules/' . $cid . '">' . $status_rules . ' </a></li>' : '') . '
                                 <li><a href="{MOD_LINK}/edit_forum/' . $cid . '/1">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="{MOD_LINK}/permis/' . $cid . '">' . faSpan('fa-key', true, $lang['change_law']) . '</a></li>
                                 <li><a href="{MOD_LINK}/resetrules/' . $cid . '">' . faSpan('fa-recycle', true, $lang['reset_rules']) . '</a></li>
                                 <li><a href="{MOD_LINK}/retivate/' . $cid . '">' . faSpan('fa-ban', true, $active) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $cid . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                    echo '</tr>';
                    modal_form_delete($cid, $name, $lang['forum_delete'] . '- ' . $name, 'name', $lang['forum_del_text'], '{MOD_LINK}/delete/' . $cid);
                }
                echo '</tbody>';
                init_tfoot('<option value="sort">' . $lang['sortirovani'] . '</option>
                            <option value="activate">' . $lang['do_activation'] . '</option>
                            <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                            <option value="resetrules">' . $lang['reset_rules'] . '</option>
                            <option value="delete">' . $lang['delete'] . '</option>
                            <input type="hidden" name="fid[]" value="' . $cid . '">
                            <input type="hidden" name="permissions[]" value="' . $cid . '">');
                echo '</table>
            </form>
         </div>
      </div>';
            }
            page_list('urs', 'board', 'board_forums', $whereC);
            echo '</div></div>
      <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
         <form id="search" name="search" role="form" method="POST" action=""> 
            <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
               <h4 class="text-left pt10";>' . $lang['quick_search'] . '</h4>
               <hr class="short">
               <div class="section mb5">
               <label for="s_type" class="field prepend-icon">
                  <select id="s_type" name="s_type" class="form-control">
                     <option value="">' . $lang['forum_type_pre'] . '</option>
                     <option value="0">' . $lang['forum_parent'] . '</option>
                     <option value="cat">' . $lang['cat'] . '</option>
                     <option value="forum">' . $lang['forum'] . '</option>
                  </select>
               ' . faI('arrow double') . '
               </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['news_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['forum_active'] . '</label>
            </div>
            <hr class="short">
            <div class="section pl5">
               <button type="submit" name="s_search"class="button btn-system btn-file ph30 btn-sm btn-raised legitRipple">' . $lang['search'] . '</button>
               <button type="button" onclick="window.location.href = \'{MOD_LINK}\'" class="button btn-danger btn-file ph30 btn-sm btn-raised legitRipple">' . $lang['clear'] . '</button>
            </div>
         </div>
      </form>
   </aside>';
        } else {
            list_empty('urs', 'board', 'url', $s_search, false, true);
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'add':
        forum_add();
        break;
    case 'edit_forum':
    case 'section_add':
        $id = isset($url[4]) ? intval($url[4]) : false;
        if (!empty($id)) {
            forum_add($id);
        } else {
            header('Location: /' . ADMIN . '/module/board/');
        }
        break;
    case 'cat_add':
        cat_add();
        break;
    case 'save':
        global $adminTpl;
        $title = filter($_POST['title'], 'title');
        $descr = isset($_POST['descr']) ? filter($_POST['descr']) : '';
        $edit = isset($_POST['edit']) ? filter($_POST['edit']) : '';
        $active = isset($_POST['active']) ? 1 : 0;
        $fid = isset($_POST['fid']) ? intval($_POST['fid']) : '';
        $pid = isset($_POST['pid']) ? intval($_POST['pid']) : '';
        $type = isset($_POST['type']) ? filter($_POST['type']) : '';
        if ($title) {
            if (!$edit) {
                $core->ins_data('board_forums', 'id,title,description,pid,type,active,open,threads,posts,lastPost,lastPoster,lastTid,lastSubject,password,rulestitle,rules,position', 'NULL,"' . $db->safesql(processText($title)) . '","' . $db->safesql(processText($descr)) . '","' . $pid . '", "' . $type . '", "' . $active . '", 0, 0, 0, 0, 0, 0, 0, 0, "", "", 1');
                $core->ins_log(false, $lang['logs_add_board'], 1, false, false, $title, false);
                list($fid) = $core->fetch_data('board_forums', 'title="' . $db->safesql($title) . '" AND description = "' . $db->safesql($descr) . '" AND pid = "' . $pid . '"');
                foreach ($_POST['permissions'] as $gid => $infos) {
                    $allowView[$gid] = isset($infos['allowView']) ? 1 : 0;
                    $allowRead[$gid] = isset($infos['allowRead']) ? 1 : 0;
                    $allowCreate[$gid] = isset($infos['allowCreate']) ? 1 : 0;
                    $allowReply[$gid] = isset($infos['allowReply']) ? 1 : 0;
                    $allowEdit[$gid] = isset($infos['allowEdit']) ? 1 : 0;
                    $allowModer[$gid] = isset($infos['allowModer']) ? 1 : 0;
                    $allowAttach[$gid] = isset($infos['allowAttach']) ? 1 : 0;
                    $core->ins_data('board_permissions', 'id,fid,gid,allowView,allowRead,allowCreate,allowReply,allowEdit,allowModer,allowAttach', 'NULL, "' . $fid . '", "' . $gid . '", "' . $allowView[$gid] . '", "' . $allowRead[$gid] . '", "' . $allowCreate[$gid] . '", "' . $allowReply[$gid] . '", "' . $allowEdit[$gid] . '", "' . $allowModer[$gid] . '", "' . $allowAttach[$gid] . '"');
                }
                action_alert('urs', 'success', 'board', false, 'forum_save_info');
            } else {
                if ($title && $fid && $fid != $pid) {
                    $core->upd_data('board_forums', 'title = "' . $db->safesql($title) . '", description = "' . $db->safesql($descr) . '", pid = "' . $pid . '", type = "' . $type . '", active = "' . $db->safesql($active) . '"', 'id = "' . $fid . '"');
                    if (isset($_POST['permissions'])) {
                        $core->del_data('board_permissions', 'fid = "' . $fid . '"');
                        foreach ($_POST['permissions'] as $gid => $infos) {
                            $allowView[$gid] = isset($infos['allowView']) ? 1 : 0;
                            $allowRead[$gid] = isset($infos['allowRead']) ? 1 : 0;
                            $allowCreate[$gid] = isset($infos['allowCreate']) ? 1 : 0;
                            $allowReply[$gid] = isset($infos['allowReply']) ? 1 : 0;
                            $allowEdit[$gid] = isset($infos['allowEdit']) ? 1 : 0;
                            $allowModer[$gid] = isset($infos['allowModer']) ? 1 : 0;
                            $allowAttach[$gid] = isset($infos['allowAttach']) ? 1 : 0;
                            $core->ins_data('board_permissions', 'id,fid,gid,allowView,allowRead,allowCreate,allowReply,allowEdit,allowModer,allowAttach', 'NULL, "' . $fid . '", "' . $gid . '", "' . $allowView[$gid] . '", "' . $allowRead[$gid] . '", "' . $allowCreate[$gid] . '", "' . $allowReply[$gid] . '", "' . $allowEdit[$gid] . '", "' . $allowModer[$gid] . '", "' . $allowAttach[$gid] . '"');
                        }
                    }
                    action_alert('urs', 'success', 'board', false, 'forum_upd_info');
                } else {
                    if ($pid == $fid) {
                        action_alert('urs', 'danger', 'board', false, 'forum_error_subforum');
                    } else {
                        action_alert('urs', 'danger', 'board', false, 'forum_save_error');
                    }
                }
            }
        } else {
            action_alert('urs', 'danger', 'board', false, 'forum_save_error');
        }
        break;
    case 'save_position':
        $dbh = init_pdo();
        if (!empty($_POST['position'])) {
            foreach ($_POST['position'] as $i => $row) {
                $sth = $dbh->prepare("UPDATE `" . DB_PREFIX . "_board_forums` SET `position` = :position WHERE `id` = :id");
                $sth->execute(array('position' => ++$i, 'id' => intval($row)));
            }
        }
        break;
    case 'retivate':
        $id = isset($url[4]) ? intval($url[4]) : false;
        if (!empty($id)) {
            $rows = $core->row_data('board_forums', 'id = "' . $id . '"');
            $active = $rows['active'] == 0 ? 1 : 0;
            $core->upd_data('board_forums', 'active = "' . $active . '"', 'id = "' . $id . '"');
            header('Location: /' . ADMIN . '/module/board');
        } else {
            action_alert('urs', 'danger', 'board', false, 'unknown_error');
        }
        break;
    case 'delete_rules':
        $id = isset($url[4]) ? intval($url[4]) : false;
        if (!empty($id)) {
            $core->upd_data('board_forums', 'rulestitle = false,rules = false', 'id = "' . $id . '"');
            header('Location: /' . ADMIN . '/module/board');
        } else {
            action_alert('urs', 'danger', 'board', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('board_forums', 'active = 1', 'id = "' . intval($id) . '"');
                        action_alert('urs', 'success', 'board');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('board_forums', 'active = 0', 'id = "' . intval($id) . '"');
                        action_alert('urs', 'success', 'board');
                    }
                    break;
                case 'sort':
                    if (isset($_POST['posit'])) {
                        foreach ($_POST['posit'] as $id => $posit) {
                            if ($id > 0) {
                                $core->upd_data('board_forums', 'position = "' . intval($posit) . '"', 'id = "' . intval($id) . '"');
                                action_alert('urs', 'success', 'board');
                            }
                        }
                    } else {
                        foreach ($_POST['checks'] as $id => $posit) {
                            if ($id > 0) {
                                $core->upd_data('board_forums', 'position = "' . intval($posit) . '"', 'id = "' . intval($id) . '"');
                                action_alert('urs', 'success', 'board');
                            }
                        }
                    }
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        if ($id > 0) {
                            $count = $core->sum_data('board_forums', 'pid = "' . intval($id) . '"');
                            if ($count < 1) {
                                $core->del_data('board_forums', 'id = "' . intval($id) . '"');
                                $core->del_data('board_threads', 'forum = "' . intval($id) . '"');
                                action_alert('urs', 'success', 'board', false, 'forum_del_info');
                            } else {
                                if ($core->del_data('board_forums', 'pid = "' . intval($id) . '"')) {
                                    $core->del_data('board_forums', 'id = "' . intval($id) . '"');
                                    $core->del_data('board_threads', 'forum = "' . intval($id) . '"');
                                    action_alert('urs', 'success', 'board', false, 'forum_del_info');
                                } else {
                                    action_alert('urs', 'danger', 'board', false, 'cat_forum_save_er1');
                                }
                            }
                        }
                    }
                    break;
                case 'resetrules':
                    foreach ($_POST['checks'] as $id) {
                        resetrules($id);
                        action_alert('urs', 'success', 'board');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('urs', 'danger', 'board');
        }
        break;
    case 'correction':
        $fid = isset($url[4]) ? intval($url[4]) : false;
        $core->upd_data('board_forums', 'pid = 0', 'id = "' . $fid . '"');
        action_alert('urs', 'success', 'board');
        break;
    case 'resetrules':
        $fid = isset($url[4]) ? intval($url[4]) : false;
        if ($fid) {
            resetrules($fid);
            action_alert('urs', 'success', 'board');
        } else {
            action_alert('urs', 'danger', 'board', false, 'unknown_error');
        }
        break;
    case 'permis':
        init_count_text();
        $fid = isset($url[4]) ? intval($url[4]) : false;
        $query = $core->select_data('groups', false, 'name');
        $adminTpl->admin_head($lang['modules'] . ' |' . $lang['forum'] . ' | ' . $lang['action'] . '');
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-success panel-border top">
         <div class="panel-heading">
            <span class="panel-title">Глобальная смена прав:</span>
         </div>
         <div class="heading-hr"></div>
         <form class="form-horizontal parsley-form" role="form" action="{MOD_LINK}/savePerms" method="post" data-parsley-validate>
            <div class="panel">
               <div class="panel-body pn table-responsive">
                  <div class="admin-form">
                     <table style="width=:100%; border: 0; border-spacing: 0; border-collapse: separate;" class="table table-striped">
                        <thead>
                           <tr>
                              <th><span class="pd-l-sm"></span>' . $lang['group_rights'] . '</th>
                              <th class="col-md-1" style="width: 40px">' . faSpan('fa-eye', true, false, false, $lang['view']) . '</th>
                              <th class="col-md-1" style="width: 40px">' . faSpan('fa-book', true, false, false, $lang['reading']) . '</th>
                              <th class="col-md-1" style="width: 40px">' . faSpan('fa-plus-circle', true, false, false, $lang['create']) . '</th>
                              <th class="col-md-1" style="width: 40px">' . faSpan('fa-reply-all', true, false, false, $lang['answer']) . '</th>
                              <th class="col-md-1" style="width: 40px">' . faSpan('fa-pencil', true, false, false, $lang['edit']) . '</th>
                              <th class="col-md-1" style="width: 40px">' . faSpan('fa-list-alt', true, false, false, $lang['moderation']) . '</th>
                              <th class="col-md-1" style="width: 40px">' . faSpan('fa-file', true, false, false, $lang['files']) . '</th>
                              <th class="col-md-1" style="width: 40px">' . $lang['all'] . '</th>
                           </tr>
                        </thead>
                        <tbody>';
        while ($rows = $db->getRow($query)) {
            $groups[$fid] = $core->row_data('board_permissions', 'gid = "' . $rows['id'] . '"');
            echo '<tr>
                              <td><span class="pd-l-sm"></span><b><span style="color:' . $rows['color'] . '">' . $rows['name'] . '</span></b></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][allowView]" style="border:none;" ' . checked(isset($groups[$fid]['allowView']) && $groups[$fid]['allowView'] == 1) . ' />' . faI('checkbox') . '</label></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][allowRead]" style="border:none;" ' . checked(isset($groups[$fid]['allowRead']) && $groups[$fid]['allowRead'] == 1) . ' />' . faI('checkbox') . '</label></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][allowCreate]" style="border:none;" ' . checked(isset($groups[$fid]['allowCreate']) && $groups[$fid]['allowCreate'] == 1) . ' />' . faI('checkbox') . '</label></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][allowReply]" style="border:none;" ' . checked(isset($groups[$fid]['allowReply']) && $groups[$fid]['allowReply'] == 1) . ' />' . faI('checkbox') . '</label></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][allowEdit]" style="border:none;" ' . checked(isset($groups[$fid]['allowEdit']) && $groups[$fid]['allowEdit'] == 1) . ' />' . faI('checkbox') . '</label></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][allowModer]" style="border:none;" ' . checked(isset($groups[$fid]['allowModer']) && $groups[$fid]['allowModer'] == 1) . ' />' . faI('checkbox') . '</label></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][allowAttach]" style="border:none;" ' . checked(isset($groups[$fid]['allowAttach']) && $groups[$fid]['allowAttach'] == 1) . '  />' . faI('checkbox') . '</label></td>
                              <td><label class="option block mt10"><input type="checkbox" id="permissions" name="permissions[' . $rows['id'] . '][all]" style="border:none;" value="1"/>' . faI('checkbox') . '</label></td>
                           </tr>';
        }
        echo '</tbody>
                     </table>
                  </div>
               </div>
               <div class="panel-footer">
                  <input type="hidden" name="act" value="savePerms">
                  <input type="hidden" name="fid[]" value="' . $fid . '">
                  <button  type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
                  <button  type="button" onclick="window.location.href = \'' . ADMIN . '/module/board/resetrules/' . $fid . '\'" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-recycle', false, $lang['reset_rules']) . '</button>
               </div>
         </form>
         </div>
      </div>
   </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'savePerms':
        foreach ($_POST['fid'] as $fid) {
            $core->del_data('board_permissions', 'fid = "' . $fid . '"');
        }
        foreach ($_POST['permissions'] as $gid => $infos) {
            $allowView[$gid] = isset($infos['allowView']) ? 1 : 0;
            $allowRead[$gid] = isset($infos['allowRead']) ? 1 : 0;
            $allowCreate[$gid] = isset($infos['allowCreate']) ? 1 : 0;
            $allowReply[$gid] = isset($infos['allowReply']) ? 1 : 0;
            $allowEdit[$gid] = isset($infos['allowEdit']) ? 1 : 0;
            $allowModer[$gid] = isset($infos['allowModer']) ? 1 : 0;
            $allowAttach[$gid] = isset($infos['allowAttach']) ? 1 : 0;
            foreach ($_POST['fid'] as $fid) {
                if ($fid) {
                    $core->ins_data('board_permissions', 'id,fid,gid,allowView,allowRead,allowCreate,allowReply,allowEdit,allowModer,allowAttach', 'NULL, "' . $fid . '", "' . $gid . '", "' . $allowView[$gid] . '", "' . $allowRead[$gid] . '", "' . $allowCreate[$gid] . '", "' . $allowReply[$gid] . '", "' . $allowEdit[$gid] . '", "' . $allowModer[$gid] . '", "' . $allowAttach[$gid] . '"');
                    action_alert('urs', 'success', 'board');
                } else {
                    action_alert('urs', 'danger', 'board', false, 'unknown_error');
                }
            }
        }
        break;
    case 'delete':
        $fid = isset($url[4]) ? intval($url[4]) : false;
        if ($fid) {
            $count = $core->sum_data('board_forums', 'pid = "' . $fid . '"');
            if ($count < 1) {
                $core->del_data('board_forums', 'id = "' . $fid . '"');
                $core->del_data('board_threads', 'forum = "' . $fid . '"');
                $core->del_data('board_permissions', 'fid = "' . $fid . '"');
                $core->ins_log(false, $lang['logs_add_board'], 1, false, false, $count['title'], false);
                action_alert('urs', 'success', 'board');
            } else {
                action_alert('urs', 'danger', 'board', false, 'forum_save_er1');
            }
        } else {
            action_alert('urs', 'danger', 'board', false, 'forum_save_er1');
        }
        break;
    case 'rules':
        init_count_text();
        $fid = isset($url[4]) ? intval($url[4]) : false;
        if (isset($fid)) {
            $forum = $core->row_data('board_forums', 'id = "' . $fid . '"');
            $id = $forum['id'];
            $title = $forum['rulestitle'];
            $rules = $forum['rules'];
        } else {
            $id = '';
            $title = '';
            $rules = '';
        }
        $adminTpl->admin_head($lang['modules'] . ' | ' . $lang['forum'] . ' | ' . $lang['forum_rules']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-success panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['forum_rules'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body admin-form">
            <form class="form-horizontal parsley-form" role="form" action="{MOD_LINK}/rulesSave" method="post" data-parsley-validate>
<div class="row">
  <div class="col-xs-12">
             <div class="tab-block mb25">
               <div class="panel-body">
 <div class="form-group">
                  <label for="title" class="control-label col-md-3 col-sm-4">' . $lang['titles'] . '</label>
                  <div class="col-lg-5 col-md-4 col-sm-5">
                     <label for="title" class="field prepend-icon">
                     <input id="title" type="text" name="title" value="' . $title . '" placeholder="' . $lang['forum_rules_title_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                     <label for="title" class="field-icon position-left">' . faI('fa-pencil', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
          </div>
             <div class="form-group">
                  <div class="col-lg-12 col-xs-12">
               <div class="tab-content_editor">
                  <div class="tab-pane active">
                     ' . adminArea('rules', $forum['rules'], 5, 'textarea', 'onchange="caa(this);"', true) . '
                  </div>
               </div>
            </div>
         </div>
          <span class="input-footer text-left">' . faI('fa-bell', false, $lang['forum_rules_pre'], true) . '</span>
      </div>
      </div>
         </div>
         </div>
         <div class="panel-footer">';
        if (isset($fid)) echo '<input type="hidden" name="edit" value="1"/>';
        echo '<input type="hidden" name="fid" value="' . $fid . '">
        <button name="submit" type="submit" id="sub" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
         </div>
         </form>
      </div>
   </div>
</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'rulesSave':
        $fid = isset($_POST['fid']) ? intval($_POST['fid']) : false;
        $title = isset($_POST['title']) ? filter($_POST['title']) : '';
        $rules = $_POST['rules'] ?? '';
        $core->upd_data('board_forums', 'rulestitle = "' . $db->safesql($title) . '", rules = "' . $db->safesql($rules) . '"', 'id = "' . $fid . '"');
        action_alert('urs', 'success', 'board', false, 'forum_rules_successfully');
        break;
    case 'config':
        init_count_text();
        require(ROOT . 'etc/board.config.php');
        $configBox = array(
            'board' => array(
                'varName' => 'board_conf',
                'title' => $lang['forum_title'],
                'groups' => array(
                    'main' => array(
                        'title' => $lang['forum_glob_config'],
                        'vars' => array(
                            'posts_num' => array(
                                'title' => $lang['forum_posts_page'],
                                'description' => $lang['forum_posts_per_page'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'threads_num' => array(
                                'title' => $lang['forum_topics_page'],
                                'description' => $lang['forum_topics_per_page'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'loadFiles' => array(
                                'title' => $lang['forum_allow_downloads'],
                                'description' => $lang['forum_activ_reg_loader'],
                                'content' => radio("loadFiles", $board_conf['loadFiles']),
                            ),
                        )
                    ),
                    'files_formats' => array(
                        'title' => $lang['forum_file_editor'],
                        'vars' => array(
                            'maxWH' => array(
                                'title' => $lang['forum_preview_width'],
                                'description' => $lang['forum_preview_desc'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'maxSize' => array(
                                'title' => $lang['forum_max_weight'],
                                'description' => $lang['forum_max_weight_desc'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'formats' => array(
                                'title' => $lang['forum_valid_file_formats'],
                                'description' => $lang['forum_accept_formats_download'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'seo' => array(
                        'title' => $lang['seo'],
                        'vars' => array(
                            'keywords' => array(
                                'title' => $lang['seo_keywords'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'keywords'),
                            ),
                            'description' => array(
                                'title' => $lang['seo_description'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'description'),
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'board', '{MOD_LINK}/config', $ok);
        break;
}
function forum_add($id = null): void
{
    global $adminTpl, $db, $core, $url, $lang;
    if ($url[3] == 'section_add') {
        $fid = isset($url[4]) ? intval($url[4]) : false;
        $pid = isset($_POST['pid']) ? intval($_POST['pid']) : false;
        $title = isset($_POST['title']) ? filter($_POST['title']) : '';
        $descr = isset($_POST['descr']) ? filter($_POST['descr']) : '';
        $active = isset($_POST['active']) ? intval($_POST['active']) : false;
        $type = isset($_POST['type']) ? filter($_POST['type']) : '';
        $admhead = $lang['forum_add_section'];
    } else {
        if (isset($id)) {
            $forum = $core->row_data('board_forums', 'id = "' . intval($id) . '"');
            $edit = true;
            $fid = isset($forum['id']) ? intval($forum['id']) : false;
            $pid = isset($forum['pid']) ? intval($forum['pid']) : false;
            $title = isset($forum['title']) ? filter($forum['title']) : '';
            $descr = isset($forum['description']) ? filter($forum['description']) : '';
            $active = isset($forum['active']) ? intval($forum['active']) : false;
            $type = isset($forum['type']) ? filter($forum['type']) : '';
            $admhead = $lang['forum_edit'];
        } else {
            $edit = false;
            $title = false;
            $descr = false;
            $active = false;
            $type = false;
            $admhead = $lang['forum_add'];
        }
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['add_title_err']),
            'maxlength' => array(49, str_replace('[count]', '50', $lang['count_text_err_2']))
        ),
        'descr' => array(
            'required' => array('true', $lang['add_descr_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
        'type' => array(
            'required' => array('true', $lang['add_type_err'])
        )
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($lang['modules'] . ' | ' . $lang['forum'] . ' | ' . $admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
    alert_info('banners');
    echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $admhead . '</span>
         </div>
         <div class="heading-hr"></div>
         <form id="admin-form" class="form-horizontal parsley-form" role="form" action="{MOD_LINK}/save' . '" method="post">
           <div class="panel-body pn table-responsive">
            <div class="panel-body admin-form">
                     <div class="form-group">
                        <label class="col-lg-3 col-sm-3 control-label">' . $lang['forum_names'] . '</label>
                       <div class="col-lg-5 col-md-5 col-sm-8">
                           <label for="title" class="field prepend-icon">
                           <input id="title" type="text" name="title" value="' . $title . '" onkeyup="count_down(this, \'title\', 50)" maxlength="50" placeholder="' . $lang['forum_name_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                           <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                           </label>
                           <div align="right" class="text-right">
                              <span id="char_title"></span>
                           </div>
                        </div>
                     </div>
                       <div class="form-group">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['forum_descr'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="descr" class="field prepend-icon">
                     <textarea id="descr" name="descr" onkeyup="count_down(this, \'descr\', 200)" maxlength="200" placeholder="' . $lang['forum_descr_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $descr . '</textarea>
                     <label for="descr" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                  <div align="right" class="text-right" style="width: 420px; min-width: 240px; max-width: 420px; margin: 0 auto">
                      <span id="char_descr"></span>
                  </div>
                  </div>
                  </div>
                     <div class="form-group">
                        <label class="col-lg-3 col-sm-3 control-label">' . $lang['forum_type'] . '</label>
                        <div class="col-lg-5 col-md-5 col-sm-8">
                            <label class="field select mb15">
                           <select class="form-control" name="type">
                           <option value="0" ' . ($type == '0' ? 'selected' : '') . '>' . $lang['forum_type_pre'] . '</option>
                           <option value="cat" ' . ($type == 'cat' ? 'selected' : '') . '>' . $lang['cat'] . '</option>
                           <option value="forum" ' . ($type == 'forum' ? 'selected' : '') . ' >' . $lang['forum'] . '</option>
                           </select>
                           ' . faI('arrow double') . '
                           </label>
                        </div>
                     </div>
                     <div class="form-group">
                        <label class="col-lg-3 col-sm-3 control-label">' . $lang['forum_parent'] . '</label>
                        <div class="col-lg-5 col-md-5 col-sm-8">
                          <label class="field select mb15">
                           <select id="pid" name="pid" class="form-control">';
    echo '<option value="0"' . ($type == '0' ? 'selected' : '') . '>' . $lang['forum_parent_pre'] . '</option>';
    if (!isset($edit) || $type) {
        $query = $core->select_data('board_forums', false, 'pid', '`id`, `title`, `pid`');
        while ($rows = $db->getRow($query)) {
            $cat_get[$rows['id']] = array($rows['title'], $rows['pid']);
        }
        if (isset($cat_get)) {
            foreach ($cat_get as $cid => $sub_arr) {
                if ($cid != $sub_arr[1]) {
                    $cats_arr[$cid] = $sub_arr[0];
                    $flag = $sub_arr[1];
                    while ($flag != "0") {
                        $cats_arr[$cid] = $cat_get[$flag][0] . " / " . $cats_arr[$cid];
                        $flag = $cat_get[$flag][1];
                    }
                }
            }
            asort($cats_arr);
            foreach ($cats_arr as $cid => $name) {
                $selected = ($cid == $fid) ? "selected" : "";
                echo '<option value="' . $cid . '" ' . $selected . '>' . $name . '</option>';
            }
        }
    }
    echo '</select>
                           ' . faI('arrow double') . '
                           </label>
                        </div>
                     </div>';
    $query = $core->select_data('groups', false, 'name');
    echo '<div class="panel-body pn table-responsive">
             <div class="tab-block mb25">
            <div class="form-group">
                         <table class="table table-xs table-striped">
                           <thead>
                              <tr>
                                 <th><span class="pd-l-sm"></span>' . $lang['group_rights'] . '</th>
                                 <th style="width: 40px">' . faSpan('fa-eye', true, false, false, $lang['view']) . '</th>
                                 <th style="width: 40px">' . faSpan('fa-book', true, false, false, $lang['reading']) . '</th>
                                 <th style="width: 40px">' . faSpan('fa-plus-circle', true, false, false, $lang['create']) . '</th>
                                 <th style="width: 40px">' . faSpan('fa-reply-all', true, false, false, $lang['answer']) . '</th>
                                 <th style="width: 40px">' . faSpan('fa-pencil', true, false, false, $lang['edit']) . '</th>
                                 <th style="width: 40px">' . faSpan('fa-list-alt', true, false, false, $lang['moderation']) . '</th>
                                 <th style="width: 40px">' . faSpan('fa-file', true, false, false, $lang['files']) . '</th>
                                 <th style="width: 40px">' . $lang['all'] . '</th>
                              </tr>
                           </thead>
                           <tbody>';
    while ($rows = $db->getRow($query)) {
        echo '<tr>
                                 <td><span class="pd-l-sm"></span><b><span style="color:' . $rows['color'] . '">' . Glang($rows['name']) . '</span></b></td>
                                 <td><label class="option  mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][allowView]" style="border:none;" ' . checked(isset($rows['guest'])) . '>' . faI('checkbox') . '</label></td>
                                 <td><label class="option block mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][allowRead]" style="border:none;" ' . checked(isset($rows['guest'])) . '>' . faI('checkbox') . '</label></td>
                                 <td><label class="option block mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][allowCreate]" style="border:none;" ' . checked(isset($rows['user'])) . '>' . faI('checkbox') . '</label></td>
                                 <td><label class="option block mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][allowReply]" style="border:none;" ' . checked(isset($rows['user'])) . '>' . faI('checkbox') . '</label></td>
                                 <td><label class="option block mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][allowEdit]" style="border:none;" ' . checked(isset($rows['user'])) . '>' . faI('checkbox') . '</label></td>
                                 <td><label class="option block mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][allowModer]" style="border:none;" ' . checked(isset($rows['moderator'])) . '>' . faI('checkbox') . '</label></td>
                                 <td><label class="option block mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][allowAttach]" style="border:none;" ' . checked(isset($rows['user'])) . '>' . faI('checkbox') . '</label></td>
                                 <td><label class="option block mt10"><input type="checkbox" name="permissions[' . $rows['id'] . '][all]" style="border:none;">' . faI('checkbox') . '</label>
                     </div>
                     </td>
                     </tr>';
    }
    echo '</tbody>
                     </table>
                     <hr class="short mv15">
                  </div>
                  ' . faI('arrow double') . '
                  <div class="form-group">
                     <div class="col-xs-6">
                        <label class="field option">
                        <input type="checkbox" name="active" ' . ($active ? 'checked' : '') . ' value="1" checked><span class="checkbox mr10"></span>' . $lang['forum_activate'] . '</label><br>
                        <hr class="alt short mv15">
                     </div>
                  </div>
               </div>
               </div>
               </div>
               </div>
            <div class="panel-footer">
               <button  type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
            </div>';
    if (isset($fid)) {
        if ($url[3] == 'edit_forum') {
            echo '<input type="hidden" name="edit" value="1">
            <input type="hidden" name="fid" value="' . $fid . '">';
        }
    }
    echo '</form>
      </div>
   </div>
</div>
</div>';
    $adminTpl->admin_foot();
}

function resetrules($id): void
{
    global $db, $core;
    $core->del_data('board_permissions', 'fid = "' . $id . '"');
    $query = $core->select_data('groups', false, 'name');
    while ($rows = $db->getRow($query)) {
        $allowView = isset($rows['guest']);
        $allowRead = isset($rows['guest']);
        $allowCreate = isset($rows['user']);
        $allowReply = isset($rows['user']);
        $allowEdit = isset($rows['user']);
        $allowModer = isset($rows['moderator']);
        $allowAttach = isset($rows['user']);
        $core->ins_data('board_permissions', 'id,fid,gid,allowView,allowRead,allowCreate,allowReply,allowEdit,allowModer,allowAttach', 'NULL, "' . $id . '", "' . $rows['id'] . '", "' . $allowView . '", "' . $allowRead . '", "' . $allowCreate . '", "' . $allowReply . '", "' . $allowEdit . '", "' . $allowModer . '", "' . $allowAttach . '"');
    }
}

function check_permis($fid, $gid)
{
    global $db, $core, $lang;
    $check = '';
    $query = $core->select_data('board_permissions', 'gid = "' . $gid . '"');
    while ($row = $db->getRow($query)) {
        $groups[$row['fid']] = $row;
    }
    $lang['truecheck'] = colorSpan('green', '<b>Полное совпадение</b>');
    $lang['falsecheck'] = colorSpan('red', '<b>Совпадения отсутствуют</b>');
    $query = $core->select_data('groups', false, 'name');
    while ($rows = $db->getRow($query)) {
        $checkid = $groups[$fid] ?? false;
        $allowView = ($rows['guest'] == $checkid['allowView']) ? $lang['truecheck'] : $lang['falsecheck'];
        $allowRead = ($rows['guest'] == $checkid['allowRead']) ? $lang['truecheck'] : $lang['falsecheck'];
        $allowCreate = ($rows['user'] == $checkid['allowCreate']) ? $lang['truecheck'] : $lang['falsecheck'];
        $allowReply = ($rows['user'] == $checkid['allowReply']) ? $lang['truecheck'] : $lang['falsecheck'];
        $allowEdit = ($rows['user'] == $checkid['allowEdit']) ? $lang['truecheck'] : $lang['falsecheck'];
        $allowModer = ($rows['moderator'] == $checkid['allowModer']) ? $lang['truecheck'] : $lang['falsecheck'];
        $allowAttach = ($rows['user'] == $checkid['allowAttach']) ? $lang['truecheck'] : $lang['falsecheck'];
        $groupsidg = $checkid['gid'] ?? '';
        $check = '<br/>';
        $check .= $allowView . '<br/>';
        $check .= $allowRead . '<br/>';
        $check .= $allowCreate . '<br/>';
        $check .= $allowReply . '<br/>';
        $check .= $allowEdit . '<br/>';
        $check .= $allowModer . '<br/>';
        $check .= $allowAttach . '<br/>';
    }
    return $check;
}

function ShowTree($parent_id = 0, $sublevelmarker = false): string
{
    global $db, $core, $lang;
    $dbh = init_pdo();
    $sth = $dbh->prepare("SELECT * FROM `" . DB_PREFIX . "_board_forums` WHERE `pid` = " . $parent_id . " ORDER BY `position`");
    $sth->execute();
    $array = $sth->fetchAll(PDO::FETCH_ASSOC);
    $cat_item = '<div class="dc">
<ul class="sortable-ul">';
    foreach ($array as $row => $result) {
        list($topics, $posts) = $db->fetchRow($db->query("SELECT COUNT(id), (SELECT COUNT(id) FROM " . DB_PREFIX . "_board_posts) as posts FROM " . DB_PREFIX . "_board_threads  WHERE `forum` ='" . $result['id'] . "'"));
        if ($result['pid'] == 0 && $result['type'] == 'forum') {
            $type = $lang['forum_parent'];
            $numtopics = '';
            $numposts = '';
        } elseif ($result['type'] == 'cat') {
            $type = $lang['cat'];
            $numtopics = $topics;
            $numposts = $posts;
        } elseif ($result['type'] == 'forum') {
            $type = $lang['forum'];
            $numtopics = $topics;
            $numposts = $posts;
        } elseif ($result['pid'] == 0 && $result['type'] == 'forum') {
            $type = $lang['forum_parent'];
            $numtopics = '';
            $numposts = '';
        } else {
            $type = '';
            $numtopics = '';
            $numposts = '';
        }
        //$rules = $core->bbDecode(parseBB($result['rules']));
        $status_icon = $result['active'] == 1 ? faSpan('fa-check-circle text-success fa-md', true, false, false, $lang['actively']) : faSpan('fa-circle text-danger fa-md', true, false, false, $lang['not_actively']);
        $status_rules_icon = $type <> $lang['forum_parent'] ? (!$result['rules'] ? faSpan('fa-info text-danger fa-md', true, false, false, $lang['forum_not_rules']) : '<a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-rules' . $result['id'] . '\')">' . faSpan('fa-info text-info fa-md', true, false, false, $lang['forum_rules']) . '</a>') : '';
        $active = (($result['active'] == 0) ? $lang['do_activation'] : $lang['do_deactivation']);
        $status_rules = $type <> $lang['forum_parent'] ? (!$result['rules'] ? faSpan('fa-info', false, $lang['forum_attach_rules']) : faSpan('fa-info', false, $lang['forum_attach_rules_edit'])) : '';
        $sub_num = $core->sum_data('board_forums', '`pid` ="' . $result['id'] . '"');
        $item_icon = $sub_num > 0 ? faSpan('fa-list-ul', false, false, false, 'Развернуть,свернуть или переместить') : faSpan('fa-list-ul');
        $cat_item .= '<li class="dc-item accordion-toggle" data-id="' . $result['id'] . '" data-toggle="collapse" data-parent="#accordion" href="#collapse_' . $result['id'] . '">
      <input type = "hidden" name = "position[]" value = "' . $result['id'] . '">
      <div class="dc-handle dd-handle">' . $item_icon . '</div>
      <div class="dc-content">' . $status_icon . '&nbsp;&nbsp;' . $status_rules_icon . '
         <b>ID: ' . $result['id'] . '</b>
         <a href="/board/forum-' . $result['id'] . '" target="_blank\">' . $result['title'] . '</a>
         <b class="dc-rcontent" style="left: 52%;"> ' . $type . '</b>
         <b class="dc-rcontent" style="left: 80%;">' . formatCounter($numposts) . '</b>
         <b class="dc-rcontent" style="left: 88%;">' . formatCounter($numtopics) . '</b>
         <div align="right" class="dc-rmenu text-right">
            <div class="btn-group">
               <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">' . faSpan('fa-caret-down', false, 'right', true) . '</a>
               <ul class="dropdown-menu text-left dropdown-menu-right">
                     <li><a href="/board/forum-' . $result['id'] . '">' . faSpan('fa-television', true, $lang['forum_view_content']) . '</a></li>
                     <li><a href="{MOD_LINK}/section_add/' . $result['id'] . '">' . faSpan('fa-code-fork', true, $lang['forum_add_section']) . '</a></li>
                    ' . (($status_rules) ? '<li><a href="{MOD_LINK}/rules/' . $result['id'] . '">' . $status_rules . ' </a></li>' : '') . '
                    <li><a href="{MOD_LINK}/edit_forum/' . $result['id'] . '/1">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                    <li><a href="{MOD_LINK}/permis/' . $result['id'] . '">' . faSpan('fa-key', true, $lang['change_law']) . '</a></li>
                    <li><a href="{MOD_LINK}/resetrules/' . $result['id'] . '">' . faSpan('fa-recycle', true, $lang['reset_rules']) . '</a></li>
                    <li><a href="{MOD_LINK}/retivate/' . $result['id'] . '">' . faSpan('fa-ban', true, $active) . '</a></li>
                    <li class="divider"></li>
                    <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $result['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>
               </ul>
            </div>
         </div>
   </li>';
        $cat_item .= '<div id="collapse_' . $result['id'] . '" class="accordion-body collapse">' . ShowTree($result['id'], true) . '</div>';
        modal_form_text('forum_active', $lang['info'], 'fa-info-circle', $lang['info_forum_active'], false, $lang['info_forum_active_desc']);
        modal_form_text('rules' . $result['id'], $lang['forum_rules'], 'fa-file-text-o', $result['rulestitle'] . '</br></br>
         <pre><code>' . $result['rules'] . '</code></pre>', false, false, '<button  type="submit" onclick="window.location.href = \'{MOD_LINK}/rules/' . $result['id'] . '\'" class="btn bg-info btn-sm btn-raised legitRipple">' . faSpan('fa-external-link', true, $lang['edit']) . '</button>
         <button  type="submit" onclick="window.location.href = \'{MOD_LINK}/delete_rules/' . $result['id'] . '\'" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>');
        modal_form_delete($result['id'], $result['title'], $lang['forum_delete'] . '- ' . $result['title'], 'name', $lang['forum_del_text'], '{MOD_LINK}/delete/' . $result['id']);
    }
    $cat_item .= '</ul>
</div>';
    return $sublevelmarker ? '<ol class="dc-list pl10">' . $cat_item . '</ol>' : $cat_item;
}