<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
function deleteTopic($tid, $fid): void
{
    global $core, $db;
    list($all) = $core->fetch_data('board_posts', 'tid="' . $tid . '"');
    $core->del_data('board_posts', 'tid ="' . $tid . '"');
    $core->del_data('board_threads', 'id ="' . $tid . '"');
    foreach (glob(ROOT . 'files/board/boardFile_' . $tid . '_*_*.*') as $f) @unlink($f);
    foreach (glob(ROOT . 'files/board/boardFile_' . $tid . '_*_*_thumb.*') as $s) @unlink($s);
    list($newTid, $newTitle, $lastTime, $lastPoster) = $core->fetch_data('board_threads', 'forum ="' . $fid . '"', 'id, title, lastTime, lastPoster');
    list($forum) = $core->sum_data('board_forums', 'id ="' . $fid . '"');
    if (!empty($newTitle)) {
        $core->upd_data('board_forums', 'posts = posts-"' . $all . '", threads=threads-1, lastPost="' . $lastTime . '", lastPoster="' . $lastPoster . '", lastTid="' . $newTid . '", lastSubject="' . $newTitle . '"', 'id ="' . $fid . '"');
    } else {
        echo $forum;
        if ($forum > 0) $core->upd_data('board_forums', 'posts = posts-"' . $all . '", threads=threads-1, lastPost= NOT `lastPost`, lastPoster= NOT `lastPoster`, lastTid=0, lastSubject=""', 'id ="' . $fid . '"');
    }
}

function menu(): void
{
    global $core, $config;
    $query = isset($_POST['query']) ? filter($_POST['query'], 'a') : '';
    $cookie = isset($_COOKIE['Block_menu']);
    $core->tpl->open('menu');
    echo '<script src="usr/plugins/js/forum.js" type="text/javascript"></script>';
    $core->tpl->loadFile('board/forum.menu');
    $core->tpl->setVar('NAME', $core->auth->user_info['nick'] ?? '');
    $core->tpl->setVar('QUERY', $query);
    $core->tpl->setVar('THEME', '/usr/tpl/' . $config['tpl']);
    $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
    $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
    $core->tpl->end();
    $core->tpl->close();
}

function permission($fid, $type, $tuid = 0): bool
{
    global $core, $db;
    $ugid = $core->auth->isUser ? $core->auth->user_info['group'] : 3;
    static $groups;
    if (!isset($groups)) {
        $query = $core->select_data('board_permissions', 'gid ="' . $ugid . '"');
        while ($row = $db->getRow($query)) {
            $groups[$row['fid']] = $row;
        }
    }
    return isset($groups[$fid]) && $groups[$fid]['allow' . $type] == 1;
}

function stremyanka($fid, $type)
{
    global $db, $core, $lang;
    static $forum;
    if (!isset($forum)) {
        $query = $core->select_data('board_forums', false, false, 'id, title, pid');
        while ($row = $db->getRow($query)) {
            $forum[$row['id']] = array($row['title'], $row['pid']);
        }
    }
    switch ($type) {
        case 'linked':
            foreach ($forum as $id => $arr) {
                if ($id == $fid) {
                    $array[$id] = '<a href="board/forum-' . $id . '" title="' . $arr[0] . '">' . $arr[0] . '</a>';
                    $sub = $arr[1];
                    while ($sub != "0") {
                        $array[$id] = '<a href="board/forum-' . $sub . '" title="' . $forum[$sub][0] . '">' . $forum[$sub][0] . "</a>&nbsp;&nbsp;" . $array[$id];
                        $sub = $forum[$sub][1];
                        $array[$id] = $array[$id];
                    }
                }
            }
            return '<a href="board" title="Форум">' . $lang['forum_title'] . '</a>&nbsp;&nbsp;' . (isset($array) ? $array[$fid] : '');
            break;
        case 'list':
            foreach ($forum as $id => $arr) {
                $array[$id] = '<option value="board/forum-' . $id . '" ' . ($id == $fid ? 'selected' : '') . '>' . $arr[0] . '</option>';
                $sub = $arr[1];
                while ($sub != "0") {
                    $array[$id] = '<option value="board/forum-' . $id . '" ' . ($sub == $fid ? 'selected' : '') . '>' . $forum[$sub][0] . " >>" . $forum[$id][0] . "</option>";
                    $sub = $forum[$sub][1];
                }
            }
            return implode('', $array);
            break;
    }
}

function get_forums($pid = 0, $level = 1)
{
    global $db, $core, $forum_name, $lang;
    static $forum;
    if (!isset($forum)) {
        $query = $core->select_data('board_forums', 'active = 1', 'position');
        while ($row = $db->getRow($query)) {
            if (permission($row['id'], 'View')) {
                $forum[$row['pid']][$row['id']] = $row;
                if (isset($pid) && $pid == $row['id']) $title = $row['title'];
            }
        }
    }
    $count = 0;
    if (isset($forum[$pid])) {
        if ($level == 1) $core->tpl->open('mainForums');
        if ($pid > 0 && $level == 1) {
            $cookie = isset($_COOKIE['Block_forum-' . $pid]) ? true : false;
            $closed = true;
            $core->tpl->open('forum.list.top');
            $core->tpl->loadFile('board/forum.list.top');
            $core->tpl->setVar('ID', $pid);
            $core->tpl->setVar('FORUM_NAME', '<a href="board/forum-' . $pid . '" title="' . $lang['main_section'] . htmlspecialchars($title) . '">' . $title . '</a> - ' . $lang['subforums'] . '');
            $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
            $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
            $core->tpl->end();
            $core->tpl->close();
            $level = 2;
        }
        foreach ($forum[$pid] as $id => $info) {
            if ($level == 1) {
                if (isset($forum[$id])) {
                    $cookie = isset($_COOKIE['Block_forum-' . $id]) ? true : false;
                    $count = 0;
                    $core->tpl->open('forum.list.top');
                    $core->tpl->loadFile('board/forum.list.top');
                    $core->tpl->setVar('ID', $id);
                    $core->tpl->setVar('FORUM_NAME', '<a href="board/forum-' . $info['id'] . '" title="' . $lang['main_section'] . ' ' . htmlspecialchars($info['title']) . '">' . $info['title'] . '</a>');
                    $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
                    $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
                    $core->tpl->end();
                    $core->tpl->close();
                }
            } elseif ($level == 2) {
                $count++;
                if ($info['open'] == 1) {
                    $icon = 'inactive.png';
                    $alt = 'Форум закрыт';
                } elseif ($info['lastPost'] == '') {
                    $icon = 'no_info.png';
                    $alt = 'Нет тем в форуме';
                } elseif ($info['lastPost'] > time() - 86400) {
                    $icon = 'board_more.png';
                    $alt = 'Есть темы за последние сутки';
                } else {
                    $icon = 'board_nonew.png';
                    $alt = 'Ничего нового';
                }
                $core->tpl->open('forum.list.body');
                $core->tpl->loadFile('board/forum.list.body');
                $core->tpl->setVar('ID', $id);
                $core->tpl->setVar('ICON', $icon);
                $core->tpl->setVar('ICON_ALT', $alt);
                $core->tpl->setVar('FORUM_NAME', '<a href="board/forum-' . $info['id'] . '" title="В раздел: ' . $info['title'] . '">' . $info['title'] . '</a>');
                $forum_name = '';
                if (isset($forum[$id])) get_forums($id, $level + 1);
                if ($forum_name <> '') {
                    $forum_name = substr($forum_name, 0, -2);
                    $forum_name = 'Подфорумы: ' . $forum_name;
                }
                $core->tpl->setVar('DOP_FORUM', $forum_name);
                $core->tpl->setVar('DESC', $info['description']);
                $core->tpl->setVar('THREADS', $info['threads']);
                $core->tpl->setVar('POSTS', $info['posts']);
                $core->tpl->setVar('LAST_POSTS', ($info['lastPost'] == '' ? 'Новых тем нет' : '<a href="board/topic-' . $info['lastTid'] . '/getlastpost" title="К последнему сообщению"><img src="media/board/up.png" border="0" alt="Последнее сообщение" style="vertical-align:middle"></a> <span>' . formatDate($info['lastPost'], true) . ' <br/>
					<b>Тема:</b>&nbsp;<a href="board/topic-' . $info['lastTid'] . '/getlastpost" title="К первому непрочитанному сообщению: ' . htmlspecialchars($info['lastSubject']) . '">' . str($info['lastSubject'], 20) . '</a><br/>
					<b>От:</b> <a href="profile/' . $info['lastPoster'] . '" title="Последний">' . $info['lastPoster'] . '</a></span>'));
                $core->tpl->end();
                $core->tpl->close();
            } elseif ($level == 3) {
                $forum_name = $forum_name . '<a href="board/forum-' . $info['id'] . '" title="В раздел: ' . $info['title'] . '">' . $info['title'] . '</a>, ';
            }
            if ($level < 2) if (isset($forum[$id])) get_forums($id, $level + 1);
            if (isset($forum[$pid]) && $count == count($forum[$pid])) {
                $core->tpl->open('forum.list.down');
                $core->tpl->loadFile('board/forum.list.down');
                $core->tpl->end();
                $core->tpl->close();
            }
        }
        if ($level == 1 or isset($closed)) $core->tpl->close();
    }
}

function attachForum($text, $files, $act = false)
{
    global $config, $core, $lang;
    $js = '';
    $picture = '';
    if ($act == false) {
        if (strpos($text, "[file=") !== false) $text = preg_replace('#\[file\=(.+?)\]#ius', 'attachForum(\'\\1\', \'' . $files . '\', true)', $text);
        return $text;
    } else {
        $f = int_Serialize('uns', $files);
        if ($f[$text]['type'] == 'file') {
            return $core->auth->group_info['showAttach'] == 1 ? '» <a href="' . $f[$text]['file'] . '" ax:wrap="0">' . $lang['download'] . '&nbsp;' . $f[$text]['name'] . '</a> (' . formatfilesize($f[$text]['size'], true) . ')' : $lang['access_attach'];
        } else {
            if (!empty($f[$text]['fileTh'])) {
                require_once(ROOT . 'media/imageEffects/' . $config['imageEffect'] . '/init.php');
                echo ROOT . 'media/imageEffects/' . $config['imageEffect'] . '/init.php';
                $core->tpl->headerIncludes['thumbNail'] = $js;
                $repl = array(
                    '{full}' => $config['url'] . '/' . $f[$text]['file'],
                    '{thumb}' => $config['url'] . '/' . $f[$text]['fileTh'],
                    '{img}' => 'alt="' . $lang['forum_increase'] . '"',
                    '{href}' => ''
                );
                return '<!--ThumbNail-->' . img_preview(str_replace(array_keys($repl), array_values($repl), $picture), 'box') . '<!--ThumbNail:end-->';
            } else {
                return img_preview('<img src="' . $config['url'] . '/' . $f[$text]['file'] . '" border="0" alt="">', 'box');
            }
        }
    }
}

function boardUpload($timepid, $tid, $message, $pid = false, $alreadyFiles = false, $fromStart = false)
{
    global $board_conf, $db, $core;
    if (!empty($_FILES['files']['name'][1]) && $board_conf['loadFiles'] == 1) {
        if ($pid == false)
            list($pid) = $core->fetch_data('board_posts', 'tid="' . $tid . '" AND time="' . $timepid . '" AND uid="' . $core->auth->user_id . '"');
        $size = 0;
        $img = array('png', 'jpg', 'gif', 'jpeg');
        foreach ($_FILES['files']['tmp_name'] as $num => $adress) {
            $realNum = $num;
            /*
                if($fromStart != false)
                {
                    $num = $num+count($alreadyFiles);
                    str_replace('[file='.$realNum.']', '[file=' . $num . ']', $fromStart);
                }*/
            $size += $_FILES['files']['size'][$realNum];
            if ($size > $board_conf['maxSize']) break;
            $fileFormat = getExt($_FILES['files']['name'][$realNum]);
            if (in_array($fileFormat, explode(',', $board_conf['formats']))) {
                $file = ROOT . 'files/board/boardFile_' . $tid . '_' . $pid . '_' . $num . '.' . $fileFormat;
                if (in_array($fileFormat, $img)) {
                    $fileTh = ROOT . 'files/board/boardFile_' . $tid . '_' . $pid . '_' . $num . '_thumb.' . $fileFormat;
                    $resp = createThumb($_FILES['files']['tmp_name'][$realNum], $fileTh, $board_conf['maxWH'], $board_conf['maxWH'], true);
                    if ($resp == 'orig') $fileTh = '';
                    createThumb($_FILES['files']['tmp_name'][$realNum], $file, 1000, 1000);
                    $files[$num] = array('type' => 'img', 'name' => $_FILES['files']['name'][$realNum], 'file' => str_replace(ROOT, '', $file), 'size' => $_FILES['files']['size'][$realNum], 'ext' => $fileFormat, 'fileTh' => str_replace(ROOT, '', $fileTh));
                } else {
                    copy($_FILES['files']['tmp_name'][$realNum], $file);
                    $files[$num] = array('type' => 'file', 'name' => $_FILES['files']['name'][$realNum], 'file' => str_replace(ROOT, '', $file), 'size' => $_FILES['files']['size'][$realNum], 'ext' => $fileFormat);
                }
            }
        }
        if (!empty($alreadyFiles) && !empty($files)) $files = array_merge($alreadyFiles, $files);
        if (!empty($files)) {
            $toDB = !empty($files) ? int_Serialize('ser', $files) : '';
            preg_match_all('#\[file\=([0-9]+)\]#i', $message, $matches);
            foreach ($matches[1] as $unset) {
                unset($files[$unset]);
            }
            if (!empty($files)) {
                foreach ($files as $id => $inf) {
                    $message .= "\n[file=" . $id . "]";
                }
            }
            $core->upd_data('board_posts', 'message ="' . $db->safesql(parseBB(processText($message))) . '", files ="' . $toDB . '"', 'id ="' . $pid . '"');
        }
    }
}