<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
require_once ROOT . 'etc/board.config.php';
require_once ROOT . 'usr/modules/board/forum_funcs.php';
loadConfig('board');
global $db, $core, $board_conf, $config, $user, $lang;
$core->loadModLang('board');
switch (isset($url[1]) ? $url[1] : null) {
    default:
        if (isset($url[1]) && eregStrt('forum-', $url[1])) {
            showForum(intval(str_replace('forum-', '', $url[1])));
        } elseif (isset($url[1]) && eregStrt('topic-', $url[1])) {
            showTopic(intval(str_replace('topic-', '', $url[1])));
        } else {
            main();
        }
        break;
    case 'search':
        searchForum();
        break;
    case 'postMessage':
        $bb = new bb;
        $mess = '';
        if ($core->auth->isUser) {
            $type = filter($_POST['type'], 'a');
            $tid = isset($_POST['tid']) ? intval($_POST['tid']) : '';
            $name = $core->row_data('board_threads', 'id ="' . $tid . '"');
            $parent = isset($_REQUEST['parent']) ? intval($_REQUEST['parent']) : (isset($_POST['parent']) ? intval($_POST['parent']) : ' ничего');
            $parent = ($core->auth->isUser && $parent > 0 && $user['commentTree'] == 1 ? $parent : 0);
            if (permission($name['forum'], 'Reply')) {
                if ($name['closed'] == 0) {
                    switch ($type) {
                        case 'quick':
                            $mess = isset($_POST['qickMessage']) ? $_POST['qickMessage'] : '';
                            break;
                    }
                    if ($mess != '') {
                        list($pid, $submessage, $uid, $time, $files) = $core->fetch_data('board_posts', 'tid="' . $tid . '"', 'id, message, uid, time, files');
                        if ($uid == $core->auth->user_id && $time >= time() - 120 && empty($_FILES['files']['name'][1])) {
                            //$m = $submessage . parseBB(processText("\n\n" . $mess));
                            $m = $submessage . fileInit('board', $tid, 'content', $bb->parse(processText(filter($mess, 'html')), $tid, true));
                            $core->upd_data('board_posts', 'message ="' . $db->safesql($m) . '",time ="' . time() . '"', 'id ="' . $pid . '"');
                            //boardUpload(0, $tid, $m, $pid, unserialize($files));
                        } else {
                            $pidTime = time();
                            $mess = fileInit('board', $tid, 'content', parseBB(processText(filter($mess, 'html')), $tid));
                            $core->ins_data('board_posts', 'id,tid,message,uid,username,ip,time,files,visible,editUser,editReason,parent_id', 'NULL,"' . $tid . '","' . $db->safesql($mess) . '","' . $core->auth->user_id . '","' . $core->auth->user_info['nick'] . '","' . getenv('REMOTE_ADDR') . '","' . $pidTime . '","",1,"","","' . $parent . '"');
                            $core->upd_data('board_threads', 'replies = replies+1, lastPoster = "' . $core->auth->user_info['nick'] . '",lastTime = "' . $pidTime . '"', 'id ="' . $tid . '"');
                            $core->upd_data('board_forums', 'posts = posts+1,lastPost = "' . $pidTime . '",lastPoster = "' . $core->auth->user_info['nick'] . '",lastTid = "' . $tid . '",lastSubject = "' . $name['title'] . '"', 'id ="' . $name['forum'] . '"');
                            $core->upd_data('board_users', 'messages = messages+1', 'uid ="' . $core->auth->user_id . '"');
                            boardUpload($pidTime, $tid, $mess);
                        }
                        location('board/topic-' . $tid . '/getlastpost');
                    } else {
                        location('board/topic-' . $tid . '/errorPost');
                    }
                } else {
                    location();
                }
            } else {
                location();
            }
        } else {
            location();
        }
        break;
    case 'newTopic':
        if (!$core->auth->isUser) location('board');
        $fid = isset($url[2]) ? intval($url[2]) : false;
        $hash = isset($url[3]) ? $url[3] : '';
        initDir('board', 'users_' . $core->auth->user_info['id'], $fid);
        if (permission($fid, 'Reply')) {
            $bb = new bb;
            menu();
            $uniqCode = gencode(10);
            $core->tpl->open();
            $core->tpl->close();
            $bb_area = $user['editor'] == "htmlEditor" ? 'bb_area' : 'edit_area';
            $textArea = $bb_area('topicMessage', '', 6, 'textarea', false, true);
            $forum_upload = forumUpload($uniqCode);
            $core->tpl->open('topic.add');
            $core->tpl->loadFile('board/topic.add');
            $core->tpl->setVar('ICON', board_theme_icon('r'));
            $core->tpl->setVar('TEXTAREA', $textArea);
            $core->tpl->setVar('FORUM_UPLOAD', $forum_upload);
            $core->tpl->setVar('ID', $fid);
            $core->tpl->setVar('UNIQCODE', $uniqCode);
            $core->tpl->setVar('HASH', $hash);
            $core->tpl->setVar('HEADTEXT', 'Добавление темы:');
            $core->tpl->setVar('ACTION', 'board/saveTopic/');
            $core->tpl->setVar('LADDER', '<div id="breadcrumbs-one"><li>' . stremyanka($fid, 'linked') . '<a href="board/newTopic/' . $fid . '" title="">' . $lang['forum_add_theme'] . '</a></li></div>');
            $core->tpl->setVar('NAME', '');
            $array_replace["#\\[post\\](.*?)\\[/post\\]#is"] = ((!empty($url[1]) && $url[1] == 'editPost') ? '\\1' : '');
            $array_replace["#\\[users\\](.*?)\\[/users\\]#is"] = ((!empty($url[1]) && $url[1] == 'editPost') ? '' : '\\1');
            $array_replace["#\\[upload\\](.*?)\\[/upload\\]#is"] = (($board_conf['loadFiles'] == 1) ? '\\1' : '');
            $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
            $core->tpl->end();
            $core->tpl->close();
        } else {
            location('/board');
        }
        break;
    case 'saveTopic':
        $id = isset($_POST['id']) ? intval($_POST['id']) : '';
        $fid = isset($_POST['forum']) ? intval($_POST['forum']) : '';
        $title = isset($_POST['title']) ? $_POST['title'] : '';
        $message = isset($_POST['topicMessage']) ? ($_POST['topicMessage']) : (isset($_POST['qickMessage']) ? ($_POST['qickMessage']) : ((isset($_POST['text']) ? ($_POST['text']) : '')));
        $bb = new bb;
        $icon = filter($_POST['icon'], 'a');
        $name = $core->row_data('board_forums', 'id ="' . $fid . '"');
        if ($name && $name['open'] == 0) {
            if (isset($_POST['type']) && $_POST['type'] == 'topic') {
                if (permission($fid, 'Create')) {
                    if ($title && $message || $title && $_POST['tid']) {
                        $time = time();
                        $core->ins_data('board_threads', 'id,forum,title,poster,startTime,lastTime,lastPoster,views,replies,important,closed,score,votes,icon,closetime', 'NULL,"' . $fid . '","' . $db->safesql(processText($title)) . '","' . $core->auth->user_id . '","' . $time . '","' . $time . '","' . $core->auth->user_info['nick'] . '",0,0,0,0,0,0,"' . $icon . '",""');
                        list($tid) = $core->fetch_data('board_threads', 'title ="' . $db->safesql(processText($title)) . '" AND startTime="' . $time . '"');
                        $timepid = time();
                        $core->ins_data('board_posts', 'id,tid,message,uid,username,ip,time,files,visible,editUser,editReason,parent_id', 'NULL,"' . $tid . '","' . $db->safesql($message) . '","' . $core->auth->user_id . '","' . $core->auth->user_info['nick'] . '","' . getenv('REMOTE_ADDR') . '","' . $timepid . '","",1,"","","0"');
                        $core->upd_data('board_forums', 'threads = threads+1, posts = posts+1,lastPost ="' . time() . '",lastPoster ="' . $core->auth->user_info['nick'] . '",lastTid ="' . $tid . '",lastSubject ="' . $title . '"', 'id ="' . $fid . '"');
                        $core->upd_data('board_users', 'messages = messages+1', 'uid ="' . $core->auth->user_id . '"');
                        boardUpload($timepid, $tid, $message);
                        location('/board/topic-' . $tid . '/getlastpost');
                    } else {
                        $core->tpl->info($lang['forum_text_field_null'] . '<a href="javascript:void(0)" onclick="javascript:history.go(-1);">' . $lang['back'] . '</a>');
                    }
                    //// 'ЭТО НОВАЯ ТЕМА';
                } else {
                    if (isset($_POST['id'])) {
                        $core->upd_data('board_posts', 'message ="' . $db->safesql($message) . '"', 'id ="' . $id . '"');
                        $threads = $core->row_data('board_threads', 'forum ="' . $fid . '"');
                        //location('/board/topic-' . $threads['id'] . '/getlastpost');
                        echo 'Сообщение сохранено ! ! !<br/>';
                        echo $id . '<br/>';
                    }
                }
            }
        }
        break;
    case 'savePost';
        $pid = isset($_POST['id']) ? intval($_POST['id']) : '';
        $tid = isset($_POST['tid']) ? intval($_POST['tid']) : '';
        $fid = isset($_POST['forum']) ? intval($_POST['forum']) : '';
        $title = isset($_POST['title']) ? $_POST['title'] : '';
        $page = isset($_POST['page']) ? $_POST['page'] : '';
        $message = isset($_POST['topicMessage']) ? ($_POST['topicMessage']) : (isset($_POST['qickMessage']) ? ($_POST['qickMessage']) : ((isset($_POST['text']) ? ($_POST['text']) : '')));
        $icon = isset($_POST['icon']) ? $_POST['icon'] : '';
        if (isset($pid) && $message) {
            $core->upd_data('board_posts', 'message ="' . $db->safesql(parseBB(processText($message))) . '"', 'id ="' . $pid . '"');
            $core->upd_data('board_threads', 'title ="' . $db->safesql(processText($title)) . '",icon ="' . $icon . '"', 'id ="' . $_POST['id'] . '"');
            location('/board/topic-' . $tid . '/page/' . $page . '#entry' . $pid);
            // echo $core->bbDecode(parseBB($message));
        } else {
            $core->tpl->info($lang['forum_error']);
        }
        break;
    case 'do':
        prt($_POST);
        $type = filter($_POST['deiv'], 'a');
        $fid = intval($_POST['fid']);
        $ttid = isset($url[2]) ? intval($url[2]) : false;
        if (!$ttid && isset($_POST['ttid'])) $ttid = intval($_POST['ttid']);
        switch ($type) {
            case 'important':
                if ($ttid) {
                    $core->upd_data('board_threads', 'important = 1', 'id ="' . $ttid . '"');
                } else {
                    foreach ($_POST['checks'] as $tid) {
                        $core->upd_data('board_threads', 'important = 1', 'id ="' . $tid . '"');
                    }
                }
                break;
            case 'noimportant':
                if ($ttid) {
                    $core->upd_data('board_threads', 'important = 0', 'id ="' . $ttid . '"');
                } else {
                    foreach ($_POST['checks'] as $tid) {
                        $core->upd_data('board_threads', 'important = 0', 'id ="' . $tid . '"');
                    }
                }
                break;
            case 'close':
                if ($ttid) {
                    $core->upd_data('board_threads', 'closed = 1', 'id ="' . $ttid . '"');
                } else {
                    foreach ($_POST['checks'] as $tid) {
                        $core->upd_data('board_threads', 'closed = 1', 'id ="' . $tid . '"');
                    }
                }
                break;
            case 'open':
                if ($ttid) {
                    $core->upd_data('board_threads', 'closed = 0', 'id ="' . $ttid . '"');
                } else {
                    foreach ($_POST['checks'] as $tid) {
                        $core->upd_data('board_threads', 'closed = 0', 'id ="' . $tid . '"');
                    }
                }
                break;
            case 'close_forum':
                $core->upd_data('board_forums', 'open = 1', 'id ="' . $fid . '"');
                break;
            case 'open_forum':
                $core->upd_data('board_forums', 'open = 0', 'id ="' . $fid . '"');
                break;
            case 'delete':
                if ($ttid) {
                    deleteTopic($ttid, $fid);
                } else {
                    foreach ($_POST['checks'] as $tid) {
                        deleteTopic($tid, $fid);
                    }
                }
                break;
        }
        if ($ttid) {
            location('/board/topic-' . $ttid . '/getlastpost');
        } else {
            location('/board/forum-' . $fid);
        }
        break;
    case 'admin':
        prt($_POST);
        $type = filter($_POST['deiv'], 'a');
        $fid = intval($_POST['fid']);
        switch ($type) {
            case 'close_forum':
                $core->upd_data('board_forums', 'open = 1', 'id ="' . $fid . '"');
                break;
            case 'open_forum':
                $core->upd_data('board_forums', 'open = 0', 'id ="' . $fid . '"');
                break;
        }
        location('/board/forum-' . $fid);
        break;
    case 'editPost':
        $bb = new bb;
        $file = '';
        if (!$core->auth->isUser) location('board');
        $pid = isset($url[2]) ? intval($url[2]) : '';
        $hash = isset($url[2]) ? $url[3] : '';
        $page = isset($url[4]) ? intval($url[4]) : '';
        $name = $core->row_data('board_posts', 'p.id="' . $pid . '"', false, 'p.*, t.forum, t.title as ttitle', 'as p LEFT JOIN ' . DB_PREFIX . '_board_threads as t ON(p.tid = t.id)');
        if (permission($name['forum'], 'Attach') && $name && $name['uid'] == $core->auth->user_id || $core->auth->isAdmin) {
            set_title(array($lang['forum_title'], $lang['forum_editing_post']));
            menu();
            $uniqCode = gencode(10);
            $textFull = $name['message'];
            $pageContent = init_page('break');
            $pageBreaks = explode('[pagebreak]', $textFull);
            if (!isset($pageBreaks[$pageContent - 1])) $pageContent = 1;
            $pagesBr = count($pageBreaks);
            $textFull = $pageBreaks[$pageContent - 1];
            $message = stripslashes($core->bbDecode(parseBB($textFull)));
            $message = str_replace(array('media/'), array($config['url'] . '/media/'), $message);
            $bb_area = $user['editor'] == "htmlEditor" ? 'bb_area' : 'edit_area';
            $textArea = $bb_area('qickMessage', $message, 6, 'textarea', false, true);
            if (!empty($name['files'])) {
                foreach (unserialize($name['files']) as $ssid => $cont) {
                    $file = '<input type="checkbox"  style="height: 14px;" name="delete[]" value="' . $ssid . '">' . $lang['delete'] . '&nbsp;' . $cont['name'] . '? <br/>';
                    $start = $ssid;
                }
            } else $start = 0;
            $names = $core->row_data('board_threads', 'id ="' . $name['tid'] . '"');
            $forum_upload = forumUpload($uniqCode, ($start + 1));
            $core->tpl->open('topic.add');
            $core->tpl->loadFile('board/topic.add');
            $core->tpl->setVar('ID', $name['id']);
            $core->tpl->setVar('TID', $name['tid']);
            $core->tpl->setVar('FORUM_NAME', $name['forum']);
            $core->tpl->setVar('ICON', board_theme_icon('r', $names['icon']));
            $core->tpl->setVar('NAME', prepareTitle($name['ttitle']));
            $core->tpl->setVar('TEXTAREA', $textArea);
            $core->tpl->setVar('FORUM_UPLOAD', $forum_upload);
            $core->tpl->setVar('UNIQCODE', $uniqCode);
            $core->tpl->setVar('FILE', $file);
            $core->tpl->setVar('PAGE', $page);
            $core->tpl->setVar('HASH', $hash);
            $core->tpl->setVar('HEADTEXT', 'Добавление темы:');
            $core->tpl->setVar('ACTION', 'board/savePost');
            $core->tpl->setVar('LADDER', '<div id="breadcrumbs-one"><li>' . stremyanka($name['id'], 'linked') . '<a href="board/topic-' . $name['tid'] . '" title="' . $name['ttitle'] . '">' . $name['ttitle'] . '</a></li></div>');
            $array_replace["#\\[post\\](.*?)\\[/post\\]#is"] = ((!empty($url[1]) && $url[1] == 'editPost') ? '\\1' : '');
            $array_replace["#\\[users\\](.*?)\\[/users\\]#is"] = ((!empty($url[1]) && $url[1] == 'editPost') ? '' : '\\1');
            $array_replace["#\\[upload\\](.*?)\\[/upload\\]#is"] = (($board_conf['loadFiles'] == 1) ? '\\1' : '');
            $array_replace["#\\[file\\](.*?)\\[/file\\]#is"] = ((!empty($name['files'])) ? '\\1' : '');
            $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
            $core->tpl->end();
            $core->tpl->close();
        }
        break;
    case 'user':
        $type = $url[2];
        $tid = intval($url[3]);
        $hash = $url[4];
        $name = $core->row_data('board_threads', 'id ="' . $tid . '"');
        if (permission($name['forum'], 'Edit') && $name && $name['poster'] == $core->auth->user_id || $core->auth->isAdmin) {
            if (md5($core->auth->user_info['tail'] . '-' . date('d')) == $hash) {
                menu();
                switch ($type) {
                    case 'editThread':
                        $core->tpl->open('topic.add');
                        $core->tpl->loadFile('board/topic.add');
                        $core->tpl->setVar('ID', $tid);
                        $core->tpl->setVar('NAME', prepareTitle($name['title']));
                        $core->tpl->setVar('ICON', board_theme_icon('r', $name['icon']));
                        $core->tpl->setVar('HASH', $hash);
                        $core->tpl->setVar('FORUM_NAME', $name['forum']);
                        $core->tpl->setVar('TEXTAREA', '');
                        $core->tpl->setVar('FORUM_UPLOAD', '');
                        $core->tpl->setVar('LADDER', '<div id="breadcrumbs-one"><li>' . stremyanka($name['id'], 'linked') . '<a href="board/topic-' . $name['id'] . '" title="' . $name['title'] . '">' . $name['title'] . '</a></li></div>');
                        $core->tpl->setVar('HEADTEXT', 'Редактирование темы:');
                        $core->tpl->setVar('ACTION', 'board/userSave/');
                        $array_replace["#\\[post\\](.*?)\\[/post\\]#is"] = ((!empty($url[1]) && $url[1] == 'user') ? '' : '\\1');
                        $array_replace["#\\[users\\](.*?)\\[/users\\]#is"] = ((!empty($url[1]) && $url[1] == 'user') ? '\\1' : '');
                        $array_replace["#\\[upload\\](.*?)\\[/upload\\]#is"] = (($board_conf['loadFiles'] == 1) ? '\\1' : '');
                        $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
                        $core->tpl->end();
                        $core->tpl->close();
                        break;
                    case 'delete':
                        deleteTopic($tid, $name['forum']);
                        $core->tpl->info($lang['forum_theme_deleted_ok'] . '<a href="board/forum-' . $name['forum'] . '">' . $lang['go_back'] . '</a>');
                        break;
                    case 'close':
                        $core->upd_data('board_threads', 'closed = 1', 'id ="' . $tid . '"');
                        location('/board/topic-' . $tid . '/getlastpost');
                        break;
                    case 'open':
                        $core->upd_data('board_threads', 'closed = 0', 'id ="' . $tid . '"');
                        location('/board/topic-' . $tid . '/getlastpost');
                        break;
                }
            }
        }
        break;
    case 'userSave':
        $bb = new bb;
        $hash = $url[2];
        $fid = intval($_POST['forum']);
        $tid = intval($_POST['tid']);
        $title = filter($_POST['title']);
        $type = filter($_POST['type'], 'a');
        echo filter($_POST['st'], 'a') . '<br/>';
        echo $type;
        $message = isset($_POST['mess']) ? filter($_POST['mess']) : '';
        $icon = filter($_POST['icon'], 'a');
        $mess = fileInit('board', $tid, $db->safesql(parseBB(processText(filter($message))), $tid), 'user_temp' . $core->auth->user_id);
        $name = $core->row_data('board_threads', 'id ="' . $tid . '"');
        if (permission($name['forum'], 'Edit') && $name && $name['poster'] == $core->auth->user_id || $core->auth->isAdmin) {
            if (md5($core->auth->user_info['tail'] . '-' . date('d')) == $hash) {
                menu();
                switch ($type) {
                    case 'topic':
                        if ($title && $fid && $tid) {
                            if ($core->upd_data('board_threads', 'title ="' . $title . '",icon ="' . $icon . '"', 'id ="' . $tid . '"')) {
                                $core->upd_data('board_forums', 'lastSubject = "' . $title . '"', 'id ="' . $fid . '"');
                                location('/board/topic-' . $tid . '/getlastpost');
                            } else {
                                location();
                            }
                        } else {
                            $core->tpl->info($lang['forum_text_field_null']);
                        }
                        break;
                }
            }
        }
        break;
    case 'ajax':
        $bb = new bb;
        $no_head = true;
        $switch = isset($url[2]) ? $url[2] : '';
        $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : '';
        $blocked = isset($_REQUEST['blocked']) ? intval($_REQUEST['blocked']) : '';
        if (isset($_COOKIE[COOKIE_AUTH])) initDir('board', 'users_' . $core->auth->user_info['id'], $id);
        switch ($switch) {
            case 'fastForm':
                if ($id) {
                    list($content, $files) = $core->fetch_data('board_posts', 'id ="' . $id . '"', 'message, files');
                    if ($blocked) {
                        echo $content;
                    } else {
                        echo "<form action=\"javascript:forumSaveEdit('fastEdit-" . $id . "', addition);\" name=\"fast\" id=\"fast\">";
                        $bb_area = $user['editor'] == "htmlEditor" ? 'bb_area' : 'edit_area';
                        $message = stripslashes($core->bbDecode(parseBB($content)));
                        $message = str_replace(array('media/'), array($config['url'] . '/media/'), $message);
                        echo edit_area('text', $message, 6, 'textarea', false, true);
                        if (!empty($files)) {
                            echo "<input type=\"hidden\" id=\"files\" value=\"1\"/>";
                            foreach (unserialize($files) as $ssid => $cont)
                                echo '<input type="checkbox"  style="height: 14px;" onclick="if(confirm(\'' . $lang['forum_are_you_sure_delete_file'] . $cont['name'] . '?\')) addition += \'&delete[]=' . $ssid . '\'; else return false;">' . $lang['delete'] . $cont['name'] . '? <br/>';
                        } else {
                            echo "<input type=\"hidden\" id=\"files\" value=\"0\"/>";
                        }
                        echo "<input type=\"hidden\" id=\"id\" value=\"" . $id . "\"/>";
                        echo "<div style=\"text-align:right;\"> <br/><input type=\"submit\" name=\"button\" class=\"fbutton\" value=\"" . $lang['apply'] . "\"> <input type=\"submit\" name=\"button\" class=\"fbutton\" value=\"" . $lang['cancel'] . "\" onclick=\"ajaxSimple('index.php?url=board/ajax/fastForm&blocked&id=" . $id . "', 'fastEdit-" . $id . "', true);\"></div>";
                        echo "</form>";
                    }
                }
                break;
            case 'fastSave':
                $bb = new bb;
                $pid = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : '';
                $tid = isset($_REQUEST['tid']) ? intval($_REQUEST['tid']) : '';
                $text = isset($_REQUEST['text']) ? $_REQUEST['text'] : '';
                $f = isset($_REQUEST['files']) ? true : '';
                $icon = isset($_REQUEST['icon']) ? $_REQUEST['icon'] : '';
                //  $m = fileInit('board', $tid, 'content', $bb->parse(processText($text), $tid, true));
                if ($text) {
                    if ($f == true) {
                        list($files) = $core->fetch_data('board_posts', 'id ="' . $pid . '"', 'files');
                        $unfiles = unserialize($files);
                        if (!empty($_REQUEST['delete'])) {
                            foreach ($_REQUEST['delete'] as $id) {
                                $inf = $unfiles[$id];
                                @unlink(ROOT . $inf['file']);
                                @unlink(ROOT . $inf['fileTh']);
                                unset($unfiles[$id]);
                                $text = str_replace('[file=' . $id . ']', '', $text);
                            }
                        }
                        $fill = empty($unfiles) ? '' : int_Serialize('ser', $unfiles);
                        $core->upd_data('board_posts', 'message ="' . $db->safesql($text) . '",files ="' . $fill . '"', 'id ="' . $pid . '"');
                        $core->upd_data('board_threads', 'icon ="' . $icon . '"', 'id ="' . $_REQUEST['tid'] . '"');
                        if ($tid) {
                            boardUpload(0, $tid, $text, $pid, $unfiles);
                            location('/board/topic-' . $_REQUEST['tid'] . '/page/' . $_REQUEST['page'] . '#entry' . $pid);
                        } else
                            echo attachForum($core->bbDecode(parseBB($text)), int_Serialize('ser', $unfiles));
                    } else {
                        $core->upd_data('board_posts', 'message ="' . $db->safesql($text) . '"', 'id ="' . $pid . '"');
                        $core->upd_data('board_threads', 'icon ="' . $icon . '"', 'id ="' . $_REQUEST['id'] . '"');
                        if ($tid) {
                            list($files) = $core->fetch_data('board_posts', 'id ="' . $pid . '"', 'files');
                            boardUpload(0, $tid, $text, $pid, int_Serialize('ser', $files));
                            location('/board/topic-' . $_REQUEST['tid'] . '/page/' . $_REQUEST['page'] . '#entry' . $pid);
                        } else
                            echo $core->bbDecode(parseBB($text));
                    }
                } else {
                    $core->tpl->info($lang['forum_error']);
                }
                break;
            case 'delete':
                list($tid, $uid, $forum) = $db->fetchRow($db->query("SELECT p.tid, p.uid, t.forum FROM " . DB_PREFIX . "_board_posts as p LEFT JOIN " . DB_PREFIX . "_board_threads as t on(p.tid=t.id) WHERE p.id='" . $id . "'"));
                if (permission($forum, 'Edit') && isset($uid) && $uid == $core->auth->user_id || $core->auth->isAdmin) {
                    if ($core->del_data('board_posts', 'id ="' . $id . '"')) {
                        foreach (glob(ROOT . 'files/board/boardFile_*_' . $id . '_*.*') as $f) @unlink($f);
                        foreach (glob(ROOT . 'files/board/boardFile_*_' . $id . '_*_thumb.*') as $s) @unlink($s);
                        $core->upd_data('board_threads', 'replies = replies-1', 'id ="' . $tid . '"');
                        $core->upd_data('board_forums', 'posts = posts-1', 'id ="' . $forum . '"');
                        echo colorSpan('green', $lang['forum_message_deleted']);
                    } else {
                        $core->tpl->info($lang['forum_error']);
                    }
                }
                break;
        }
        break;
}
function main()
{
    global $db, $core, $lang;
    $core->loadModLang('board');
    set_title(array($lang['forum_title']));
    menu();
    get_forums();
    check_views();
    $online = 0;
    list($topics, $posts) = $db->fetchRow($db->query("SELECT COUNT(id), (SELECT COUNT(id) FROM " . DB_PREFIX . "_board_posts) as posts FROM " . DB_PREFIX . "_board_threads"));
    list($users, $last) = $db->fetchRow($db->query("SELECT COUNT(id), (SELECT nick FROM `" . USER_DB . "`.`" . USER_PREFIX . "_users` ORDER BY id DESC LIMIT 1) as last FROM `" . USER_DB . "`.`" . USER_PREFIX . "_users`"));
    $on = $db->query("SELECT o.*, p.nick FROM " . DB_PREFIX . "_online AS o LEFT JOIN `" . USER_DB . "`.`" . USER_PREFIX . "_users` AS p ON (p.id=o.uid) WHERE url LIKE '%board%'");
    $i = 0;
    while ($online = $db->getRow($on)) {
        $i++;
        if (!empty($online['nick'])) $onn[] = '<a href="profile/' . $online['nick'] . '">' . $online['nick'] . '</a>';
    }
    $cookie = isset($_COOKIE['Block_stats']) ? true : false;
    $core->tpl->open('forum.stat');
    $core->tpl->loadFile('board/forum.stat');
    $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
    $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
    $core->tpl->setVar('NUMB_USER', $users);
    $core->tpl->setVar('NUMB_TOPICS', $topics);
    $core->tpl->setVar('NUMB_POSTS', $posts);
    $core->tpl->setVar('NUMB_ONLINE', ($i == 0 ? ($core->auth->isUser ? 1 : 0) : $i));
    $core->tpl->setVar('ONLINE_USER', (empty($onn) ? ($core->auth->isUser ? '<a href="profile/' . $core->auth->user_info['nick'] . '" title="' . $core->auth->user_info['nick'] . '">' . $core->auth->user_info['nick'] . '</a>' : '...') : implode(', ', $onn)));
    $core->tpl->setVar('NEW_USER', '<a href="profile/' . $last . '" title="' . $last . '">' . $last . '</a>');
    $core->tpl->end();
    $core->tpl->close();
}

function showForum($tid)
{
    global $db, $core, $board_conf, $lang;
    $core->loadModLang('board');
    $name = $core->row_data('board_forums', 'id ="' . $tid . '"');
    $orderType = isset($_POST['order']) ? filter($_POST['order'], 'a') : '';
    if ($name && permission($tid, 'View')) {
        switch ($orderType) {
            default:
                $orderBy = 'lastTime';
                break;
            case 'subject':
                $orderBy = 'title';
                break;
            case 'lastpost':
                $orderBy = 'lastTime';
                break;
            case 'starter':
                $orderBy = 'poster';
                break;
            case 'started':
                $orderBy = 'startTime';
                break;
            case 'replies':
                $orderBy = 'replies';
                break;
            case 'views':
                $orderBy = 'views';
                break;
        }
        $orderHow = isset($_POST['sort']) && $_POST['sort'] == 'ASC' ? 'ASC' : 'DESC';
        set_title(array($lang['forum_title'], $name['title']));
        menu();
        get_forums($tid);
        $core->tpl->open();
        $core->tpl->setVar('LADDER', '<div id="breadcrumbs-one"><li>' . stremyanka($name['id'], 'linked') . '<a href="board/forum-' . $name['id'] . '" title="' . $name['title'] . '">' . $name['title'] . '</a></li></div>');
        $core->tpl->close();
        if ($name['type'] == 'forum') {
            if ($name['rules']) {
                $cookie = isset($_COOKIE['Block_rules']) ? true : false;
                $core->tpl->open('forum.rules');
                $core->tpl->loadFile('board/forum.rules');
                $core->tpl->setVar('TITLE', ($name['rulestitle'] ? $name['rulestitle'] : 'Правила:'));
                $core->tpl->setVar('RULES', $core->bbDecode(parseBB($name['rules'])));
                $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
                $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
                $core->tpl->end();
                $core->tpl->close();
            }
            $num = $board_conf['threads_num'];
            $page = init_page();
            $cut = ($page - 1) * $num;
            $all = $core->sum_data('board_threads', 'forum ="' . $tid . '"');
            $result = $db->query("SELECT t.*, u.nick, (SELECT count(id) FROM `" . DB_PREFIX . "_board_posts` WHERE tid = t.id AND uid = '" . $core->auth->user_id . "') as isUserPost FROM `" . DB_PREFIX . "_board_threads` as t LEFT JOIN `" . USER_DB . "`.`" . USER_PREFIX . "_users` as u on(t.poster = u.id) WHERE `forum` = '" . $tid . "' ORDER BY " . $orderBy . " " . $orderHow . " LIMIT " . $cut . ", " . $num . "");
            if ($db->numRows($result) > 0) {
                while ($row = $db->getRow($result)) {
                    $topics[$row['important']][$row['id']] = $row;
                }
                $i = 0;
                if (isset($topics[1])) {
                    $warn = 0;
                    $topic_important = '';
                    foreach ($topics[1] as $id => $row) {
                        $i++;
                        $icon = Bstat($row);
                        foreach ($topics[1] as $id => $row) {
                            $warn++;
                            $topic_important = $topic_important . '<tr>
   <td style="text-align:center">' . Bicon($icon, 'i') . '</td>
   <td class="hidden-xs" style="text-align:center">' . Bicon($row['icon'], 't') . '</td>
   <td><b><a href="board/topic-' . $row['id'] . '" title="' . $lang['forum_in_section'] . '&nbsp;' . $row['title'] . '">' . $row['title'] . '</a></b></td>
   <td class="hidden-xs" style="text-align:center"><a href="profile/' . $row['nick'] . '" title="' . $lang['forum_author_theme'] . '&nbsp;' . $row['nick'] . '">' . $row['nick'] . '</a></td>
   <td class="hidden-xs" style="text-align:center">' . $row['replies'] . '</td>
   <td class="hidden-xs" style="text-align:center">' . $row['views'] . '</td>
   <td nowrap="nowrap">' . formatDate($row['lastTime'], true) . '<br/>
      <b>' . $lang['forum_last'] . ':</b> <a href="profile/' . $row['lastPoster'] . '" title="' . $lang['forum_last_otvetevshy'] . '">' . $row['lastPoster'] . '</a>
   </td>';
                            if (permission($tid, 'Moder')) $topic_important = $topic_important . '<td style="text-align:center"><input type="checkbox"  style="height: 14px;" name="checks[]" value="' . $id . '"></td>';
                        }
                    }
                }
                if (isset($topics[0])) {
                    $topic_last = '';
                    foreach ($topics[0] as $id => $row) {
                        $i++;
                        $icon = Bstat($row);
                        $topic_last = $topic_last . '<tr>
   <td style="text-align:center">' . Bicon($icon, 'i') . '</td>
   <td class="hidden-xs" style="text-align:center">' . Bicon($row['icon'], 't') . '</td>
   <td><b><a href="board/topic-' . $row['id'] . '" title="' . $lang['forum_in_section'] . '&nbsp;' . $row['title'] . '">' . $row['title'] . '</a></b></td>
   <td class="hidden-xs" style="text-align:center"><a href="profile/' . $row['nick'] . '" title="' . $lang['forum_author_theme'] . '&nbsp;' . $row['nick'] . '">' . $row['nick'] . '</a></td>
   <td class="hidden-xs" style="text-align:center">' . $row['replies'] . '</td>
   <td class="hidden-xs" style="text-align:center">' . $row['views'] . '</td>
   <td nowrap="nowrap">' . formatDate($row['lastTime'], true) . '<br/>
      <b>' . $lang['forum_last'] . ':</b> <a href="profile/' . $row['lastPoster'] . '" title="' . $lang['forum_last_otvetevshy'] . '">' . $row['lastPoster'] . '</a>
   </td>';
                        if (permission($tid, 'Moder')) $topic_last = $topic_last . '<td style="text-align:center"><input type="checkbox"  style="height: 14px;" name="checks[]" value="' . $id . '"></td>';
                        $topic_last = $topic_last . '</tr>';
                    }
                }
            }
            $forum = $core->row_data('board_threads', 'forum ="' . $name['id'] . '"');
            $cookie = isset($_COOKIE['Block_list']) ? true : false;
            $core->tpl->open('topic.list');
            $core->tpl->loadFile('board/topic.list');
            $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
            $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
            $core->tpl->setVar('TITLE', $name['title']);
            $core->tpl->setVar('NEW_TOPIC', ((permission($tid, 'Reply') && $name['open'] == 0) ? '<a href="board/newTopic/' . $tid . '"> Новая тема</a>' : ''));
            $array_replace["#\\[moder\\](.*?)\\[/moder\\]#is"] = ((permission($tid, 'Moder')) ? '\\1' : '');
            $array_replace["#\\[nomoder\\](.*?)\\[/nomoder\\]#is"] = ((!permission($tid, 'Moder')) ? '\\1' : '');
            $array_replace["#\\[important\\](.*?)\\[/important\\]#is"] = ((isset($topics[1])) ? '\\1' : '');
            $array_replace["#\\[last\\](.*?)\\[/last\\]#is"] = ((isset($topics[0])) ? '\\1' : '');
            $array_replace["#\\[admin\\](.*?)\\[/admin\\]#is"] = (($core->auth->isAdmin) ? '\\1' : '');
            $array_replace["#\\[search\\](.*?)\\[/search\\]#is"] = (!isset($_POST['query']) ? '\\1' : '');
            $array_replace["#\\[noempty\\](.*?)\\[/noempty\\]#is"] = ((isset($topics[0]) && count($topics[0]) == $i || isset($topics[1]) && count($topics[1]) == $warn) ? '\\1' : '');
            $array_replace["#\\[empty\\](.*?)\\[/empty\\]#is"] = ((!(isset($topics[0]) && count($topics[0]) == $i || isset($topics[1]) && count($topics[1]) == $warn)) ? '\\1' : '');
            $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
            $core->tpl->setVar('TOPIC_IMPORTANT', (!empty($topic_important) ? $topic_important : ''));
            $core->tpl->setVar('TOPIC_LAST', (!empty($topic_last) ? $topic_last : ''));
            $core->tpl->setVar('QUERY', '');
            $core->tpl->setVar('MASSAGE', $lang['forum_those_not_found']);
            $core->tpl->setVar('T_ID', $tid);
            $core->tpl->setVar('ID', (!empty($id) ? $id : ''));
            $core->tpl->setVar('LADDER', '<div id="breadcrumbs-one"><li>' . stremyanka((isset($id) == (isset($forum['id']) ? $forum['id'] : '') ? filter((!empty($id) ? $id : '')) : ''), 'linked') . '<a href="board/forum-' . $name['id'] . '" title="' . $name['title'] . '">' . $name['title'] . '</a></li></div>');
            $core->tpl->end();
            $core->tpl->close();
        }
        if ($name['type'] == 'forum') $core->tpl->pages($page, $num, $all, 'board/forum-' . $tid . '/{page}');
        $cookie = isset($_COOKIE['Block_sort']) ? true : false;
        $core->tpl->open('forum.short');
        $core->tpl->loadFile('board/forum.short');
        $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
        $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
        $short = '<form method="post" name="forumSearch" action="board/forum-' . $tid . '">
 <div class="padding">
   <select class="fiels select" name="order">
   <option value="subject" ' . (isset($_POST['order']) && $_POST['order'] == 'subject' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_theme'] . '</option>
   <option value="lastpost" ' . ((!isset($_POST['order']) || $_POST['order'] == 'lastpost') ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_last_post'] . '</option>
   <option value="starter" ' . (isset($_POST['order']) && $_POST['order'] == 'starter' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_author'] . '</option>
   <option value="started" ' . (isset($_POST['order']) && $_POST['order'] == 'started' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_create'] . '</option>
   <option value="replies" ' . (isset($_POST['order']) && $_POST['order'] == 'replies' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_answers'] . '</option>
   <option value="views" ' . (isset($_POST['order']) && $_POST['order'] == 'views' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_views'] . '</option>
   </select>
    </div>
   <div class="padding">
   <select class="fiels select" name="sort">
   <option value="ASC" ' . (isset($_POST['sort']) && $_POST['sort'] == 'ASC' ? 'selected="selected"' : '') . '>' . $lang['forum_vozrastanie'] . '</option>
   <option value="DESC" ' . ((!isset($_POST['sort']) || $_POST['sort'] == 'DESC') ? 'selected="selected"' : '') . '>' . $lang['forum_ubyvanie'] . '</option>
   </select>
   </div>
    <div class="padding">
   <input type="submit"  class="fbutton" value="' . $lang['forum_sort'] . '">
      </div>
</form>';
        $core->tpl->setVar('SHORT', $short);
        $core->tpl->end();
        $core->tpl->close();
        $cookie = isset($_COOKIE['Block_help']) ? true : false;
        $core->tpl->open('forum.help');
        $core->tpl->loadFile('board/forum.help');
        $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
        $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
        $permis = '<strong>' . (permission($tid, 'View') ? faSpan('fa-eye', true, $lang['forum_view_this']) : faSpan('fa-times-circle', true, $lang['forum_view_this'])) . '</strong><br/>
<strong>' . (permission($tid, 'Read') ? faSpan('fa-newspaper-o', true, $lang['forum_reading_order_of_the']) : faSpan('fa-times-circle', true, $lang['forum_reading_order_of_the'])) . '</strong><br/>
<strong>' . (permission($tid, 'Create') ? faSpan('fa-plus', true, $lang['forum_create_topics_in_this']) : faSpan('fa-times-circle', true, $lang['forum_create_topics_in_this'])) . '</strong><br/>
<strong>' . (permission($tid, 'Reply') ? faSpan('fa-reply', true, $lang['forum_respond_to_the_theme_of_this']) : faSpan('fa-times-circle', true, $lang['forum_respond_to_the_theme_of_this'])) . '</strong><br/>
<strong>' . (permission($tid, 'Edit') ? faSpan('fa-pencil-square-o', true, $lang['forum_editing_their_posts']) : faSpan('fa-times-circle', true, $lang['forum_editing_their_posts'])) . '</strong><br/>
<strong>' . (permission($tid, 'Moder') ? faSpan('fa-unlock', true, $lang['forum_you_moderator']) : faSpan('fa-lock', true, $lang['forum_you_are_not_moderator'])) . '</strong>';
        $core->tpl->setVar('PERMISSION', $permis);
        $core->tpl->end();
        $core->tpl->close();
    } else {
        location('/board');
    }
}

//продолжить
function showTopic($id, $toLast = false, $comment_num = 10, $newPage = false)
{
    global $db, $core, $config, $board_conf, $url, $user, $lang;
    $core->loadModLang('board');
    $name = $core->row_data('board_threads', 'id ="' . $id . '"');
    $showErr = false;
    $bb = new bb;
    $message = '&nbsp;';
    $brating = '';
    $i = 0;
    $topic_v = '';
    if ($name) {
        $num = $board_conf['posts_num'];
        $all = $core->sum_data('board_posts', 'tid ="' . $id . '"');
        $loc_link = '/board/topic-' . $id;
        if (isset($url[2]) && $url[2] == 'getlastpost') {
            $page = ceil($all / $num);
            location($loc_link . ($page > 1 ? '/page/' . $page . '#lastPost' : '#lastPost'));
        } elseif (isset($url[2]) && $url[2] == 'errorPost') {
            $page = ceil($all / $num);
            location($loc_link . ($page > 1 ? '/page/' . $page . '&err#lastPost' : '&err#lastPost'));
            $showErr = true;
        } else {
            $page = init_page();
        }
        $cut = ($page - 1) * $num;
        $link = $cut == 0 ? 'board/topic-' . $id : 'board/topic-' . $id . '/page/' . $page;
        menu();
        $core->upd_data('board_threads', 'views = views+1', 'id ="' . $id . '"');
        set_title(array($lang['forum_title'], $name['title']));
        $core->tpl->pages($page, $num, $all, 'board/topic-' . $id . '/{page}');
        $core->tpl->open('showTopic');
        $result = $db->query("SELECT p.*, u.id as uidd, u.place, u.signature, u.points, u.carma, g.name as gname, g.icon as gicon, g.color as gcolor, fu.thanks, fu.messages, fu.specStatus FROM `" . DB_PREFIX . "_board_posts` as p LEFT JOIN `" . DB_PREFIX . "_board_users` as fu ON(p.uid = fu.uid) LEFT JOIN `" . USER_DB . "`.`" . USER_PREFIX . "_users` as u ON(p.uid = u.id) RIGHT JOIN `" . USER_DB . "`.`" . USER_PREFIX . "_groups` as g ON(u.group = g.id) WHERE p.`tid` = '" . $id . "' ORDER BY p.`time` LIMIT " . $cut . ", " . $num . "");
        $page = $newPage ? intval($newPage) : init_page();
        $cut = ($page - 1) * $comment_num;
        if (permission($name['forum'], 'Read')) {
            $allowEdit = permission($name['forum'], 'Edit');
            $carmaUsers = array();
            $nowNumber = $all - $cut;
            while ($row = $db->getRow($result)) {
                if (!in_array($row['username'], $carmaUsers)) boardCarmaInit($row['uidd'], $row['username']);
                $carmaUsers[] = $row['username'];
                $i++;
                $comment_array[$row['parent_id']][] = $row;
                $topic_v = $topic_v . '<tr  id="entry' . $row['id'] . '">
<th style="padding:7px 7px 7px 7px; width:20%;">';
                $topic_v = ($i + $cut) == 1 ? $topic_v . ($name['icon'] ? Bicon($name['icon'], 't') : '') : $topic_v . Bicon('user.png', false);
                $topic_v = $topic_v . '<a href="profile/' . $row['username'] . '" title="' . $lang['profile'] . ': ' . $row['username'] . '">' . $row['username'] . '</a>
   </th>
   <th style="padding:7px 7px 7px 7px;">
      <div style="float:left;">' . Bicon('time.png', 'o') . ' <span class="message-data-time">' . formatDate($row['time'], true) . '</span></div>';
                $topic_v = $topic_v . '<div style="float:right;">';
                //  if (($i + $cut) == 1) $topic_v = $topic_v . boardDraw_rating($id, 'board', $name['score'], $name['votes']);
                // if ($row['id'] == $row['parent_id']) $topic_v = $topic_v . '<span class="message-data-time">&nbsp;<a href="' . $link . '#entry' . $row['id'] . '" title="">Ответ на сообщение №' . $cut . '</a></span>&nbsp;&nbsp;&nbsp;';

                $topic_v = $topic_v . $lang['forum_message'] . '<span class="message-data-time">&nbsp;<a href="' . $link . '#entry' . $row['id'] . '" title="' . $lang['forum_move_to_message'] . '">№' . ($i + $cut) . '</a></span></div>';
                $message = $core->bbDecode(parseBB($row['message']));
                $message = str_replace(array('media/'), array($config['url'] . '/media/'), $message);
                $topic_v = $topic_v . '</th>
 </tr>
 <tr class="thNOanim">
    <td class="thNOanim" style="vertical-align: top;">
<div class="chat-headers clearfix">
<div style ="float:left">
      <img alt="avatar" src ="' . avatar($row['uid']) . '" class="avatar list-unstyled chat-list mt-2 mb-0 padding"  style="border:0;"><br/><br/>
   </div>
       <div style ="float:right">
       ' . $lang['forum_group'] . ': ' . colorSpan($row['gcolor'], $row['gname']) . ' <br/>
       ' . $lang['forum_user_n'] . ': ' . $row['uidd'] . '<br/>
       ' . $lang['forum_messages'] . ': ' . (isset($row['messages']) > 0 ? filter($row['messages']) : '0') . '<br/>
       ' . $lang['forum_reputation'] . ': <a href ="javascript:void(0)" onclick ="carmaHistory(\'' . $row['uidd'] . '\')"> <span id ="pcarma' . $row['uidd'] . '">' . ($row['carma'] > 0 ? ' + ' . $row['carma'] : $row['carma']) . '</span> </a> <br/>
       ' . ($row['place'] ? $lang['forum_sfrom'] . ': ' . $row['place'] . '<br/>' : '') . '
           <a href ="javascript:void(0)" onclick ="javascript:insertCode(\'b\', \'nick\', \'' . $row['username'] . '\'); gid(\'qr\').style.display = \'block\';">' . $lang['forum_insert_nick'] . '</a>
     <br/>
     </div></div>
 </td>
    <td class="thNOanim" style="width:80%; vertical-align: top;">';
                if ($core->auth->isUser && $name['closed'] == 0) {
                    $topic_v = $topic_v . '<div class="reply" style ="float:right">
        <a href ="javascript:void(0)" onclick ="javascript:reply_quick(\'' . $row['id'] . '\'); gid(\'reply_to\').style.display = \'block\';"><span class="smallPart">Ответить<i class="fa fa-level-down spaceLeft"></i></span></a>
        </div>
        <br/><br/>';
                }
                $topic_v = $topic_v . '<div class="forumMessage message other-message " id ="fastEdit-' . $row['id'] . '">' . attachForum($message, $row['files']) . '</div>
              ' . ($row['signature'] ? '<br/><br/>-------------------- <br/><noindex>' . $core->bbDecode($row['signature']) . '</noindex>' : '') . '</td>
                </tr>
                <tr class="thNOanim" style ="padding:5px;">
                   <td class="thNOanim" style ="padding:5px;">
                       <div style ="float:left">
                          <a href ="javascript:void(0)" title ="' . $lang['forum_karma_plus'] . '" onclick ="javascript:modal_box(\'carma' . $row['uidd'] . '\')" style ="color:white">' . Bicon('plus.png', true, true) . '</a>
                          <a href ="javascript:void(0)" title ="' . $lang['forum_karma_minus'] . '" onclick ="javascript:modal_box(\'carma' . $row['uidd'] . '\')" style ="color:white">' . Bicon('minus.png', true, true) . '</a>
                       </div>
                  </td>
                   <td class="thNOanim" style ="padding:5px;">
                      <div style ="float:left">
                      <a href ="javascript:void(0)" onclick ="javascript:QuickQuote(\'s\', \'qickMessage\'); gid(\'qr\').style.display = \'block\';">' . $lang['quotes'] . '</a> </div>';
                if (($allowEdit && $row['uid'] == $core->auth->user_id) || $core->auth->isAdmin) {
                    $topic_v = $topic_v . '<div style ="float:right">';
                    if (($i + $cut) != 1) $topic_v = $topic_v . '<div style ="float:right"><a href ="javascript:void(0)" onclick ="javascript:forumPostDelete(\'' . $row['id'] . '\', \'fastEdit-' . $row['id'] . '\')" title ="' . $lang['delete'] . '">' . Bicon('del.png', true) . '</a></div>';
                    $topic_v = $topic_v . '<div style ="float:right"><a href ="javascript:void(0)" onclick ="javascript:forumPostEdit(\'' . $row['id'] . '\', \'fastEdit-' . $row['id'] . '\')" title ="' . $lang['forum_fast_edit'] . '">' . Bicon('edit_add.png', true) . '</a></div>';
                    $topic_v = $topic_v . '<div style ="float:right"><a href ="board/editPost/' . $row['id'] . '/' . md5($core->auth->user_info['tail'] . '-' . date('d')) . '/' . $page . '" title ="' . $lang['forum_full_edit'] . '">' . Bicon('fullEdit.png', true) . '</a></div>
        </div>';
                }
                $topic_v = $topic_v . '</td>
                </tr>';
            }
        } else {
            $topic_v = $topic_v . '<tr>
     <td class="row4" style="text-align:center;">' . $lang['forum_group_users'] . '<strong>' . $core->auth->user_info['gname'] . '</strong>' . $lang['forum_read_denied'] . '</td>
  </tr>';
        }
        if ((permission($name['forum'], 'Moder')) && (permission($name['forum'], 'Reply'))) {
            $topic_v = $topic_v . '<tr class="thNOanim">
   <td class="thNOanim" colspan ="2">';
        }
        if ($name['closed'] == 0) {
            if (permission($name['forum'], 'Moder')) {
                $topic_v = $topic_v . '<div style ="float:left">
         <form id ="tablesForm" method ="post" action ="board/do">
          <div class="padding">
            <input type ="hidden" name ="ttid" value ="' . $name['id'] . '">
            <input type ="hidden" name ="fid" value ="' . $id . '">
            <select  class="fiels select" name ="deiv">
               <option value ="important">' . $lang['forum_important'] . '</option>
               <option value ="noimportant">' . $lang['forum_usual'] . '</option>
               <option value ="close">' . $lang['forum_close'] . '</option>
               <option value ="open">' . $lang['forum_open'] . '</option>
               <option value ="delete">' . $lang['forum_delete'] . '</option>
            </select>
            </div>
             <div class="padding">
            <input type ="submit" class="fbutton" value ="' . $lang['forum_submit_gogo'] . '">
            </div>
         </form>
      </div>';
            }
            if (permission($name['forum'], 'Reply')) {
                $topic_v = $topic_v . '<div style="text-align:right; float:right">
                <div class="padding">
         <a href ="#" onclick ="showhide(\'qr\'); return false;">
            <input type ="submit" class="fbutton" value ="' . $lang['forum_write_answer'] . '">
      </div>
      </div>';
            }
        } else {
            $topic_v = $topic_v . '<div style="text-align:right; float:right">' . Bicon('t_closed.gif', 'b') . '</div>';
        }
        if ((permission($name['forum'], 'Moder')) && (permission($name['forum'], 'Reply'))) $topic_v = $topic_v . '</td> </tr>';
        $uniqCode = '';
        $err = isset($_GET['err']) ? $_GET['err'] : '';
        $_showErr = isset($showErr) ? $showErr : '';
        if ($name['closed'] == 0) {
            if ($core->auth->isUser) {
                if ($err || $_showErr) {
                    $showErr = true;
                    $core->tpl->info($lang['forum_message_text_null']);
                }
                $uniqCode = gencode(10);
            }
        }
        $bb_area = $user['editor'] == "htmlEditor" ? 'bb_area' : 'edit_area';
        $bb = $bb_area('qickMessage', '&nbsp;', 6, 'textarea', false, true);
        $cookie = isset($_COOKIE['Block_view']) ? true : false;
        $core->tpl->open('topic.view');
        $core->tpl->loadFile('board/topic.view');
        $core->tpl->setVar('ID', $id);
        $core->tpl->setVar('TITLE', $name['title']);
        $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
        $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
        $core->tpl->setVar('RATING', draw_rating($id, 'board', $name['score'], $name['votes']));
        $core->tpl->setVar('ACTION', ((permission($name['forum'], 'Edit') && $name['poster'] == $core->auth->user_id || $core->auth->isAdmin) ? ' [ <a href ="board/user/editThread/' . $name['id'] . '/' . md5($core->auth->user_info['tail'] . '-' . date('d')) . '">' . $lang['edit'] . '</a>-' . ($name['closed'] == 1 ? '<a href ="board/user/open/' . $name['id'] . '/' . md5($core->auth->user_info['tail'] . '-' . date('d')) . '">' . $lang['forum_open_theme'] . '</a>' : '<a href ="board/user/close/' . $name['id'] . '/' . md5($core->auth->user_info['tail'] . '-' . date('d')) . '">' . $lang['forum_close_themeadmin'] . '</a>') . ' - <a href ="board/user/delete/' . $name['id'] . '/' . md5($core->auth->user_info['tail'] . '-' . date('d')) . '">' . $lang['forum_delete_theme'] . '</a>  ]' : ''));
        $core->tpl->setVar('LADDER', '<div id ="breadcrumbs-one"><li>' . stremyanka($name['forum'], 'linked') . '<a href ="board/forum-' . $name['id'] . '" title ="' . $name['title'] . '">' . $name['title'] . '</a></li></div>');
        $core->tpl->setVar('SLADDER', '<div style="text-align:right;"> <select name ="url" id ="ulrGo">' . stremyanka($name['forum'], 'list') . '</select>  <div style="float:right"><div class="padding"> <input type ="button" value ="' . $lang['forum_move_to_section'] . '" onclick ="window.location = \'/\' + gid(\'ulrGo\').value;"></div></div></div>');
        $core->tpl->setVar('TOPIC', $topic_v);
        $core->tpl->setVar('FORUM', $name['forum']);
        $core->tpl->setVar('SHOW_EDIT', (!isset($showErr) ? 'display:none' : ''));
        $core->tpl->setVar('UPLOAD', (($board_conf['loadFiles'] == 1) ? '<div style="text-align:left; padding-top:10px;"> <a href ="javascript:void(0)" onclick ="showhide(\'fileUpload\');">' . $lang['file_editor'] . '</a><br/><div id ="fileUpload" style ="display:none;">' . forumUpload($uniqCode) . '</div></div>' : ''));
        $array_replace["#\\[search_by_forums\\](.*?)\\[/search_by_forums\\]#is"] = (($i == $db->numRows($result)) ? '\\1' : '');
        $array_replace["#\\[close\\](.*?)\\[/close\\]#is"] = (($name['closed'] == 0) ? '\\1' : '');
        $array_replace["#\\[rating\\](.*?)\\[/rating\\]#is"] = (($core->auth->user_id) ? '\\1' : '');
        $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
        $core->tpl->setVar('TEXTAREA', '<div id="MessageBox_' . $id . '">' . "\n" . $bb . '</div>' . "\n");
        $core->tpl->end();
        $core->tpl->close();
        $core->tpl->close();
        $core->tpl->pages($page, $num, $all, 'board/topic - ' . $id . ' /{page}');
    } else {
        location('/board');
    }
}

function boardCarmaInit($uid, $uname)
{
    global $core, $lang;
    require_once(ROOT . 'usr/plugins/modal_box/init.php');
    if ($core->auth->isUser == false) {
        $content = '<div class="mbmest">' . $lang['forum_change_karma_registered_only'] . '</div>';
    } elseif ($uid == $core->auth->user_info['id']) {
        $content = '<div class="mbmest">' . $lang['forum_karma_yourself_denied'] . '</div>';
    } elseif (isset($_COOKIE['carma' . $uid])) {
        $content = '<div class="mbmest">' . $lang['forum_karma_user_dont_again'] . '</div>';
    } else {
        $content = '<table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;"><tr><td style ="width:30%; vertical-align: top;">' . $lang['forum_action'] . ':</td><td><select class="date_selection" id = "carmaDo" style ="width:90%;"><option value ="p">' . $lang['forum_reputation_plus'] . '</option><option value ="m">' . $lang['forum_reputation_minus'] . '</option><option value ="n">' . $lang['forum_neutral'] . '</option></select></td></tr><tr><td><br/></td></tr><tr><td style="vertical-align: top;">' . $lang['forum_message_to_user'] . ': </td><td><textarea id = "carmaText" name ="textarea" style ="width:90%;" rows ="4"></textarea><br/><sup>' . $lang['forum_max_symbols'] . '</sup></td></tr><tr><td>&nbsp;</td><td><input type ="button" value ="' . $lang['send'] . '" class="inputsubmit" onclick ="addCarma(\'' . $uid . '\', \'carma' . $uid . '\')"></td></tr></table>';
    }
    modal_box($lang['forum_user_karma_changing'], $lang['forum_karma_select_action'] . '"<b>' . $uname . '</b>"', $content, 'carma' . $uid);
    $core->tpl->headerIncludes['carmaHistoryBoard'] = '<script>function carmaHistory(uid) {
    modal_box(\'carmaHistory\'+uid); AJAXEngine.showedLoadBar = \'\'; AJAXEngine.sendRequest(\'ajax.php?do=carmaHistory&uid=\'+uid, \'carmaHistory\'+uid); }</script>';
    modal_box($lang['forum_user_karma_history'], $lang['forum_karma_history'] . '"<b>' . $uname . '</b>"', '<div id="carmaHistory' . $uid . '"><div class="mbmest">' . $lang['forum_karma_loading'] . '</div></div>', 'carmaHistory' . $uid);
}

//поиск
function searchForum()
{
    global $db, $core, $board_conf, $url, $lang;
    $core->loadModLang('board');
    $orderType = isset($_POST['order']) ? filter($_POST['order'], 'a') : '';
    $fidSearch = isset($_POST['fid']) ? intval($_POST['fid']) : '';
    $query = isset($_POST['query']) ? filter($_POST['query'], 'a') : '';
    $name = $core->row_data('board_threads', 'id ="' . $fidSearch . '"');
    $tid = isset($name['id']) ? $name['id'] : false;
    $where = $fidSearch ? " WHERE title LIKE '%" . $db->safesql($query) . "%' AND forum = '" . $fidSearch . "'" : " WHERE title LIKE '%" . $db->safesql($query) . "%'";
    switch ($orderType) {
        default:
            $orderBy = 'lastTime';
            break;
        case 'subject':
            $orderBy = 'title';
            break;
        case 'lastpost':
            $orderBy = 'lastTime';
            break;
        case 'starter':
            $orderBy = 'poster';
            break;
        case 'started':
            $orderBy = 'startTime';
            break;
        case 'replies':
            $orderBy = 'replies';
            break;
        case 'views':
            $orderBy = 'views';
            break;
    }
    $orderHow = isset($_POST['sort']) && $_POST['sort'] == 'ASC' ? 'ASC' : 'DESC';
    set_title(array($lang['forum_title'], $query));
    menu();
//$core->tpl->open();
//    echo '<a href="board">' . $lang['forum_title'] . '</a>' . $lang['search'];
//$core->tpl->close();
    $num = $board_conf['threads_num'];
    $page = init_page();
    $cut = ($page - 1) * $num;
    $all = $core->sum_data('board_threads', $where);
    $result = $db->query("SELECT t.*, u.nick FROM `" . DB_PREFIX . "_board_threads` as t LEFT JOIN `" . USER_DB . "`.`" . USER_PREFIX . "_users` as u on(t.poster = u.id) $where ORDER BY " . $orderBy . " " . $orderHow . " LIMIT " . $cut . ", " . $num . "");
    if ($db->numRows($result) > 0) {
        while ($row = $db->getRow($result)) {
            $topics[$row['important']][$row['id']] = $row;
        }
        if (isset($topics[1])) {
            $warn = 0;
            $topic_important = '';
            foreach ($topics[1] as $id => $row) {
                $icon = Bstat($row);
                $warn++;
                $topic_important = $topic_important . '<tr>
   <td class="hidden-xs" style="text-align:center">' . Bicon($icon, 'i') . '</td>
   <td style="text-align:center">' . Bicon($row['icon'], 't') . '</td>
   <td><b><a href="board/topic-' . $row['id'] . '" title="' . $lang['forum_in_section'] . '&nbsp;' . $row['title'] . '">' . $row['title'] . '</a></b></td>
   <td class="hidden-xs" style="text-align:center"><a href="profile/' . $row['nick'] . '" title="' . $lang['forum_author_theme'] . '&nbsp;' . $row['nick'] . '">' . $row['nick'] . '</a></td>
   <td class="hidden-xs" style="text-align:center">' . $row['replies'] . '</td>
   <td class="hidden-xs" style="text-align:center">' . $row['views'] . '</td>
   <td  nowrap="nowrap">' . formatDate($row['lastTime'], true) . '<br/>
      <b>' . $lang['forum_last'] . ':</b> <a href="profile/' . $row['lastPoster'] . '" title="' . $lang['forum_last_otvetevshy'] . '">' . $row['lastPoster'] . '</a>
   </td>';
                if (permission($tid, 'Moder')) $topic_important = $topic_important . '
   <td style="text-align:center"><input type="checkbox"  style="height: 14px;" name="checks[]" value="' . $id . '"></td>';
                $topic_important = $topic_important . '</tr>';
            }
        }
        $i = 0;
        if (isset($topics[0])) {
            $topic_last = '';
            foreach ($topics[0] as $id => $row) {
                $i++;
                $icon = Bstat($row);
                $topic_last = $topic_last . '<tr>
   <td class="hidden-xs" style="text-align:center">' . Bicon($icon, 'i') . '</td>
   <td class="hidden-xs" style="text-align:center">' . Bicon($row['icon'], 't') . '</td>
   <td><b><a href="board/topic-' . $row['id'] . '" title="' . $lang['forum_in_section'] . '&nbsp;' . $row['title'] . '">' . $row['title'] . '</a></b></td>
   <td class="hidden-xs" style="text-align:center"><a href="profile/' . $row['nick'] . '" title="' . $lang['forum_author_theme'] . '&nbsp;' . $row['nick'] . '">' . $row['nick'] . '</a></td>
   <td class="hidden-xs" style="text-align:center">' . $row['replies'] . '</td>
   <td class="hidden-xs" style="text-align:center">' . $row['views'] . '</td>
   <td  nowrap="nowrap">' . formatDate($row['lastTime'], true) . '<br/>
      <b>' . $lang['forum_last'] . ':</b> <a href="profile/' . $row['lastPoster'] . '" title="' . $lang['forum_last_otvetevshy'] . '">' . $row['lastPoster'] . '</a>
   </td>';
                if (permission($tid, 'Moder')) $topic_last = $topic_last . '
   <td style="text-align:center"><input type="checkbox" style="height: 14px;"  name="checks[]" value="' . $id . '"></td>';
                $topic_last = $topic_last . '</tr>';
            }
        }
    }
    $name = $core->row_data('board_forums', 'id ="' . isset($topics[0]) . '"');
    $cookie = isset($_COOKIE['Block_list']) ? true : false;
    $core->tpl->open('topic.list');
    $core->tpl->loadFile('board/topic.list');
    $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
    $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
    $core->tpl->setVar('TITLE', 'Поиск по форуму');
    $core->tpl->setVar('NEW_TOPIC', ((permission(isset($topics[0]), 'Reply') && (isset($name) ? $name['open'] == 0 : '')) ? '<a href="board/newTopic/' . isset($topics[0]) . '">' . $lang['forum_new_topics'] . '</a>' : ''));
    $array_replace["#\\[moder\\](.*?)\\[/moder\\]#is"] = ((permission(isset($topics[0]), 'Moder')) ? '\\1' : '');
    $array_replace["#\\[nomoder\\](.*?)\\[/nomoder\\]#is"] = ((!permission(isset($topics[0]), 'Moder')) ? '\\1' : '');
    $array_replace["#\\[important\\](.*?)\\[/important\\]#is"] = ((isset($topics[1])) ? '\\1' : '');
    $array_replace["#\\[last\\](.*?)\\[/last\\]#is"] = ((isset($topics[0])) ? '\\1' : '');
    $array_replace["#\\[admin\\](.*?)\\[/admin\\]#is"] = (($core->auth->isAdmin) ? '\\1' : '');
    $array_replace["#\\[search\\](.*?)\\[/search\\]#is"] = (!isset($_POST['query']) ? '\\1' : '');
    $array_replace["#\\[noempty\\](.*?)\\[/noempty\\]#is"] = ((isset($topics[0]) && count($topics[0]) == $i || isset($topics[1]) && count($topics[1]) == $warn) ? '\\1' : '');
    $array_replace["#\\[empty\\](.*?)\\[/empty\\]#is"] = ((!(isset($topics[0]) && count($topics[0]) == $i || isset($topics[1]) && count($topics[1]) == $warn)) ? '\\1' : '');
    $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
    $core->tpl->setVar('TOPIC_IMPORTANT', (!empty($topic_important) ? $topic_important : ''));
    $core->tpl->setVar('TOPIC_LAST', (!empty($topic_last) ? $topic_last : ''));
    $core->tpl->setVar('T_ID', isset($topics[0]) ? $topics[0] : '');
    $core->tpl->setVar('ID', isset($name['id']) ? $name['id'] : '');
    $core->tpl->setVar('QUERY', $query);
    $core->tpl->setVar('MASSAGE', (($query) ? $lang['forum_no_found_try_again'] . '&nbsp;&nbsp;» <a href="javascript:history.back()" onclick="/' . $url[0] . '" >' . $lang['back'] . '</a>' : $lang['forum_enter_text_for_search']));
    $core->tpl->setVar('LADDER', isset($name['id']) ? '<div id="breadcrumbs-one"><li>' . stremyanka($name['id'], 'linked') . '<a href="board/forum-' . $name['id'] . '" title="' . $name['title'] . '">' . $name['title'] . '</a></li></div>' : '');
    $core->tpl->end();
    $core->tpl->close();
    $cookie = isset($_COOKIE['Block_sort']) ? true : false;
    $core->tpl->open('forum.short');
    $core->tpl->loadFile('board/forum.short');
    $core->tpl->setVar('COOKIE_IMG', ($cookie ? 'close' : 'open'));
    $core->tpl->setVar('COOKIE_DIS', ($cookie ? 'none' : 'block'));
    $short = '<form method="post" name="forumSearch" action="board/search">
  <div class="padding">
   <select class="fiels select"  name="order">
   <option value="subject" ' . (isset($_POST['order']) && $_POST['order'] == 'subject' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_theme'] . '</option>
   <option value="lastpost" ' . ((!isset($_POST['order']) || $_POST['order'] == 'lastpost') ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_last_post'] . '</option>
   <option value="starter" ' . (isset($_POST['order']) && $_POST['order'] == 'starter' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_author'] . '</option>
   <option value="started" ' . (isset($_POST['order']) && $_POST['order'] == 'started' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_create'] . '</option>
   <option value="replies" ' . (isset($_POST['order']) && $_POST['order'] == 'replies' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_answers'] . '</option>
   <option value="views" ' . (isset($_POST['order']) && $_POST['order'] == 'views' ? 'selected="selected"' : '') . '>' . $lang['forum_sort_by_views'] . '</option>
   </select>
   <select class="fiels select" name="sort">
   <option value="ASC" ' . (isset($_POST['sort']) && $_POST['sort'] == 'ASC' ? 'selected="selected"' : '') . '>' . $lang['forum_vozrastanie'] . '</option>
   <option value="DESC" ' . ((!isset($_POST['sort']) || $_POST['sort'] == 'DESC') ? 'selected="selected"' : '') . '>' . $lang['forum_ubyvanie'] . '</option>
   </select>
    </div>
   <div class="padding">
   <input type="submit" value="' . $lang['forum_sort'] . '">
    </div>
</form>';
    $core->tpl->setVar('SHORT', $short);
    $core->tpl->end();
    $core->tpl->close();
}

function forumUpload($uniqCode, $start = 1)
{
    global $board_conf, $lang;
    $content = '<script type="text/javascript">var i = ' . $start . '; function addUploadInput() { i++; gid(\'addUploadInput\').innerHTML += \'<div style="margin-top:3px;"><input name="files[\' + i + \']" type="file" size="35"> [file=\'+i+\']</div>\'; }</script>';
    $content .= $lang['forum_alows_expansions'] . '<b>' . $board_conf['formats'] . '</b><br/><br/>' . $lang['forum_max_size'] . '<b>' . formatfilesize($board_conf['maxSize']) . '</b><br/><br/>' . $lang['forum_picture_max_size'] . '<b>2 000 x 2 000 px</b>';
    $content .= '<br/><br/><input name="files[' . $start . ']" type="file" size="35"> [file=' . $start . '] [ <a href="javascript:void(0)" onclick="addUploadInput()">+</a> ]
<div id="addUploadInput"></div>
<sup><br/>' . $lang['forum_upload_info'] . '</sup>';
    return $content;
}

function Bstat($row)
{
    if ($row['closed'] == 1) {
        $icon = 'closed.gif';
    } elseif ($row['replies'] > 20 && $row['views'] > 400) {
        $icon = $row['lastTime'] > time() - 86400 ? 'hot_new.gif' : 'hot.gif';
    } elseif (($row['lastTime'] > time() - 86400) && $row['replies'] < 20 && $row['views'] < 400) {
        $icon = $row['important'] == 1 ? 'hot_new.gif' : 'norm_new.gif';
    } elseif ($row['isUserPost'] > 0) {
        $icon = 'thread.gif';
    } else {
        $icon = 'norm_nonew.gif';
    }
    return $icon;
}

function Bicon($icon, $type = false, $edir = false, $size = false)
{
    $dir = '';
    switch ($type) {
        case 'i':
            $dir = 'icons';
            break;
        case 'b':
            $dir = 'buttons';
            break;
        case 't':
            $dir = 'theme_icon';
            break;
        case 'o':
            $dir = 'other';
            break;
    }
    $size = $size ? 'width="48" height="48"' : '';
    $dirs = $edir ? 'edit' : ($dir == 'other' ? 'other' : 'board/' . $dir);
    return $icon ? '<img alt="" src="media/' . $dirs . '/' . $icon . '" class="icon avatar" ' . $size . ' border="0">' : '<img alt="" src="media/cats/no_image.png"' . $size . ' border="0">';
}

function board_theme_icon($type, $ic = '')
{
    global $lang;
    if ($type == 'r') {
        $icon = '<div align ="left" style ="float:left"><input type="radio" name="icon" value="" checked=""> Нет иконки<br/>';
        $path = ROOT . 'media/board/theme_icon/';
        $dh = opendir($path);
        $c = 0;
        while ($file = readdir($dh)) {
            if (eregStrt('.gif', $file)) {
                $check = $ic == $file ? 'checked' : '';
                $icon = $icon . '<div align ="left" style ="float:left"><label><input type="radio" name="icon"  class="icon avatar" value="' . $file . '" ' . $check . '>' . Bicon($file, 't', false, true) . '</label></div>';
            }
        }
        closedir($dh);
    } elseif ($type == 's') {
        $path = 'media/board/theme_icon/';
        $dh = opendir(ROOT . $path);
        $icon = '<select name="icon" id="icon" class="fiels select" onchange="changeIcon(\'' . $path . '\' + this.value, \'iconImg\')" style="height: auto; overflow: hidden; z-index: 40000;"  multiple="multiple">
                    <option value="no_image.png">' . $lang['cats_icon_no'] . '</option>';
        while ($file = readdir($dh)) {
            if (eregStrt('.gif', $file)) {
                $selected = $ic == $file ? "selected" : "";
                $icon .= '<option value="' . $file . '"' . $selected . '>' . $file . '</option>';
            }
        }
        $icon .= '</select>';
        $icon = '<div align ="left" style ="float:left"><img src="' . $path . $ic . '" id="iconImg" class="icon avatar" border="0" alt="' . $ic . '"/></div><div align ="left" style ="float:left">' . $icon . '</div>';
    } else {
        return;
    }
    return $icon;
}

function check_views()
{
    global $core;
    $forum = $core->row_data('board_forums');
    if (isset($forum['posts']) && $forum['posts'] < 0) $core->upd_data('board_forums', 'posts = 0', 'id ="' . $forum['id'] . '"');
    return;
}