<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_SWITCH')) {
    header('Location: /');
    exit;
}
global $adminTpl, $core, $db, $admin_conf, $config, $content_conf, $url, $lang;
ConfigMod('content');
switch ($url[3] ?? null) {
    default:
        content_main();
        break;
    case 'add':
        content_add();
        break;
    case 'save':
        content_save();
        break;
    case 'edit':
        $id = intval($url[4]);
        content_add($id);
        break;
    case 'delete':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            delete($id);
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'retivate':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('content', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $active = $rows['active'] == 0 || $rows['active'] == 2 ? 1 : 0;
            $core->upd_data('content', 'active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_content'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'cleanccomm':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('content', 'id ="' . $id . '"');
            $core->upd_data('content', 'comments = 0', 'id ="' . $id . '"');
            $core->del_data('comments', 'post_id ="' . $id . '" AND module ="content"');
            $core->ins_log(false, $lang['logs_change_clearcounter_content_comm'], 1, false, false, $rows['description'], false);
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'cleancviews':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('content', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $core->upd_data('content', 'views = 0', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_clearcounter_content_views'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'moder_moderation':
    case 'activate':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('content', 'id ="' . $id . '"');
            $core->upd_data('content', 'active = 1', 'id ="' . $id . '"');
            $core->upd_data('users', 'user_news = user_news+1', 'nick ="' . $rows['author'] . '"');
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'moderation':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('content', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $core->upd_data('content', 'active = 2', 'id ="' . $id . '"');
            $core->upd_data('users', 'user_news = user_news-1', 'nick ="' . $rows['author'] . '"');
            $core->ins_log(false, $lang['logs_change_moderation_content'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'deactivate':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('content', 'id ="' . $id . '"');
            $core->upd_data('content', 'active = 0', 'id ="' . $id . '"');
            $core->upd_data('users', 'user_news = user_news-1', 'nick ="' . $rows['author'] . '"');
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'cats':
        $cat_id = isset($url[4]) ? ',' . $url[4] . ',' : 0;
        $id = isset($url[5]) ? intval($url[5]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('content', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $active = $rows['active'] == 0 || $rows['active'] == 2 ? 1 : 0;
            $core->upd_data('content', 'cat ="' . $cat_id . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_content'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'content');
        } else {
            action_alert('urs', 'danger', 'content', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('content', 'active = 1', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'content');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('content', 'active = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'content');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('content', 'active = NOT `active`', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'content');
                    }
                    break;
                case 'cleancomm':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('content', 'comments = 0', 'id ="' . intval($id) . '"');
                        $core->del_data('comments', 'post_id ="' . $id . '" AND module ="content"');
                        action_alert('urs', 'success', 'content');
                    }
                    break;
                case 'cleanviews':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('content', 'views = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'content');
                    }
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        delete($id);
                        action_alert('urs', 'success', 'content');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('urs', 'danger', 'content');
        }
        break;
    case 'ajax':
        global $adminTpl, $core, $url, $db, $lang;
        ajaxInit();
        $status = $url[1] == 'module';
        $module = $status ? ($url[2] ?? '') : ($url[1] ?? '');
        $type = $status ? ($url[4] ?? '') : ($url[3] ?? '');
        $count = $status ? ($url[5] ?? '') : ($url[4] ?? '');
        $id = $status ? ($url[6] ?? '') : ($url[5] ?? '');
        $u7 = $url[7] ?? '';
        $where = $status ? ' WHERE ' . $u7 : ' WHERE ' . $url[6];
        $swhere = str_replace(array('WHERE'), array(''), $where);
        switch ($type) {
            case 'isurl':
                if (isset($_POST['translate'])) {
                    if (!preg_match("/^[a-zA-Z0-9_-]+$/", $_POST['translate'])) {
                        echo(json_encode($lang['static_add_url_err_2']));
                    } else {
                        $query = $core->select_data('content', 'translate ="' . $db->safesql($_POST['translate']) . '"');
                        $result = ($db->numRows($query) > 0) && ($url[5] != 'update') ? 'false' : 'true';
                        echo $result;
                    }
                }
                break;
            case 'date':
                $rows = $core->row_data('content', $where);
                $counter = $count == 'core' ? $core->sum_data($module, $swhere) : $rows[$count];
                echo formatDate($counter, true);
                break;
            case 'count':
                $rows = $core->row_data('content', $where);
                $counter = $count == 'core' ? $core->sum_data($module, $swhere) : $rows[$count];
                echo formatCounter($counter);
                break;
            case 'loadtpl':
                $file = (isset($url[5]) && file_exists('usr/tpl/' . $config['tpl'] . '/content/' . $url[5] . '/content-view.tpl')) ? $url[5] : '';
                $text = htmlspecialchars(file_get_contents(ROOT . 'usr/tpl/' . $config['tpl'] . '/content/' . $file . '/content-view.tpl'), ENT_QUOTES);
                $count_rows = count(explode("\n", $text)) * 20;
                echo int_cong('textarea', 'templ', $text, '_code', 'style="width: 100%; height: 280px"');
                break;
        }
        break;
    case 'config':
        init_count_text();
        require(ROOT . 'etc/content.config.php');
        $configBox = array(
            'content' => array(
                'varName' => 'content_conf',
                'title' => $lang['static_config_title'],
                'groups' => array(
                    'main' => array(
                        'title' => $lang['config_main'],
                        'vars' => array(
                            'num' => array(
                                'title' => $lang['static_config_post'],
                                'description' => $lang['static_config_post_t'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'comments_num' => array(
                                'title' => $lang['static_config_com'],
                                'description' => $lang['static_config_com_t'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'allowComm' => array(
                                'title' => $lang['static_config_comp'],
                                'description' => $lang['static_config_comp_t'],
                                'content' => radio("allowComm", $content_conf['allowComm']),
                            ),
                            'thumb_width' => array(
                                'title' => $lang['static_config_thumb'],
                                'description' => $lang['static_config_thumb_t'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'related' => array(
                        'title' => $lang['static_config_related'],
                        'vars' => array(
                            'related' => array(
                                'title' => $lang['static_config_relatedt'],
                                'description' => $lang['static_config_relatedd'],
                                'content' => radio("related", $content_conf['related']),
                            ),
                            'related_content_img' => array(
                                'title' => $lang['static_config_related_imgt'],
                                'description' => $lang['static_config_related_imgd'],
                                'content' => radio("related_content_img", $content_conf['related_content_img']),
                            ),
                            'related_content_img_thumbs' => array(
                                'title' => $lang['static_config_related_thumbst'],
                                'description' => $lang['static_config_related_thumbsd'],
                                'content' => radio("related_content_img_thumbs", $content_conf['related_content_img_thumbs']),
                            ),
                            'related_content_img_height' => array(
                                'title' => $lang['static_config_related_heightt'],
                                'description' => $lang['static_config_related_heightd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'related_content_img_widtht' => array(
                                'title' => $lang['static_config_related_widthtt'],
                                'description' => $lang['static_config_related_widthtd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'related_content' => array(
                                'title' => $lang['static_config_main_relatedt'],
                                'description' => $lang['static_config_main_relatedd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'bookmarks' => array(
                        'title' => $lang['static_config_bookmarks'],
                        'vars' => array(
                            'bookmarks' => array(
                                'title' => $lang['static_config_main_bookmarkst'],
                                'description' => $lang['static_config_main_bookmarksd'],
                                'content' => radio("bookmarks", $content_conf['bookmarks']),
                            ),
                            'numbookmarks' => array(
                                'title' => $lang['static_config_numbookmarks'],
                                'description' => $lang['static_config_numbookmarksd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'seo' => array(
                        'title' => $lang['seo'],
                        'vars' => array(
                            'keywords' => array(
                                'title' => $lang['seo_keywords'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'keywords'),
                            ),
                            'description' => array(
                                'title' => $lang['seo_description'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'description'),
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'content', '{MOD_LINK}/config', $ok);
        break;
}
function content_main(): void
{
    global $adminTpl, $core, $db, $admin_conf, $content_conf, $url, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $order = '';
    $cats_arr = $core->aCatList('content');
    $cats = (isset($url[3]) && $url[3] == 'cat') ? '/' . $url[4] : '';
    if (isset($url[3]) && $url[3] == 'cat') {
        if ($url[4] <> false) {
            foreach ($cats_arr as $cid => $name) {
                if (in_array($cid, $cats_arr)) {
                    if ($cid == $url[4]) $where = '`cat` =",' . $cid . ',"';
                } else {
                    $where = '`cat` =",' . $url[4] . ',"';
                }
            }
        } else {
            $where = '`cat` =",' . $url[4] . ',"';
        }
    } else {
        $where = 'n.id != 0';
    }
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : ((isset($url[3]) && $url[3] == 'user_news') ? (isset($url[4]) ? $url[4] : '') : '');
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_tags = (isset($url[3]) ? $url[3] == 'tag' : '') ? $url[4] : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_cat = isset($_POST['s_cat']) ? intval($_POST['s_cat']) : '';
    $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
    $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
    $s_day = isset($_POST['s_day']) ? intval($_POST['s_day']) : '';
    $s_active = isset($_POST['s_active']);
    $s_search = isset($_POST['s_search']);
    $where .= (isset($url[3]) && $url[3] == 'users_news_delete') ? 'AND active = 3' : ($s_active ? ($_POST['s_active'] == 1 ? 'AND n.active = 1' : 'AND n.active = 0') : 'AND n.active != 2');
    $whereC = str_replace(array('n.'), array(''), $where);
    $where .= 'AND l.lang ="' . $core->InitLang() . '"';
    if ($s_day) $where .= 'AND n.`date`>="' . mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")) . '"';
    if ($s_id) $where .= 'AND n.`id` LIKE"%' . $db->safesql($s_id) . '%"';
    if (!$s_id) $s_id = '';
    if ($s_author || isset($url[3]) && $url[3] == 'user_news') $where .= 'AND n.`author` LIKE"%' . $db->safesql($s_author) . '%"';
    if ($s_title) $where .= 'AND l.`title` LIKE"%' . $db->safesql($s_title) . '%"';
    if ($s_tags) $where .= 'AND n.`tags` ="' . $db->safesql($s_tags) . "'";
    if ($s_desc) $where .= 'AND l.`full` LIKE"%' . $db->safesql($s_desc) . '%"';
    if ($s_cat) {
        if ($s_cat !== ',0,') $where .= 'AND n.`cat` =",' . $db->safesql($s_cat) . ',"';
    }
    if ($startdate) $where .= 'AND n.`date` >="' . intval($startdate) . '"';
    if ($enddate) $where .= 'AND n.`date` <="' . intval($enddate) . '"';
    if (isset($url[3]) && $url[3] == 'order') {
        switch ($url[4]) {
            case 'abc':
                $order .= 'n.translate ASC';
                break;
            case 'last':
                $order .= 'n.date DESC';
                break;
            case 'id':
                $order .= 'n.id ASC';
                break;
        }
    } else {
        $order .= 'n.date DESC';
    }
    $query = $core->select_data('content', $where, $order . ' LIMIT ' . limit_page(), 'n.*, l.*, c.id as cid, c.name, c.altname as alturl', 'AS n LEFT JOIN ' . DB_PREFIX . '_categories AS c ON (n.cat=c.id) LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=n.id and l.module="content")');
    $adminTpl->admin_head($lang['static']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('content');
        onmoder('content', 'active', 'static_moder');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . ((isset($url[3]) ? $url[3] == 'tag' : '') ? str_replace('[tag]', $s_tags, $lang['static_search_tags']) : $lang['static_list']) . ' (' . $core->sum_data('content', 'active != 2') . '):</span>
            ' . sort_head('urs', 4, 'last') . '        
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-6">' . $lang['titles'] . '</th>
                        <th class="text-center" data-toggle="tooltip" data-original-title="' . $lang['commentes'] . '">' . faSpan('fa-comments-o', true) . '</th>
                        <th class="text-center" data-toggle="tooltip" data-original-title="' . $lang['views'] . '">' . faSpan('fa-eye', true) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($content = $db->getRow($query)) {
            if ($content['id']) initDir('content', $content['id']);
            $rel_link = $content['cat'] !== ',0,' ? 'content/' . $core->getCat('content', $content['cat'], 'development') . '/' : 'content/';
            $patch = !$content_conf['related_content_img_thumbs'] ? 'files/content/' . $content['id'] . '/' : 'files/thumbs/files/content/' . $content['id'] . '/';
            $images = array();
            $dir = news_image($patch);
            $all_files = !empty($dir) ? scandir($dir) : null;
            if (!$all_files) initDir('content', $content['id']);
            for ($i = 0; $i < count_($all_files); $i++) {
                if (!str_contains($all_files[$i], ".png") and !str_contains($all_files[$i], ".jpg") and
                    !str_contains($all_files[$i], ".gif")
                ) continue;
                $images[] = $all_files[$i];
            }
            $dir = news_image($patch);
            $img_random = $images ? $images[rand(0, sizeof($images) - 1)] : 'media/cats/no_image.png';
            $img_src = $images ? $dir . $img_random : $img_random;
            $select_cat = '';
            foreach ($cats_arr as $cid => $name) {
                $select_cat = '<option value="{MOD_LINK}/cats/' . $cid . '/' . $content['id'] . '">' . $name . '</option>';
            };
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $content['id'] . '</td>
                        <td>
                           <div class="media media-list text-right"><a href="' . $rel_link . $content['translate'] . '.html"><img src="' . $img_src . '" class="img-responsive mw60 ib br4" alt=""></a></p></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto"><a href="' . $rel_link . $content['translate'] . '.html" target="_blank" data-toggle="tooltip" data-original-title="' . $content['title'] . '">' . trimtitle($content['title'], 50) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($content['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['cats'] . ': ' . ($content['cat'] !== ',0,' ? $core->getCat('content', $content['cat'], 'short', 3) : $lang['no']) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ':<a href="profile/' . $content['author'] . '"> ' . $content['author'] . ' </a></ol>
                        </td>';
            init_Ajax_count('urs', 'content', $content['id'], 'comments', 'id=' . $content['id']);
            init_Ajax_count('urs', 'content', $content['id'], 'views', 'id=' . $content['id']);
            echo '<td class="text-center">' . status_icon('content', $content['id']) . '</td>';
            init_checkbox('td', $content['id'], false, '<li><a href="/content/' . $content['translate'] . '.html" target="_blank">' . faSpan('fa-desktop', true, $lang['view']) . '</a></li>
                                 <li><a href = \'{MOD_LINK}/edit/' . $content['id'] . '\'">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a>
                                      ' . faSpan('fa-list', true) . '
                                       <select onChange="if(this.options&#91;this.selectedIndex&#93;.value!=\'\'){window.location=this.options&#91;this.selectedIndex&#93;.value}else{this.options&#91;selectedIndex=0&#93;;}">
                                       <option value="{MOD_LINK}/cats/' . $content['id'] . '">' . $lang['select_cats'] . '</option>
                                       <option value="{MOD_LINK}/cats/0/' . $content['id'] . '">' . $lang['default_cats'] . '</option>
                                       ' . $select_cat . '
                                       </select>
                                    </a>
                                 </li>
            ' . (($content['active'] != 2) ? '<li><a href="{MOD_LINK}/moderation/' . $content['id'] . '">' . faSpan('fa-share-square-o', true, $lang['do_moderation']) . '</a></li>' : '') . '
            <li><a href="{MOD_LINK}/retivate/' . $content['id'] . '">' . faSpan('fa-power-off', true, (($content['active'] != 1) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-ccomm' . $content['id'] . '\')">' . faSpan('fa-eraser', true, $lang['action_ccleancom']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-ccounter' . $content['id'] . '\')">' . faSpan('fa-eraser', true, $lang['action_clean']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $content['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete('ccomm' . $content['id'], $content['title'], $lang['static_ccleancom_title'], 'content', $lang['static_ccleancom_text'], '{ADMIN}/module/content/cleanccomm/' . $content['id'], false, true);
            modal_form_delete('ccounter' . $content['id'], $content['title'], $lang['static_cleancounter_title'], 'content', $lang['static_cleancounter_text'], '{ADMIN}/module/content/cleancviews/' . $content['id'], false, true);
            modal_form_delete($content['id'], $content['title'], $lang['static_delete_title'], 'content', $lang['static_delete_text'], '{ADMIN}/module/content/delete/' . $content['id']);
        }
        echo '</tbody>';
        init_tfoot('<option value="activate">' . $lang['do_active'] . '</option>
                    <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('urs', 'content', 'content', $whereC);
        echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div class="form-group admin-form p15">
			 <h4 class="pl20">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">
                     <option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = (isset($content['author']) && ($users_list['nick'] == $content['author'])) ? "selected" : "";
                echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                  ' . faI('arrow double') . '
               </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['content_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['content_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 pl10">
               <h5><small>' . $lang['content_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-md-6">
                     <label for="startdate" class="field prepend-icon">
                     <input id="startdate" type="text" name="startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-md-6">
                     <label for="enddate" class="field prepend-icon">
                     <input id="enddate" type="text" name="enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_day" value="0">
               <input type="checkbox" name="s_day" ' . ($s_day ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['content_day'] . '</label>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['content_active'] . '</label>
            </div>
             ' . init_sfoot(true, true, false, '{MOD_LINK}') . '
         </div>
      </form>
   </aside>
</div>';
    } else {
        onmoder('content', 'active', 'static_moder');
        if (isset($url[4]) && $url[4] == 'order' || $s_search == 1) {
            $adminTpl->info($lang['static_order_empty'], 'empty', null, $lang['static_list'], $lang['static_list'], ADMIN . '/module/content/');
            header('refresh: 5; url="/' . ADMIN . '/module/content"');
        } else {
            $adminTpl->info($lang['static_empty'], 'empty', null, $lang['static_list'], $lang['static_add'], ADMIN . '/module/content/add');
        }
    }
    echo '</div>';
    $adminTpl->admin_foot();
}

function content_add($nid = null): void
{
    global $adminTpl, $core, $db, $url, $config, $lang;
    if (isset($nid)) {
        $content = $core->row_data('content', 'id = ' . $nid);
        $id = $content['id'];
        $author = $content['author'];
        $active = $content['active'];
        $keywords = $content['keywords'];
        $description = $content['description'];
        $date = gmdate('d.m.Y H:i', $content['date']);
        $theme = $content['theme'];
        $translate = $content['translate'];
        $preview = $content['preview'];
        $cat = $content['cat'];
        $active = ($content['active'] == 2 ? 0 : $content['active']);
        $catttt = explode(',', $cat);
        $firstCat = $catttt[1];
        $deleteKey = array_search($firstCat, $catttt);
        unset($catttt[$deleteKey]);
        $query = $core->select_data('langs', 'postId ="' . $id . '" AND module="content"');
        while ($langs = $db->getRow($query)) {
            $title[$langs['lang']] = prepareTitle($langs['title']);
            $fulltitle[$langs['lang']] = prepareTitle($langs['fulltitle']);
            $text[$langs['lang']] = stripslashes($core->bbDecode(parseBB($langs['short'])));
        }
        $remote = ADMIN . '/module/content/ajax/isurl/update';
        $admhead = $lang['static_edit'];
        $edit = true;
    } else {
        $id = false;
        $author = $core->auth->user_info['nick'];
        $active = false;
        $title = false;
        $fulltitle = false;
        $keywords = false;
        $description = false;
        $date = gmdate('d.m.Y H:i');
        $cat = isset($url[4]) ? "'," . $url[4] . ",'" : false;
        $cat_array = isset($url[4]) ? explode(',', $cat) : false;
        $catttt = isset($url[4]) ? explode(',', $cat) : false;
        $firstCat = isset($url[4]) ? $catttt[1] : false;
        $translate = false;
        $preview = false;
        $catttt = false;
        $active = 1;
        $text = '';
        $theme = '';
        $remote = ADMIN . '/module/content/ajax/isurl';
        $admhead = $lang['static_add'];
        $edit = false;
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['static_add_title_err'])
        ),
        'translate' => array(
            'required' => array('true', $lang['static_add_url_err_1'])/*,
            'remote' => array($remote, $lang['cats_url_err_2'])*/
        )
    );
    $codem = 'CodeMirror.fromTextArea("_code", {height:"dynamic",parserfile: ["parsexml.js","parsecss.js","tokenizejavascript.js","parsejavascript.js","parsehtmlmixed.js"],stylesheet: ["' . PLUGINS . 'highlight_code/xmlcolors.css","' . PLUGINS . 'highlight_code/jscolors.css","' . PLUGINS . 'highlight_code/csscolors.css"], path:"' . PLUGINS . 'highlight_code/", lineNumbers: true});';
    $file = $theme;
    $adminTpl->footIncludes[] = '<script src="' . PLUGINS . '/highlight_code/codemirror.js" type="text/javascript"></script>';
    $adminTpl->footIncludes[] = '<script type="text/javascript">ajaxGetJS(\'' . ADMIN . '/module/content/ajax/loadtpl/' . $file . '\', \'' . $codem . '\', \'_div\');</script>';
    $adminTpl->footIncludes[] = '<script type="text/javascript">function loadtpl(file){ajaxGetJS(\'' . ADMIN . '/module/content/ajax/loadtpl/\'+file, \'' . $codem . '\', \'_div\');}</script>';
    validationInit($validation_array);
    init_count_text();
    datetimepickerInit('date');
    ajaxInit();
    fancyboxInit();
    UniClass('selectList');
    $cats_arr = $core->aCatList('content');
    $adminTpl->admin_head($lang['modules'] . ' | ' . $admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
       <div class="tray tray-center">
      <form id="admin-form" class="form-horizontal parsley-form" enctype="multipart/form-data" role="form" method="POST" action="{MOD_LINK}/save" data-parsley-validate>
         <div class="panel panel-default panel-border top">
            <div class="panel-heading br-b-ddd">
               <span class="panel-title hidden-xs">' . $admhead . '</span>
               <ul class="nav panel-tabs-border panel-tabs">
                  <li class="active"><a href="#tab1_1" data-toggle="tab">' . $lang['static_tab_main'] . '</a></li>
                  <li><a href="#tab1_2" data-toggle="tab">' . $lang['static_tab_settings'] . '</a></li>
               </ul>
            </div>
         <div class="heading-hr"></div>
         <div class="panel-body p20 pb10">
            <div class="tab-content pn br-n">
               <div id="tab1_1" class="tab-pane active admin-form">
                  <div class="section row mbn">
                     <div class="col-md-9 pl15">
                        <div class="section row mb15">
                           <div class="col-xs-6">
                              <label for="title" class="field prepend-icon">
                                 <input type="text" name="title" ' . (!isset($nid) ? 'onkeyup="getTranslit(gid(\'title\').value, \'translate\'),getRelates(gid(\'title\').value, \'related_translate\'),count_down(this, \'title\', 200); caa(this);"' : '') . '  value="' . (isset($title[$config['lang']]) ? $title[$config['lang']] : '') . '" class="form-control" id="title" placeholder="' . $lang['static_add_title'] . '" data-parsley-required="true" data-parsley-trigger="change">
                              <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                              </label>
                               <div align="right" class="text-right">
                                    <span id="char_title"></span>
                                 </div>
                                 <div id="related_translate"></div>
                             </div>
                           <div class="col-xs-6">
                              <label for="translate" class="field prepend-icon">
                              <input id="translate" type="text" name="translate" placeholder="' . $lang['static_add_url'] . '" class="event-name form-control" value="' . $translate . '">
                              <label for="translate" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
                              </label>
                           </div>
                        </div>
                        <div class="section row mb15">
                           <div class="col-xs-6">
                              <label for="author" class="field prepend-icon">
                              <select name="author" class="select2-single form-control">';
    $query_users_list = $core->select_data('users');
    if ($db->numRows($query_users_list) > 0) {
        while ($users_list = $db->getRow($query_users_list)) {
            $selected = ($users_list['nick'] == $author) ? "selected" : "";
            echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
        }
    }
    echo '</select>
                              <label for="author" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
                              </label>
                           </div>
                           <div class="col-xs-6">
                              <label for="date" class="field prepend-icon">
                              <input id="date" type="text" name="date" placeholder="' . $lang['news_add_date'] . '" class="form-control" value="' . $date . '">
                              <label for="date" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                              </label>
                           </div>
                        </div>
     <div class="section row mb15">
                           <div class="col-xs-6">
                              <label for="theme" class="field prepend-icon">
                                   <label for="theme" class="field select mb15">
              <select class="select-single form-control" name="theme" onchange="loadtpl(this.value)">
                                       <option value="0">' . $lang['static_tpl_default'] . '</option>';
    $level = 0;
    $path = ROOT . '/usr/tpl/' . $config['tpl'] . '/content/';
    $ignore = array('cgi-bin', '.', '..');
    $dh = @opendir($path);
    while (false !== ($file = readdir($dh))) {
        if (!in_array($file, $ignore)) {
            $spaces = str_repeat('&nbsp;', ($level * 4));
            if (is_dir("$path/$file")) echo '<option value="' . $file . '" ' . (($file == $theme) ? 'selected' : '') . '>' . $file . '</option>';
        }
    }
    closedir($dh);
    echo '</select>
                  ' . faI('arrow double') . '
                  </label>
                           </div>
                           <div class="col-xs-6">
                                 <label for="keywords" class="field prepend-icon">
                                 <input type="text" name="tags" value="' . $keywords . '" class="form-control" id="keywords"  data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['static_keywords'] . '">
                                 <label for="keywords" class="field-icon">' . faI('fa-star', false, false, true) . '</label>
                              </label>
                           </div>
                        </div>
                        <div class="section row mb15">
                           <div class="col-xs-6">
                              <label for="category" class="field select mb15">
                                 <select class="select-single form-control" name="category[]" id="maincat" onchange="if(this.value != \'0\') {show(\'catSub\');}" >
                                       <option value="0">' . $lang['static_add_nocat'] . '</option>';
    foreach ($cats_arr as $cid => $name) {
        $selected = ($cid == $firstCat) ? "selected" : "";
        echo '<option value="' . $cid . '" ' . $selected . '>' . $name . '</option>';
    }
    echo '</select>
                  ' . faI('arrow double') . '
                  </label>
                           </div>
                           <div class="col-xs-6" id="catSub" style="' . ((isset($nid) && ($firstCat != 0)) ? '' : 'display:none;') . '">
                              <label class="field select">
                              <select class="select2-single form-control"  name="category[]" id="category"  multiple>';
    foreach ($cats_arr as $cid => $name) {
        if ($catttt) $selected = in_array($cid, $catttt) ? "selected" : "";
        echo '<option value="' . $cid . '" ' . $selected . ' id="cat_' . $cid . '">' . $name . '</option>';
    }
    echo ' </select>
                  </label>
                           </div>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div data-provides="fileupload" class="fileupload fileupload-' . ($preview ? 'exists' : 'new') . ' admin-form">
                           <div class="fileupload-preview thumbnail mb15">
                              <img ' . ($preview ? 'src="' . $config['url'] . $preview . '"' : 'data-src="holder.js/100%x147/text:' . $lang['news_add_mini'] . '"') . ' alt="holder">
                           </div>
                           <span class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple">
                           <span class="fileupload-new">' . $lang['upload'] . '</span>
                           <span class="fileupload-exists">' . $lang['upload_again'] . '</span>
                           <input name="preview" type="file">
                           </span>
                        </div>
                        <div class="checkbox-custom checkbox-warning mb5 mt15 text-center">
                           <input id="preview_del" name="preview_del" type="checkbox">
                           <label for="preview_del">' . $lang['static_add_mini_del'] . '</label>
                        </div>
                     </div>
                  </div>
              </div>
                  <div id="tab1_2" class="tab-pane admin-form">
                     <div class="section row mbn">
                        <div class="col-xs-6 pr15">
                           <div class="section mb10">
                              <label class="field mb5">' . $lang['static_add_fulltitle'] . ':</label>
                              <label for="fulltitle" class="field prepend-icon">
                              <input id="fulltitle" type="text" name="fulltitle" placeholder="' . $lang['static_add_fulltitle_pre'] . '" class="event-name form-control" value="' . (isset($fulltitle[$config['lang']]) ? $fulltitle[$config['lang']] : '') . '">
                              <label for="fulltitle" class="field-icon">' . faI('fa-code', false, false, true) . '</label>
                              </label>
                           </div>
                           <div class="section mb10">
                              <label class="field mb5">' . $lang['static_add_keywords'] . ':</label>
                              <label for="keywords" class="field prepend-icon">
                              <input id="keywords" type="text" name="keywords" placeholder="' . $lang['static_add_keywords_pre'] . '" class="event-name form-control" value="' . $keywords . '">
                              <label for="keywords" class="field-icon">' . faI('fa-star', false, false, true) . '</label>
                              </label>
                           </div>
                           <div class="section mb10">
                              <label class="field mb5">' . $lang['static_add_description'] . ':</label>
                              <label for="description" class="field prepend-icon">
                              <input id="description" type="text" name="description" placeholder="' . $lang['static_add_description_pre'] . '" class="event-name form-control" value="' . $description . '">
                              <label for="description" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                              </label>
                           </div>
                           <hr class="alt short mv15">
                           <p class="text-muted">' . faSpan('fa-exclamation-circle text-warning fs15 pr5', false, $lang['static_add_seo']) . '</p>
                        </div>
                        <div class="col-xs-6">
                           <label class="field option">
                           ' . checkbox('status', $active, $lang['static_add_active']) . '
                           </label>
                        </div>
                     </div>
                     <br>
                  </div>
               </div>';
    initDir('content', $id);
    echo '<div class="row">
  <div class="col-xs-12">
             <div class="tab-block mb25">
            <ul class="nav nav-tabs_editor nav-tabs-right">
               <li class="active">
                     <a href="#tab1" data-toggle="tab" aria-expanded="true">' . $lang['static_add_content'] . '</a>
                  </li>
                  <li class="">
                     <a href="#tab2" data-toggle="tab" aria-expanded="false">' . $lang['static_add_tpl'] . '</a>
                  </li>
                  <li class="">
                     <a id="fbox" data-fancybox-type="iframe" href="usr/plugins/filemanager/dialog.php?type=2">' . faSpan('fa-folder-open-o text-purple', false, $lang['static_add_upload']) . '</a>
                  </li>
               </ul>
               <div class="tab-content_editor">
                  <div id="tab1" class="tab-pane active">
                     ' . adminArea('text[' . $config['lang'] . ']', ($text[$config['lang']] ?? ''), 10, 'textarea', 'onchange="caa(this);"', true) . '
                  </div>
                  <div class="heading-hr"></div>
                  <div id="tab2" class="tab-pane p20">
                     <div id="_div"></div>
                  </div>
            </div>
         </div>
      </div>
        </div>
            </div>
            <div class="panel-footer">
               <button type="button" class="p7 btn bg-success btn-sm btn-preview btn-raised legitRipple" onclick="genContentPreview(\'title\', \'date\', \'maincat\', \'text[' . $config['lang'] . ']\');">' . faSpan('fa-television', true, false, false, $lang['view']) . '</button>
               <button  type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
            </div>
               </div>
            </div>
         </div>';
    if ($edit) {
        echo '<script type="javascript">
            $(\'#admin-form\').submit(function (e) {
            	var form = this;
            	e.preventDefault();
            	setTimeout(function () {
            		form.submit();
            	}, 1000); // in milliseconds
            });
         </script>
         <input type="hidden" name="edit" value="1">';
        if ($active == 2) echo '<input type="hidden" name="from_user" value="1">';
        echo '<input type="hidden" name="edit_id" value="' . $id . '">';
    }
    if (isset($nid)) echo '<input type="hidden" name="oldtranslate" value="' . $translate . '">';
    echo '</form>
   </div>
</div>';
    $adminTpl->admin_foot();
}

function content_save(): void
{
    global $adminTpl, $core, $db, $cats, $groupss, $config, $content_conf, $lang;
    $word_counter = new Counter();
    $bb = new bb;
    $gen_tag = $word_counter->get_keywords($_POST['text'][$config['lang']]);
    $title = $_POST['title'] ?? '';
    $langTitle = array();;
    $langTitle[$config['lang']] = $title;
    $fulltitle[$config['lang']] = $_POST['fulltitle'] ?? '';
    $short = isset($_POST['text']) ? ($_POST['text']) : '';
    $theme = isset($_POST['theme']) ? ($_POST['theme']) : '';
    $templ = isset($_POST['templ']) ? ($_POST['templ']) : '';
    $ttime = 'UNIX_TIMESTAMP(NOW())';
    $date = !empty($_POST['date']) ? $_POST['date'] : $ttime;
    $tags = isset($_POST['tags']) ? mb_strtolower(filter($_POST['tags'], 'a')) : mb_strtolower(filter($gen_tag, 'a'));
    $translit = ($_POST['translit'] !== '') ? mb_strtolower(str_replace(array('-', ' '), array('_', '_'), $_POST['translate']), 'UTF-8') : translit($title);
    $category = isset($_POST['category']) ? array_unique($_POST['category']) : '0';
    $edit_id = isset($_POST['edit_id']) ? intval($_POST['edit_id']) : '';
    $cnt = $short['ru'];
    $gen_tag = $word_counter->get_keywords(substr($cnt, 0, 500));
    $keywords = !empty($_POST['keywords']) ? $_POST['keywords'] : $word_counter->get_keywords(substr($cnt, 0, 500));
    $newcnt = $bb->parse(processText(filter(fileInit('content', $edit_id, 'content', $cnt), 'html')), $edit_id, true);
    $description = !empty($_POST['description']) ? $_POST['description'] : substr(strip_tags($newcnt), 0, 150);
    if (is_array($category)) {
        $firstCat = $category[0];
        unset($category[0]);
        $deleteCat = array_search($firstCat, $category);
        unset($category[$deleteCat]);
        $category[0] = $firstCat;
        ksort($category);
        foreach ($category as $cid) {
            $cats .= intval($cid) . ",";
        }
    } else {
        $cats = $category . ',';
    }
    $cats = ',' . $cats;
    $status = isset($_POST['status']) ? 1 : 0;
    $fix = isset($_POST['fix']) ? 1 : 0;
    $admhead = isset($_POST['edit']) ? $lang['static_edits'] : $lang['static_adds'];
    if ($date != $ttime) {
        $parseDate = explode(' ', $date);
        $subDate = explode('.', $parseDate[0]);
        if (isset($parseDate[1])) {
            $subTime = explode(':', $parseDate[1]);
        } else {
            $subTime[0] = 12;
            $subTime[1] = 0;
        }
        $date = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
    }
    $adminTpl->admin_head($lang['modules'] . ' | ' . $admhead);
    if ($title && $short[$config['lang']] && $translit) {
        if (isset($_POST['edit'])) {
            foreach ($langTitle as $k => $v) {
                $ntitle = filter(trim($v), 'title');
                $ftitle = filter(trim(htmlspecialchars_decode($fulltitle[$k], ENT_QUOTES)), 'title');
                $text = filter(fileInit('content', $edit_id, 'content', $short[$k]), 'html');
                if (isset($_POST['empty'][$k]) && trim($v) != '' && trim($short[$k]) != '') {
                    $core->ins_data('langs', 'postId,module,title,fulltitle,short,lang', '"' . $edit_id . '","content","' . $db->safesql(processText($ntitle)) . '","' . $db->safesql(processText($ftitle)) . '","' . $db->safesql(parseBB(processText($text), $edit_id, true)) . '","' . $k . '"');
                } elseif (!isset($_POST['empty'][$k]) && (trim($v) == '' or trim($short[$k]) == '')) {
                    $core->del_data('langs', 'postId ="' . $edit_id . '" AND module ="content" AND lang ="' . $k . '"');
                } elseif (!isset($_POST['empty'][$k]) && trim($v) != '' && trim($short[$k]) != '') {
                    $core->upd_data('langs', 'title ="' . $db->safesql(processText($ntitle)) . '",fulltitle ="' . $db->safesql(processText($ftitle)) . '",short ="' . $db->safesql(parseBB(processText($text), $edit_id, true)) . '"', 'postId ="' . $edit_id . '" AND module ="content" AND lang ="' . $k . '"');
                }
            }
            $update = $core->upd_data('content', '`translate` ="' . $translit . '",`cat` ="' . $cats . '",`keywords` ="' . $keywords . '",`description` ="' . $description . '",`date` ="' . $date . '", `theme` ="' . $theme . '", `active` ="' . $status . '"', 'id ="' . $edit_id . '"');
            if ($update) {
                $core->ins_log(false, $lang['logs_edit_content'], 1, false, false, $db->safesql(processText($ntitle)), false);
                action_alert('urs', 'success', 'content', false, 'static_edit_ok');
            }
            $cont_id = $edit_id;
        } else {
            $insert = $core->ins_data('content', 'id,translate,cat,keywords,description,preview,active,date,comments,views,theme,author', 'NULL,"' . $translit . '","' . $cats . '","' . $keywords . '","' . $description . '","","' . $status . '","' . $date . '",0,0,"' . $theme . '","' . $core->auth->user_info['nick'] . '"');
            if ($insert) {
                action_alert('urs', 'success', 'content', false, 'static_add_ok');
                $content = $core->row_data('content', 'translate ="' . $translit . '"');
                foreach ($langTitle as $k => $v) {
                    if (trim($v) != '' && trim($short[$k]) != '') {
                        $ntitle = filter(trim($v), 'title');
                        $ftitle = filter(trim(htmlspecialchars_decode($fulltitle[$k], ENT_QUOTES)), 'title');
                        $text = fileInit('content', $content['id'], 'content', parseBB(processText(filter($short[$k], 'html'), $content['id'], true)));
                        $core->ins_data('langs', 'postId,module,title,fulltitle,short,lang', '"' . $content['id'] . '","content","' . $db->safesql(processText($ntitle)) . '","' . $db->safesql(processText($ftitle)) . '","' . $db->safesql($text) . '","' . $k . '"');
                        $core->ins_log(false, $lang['logs_add_content'], 1, false, false, $db->safesql(processText($ntitle)), false);
                    }
                }
                fileInit('content', $content['id']);
                $cont_id = $content['id'];
                clearcache();
            } else {
                $adminTpl->info($lang['base_error_2'], 'error', null, $lang['error'], $lang['go_back'], 'javascript:history.go(-1)');
            }
        }
        if (isset($_POST['preview_del']) && isset($_POST['edit'])) {
            $contPR = $core->row_data('content', 'id ="' . $cont_id . '"', false, 'preview');
            if (file_exists(ROOT . $contPR['preview'])) unlink(ROOT . $contPR['preview']);
            $core->upd_data('content', 'preview =""', 'id ="' . $cont_id . '"');
        } else {
            if (isset($_FILES['preview']) && $_FILES['preview']['size'] > 0) {
                $purl = 'files/content/' . $cont_id . '/';
                $path_info = pathinfo($_FILES['preview']['name']);
                $ext = $path_info['extension'];
                $file_full = $purl . 'preview_' . $cont_id . '.' . $ext;
                if (file_exists(ROOT . $file_full)) @unlink(ROOT . $file_full);
                if ($foo = new Upload($_FILES['preview'])) {
                    $foo->file_new_name_body = 'preview_' . $cont_id;
                    $foo->image_resize = false;
                    $foo->image_x = $content_conf['thumb_width'];
                    $foo->image_ratio_y = true;
                    $foo->file_overwrite = true;
                    $foo->file_auto_rename = false;
                    $foo->Process(ROOT . $purl);
                    $foo->allowed = array("image/*");
                    if ($foo->processed) $foo->Clean();
                }
                $core->upd_data('content', 'preview ="/' . $file_full . '"', 'id ="' . $cont_id . '"');
            }
        }
        if ($theme == '0') $theme = '';
        if (is_writable(ROOT . 'usr/tpl/' . $config['tpl'] . '/content/' . $theme . '/content-view.tpl')) {
            $fp = @fopen(ROOT . 'usr/tpl/' . $config['tpl'] . '/content/' . $theme . '/content-view.tpl', 'w');
            fwrite($fp, stripslashes($templ));
            fclose($fp);
        }
    } else {
        $adminTpl->info($lang['base_error_1'], 'error', null, $lang['error'], $lang['go_back'], 'javascript:history.go(-1)');
    }
    $adminTpl->admin_foot();
}

function delete($id): void
{
    global $core, $lang;
    $rows = $core->row_data('content', 'id ="' . $id . '"');
    $row = $core->row_data('langs', 'postid ="' . $id . '"');
    $core->del_data('content', 'id ="' . $id . '"');
    $core->del_data('langs', 'postId ="' . $id . '" AND module ="content"');
    $core->upd_data('users', 'user_news = user_news-1', 'nick ="' . $rows['author'] . '"');
    $core->ins_log(false, $lang['logs_delete_content'], 1, false, false, $row['title'], false);
    full_rmdir(ROOT . initDC('content', "", "", $rows['id']));
    deleteComments($id, 'content', $rows['id'], $core->auth->user_id);
    clearcache();
}

function activate($id): void
{
    global $core;
    $core->upd_data('content', 'active = 1', 'id ="' . $id . '"');
}