<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

global $adminTpl, $core, $db, $admin_conf, $content_conf, $url, $lang;
if (empty($url[2])) {
    onmoder('content', 'active', 'content_moder');
} else {
    content_main();
}
function content_main(): void
{
    global $adminTpl, $core, $db, $content_conf, $url, $lang;
    ConfigMod('content');
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $where = '';
    $order = '';
    $cats_arr = $core->aCatList('content');
    $cats = (isset($url[3]) && $url[3] == 'cat') ? '/' . $url[4] : '';
    if (isset($url[3]) && $url[3] == 'cat') {
        if ($url[4]) {
            foreach ($cats_arr as $cid => $name) {
                if ($cid == $url[4]) $where .= 'WHERE `cat` =",' . $cid . ',"';
            }
        }
    }
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : '';
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_tags = (isset($url[3]) ? $url[3] == 'tag' : '') ? $url[4] : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_cat = isset($_POST['s_cat']) ? intval($_POST['s_cat']) : '';
    $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
    $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
    $s_day = isset($_POST['s_day']) ? intval($_POST['s_day']) : '';
    $s_active = isset($_POST['s_active']);
    $s_search = isset($_POST['s_search']);
    if ($s_search) $s_search = $_POST['s_search'] == 1;
    $where = 'WHERE n.active = 2';
    $whereC = str_replace(array('n.'), array(''), $where);
    $where .= 'AND l.lang ="' . $core->InitLang() . '"';
    if ($s_day) $where .= 'AND n.`date`>="' . mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")) . '"';
    if ($s_id) $where .= 'AND n.`id` LIKE"%' . $db->safesql($s_id) . '%"';
    if (!$s_id) $s_id = '';
    if ($s_author) $where .= 'AND n.`author` LIKE"%' . $db->safesql($s_author) . '%"';
    if ($s_title) $where .= 'AND l.`title` LIKE"%' . $db->safesql($s_title) . '%"';
    if ($s_tags) $where .= 'AND n.`tags` ="' . $db->safesql($s_tags) . "'";
    if ($s_desc) $where .= 'AND l.`full` LIKE"%' . $db->safesql($s_desc) . '%"';
    if ($s_cat) {
        if ($s_cat !== ',0,') $where .= 'AND n.`cat` =",' . $db->safesql($s_cat) . ',"';
    }
    if ($startdate) $where .= 'AND n.`date` >="' . intval($startdate) . '"';
    if ($enddate) $where .= 'AND n.`date` <="' . intval($enddate) . '"';
    if (isset($url[4]) && $url[4] == 'order') {
        switch ($url[5]) {
            case 'abc':
                $order .= 'n.translate ASC';
                break;
            case 'last':
                $order .= 'n.date DESC';
                break;
            case 'id':
                $order .= 'n.id ASC';
                break;
        }
    } else {
        $order .= 'n.date DESC';
    }
    $query = $core->select_data('content', $where, $order . ' LIMIT ' . limit_page(), 'n.*, l.*, c.id as cid, c.name, c.altname as alturl', 'AS n LEFT JOIN ' . DB_PREFIX . '_categories AS c ON (n.cat=c.id) LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=n.id and l.module="content")');
    $adminTpl->admin_head($lang['static']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('content');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . ((isset($url[3]) ? $url[3] == 'tag' : '') ? str_replace('[tag]', $s_tags, $lang['static_search_tags']) : $lang['static_list']) . ' (' . $core->sum_data('content', 'active = 2') . '):</span>        
             ' . sort_head('moder', 5, 'last') . '          
         </div>
       <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ACT_MODER_LINK}" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-6">' . $lang['titles'] . '</th>
                        <th class="text-center">' . faSpan('fa-comments-o', true, false, false, $lang['commentes']) . '</th>
                        <th class="text-center">' . faSpan('fa-eye', true, false, false, $lang['views']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo ' </tr>
                  </thead>
                  <tbody>';
        while ($content = $db->getRow($query)) {
            if ($content['id']) initDir('content', $content['id']);
            $rel_link = $content['cat'] !== ',0,' ? 'content/' . $core->getCat('content', $content['cat'], 'development') . '/' : 'content/';
            $patch = !$content_conf['related_content_img_thumbs'] ? 'files/content/' . $content['id'] . '/' : 'files/thumbs/files/content/' . $content['id'] . '/';
            $images = array();
            $dir = news_image($patch);
            $all_files = !empty($dir) ? scandir($dir) : null;
            if (!$all_files) initDir('content', $content['id']);
            for ($i = 0; $i < count_($all_files); $i++) {
                if (!str_contains($all_files[$i], ".png") and !str_contains($all_files[$i], ".jpg") and
                    !str_contains($all_files[$i], ".gif")
                ) continue;
                $images[] = $all_files[$i];
            }
            $dir = news_image($patch);
            $img_random = $images ? $images[rand(0, sizeof($images) - 1)] : 'media/cats/no_image.png';
            $img_src = $images ? $dir . $img_random : $img_random;
            $rows = $core->row_data('users', 'nick ="' . $content['author'] . '"');
            $name = $rows['nick'] ?: $content['author'];
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $content['id'] . '</td>
                        <td>
                           <div class="media media-list text-right"><a href="' . $rel_link . $content['translate'] . '.html"><img src="' . $img_src . '" class="img-responsive mw60 ib br4" alt=""></a></p></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto"><a href="' . $rel_link . $content['translate'] . '.html" target="_blank" data-toggle="tooltip" data-original-title="' . $content['title'] . '">' . trimtitle($content['title'], 50) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($content['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['cats'] . ': ' . ($content['cat'] !== ',0,' ? $core->getCat('content', $content['cat'], 'short', 3) : $lang['no']) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ':<a href="profile/' . $name . '"> ' . $name . ' </a></ol>
                        </td>';
            init_Ajax_count('urs', 'content', $content['id'], 'comments', 'id=' . $content['id']);
            init_Ajax_count('urs', 'content', $content['id'], 'views', 'id=' . $content['id']);
            echo '<td class="text-center">' . status_icon('content', $content['id']) . '</td>';
            init_checkbox('td', $content['id'], false, '<li><a href="{LI_MODER_LINK}/edit/' . $content['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
			                    	<li><a href="{LI_MODER_LINK}/moder_moderation/' . $content['id'] . '">' . faSpan('fa-power-off', true, $lang['do_active']) . '</a></li>
                                    <li class="divider"></li>
                                    <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $content['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete($content['id'], $content['title'], $lang['static_delete_title'], 'content', $lang['static_delete_text'], '{ADMIN}/module/content/delete/' . $content['id']);
        }
        echo '</tbody>';
        init_tfoot('<option value="activate">' . $lang['do_active'] . '</option>
				    <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
          </form>
         </div>
      </div>';
        page_list('root', 'moderation/mod/content', 'content', $whereC);
        echo '</div>
   <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
			 <h4 class="pl20">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">
                     <option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = (isset($news['author']) && ($users_list['nick'] == $news['author'])) ? "selected" : "";
                echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                  ' . faI('arrow double') . '
               </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['news_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
           <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['news_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 pl10">
               <h5><small>' . $lang['news_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-md-6">
                     <label for="startdate" class="field prepend-icon">
                     <input id="startdate" type="text" name="startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-md-6">
                     <label for="enddate" class="field prepend-icon">
                     <input id="enddate" type="text" name="enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_day" value="0">
               <input type="checkbox" name="s_day" ' . ($s_day ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news_day'] . '</label>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news_active'] . '</label>
            </div>
             ' . init_sfoot(true, true, false, '{MODER_LINK}') . '
         </div>
      </form>
   </aside>
</div>';
    } else {
        list_empty('urs', 'content', 5, $s_search, 'mod');
    }
    echo '</div>
</div>';
    $adminTpl->admin_foot();
}

