<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $db, $config, $core, $tags, $news_conf, $url, $headTag, $cache, $lang;
require(ROOT . 'etc/content.config.php');
$where = '';
if ($category != 'all') {
    $catsArr = array_map('trim', explode(',', $category));
    $i = 0;
    foreach ($catsArr as $cat) {
        $i++;
        $where .= $i == 1 ? ' AND ' : ' OR ';
        $where .= 'cat like"%,' . $cat . ',%"';
    }
}
if (!empty($notin)) {
    $notcatsArr = array_map('trim', explode(',', $notin));
    foreach ($notcatsArr as $cat) {
        $where .= ' AND cat NOT LIKE"%,' . $cat . ',%"';
    }
}
$where .= ' AND c.lang ="' . $core->InitLang() . '"';

if (($order != 'date') && ($order != 'views')) $order = 'date';
if (($short != 'DESC') && ($short != 'ASC')) $short = 'DESC';
$core->loadModLang('content');
$core->tempModule = 'content';
$queryDB = $core->select_data('content', 'active = 1' . $where, $order . ' ' . $short . ' LIMIT ' . $core->site_limit_page($news_conf, $limit), 'n.*, c.*', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="content")');
$custom = '';
if ($db->numRows($queryDB) > 0) {
    $content = '';
    while ($content = $db->getRow($queryDB)) {
        $catInfo = $content['cat'] !== ',0,' ? $core->catInfo('content', $content['cat']) : '';
        $cat = $content['cat'] !== ',0,' ? $core->getCat('content', $content['cat'], 'short', 3) : '';
        $content_link = $content['cat'] !== ',0,' ? 'content/' . $core->getCat('content', $content['cat'], 'development') . '/' : 'content/';
        $cat_one = $content['cat'] !== ',0,' ? $core->getCat('content', $content['cat'], 'translate', 1) : 'index';
        $short = $core->bbDecode(str($content['short'], 500), $content['id']);
        $miniImg = _getCustomImg($short);
        ob_start();
        $core->tpl->loadFile($template);
        include(loadTag('content'));
        $custom .= $core->tpl->return_end();
        ob_end_clean();
    }
}