<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $db, $config, $core, $url, $content_conf, $headTag, $lang;
loadConfig('news');
$core->loadModLang('content');
$core->tempModule = 'content';
$miniImg = array();
$query = isset($_REQUEST['query']) ? filter(utf_decode(urldecode($_REQUEST['query'])), 'query') : $url[1];
$content = $core->select_data('content', 'title LIKE"%' . $db->safesql($query) . '%" AND active=1', false, 'c.*, l.*', 'as c LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=c.id and l.module="content")');
if ($db->numRows($content) > 0 && $query) {
    loadConfig('content');
    $core->loadModLang('content');
    $core->tempModule = 'content';
    global $db, $config, $core, $content_conf, $lang, $headTag;
    $where = 'AND title LIKE"%' . $db->safesql($query) . '%" OR translate LIKE"%' . $db->safesql($query) . '%"  OR description LIKE"%' . $db->safesql($query) . '%"';
    $where .= 'AND l.lang ="' . $core->InitLang() . '"';
    $query_content = $core->select_data('content', 'active!=0 ' . $where . ' LIMIT  ' . $core->site_limit_page($content_conf, $content_conf['num']), false, 'c.*, l.*', 'as c LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=c.id and l.module="content")');
    list($all) = $core->fetch_data('content ', 'active!=0 ' . $where, 'count(c.id)', 'as c LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=c.id and l.module="content")');
    if ($db->numRows($query_content) > 0) {
        $core->tpl->title($lang['static'] . ': ' . $all);
        while ($content = $db->getRow($query_content)) {
            $bookmark = $core->row_data('bookmarks', 'nid ="' . $content['id'] . '/' . $core->auth->user_id . '"');
            $cat = $content['cat'] !== ',0,' ? $core->getCat('content', $content['cat'], 'short', 3) : '';
            $link = $content['cat'] !== ',0,' ? 'content/' . $core->getCat('content', $content['cat'], 'development') . '/' : 'content/';
            $altname = $content['translate'];
            $content_link = $content['cat'] !== ',0,' ? 'content/' . $core->getCat('content', $content['cat'], 'development') . '/' : 'content/';
            $short = $core->bbDecode($content['short'], $content['id']);
            $core->tpl->loadFile('content/content-main');
            $core->tpl->setVar('ID', $content['id']);
            $core->tpl->setVar('TITLE', $content['title']);
            $core->tpl->setVar('TEXT', $core->bbDecode(str($content['short'], 500), $content['id']));
            $core->tpl->setVar('SHORT', '<div id="short-' . $content['id'] . '">' . $core->bbDecode(str($content['short'], 500), $content['id']) . '</div>');
            $core->tpl->setVar('FULL', $core->bbDecode($content['short'], $content['id']));
            $core->tpl->setVar('ALTNAME', $content['translate']);
            $core->tpl->setVar('AUTHOR', $content['author']);
            $core->tpl->setVar('KEYWORDS', $content['keywords']);
            $core->tpl->setVar('COMMENTS', formatCounter($content['comments']));
            $core->tpl->setVar('VIEWS', formatCounter($content['views']));
            $core->tpl->setVar('DATE', formatDate($content['date']));
            $core->tpl->setVar('BOOKMARKS', BookmarksInit($content['id'], 'content', $content['title']));
            $core->tpl->setVar('PREVIEW', $content['preview']);
            $core->tpl->setVar('CATEGORY', $cat);
            $core->tpl->sources = preg_replace_callback("#\\[bookmarks\\](.*?)\\[/bookmarks\\]#is", function ($matches) use ($content_conf) {
                if ($content_conf['bookmarks']) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\{%SHORT:(.*?)%\\}#is",
                function ($match) use ($short) {
                    return short($match[1], processText($short));
                }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[mini_img\\](.*?)\\[/mini_img\\]#is", function ($matches) use ($miniImg) {
                if (!empty($miniImg[0])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[category\\](.*?)\\[/category\\]#is", function ($matches) use ($cat) {
                if ($cat) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[preview\\](.*?)\\[/preview\\]#is", function ($matches) use ($content) {
                if ($content['preview']) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[more\\](.*?)\\[/more\\]#is",
                function ($match) use ($link, $altname) {
                    return format_link($match[1], $link . $altname . '.html');
                }, $core->tpl->sources);
            $core->tpl->end();
        }
        $core->tpl->pages(init_page(), $content_conf['num'], $all, 'search/' . $query . '/{page}');
    }
}