<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $config, $core, $db, $url, $user, $content_conf, $files_conf, $cache, $lang;
require(ROOT . 'etc/content.config.php');
if (!$content['id']) require(ROOT . 'usr/modules/content/index.php');
$userInfo = $core->row_data('users', 'nick ="' . $content['author'] . '"');
$avatar = $content['author'] == $userInfo['nick'] && $userInfo['id'] != $content['id'] ? avatar($userInfo['id']) : $config['url'] . '/' . $user['noAvatar'];
$altname = $content['translate'];
$core->tpl->setVar('TITLE', $content['title']);
$core->tpl->setVar('SHORT', $short);
$core->tpl->setVar('FULL', '<div id="full-' . $content['id'] . '">' . $core->bbDecode($fulls, $content['id']) . '</div>');
$core->tpl->setVar('CATEGORY', $cat);
$core->tpl->setVar('CAT_ONE', $cat_one);
$core->tpl->setVar('ALTNAME', $altname);
$core->tpl->setVar('ICON', isset($catInfo['icon']) ? $core->getCatImg($content_link, $catInfo['icon'], $catInfo['title']) : '');
$core->tpl->setVar('AUTHOR', '<a href="profile/' . $content['author'] . '" title="' . $lang['page'] . ': ' . $content['author'] . '">' . $content['author'] . '</a>');
$core->tpl->setVar('VIEWS', formatCounter($content['views']));
$core->tpl->setVar('AUTHOR_AVATAR', $avatar);
$core->tpl->setVar('PREVIEW', $content['preview'] ? $content['preview'] : '');
$core->tpl->setVar('COMMENTS', formatCounter($content['comments']));
$core->tpl->setVar('FULL_LINK', $content_link . $altname .".html");
$miniImg = _getCustomImg($short);
$core->tpl->sources = preg_replace_callback("#\\[rating\\](.*?)\\[/rating\\]#is", function ($matches) use ($content) {
    if ($content['allow_rating']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[preview\\](.*?)\\[/preview\\]#is", function ($matches) use ($content) {
    if ($content['preview']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[category\\](.*?)\\[/category\\]#is", function ($matches) use ($cat) {
    if ($cat) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[mini_img\\](.*?)\\[/mini_img\\]#is", function ($matches) use ($miniImg) {
    if (!empty($miniImg[0])) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[more\\](.*?)\\[/more\\]#is",
    function ($match) use ($content_link, $altname) {
        return format_link($match[1], $content_link . $altname . '.html');
    }, $core->tpl->sources);
$content_date = $content['date'];
$core->tpl->sources = preg_replace_callback("#\\{%MYDATE:(.*?)%\\}#is",
    function ($match) use ($content_date) {
        return date($match[1], $content_date);
    }, $core->tpl->sources);
$content_title = $content['title'];
$core->tpl->sources = preg_replace_callback("#\\{%TITLE:(.*?)%\\}#is",
    function ($match) use ($content_title) {
        return short($match[1], $content_title);
    }, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\{%SHORT:(.*?)%\\}#is",
    function ($match) use ($short) {
        return short($match[1], processText($short));
    }, $core->tpl->sources);
$core->tpl->sources = preg_replace("#\\{%IMG:(.*?):(.*?)%\\}#is", (!empty($miniImg[(int)"\${1}"]) ? $miniImg[(int)"\${1}"] :"\${2}"), $core->tpl->sources);
$core->tpl->sources = preg_replace("#\\{%IMG:(.*?)%\\}#is", (!empty($miniImg[(int)"\${1}"]) ? $miniImg[(int)"\${1}"] : ''), $core->tpl->sources);