<?php

/*
  * @name        JMY CMS
  * @link        https://jmy.su/
  * @copyright   Copyright (C) 2012-2025 JMY LTD
  * @license     LICENSE.txt (see attached file)
  * @version     VERSION.txt (see attached file)
  * @author      Orlov Alexsey
  */

if (!defined('ADMIN_SWITCH')) {
    header('Location: /');
    exit;
}
global $adminTpl, $config, $page, $url, $lang;
switch ($url[3] ?? null) {
    default:
    case "documentation":
        init_count_text();
        $adminTpl->admin_head($lang['documentation']);
        echo '<section id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        foreach (glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*/*.tpl') as $inFile) {
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $inFile);
            $name = $name[1];
            $subDir = explode('/', $name);
            $inDirs[$subDir[0]][] = $inFile;
        }
        $zeroDirs = glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*.tpl');
        $codem = 'CodeMirror.fromTextArea("_code", {height: "dynamic",parserfile: ["parsexml.js", "parsecss.js", "tokenizejavascript.js", "parsejavascript.js", "parsehtmlmixed.js"],stylesheet: ["' . PLUGINS . 'highlight_code/xmlcolors.css", "' . PLUGINS . 'highlight_code/jscolors.css", "' . PLUGINS . 'highlight_code/csscolors.css"], path: "' . PLUGINS . 'highlight_code/", lineNumbers: true});';
        $file = $url[2] ?? '';
        $adminTpl->footIncludes[] = '<script src="' . PLUGINS . '/highlight_code/codemirror.js" type="text/javascript"></script>
                                     <script type="text/javascript">ajaxGetJS(\'' . ADMIN . '/module/documentation/ajax/loadtpl/' . $file . '\', \'' . $codem . '\', \'_div\');</script>';
        $adminTpl->headerIncludes[] = '<link rel="stylesheet" type="text/css" href="' . $adminTpl->file_dir . 'assets/css/ui.fancytree.min.css">';
        $adminTpl->js_code[] = '$("#tree5").fancytree({
      click: function(event, data)
      { // allow re-loads
      var node = data.node,
      orgEvent = data.originalEvent;
      if(node.data.href){
      ajaxGetJS(\'' . ADMIN . '/module/documentation/ajax/loadtpl/\'+node.data.href, \'' . $codem . '\', \'_div\');
      }
      }
      });';
        $adminTpl->js_code[] = '$("#engine").fancytree({
      click: function(event, data)
      { // allow re-loads
      var node = data.node,
      orgEvent = data.originalEvent;
      if(node.data.href){
      ajaxGetJS(\'' . ADMIN . '/module/documentation/ajax/System/\'+node.data.href, \'' . $codem . '\', \'_div\');
      }
      }
      });';
        echo '<div id="_div" class="row text-center">
   <div class="panel-heading">' . $lang['ajax_load'] . '<img src="usr/tpl/admin/images/loading.gif" style="border:0;" width="75" height="50" alt=""/></div>
</div>
   </div>
    <aside data-tray-height="match" class="panel tray-right tray-rescale tray320">
         <div style="padding-right: 1px !important; margin-bottom: 20px; border-width: 0;" class="form-group admin-form pl25">
            <h4 class="text-left pt10">' . $lang['documentation_data'] . '</h4>
             <hr class="alt short">
      <div id="engine" class="fancytree-radio">
 <ul id="treeData" style="display: none;">
  <li class="text-left folder">' . $lang['documentation_g_info'];
        if (isset($url[3]) && $url[3] == 'engine') $adminTpl->js_code[] = '$("#engine").fancytree("getTree").activateKey("engine");';
        echo '<ul>
            <li id="0.general" class="text-left"><a href="general">' . $lang['documentation_general'] . '</a></li>
            <li id="0.ability" class="text-left"><a href="ability">' . $lang['documentation_ability'] . '</a></li>
            <li id="0.changes" class="text-left"><a href="changes">' . $lang['documentation_changes'] . '</a></li>
    </ul>
  </li>
 <li class="text-left folder">' . $lang['documentation_working'];
        echo '<ul>
            <li id="0.core" class="text-left"><a href="core">' . $lang['documentation_core'] . '</a></li>
            <li id="0.global" class="text-left"><a href="global">' . $lang['documentation_global'] . '</a></li>
            <li id="0.customs" class="text-left"><a href="customs">' . $lang['documentation_customs'] . '</a></li>
    </ul>
  </li>
</ul>
</div>
      <h5>' . $lang['template'] . ': ' . $config['tpl'] . '</h5>
      <hr class="alt short">
      <div id="tree5" class="fancytree-radio">
         <ul id="treeData" style="display: none;">';
        $count_folder = 0;
        if (isset($inDirs)) {
            foreach ($inDirs as $catalog => $files) {
                $count_folder++;
                $count_files = 0;
                $_fold[$catalog] = $lang['tpl_fold_' . $catalog] ?? $catalog . '.tpl';
                echo '<li id="' . $count_folder . '" class="text-left folder">' . ($_fold[$catalog] ?? $catalog) . '<ul>';
                foreach ($files as $file) {
                    $count_files++;
                    $name = explode('/', $file);
                    $name = end($name);
                    $_a = explode('usr/tpl/' . $config['tpl'] . '/', $file);
                    $absolute = str_replace('/', '=', end($_a));
                    $abs = str_replace(array('.tpl'), array(''), ($name));
                    $absol = str_replace(array($name, '='), array('', ''), ($absolute));
                    $_names[$absolute] = $lang['tpl_name_' . $absol . '_' . $abs] ?? $name;
                    if (isset($url[3]) && ($url[3] == $absolute)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("' . $count_folder . '.' . $count_files . '");';
                    echo '<li id="' . $count_folder . '.' . $count_files . '" class="text-left"><a href="' . $absolute . '">' . ($_names[$absolute] ?? $name) . '</a></li>';
                }
                echo '</ul>';
            }
        }
        $count_files = 0;
        foreach ($zeroDirs as $file) {
            $count_files++;
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $file);
            $name = $name[1];
            $abs = str_replace(array('.tpl'), array(''), ($name));
            $_names[$name] = $lang['tpl_name_' . $abs] ?? $name;
            if (isset($url[3]) && ($url[3] == $name)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("0.' . $count_files . '");';
            echo '<li id="0.' . $count_files . '" class="text-left"><a href="' . $name . '">' . ($_names[$name] ?? $name) . '</a></li>';
        }
        echo '</ul>
      </div>
      </div>
      </div>
   </aside>
</section>';
        $adminTpl->admin_foot();
        break;
    case 'ajax':
        ajaxInit();
        $type = $url[4];
        switch ($type) {
            case 'loadtpl':
                $file = (isset($url[5]) && file_exists('usr/tpl/' . $config['tpl'] . '/' . str_replace('=', '/', $url[5]))) ? str_replace('=', '/', $url[5]) : 'index.tpl';
                $text = htmlspecialchars(file_get_contents(ROOT . 'usr/tpl/' . $config['tpl'] . '/' . $file), ENT_QUOTES);
                $count_rows = count(explode("\n", $text)) * 20;
                $status = ping_dir(getHost($lang['jmycms']), $lang['p80']);
                $id = $status ? file_get_contents_utf8($lang['jmycmsck'] . 'documentationid.php?dir=' . $config['url'] . '&lang=' . $config['lang'] . '&key=' . $config['key'] . '&version=' . VERSION_ID . '">"') : '';
                $documentation_list = $status ? file_get_contents_utf8($lang['jmycmsck'] . 'documentation.php?dir=' . $config['url'] . '&version=' . VERSION_ID . '&tpl=' . $file . '&lang=' . $config['lang']) : '';
                return isset($id) && $documentation_list ? documentation_content($file, $documentation_list) : documentation_info_error($file);
            case 'System':
                $file = $url[5] ?? 'core';
                $abs = str_replace(array('.tpl'), array(''), $file);
                $absolute = $lang['documentation_' . $abs] ?? $file;
                $status = ping_dir(getHost($lang['jmycms']), $lang['p80']);
                $id = $status ? file_get_contents_utf8($lang['jmycmsck'] . 'documentationid.php?dir=' . $config['url'] . '&lang=' . $config['lang'] . '&key=' . $config['key'] . '&version=' . VERSION_ID . '">"') : '';
                $documentation_list = $status ? file_get_contents_utf8($lang['jmycmsck'] . 'documentation.php?dir=' . $config['url'] . '&version=' . VERSION_ID . '&tpl=' . $file . '&lang=' . $config['lang']) : '';
                return isset($id) && $documentation_list ? documentation_content($file, $documentation_list) : documentation_info_error($file);
        }
}
function documentation_info_error($file): void
{
    global $lang;
    $abs = str_replace(array('.tpl'), array(''), $file);
    $absolute = $lang['documentation_' . $abs] ?? $file;
    documentation_content($absolute);
}

function documentation_content($absolute, $documentation_list = false): void
{
    global $lang;
    $title = $lang['documentation_' . $absolute] ?? $absolute;
    $title = !str_contains($absolute, '.tpl') ? $title : $lang['documentation'] . ': ' . $title;
    $documentation_list = $documentation_list ?: $lang['documentation_info_error'];
    $documentation_list = $documentation_list == $lang['documentation_info_error'] ? '<div id="alert" class="p20 pt20 pb15">
    <div class="alert alert-default alert-styled-left alert-arrow-left alert-dismissible show">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <p class="mb-0">' . $documentation_list . '</p>
    </div>
</div>' : $documentation_list;
    echo '<div class="panel panel-dark panel-border top">
   <div class="panel-heading">
      <span class="panel-title">' . $title . '</span>
   </div>
   <div class="heading-hr"></div>
   <div class="_code">
      ' . $documentation_list . '
   </div>
   <div class="panel-footer-lines">
   </div>
</div>';
}