<?php

/*
  * @name        JMY CMS
  * @link        https://jmy.su/
  * @copyright   Copyright (C) 2012-2025 JMY LTD
  * @license     LICENSE.txt (see attached file)
  * @version     VERSION.txt (see attached file)
  * @author      Orlov Alexsey
  */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $core, $db, $config, $adminTpl, $email_conf, $lang;
switch ($url[3] ?? null) {
    default:
        init_count_text();
        $query = $core->select_data('email', false, 'id ASC');
        $adminTpl->admin_head($lang['email_templ']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('email');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['email_templ'] . '</span>
             <div class="widget-menu pull-right">
               <div class="btn-group popup-basic admin-form">
                  <button type ="button" onclick ="window.location.href = \'{MOD_LINK}/truncate_data\'" type="button" class="btn btn-system btn-sm btn-raised legitRipple">' . $lang['panel_menu_exp_tpl'] . '&nbsp;' . $lang['default'] . '</button>
               </div>
            </div>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body p20 pb10">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/save">
               <table class="table table-xs table-striped">
                  <tbody>';
            while ($result = $db->getRow($query)) {
                initDir('templates', 'email');
                echo email_body('hacking_attempt_text', 'email_templ_error_a', 'hacking_info_attempt', 1, 'hacking_attempt_info');
                echo email_body('access_mail_text', 'email_templ_error_a1', 'email_info_access', 2, 'email_access_info');
                echo email_body('reg_mail_text', 'email_templ_error_1', 'email_info', 3, 'email_reg_info');
                echo email_body('comp_mail_text', 'email_templ_error_2', 'email_info_5', 4, 'email_comp_info');
                echo email_body('feed_mail_text', 'email_templ_error_3', 'email_info_1', 5, 'email_feed_info');
                echo email_body('lost_mail_text', 'email_templ_error_4', 'email_info_2', 6, 'email_lost_info');
                echo email_body('new_password_mail_text', 'email_templ_error_4_1', 'email_info_8', 7, 'email_new_password_info');
                echo email_body('new_news_text', 'email_templ_error_5', 'email_info_3', 8, 'email_news_info');
                echo email_body('new_comments_text', 'email_templ_error_6', 'email_info_4', 9, 'email_comm_info');
                echo email_body('new_pm_text', 'email_templ_error_7', 'email_info_6', 10, 'email_pm_info');
                echo email_body('subscribe_mail_text', 'email_templ_error_8', 'email_info_7', 11, 'email_subscribe_info');
                echo email_body('newsletter_mail_text', 'email_templ_error_8', 'email_info_9', 12, 'email_newsletter_info');
                echo email_body('twofactor_mail_text', 'email_templ_error_16', 'email_info_12', 13, 'email_twofactor_info');
            }
            echo '</tbody>
               </table>
         </div>
         <div class="panel-footer text-right">
         <button name="submit" type="submit" id="sub" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
         <input type="hidden" name="save" value="1">
         </div>
         </form>				
      </div>';
        } else {
            $adminTpl->info($lang['email_empty'], 'empty', null, $lang['email'], $lang['panel_menu_exp_tpl'] . '&nbsp;' . $lang['default'], ADMIN . '/module/email/start');
        }
        echo '</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'send_letter':
        $id = intval($url[4]) ?? false;
        $title = colorSpan('red', $lang['email_info_title']);
        $result = $core->row_data('email');
        if (isset($id)) {
            switch ($id) {
                case '1':
                    $html_mail = $result['html_hacking_attempt'];
                    $title = $lang['hacking_info_attempt'];
                    $mail_text = $result['hacking_attempt_text'];
                    break;
                case '2':
                    $html_mail = $result['html_access_mail'];
                    $title = $lang['email_info_access'];
                    $mail_text = $result['access_mail_text'];
                    break;
                case '3':
                    $html_mail = $result['html_reg_mail'];
                    $title = $lang['email_info'];
                    $mail_text = $result['reg_mail_text'];
                    break;
                case '4':
                    $html_mail = $result['html_comp_mail'];
                    $title = $lang['email_info_5'];
                    $mail_text = $result['comp_mail_text'];
                    break;
                case '5':
                    $html_mail = $result['html_feed_mail'];
                    $title = $lang['email_info_1'];
                    $mail_text = $result['feed_mail_text'];
                    break;
                case '6':
                    $html_mail = $result['html_lost_mail'];
                    $title = $lang['email_info_2'];
                    $mail_text = $result['lost_mail_text'];
                    break;
                case '7':
                    $html_mail = $result['html_new_password_mail'];
                    $title = $lang['email_info_8'];
                    $mail_text = $result['new_password_mail_text'];
                    break;
                case '8':
                    $html_mail = $result['html_new_news'];
                    $title = $lang['email_info_3'];
                    $mail_text = $result['new_news_text'];
                    break;
                case '9':
                    $html_mail = $result['html_new_comments'];
                    $title = $lang['email_info_4'];
                    $mail_text = $result['new_comments_text'];
                    break;
                case '10':
                    $html_mail = $result['html_new_pm'];
                    $title = $lang['email_info_6'];
                    $mail_text = $result['new_pm_text'];
                    break;
                case '11':
                    $html_mail = $result['html_subscribe_mail'];
                    $title = $lang['email_info_7'];
                    $mail_text = $result['subscribe_mail_text'];
                    break;
                case '12':
                    $html_mail = $result['html_newsletter_mail'];
                    $title = $lang['email_info_9'];
                    $mail_text = $result['newsletter_mail_text'];
                    break;
                case '13':
                    $html_mail = $result['html_twofactor_mail'];
                    $title = $lang['email_info_12'];
                    $mail_text = $result['twofactor_mail_text'];
                    break;
            }
        } else {
            $html_mail = '';
            $title = '';
            $mail_text = '';
        }
        $messages = $html_mail > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%title%}', '{%category%}', '{%username_to%}', '{%username_from%}', '{%link%}', '{%lostlink%}', '{%ip%}', '{%unsubscribe%}', '{%date%}', '{%group%}', '{%email%}', '{%text%}', '{%sitename%}', '{%url%}', '{%password%}', '{%nick%}', '{%pass%}', '{%device%}', '{%validationlink%}', '{%fromusername%}', '{%geo%}', '{%browser%}'), array('<', '>', colorSpan('red', $lang['email_info_username']), $title, colorSpan('red', $lang['email_info_category']), colorSpan('red', $lang['email_info_username_to']), colorSpan('red', $lang['email_info_username_from']), colorSpan('red', $lang['email_info_link']), colorSpan('red', $lang['email_info_lostlink']), colorSpan('red', $lang['email_info_ip']), colorSpan('red', $lang['email_info_unsubscribe']), colorSpan('red', $lang['email_info_date']), colorSpan('red', $lang['email_info_group']), colorSpan('red', $lang['email_info_mail']), colorSpan('red', $lang['email_info_text']), colorSpan('red', $lang['email_info_sitename']), colorSpan('red', $lang['email_info_url']), colorSpan('red', $lang['email_info_password']), colorSpan('red', $lang['email_info_nick']), colorSpan('red', $lang['email_info_pass']), colorSpan('red', $lang['email_info_device']), colorSpan('red', $lang['email_info_validationlink']), colorSpan('red', $lang['email_info_fromusername']), colorSpan('red', $lang['email_info_geo']), colorSpan('red', $lang['email_info_browser'])), $mail_text) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%title%}', '{%category%}', '{%username_to%}', '{%username_from%}', '{%link%}', '{%lostlink%}', '{%ip%}', '{%unsubscribe%}', '{%date%}', '{%group%}', '{%email%}', '{%text%}', '{%sitename%}', '{%url%}', '{%password%}', '{%nick%}', '{%pass%}', '{%device%}', '{%validationlink%}', '{%fromusername%}', '{%geo%}', '{%browser%}'), array('""', '""', '""', '\n', '\n', '\n', colorSpan('red', $lang['email_info_username']), $title, colorSpan('red', $lang['email_info_category']), colorSpan('red', $lang['email_info_username_to']), colorSpan('red', $lang['email_info_username_from']), colorSpan('red', $lang['email_info_link']), colorSpan('red', $lang['email_info_lostlink']), colorSpan('red', $lang['email_info_ip']), colorSpan('red', $lang['email_info_unsubscribe']), colorSpan('red', $lang['email_info_date']), colorSpan('red', $lang['email_info_group']), colorSpan('red', $lang['email_info_mail']), colorSpan('red', $lang['email_info_text']), colorSpan('red', $lang['email_info_sitename']), colorSpan('red', $lang['email_info_url']), colorSpan('red', $lang['email_info_password']), colorSpan('red', $lang['email_info_nick']), colorSpan('red', $lang['email_info_pass']), colorSpan('red', $lang['email_info_device']), colorSpan('red', $lang['email_info_validationlink']), colorSpan('red', $lang['email_info_fromusername']), colorSpan('red', $lang['email_info_geo']), colorSpan('red', $lang['email_info_browser'])), $mail_text);
        mailSMTP($config['support_mail'], $html_mail, $title, $messages);
        action_alert('urs', 'success', 'email', false, 'sendok');
        break;
    case 'start':
        $core->ins_data('email', 'id,hacking_attempt_text,access_mail_text,comp_mail_text,feed_mail_text,lost_mail_text,new_comments_text,new_news_text,new_password_mail_text,new_pm_text,reg_mail_text,subscribe_mail_text,newsletter_mail_text,twofactor_mail_text,html_hacking_attempt,html_access_mail,html_comp_mail,html_feed_mail,html_lost_mail,html_new_comments,html_new_password_mail,html_new_news,html_new_pm,html_reg_mail,html_subscribe_mail,html_newsletter_mail,html_twofactor_mail,lang', '1,"","","","","","","","","","","","","",1,1,1,1,1,1,1,1,1,1,1,1,1,"' . $config['lang'] . '"');
        $core->upd_data('email', "`hacking_attempt_text` = '" . $lang['email_hacking_attempt_text'] . "' ,`html_hacking_attempt` = '1'");
        $core->upd_data('email', "`access_mail_text` = '" . $lang['email_access_mail_text'] . "' ,`html_access_mail` = '1'");
        $core->upd_data('email', "`reg_mail_text` = '" . $lang['email_reg_mail_text'] . "',`html_reg_mail` = '1'");
        $core->upd_data('email', "`comp_mail_text` = '" . $lang['email_comp_mail_text'] . "',`html_comp_mail` = '1'");
        $core->upd_data('email', "`feed_mail_text` = '" . $lang['email_feed_mail_text'] . "',`html_feed_mail` = '1'");
        $core->upd_data('email', "`lost_mail_text` = '" . $lang['email_lost_mail_text'] . "',`html_lost_mail` = '1'");
        $core->upd_data('email', "`new_password_mail_text` = '" . $lang['email_new_password_mail_text'] . "',`html_new_password_mail` = '1'");
        $core->upd_data('email', "`new_news_text` = '" . $lang['email_new_news_text'] . "',`html_new_news` = '1'");
        $core->upd_data('email', "`new_comments_text` = '" . $lang['email_new_comments_text'] . "',`html_new_comments` = '1'");
        $core->upd_data('email', "`new_pm_text` = '" . $lang['email_new_pm_text'] . "',`html_new_pm` = '1'");
        $core->upd_data('email', "`subscribe_mail_text` = '" . $lang['email_subscribe_mail_text'] . "',`html_subscribe_mail` = '1'");
        $core->upd_data('email', "`newsletter_mail_text` = '" . $lang['email_newsletter_mail_text'] . "',`html_newsletter_mail` = '1'");
        $core->upd_data('email', "`twofactor_mail_text` = '" . $lang['email_twofactor_mail_text'] . "',`html_twofactor_mail` = '1'");
        action_alert('urs', 'success', 'email');
        break;
    case 'save':
        $hacking_attempt_text = $_POST['hacking_attempt_text'] ?? '';
        $access_mail_text = $_POST['access_mail_text'] ?? '';
        $reg_mail_text = $_POST['reg_mail_text'] ?? '';
        $comp_mail_text = $_POST['comp_mail_text'] ?? '';
        $feed_mail_text = $_POST['feed_mail_text'] ?? '';
        $lost_mail_text = $_POST['lost_mail_text'] ?? '';
        $new_password_mail_text = $_POST['new_password_mail_text'] ?? '';
        $new_news_text = $_POST['new_news_text'] ?? '';
        $new_comments_text = $_POST['new_comments_text'] ?? '';
        $new_pm_text = $_POST['new_pm_text'] ?? '';
        $newsletter_mail_text = $_POST['newsletter_mail_text'] ?? '';
        $twofactor_mail_text = $_POST['twofactor_mail_text'] ?? '';
        $subscribe_mail_text = $_POST['subscribe_mail_text'] ?? '';
        $html_hacking_attempt = intval($_POST['html_hacking_attempt']) ?? false;
        $html_access_mail = intval($_POST['html_access_mail']) ?? false;
        $html_reg_mail = intval($_POST['html_reg_mail']) ?? false;
        $html_comp_mail = intval($_POST['html_comp_mail']) ?? false;
        $html_feed_mail = intval($_POST['html_feed_mail']) ?? false;
        $html_lost_mail = intval($_POST['html_lost_mail']) ?? false;
        $html_new_password_mail = intval($_POST['html_new_password_mail']) ?? false;
        $html_new_news = intval($_POST['html_new_news']) ?? false;
        $html_new_comments = intval($_POST['html_new_comments']) ?? false;
        $html_new_pm = intval($_POST['html_new_pm']) ?? false;
        $html_subscribe_mail = intval($_POST['html_subscribe_mail']) ?? false;
        $html_newsletter_mail = intval($_POST['html_newsletter_mail']) ?? false;
        $html_twofactor_mail = intval($_POST['html_twofactor_mail']) ?? false;
        if ($hacking_attempt_text && $access_mail_text && $reg_mail_text && $comp_mail_text && $feed_mail_text && $lost_mail_text && $new_password_mail_text && $new_news_text && $new_comments_text && $new_pm_text && $subscribe_mail_text && $newsletter_mail_text && $twofactor_mail_text) {
            $core->upd_data('email', "`hacking_attempt_text` = '" . $hacking_attempt_text . "'");
            $core->upd_data('email', "`html_hacking_attempt` = '$html_hacking_attempt'");
            $core->upd_data('email', "`access_mail_text` = '$access_mail_text'");
            $core->upd_data('email', "`html_access_mail` = '$html_access_mail'");
            $core->upd_data('email', "`reg_mail_text` = '$reg_mail_text'");
            $core->upd_data('email', "`html_reg_mail` = '$html_reg_mail'");
            $core->upd_data('email', "`comp_mail_text` = '$comp_mail_text'");
            $core->upd_data('email', "`html_comp_mail` = '$html_comp_mail'");
            $core->upd_data('email', "`feed_mail_text` = '$feed_mail_text'");
            $core->upd_data('email', "`html_feed_mail` = '$html_feed_mail'");
            $core->upd_data('email', "`lost_mail_text` = '$lost_mail_text'");
            $core->upd_data('email', "`html_lost_mail` = '$html_lost_mail'");
            $core->upd_data('email', "`new_password_mail_text` = '$new_password_mail_text'");
            $core->upd_data('email', "`html_new_password_mail` = '$html_new_password_mail'");
            $core->upd_data('email', "`new_news_text` = '$new_news_text'");
            $core->upd_data('email', "`html_new_news` = '$html_new_news'");
            $core->upd_data('email', "`new_comments_text` = '$new_comments_text'");
            $core->upd_data('email', "`html_new_comments` = '$html_new_comments'");
            $core->upd_data('email', "`new_pm_text` = '$new_pm_text'");
            $core->upd_data('email', "`html_new_pm` = '$html_new_pm'");
            $core->upd_data('email', "`subscribe_mail_text` = '$subscribe_mail_text'");
            $core->upd_data('email', "`html_subscribe_mail` = '$html_subscribe_mail'");
            $core->upd_data('email', "`newsletter_mail_text` = '$newsletter_mail_text'");
            $core->upd_data('email', "`html_newsletter_mail` = '$html_newsletter_mail'");
            $core->upd_data('email', "`twofactor_mail_text` = '$twofactor_mail_text'");
            $core->upd_data('email', "`html_twofactor_mail` = '$html_twofactor_mail'");
            action_alert('urs', 'success', 'email', false, 'email_templ_ok');
        } elseif ($hacking_attempt_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_a');
        } elseif ($access_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_a1');
        } elseif ($reg_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_1');
        } elseif ($comp_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_2');
        } elseif ($feed_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_3');
        } elseif ($lost_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_4');
        } elseif ($new_password_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_4_1');
        } elseif ($new_news_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_5');
        } elseif ($new_comments_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_6');
        } elseif ($new_pm_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_7');
        } elseif ($subscribe_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_8');
        } elseif ($newsletter_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_15');
        } elseif ($twofactor_mail_text == '') {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error_16');
        } else {
            action_alert('urs', 'danger', 'email', false, 'email_templ_error');
        }
        break;
    case 'truncate_data':
        if ($core->ereg_Strt('email')) {
            $core->truncate_data('email');
            location(ADMIN . '/module/email/start');
        } else {
            action_alert('root', 'danger', 'email', false, 'unknown_error');
        }
        break;
    case 'config':
        global $lang;
        init_count_text();
        require(ROOT . 'etc/email.config.php');
        $configBox = array(
            'email' => array(
                'varName' => 'email_conf',
                'title' => $lang['email_send'],
                'groups' => array(
                    'main' => array(
                        'title' => $lang['send_email'],
                        'vars' => array(
                            'hacking_mail' => array(
                                'title' => $lang['send_email_hacking'],
                                'description' => $lang['send_email_hacking1'],
                                'content' => radio("hacking_mail", $email_conf['hacking_mail']),
                            ),
                            'access_mail' => array(
                                'title' => $lang['send_email_acceess'],
                                'description' => $lang['send_email_acceess1'],
                                'content' => radio("access_mail", $email_conf['access_mail']),
                            ),
                            'reg_mail' => array(
                                'title' => $lang['send_email_reg'],
                                'description' => $lang['send_email_reg1'],
                                'content' => radio("reg_mail", $email_conf['reg_mail']),
                            ),
                            'comp_mail' => array(
                                'title' => $lang['send_email_comp'],
                                'description' => $lang['send_email_comp1'],
                                'content' => radio("comp_mail", $email_conf['comp_mail']),
                            ),
                            'feed_mail' => array(
                                'title' => $lang['send_email_feed'],
                                'description' => $lang['send_email_feed1'],
                                'content' => radio("feed_mail", $email_conf['feed_mail']),
                            ),
                            'lost_mail' => array(
                                'title' => $lang['send_email_lost'],
                                'description' => $lang['send_email_lost1'],
                                'content' => radio("lost_mail", $email_conf['lost_mail']),
                            ),
                            'new_news' => array(
                                'title' => $lang['send_email_new_news'],
                                'description' => $lang['send_email_new_news1'],
                                'content' => radio("new_news", $email_conf['new_news']),
                            ),
                            'new_comments' => array(
                                'title' => $lang['send_email_new_comments'],
                                'description' => $lang['send_email_new_comments1'],
                                'content' => radio("new_comments", $email_conf['new_comments']),
                            ),
                            'new_pm' => array(
                                'title' => $lang['send_email_new_pm'],
                                'description' => $lang['send_email_new_pm1'],
                                'content' => radio("new_pm", $email_conf['new_pm']),
                            ),
                            'subscribe_mail' => array(
                                'title' => $lang['send_email_subscribe_mail'],
                                'description' => $lang['send_email_subscribe_mail1'],
                                'content' => radio("subscribe_mail", $email_conf['subscribe_mail']),
                            ),
                            'newsletter_mail' => array(
                                'title' => $lang['send_email_newsletter_mail'],
                                'description' => $lang['send_email_newsletter_mail1'],
                                'content' => radio("newsletter_mail", $email_conf['newsletter_mail']),
                            ),
                            'twofactor_mail' => array(
                                'title' => $lang['send_email_twofactor_mail'],
                                'description' => $lang['send_email_twofactor_mail1'],
                                'content' => radio("twofactor_mail", $email_conf['twofactor_mail']),
                            ),
                        ),
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'email', '{MOD_LINK}/config', $ok);
        break;
}
function color_info($error, $text)
{
    global $url;
    return (isset($url[4]) && ($url[4] == $error)) ? colorSpan('red', $text) : $text;
}


function email_body($id, $error, $info, $url, $itext = false): string
{
    global $core, $lang;
    $email = $core->row_data('email', $id . '=' . $id);
    $html = str_replace(array('_text'), array(''), $id);
    $checked = $email['html_' . $html] ? 'checked ' : '';
    return '<div class="col-lg-12">
                        <div class="panel" style="margin: 10px 0 0;padding: 5px 10px 5px 10px;">
                           <div class="admin-form-text accordion-heading">
                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapse' . $url . '">' . color_info($error, $lang[$info]) . '</a>
                           </div>
                           <div id="collapse' . $url . '" class="accordion-body collapse">
                              <div class="row">
                                 <div class="panel-body">
                                    <div class="col-md-12">
                                       <div class="col-sm-7">' . adminArea($id, $email[$id], 5, 'textarea', 'onchange="caa(this);"', true) . '</div>
                                       <div class="switch switch-info round switch-inline">
                                          <input type="hidden" name="html_' . $html . '" value="">' . $lang['email_use_html'] . '
                                          <input id="html_' . $html . '" name="html_' . $html . '" type="checkbox"	' . $checked . ' value="1">
                                          <label for="html_' . $html . '"></label>
                                       </div>
                                       <div class="accordion-inner padded"> ' . $lang[$itext] . '</div>
                                    <br/>
                                       <button onclick="location.href=\'{MOD_LINK}/send_letter/' . $url . '\';" type="button" class="button btn btn-info ph40 btn-raised legitRipple" title="' . $lang['email_send_test_info'] . '" >' . faI('fa-envelope-o', false, $lang['email_send_test']) . '</button>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>';
}