<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
loadConfig('feed');
global $adminTpl, $admin_conf, $feed_conf, $config, $url, $core, $lang, $db;
switch ($url[3] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = '';
        $order = '';
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_title = $_POST['s_title'] ?? '';
        $s_desc = $_POST['s_desc'] ?? '';
        $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
        $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
        $s_active = isset($_POST['s_active']);
        $s_search = isset($_POST['s_search']);
        if ($s_search) $s_search = $_POST['s_search'] == 1;
        if ($s_active) {
            if ($_POST['s_active'] == 1) {
                $where = 'WHERE `active` = 1 ';
            } else {
                $s_active = false;
                $where = 'WHERE `active` = 0 ';
            }
        } else {
            $s_active = true;
        }
        if ($s_id) {
            $where .= 'AND `id` LIKE"%' . $db->safesql($s_id) . '%"';
        } else {
            $s_id = '';
        }
        if ($s_title) $where .= 'AND `title` LIKE"%' . $db->safesql($s_title) . '%"';
        if ($s_desc) $where .= 'AND `desc` LIKE"%' . $db->safesql($s_desc) . '%"';
        if (isset($url[2]) && $url[2] == 'order') {
            switch ($url[3]) {
                case 'abc':
                    $order .= 'title ASC';
                    break;
                case 'last':
                    $order .= 'date DESC';
                    break;
                case 'id':
                    $order .= 'id ASC';
                    break;
            }
        } else {
            $order .= 'id DESC';
        }
        $query = $core->select_data('feed', $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['feed']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('feed');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['feed_list'] . ':</span>
            ' . sort_head('urs', 4) . '
        </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-8 text-left">' . $lang['titles'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($row = $db->getRow($query)) {
                $tags = str_replace(array('<br>', '<br/>', '\p', '\n', '<', '>'), array('\n', '\n', '""', '""', '&lt;', '&gt;'), ' [' . $row['tags'] . '] {%' . $row['tags'] . '%} [/' . $row['tags'] . '] ');
                $command = 'document.querySelector(\'#copy_' . $row['id'] . '\').select(); document.execCommand(\'copy\'); notif(\'primary\', \'' . $lang['info'] . '\', \'' . $lang['copy_success'] . '\');';
                echo '<tr>
                        <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $row['id'] . '</td>
                        <td>
                           <div class="media media-list"></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style="padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['title'] . ': ' . trimtitle($row['title'], 50) . '</ol>
                           <ol class="timeline-list" style="padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['sourse'] . ': ' . trimtitle($row['sourse'], 50) . '</ol>
                           <ol class="timeline-list" style="padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['description'] . ': ' . trimtitle($row['desc'], 50) . '</ol>
                           <ol class="timeline-list" style="padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['template'] . ': ' . $row['templ'] . '</ol>
                           <ol class="timeline-list" style="padding:0;font-size: 12px;font-family: verdana; margin: 0 auto"><p class="text-left" href="' . $row['id'] . '#copy" onclick="' . $command . '" title="' . $lang['feed_tag'] . $tags . '">
                           <textarea id="copy_' . $row['id'] . '" style="height: 40px; margin: 0; font-size: 14px;" class="form-control input-sm text-center" data-parsley-required="true" data-parsley-trigger="change">' . $tags . '</textarea>
                           </p></ol>
                        </td>
                        <td class="text-center">' . status_icon('feed', $row['id']) . '</td>';
                init_checkbox('td', $row['id'], false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $row['id'] . '\')">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/feed/edit/' . $row['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#copy" onclick="' . $command . '">' . faSpan('fa-files-o', false, $lang['feed_copy']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/feed/retivate/' . $row['id'] . '">' . faSpan('fa-power-off', true, (($row['active'] == 0) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $row['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
                modal_form_delete($row['id'], $row['tags'], $lang['feed_del_desc'], 'feed', $lang['feed_del_text'], ADMIN . '/module/feed/delete/' . $row['id']);
                modal_form_text('view' . $row['id'], $lang['info'], 'fa-desktop', rss_forms($row['url']), '<fieldset> ' . getFeed($row['url'], $row['nmax'], $row['tmax'], $row['dmax'], $row['date_format']) . '</fieldset>');
            }
            echo '</tbody>';
            init_tfoot('<option value="Activate">' . $lang['do_activation'] . '</option>
                        <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                        <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                        <option value="Delete">' . $lang['delete'] . '</option>');
            echo '</table>
            </form>
         </div>
      </div>';
            page_list('urs', 'feed', 'feed', $where);
            echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['news_id'] . '" class="form-control" value="' . $s_id . '" onkeypress="if (isNaN(this.value + String.fromCharCode(event.keyCode))) return false;">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['news_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['feed_active'] . '</label>
            </div>
             ' . init_sfoot(true, true, false, '{MOD_LINK}') . '
         </div>
      </form>
   </aside>';
        } else {
            list_empty('urs', 'feed', 'url', $s_search, false, true, false);
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'add':
        add();
        break;
    case 'edit':
        $id = intval($url[4]);
        add($id);
        break;
    case 'save':
        feed_save();
        break;
    case 'delete':
        $id = intval($url[4]);
        delfeed($id);
        location(ADMIN . '/module/feed');
        break;
    case 'retivate':
        $id = intval($url[4]);
        if (!empty($id)) {
            $rows = $core->row_data('feed', 'id ="' . $id . '"');
            $active = $rows['active'] == 0 ? 1 : 0;
            $core->upd_data('feed', 'active ="' . $active . '"', 'id ="' . $id . '"');
        }
        location(ADMIN . '/module/feed');
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'Activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('feed', 'active = 1', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'feed');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('feed', 'active = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'feed');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('feed', 'active = NOT `active`', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'feed');
                    }
                    break;
                case 'Delete':
                    foreach ($_POST['checks'] as $id) {
                        delfeed(intval($id));
                        action_alert('urs', 'success', 'feed');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('urs', 'danger', 'feed');
        }
        break;
    case 'config':
        init_count_text();
        $configBox = array(
            'feed' => array(
                'varName' => 'feed_conf',
                'title' => $lang['feed_config'],
                'groups' => array(
                    'rss_2_0' => array(
                        'title' => $lang['rss_2_0'],
                        'vars' => array(
                            'rss_2_0_on' => array(
                                'title' => $lang['rss_2_0_config'],
                                'description' => $lang['rss_2_0_configd'],
                                'content' => radio("rss_2_0_on", $feed_conf['rss_2_0_on']),
                            ),
                        )
                    ),
                    'atom' => array(
                        'title' => $lang['atom'],
                        'vars' => array(
                            'atom_on' => array(
                                'title' => $lang['atom_config'],
                                'description' => $lang['atom_configd'],
                                'content' => radio("atom_on", $feed_conf['atom_on']),
                            ),
                        )
                    ),
                    'yandex_turbo_rss' => array(
                        'title' => $lang['yandex_turbo_rss'],
                        'vars' => array(
                            'yandex_turbo_rss_on' => array(
                                'title' => $lang['yandex_turbo_rss_config'],
                                'description' => $lang['yandex_turbo_rss_configd'],
                                'content' => radio("yandex_turbo_rss_on", $feed_conf['yandex_turbo_rss_on']),
                            ),
                            'yandex_metrics_code' => array(
                                'title' => $lang['yandex_metrics_code_config'],
                                'description' => $lang['yandex_metrics_code_configd'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'commentSignature', 'style="width: 440px; min-width: 240px; max-width: 440px; height: 124px; margin: 0 auto" data-parsley-required="true" data-parsley-trigger="change"'),
                            ),
                            'block_yandex_turbo' => array(
                                'title' => $lang['block_yandex_turbo_config'],
                                'description' => $lang['block_yandex_turbo_configd'],
                                'content' => radio("block_yandex_turbo", $feed_conf['block_yandex_turbo']),
                            ),
                        )
                    ),
                    'seo' => array(
                        'title' => $lang['seo'],
                        'vars' => array(
                            'keywords' => array(
                                'title' => $lang['seo_keywords'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'keywords'),
                            ),
                            'description' => array(
                                'title' => $lang['seo_description'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'description'),
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'feed', '{MOD_LINK}/config', $ok);
        break;
}
function add($id = null): void
{
    global $adminTpl, $config, $core, $lang;
    $rows = $core->row_data('feed', 'id ="' . $id . '"');
    $cats_arr = $core->aCatList();
    if (isset($id)) {
        $admhead = $lang['feed_edit'];
        $eid = $rows['id'];
        $title = $rows['title'];
        $tag = $rows['tags'];
        $tags = '<div class="form-group">
   <label class="col-sm-3 control-label">' . $lang['feed_tag'] . '</label>
   <div class="col-lg-5 col-md-5 col-sm-8">
      <label for="vars" class="field prepend-icon">
         <pre><code>[' . $rows['tags'] . '] {%' . $rows['tags'] . '%} [/' . $rows['tags'] . ']</code></pre>
      </label>
       <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['feed_tags']) . '</span>
   </div>
</div>';
        $desc = $rows['desc'];
        $sourse = $rows['sourse'];
        $cat = $rows['cat'];
        $catttt = explode(',', $cat);
        $firstCat = $catttt[1];
        $deleteKey = array_search($firstCat, $catttt);
        unset($catttt[$deleteKey]);
        $url = $rows['url'];
        $date_format = $rows['date_format'];
        $nmax = $rows['nmax'];
        $templ = $rows['templ'];
        $tmax = $rows['tmax'];
        $dmax = $rows['dmax'];
        $active = $rows['active'];
        $alert = '<span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['feed_title_alert']) . '</span>';
    } else {
        $admhead = $lang['feed_add'];
        $eid = false;
        $title = false;
        $tag = false;
        $tags = false;
        $desc = false;
        $sourse = false;
        $cat = false;
        $catttt = false;
        $firstCat = false;
        $url = false;
        $date_format = false;
        $nmax = 0;
        $templ = false;
        $tmax = 0;
        $dmax = 0;
        $active = false;
        $alert = false;
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['add_title_err']),
            'maxlength' => array(49, str_replace('[count]', '50', $lang['count_text_err_2']))
        ),
        'sourse' => array(
            'required' => array('true', $lang['add_sourse_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
        'desc' => array(
            'required' => array('true', $lang['add_descr_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
    );
    $adminTpl->js_code[] = '$("#nmax").spinner();$("#tmax").spinner();$("#dmax").spinner();';
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
    alert_info('feed');
    echo '<div class="panel panel-dark panel-border top">
      <div class="panel-heading"><span class="panel-title">' . $admhead . ':</span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body pn table-responsive">
         <form id="admin-form" action="{MOD_LINK}/save" method="post" role="form" class="form-horizontal parsley-form" data-parsley-validate>
            <div class="panel-body admin-form">
            <div class="form-group">
               <label class="col-sm-3 control-label">' . $lang['f_title'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="title" class="field prepend-icon">
                  <input id="title" type="text" name="title" onkeyup="count_down(this, \'title\', 50)" maxlength="50" placeholder="' . $lang['feed_title'] . '" class="form-control" ' . (isset($nid) ? '' : 'onchange="getTranslit(gid(\'title\').value, \'translit\'),getRssInform(gid(\'title\').value, \'related_tag\');"') . '  value="' . $title . '">
                  <input id="translit" type="hidden" name="translit"  class="form-control"  ' . (isset($id) ? '' : 'onchange="getRssInform(gid(\'title\').value, \'related_tag\');"') . '   value="' . $tag . '">
                  <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                  </label>
                  ' . $alert . '
                 <div class="text-right" style="text-align:right;">
                     <span id="char_title"></span>
                 </div>
                  <span id="related_tag"></span>
               </div>
            </div>
            ' . $tags . '
            <div class="form-group">
               <label for="desc" class="col-lg-3 col-sm-3 control-label">' . $lang['f_descr'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="desc" class="field prepend-icon">
                  <textarea name="desc" id="desc"  onkeyup="count_down(this, \'desc\', 200)" maxlength="200" placeholder="' . $lang['feed_descr'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto" data-parsley-required="true" data-parsley-trigger="change">' . $desc . '</textarea>
                  <label for="desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                  </label>
                   <div class="text-right" style="text-align:right;">
                     <span id="char_desc"></span>
                 </div>
               </div>
            </div>
            <div class="form-group">
               <label for="category" class="col-lg-3 col-sm-3 control-label">' . $lang['feed_in_cat'] . '</label>
                <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="category" class="field select mb15">
                     <select id="maincat" name="category[]" class="select-single form-control"  onchange="if(this.value != \'0\') {show(\'catSub\');}" >
                        <option value="0">' . $lang['cats_incat_no'] . '</option>';
    foreach ($cats_arr as $cid => $name) {
        $selected = ($cid == $firstCat) ? "selected" : "";
        echo '<option value="' . $cid . '" ' . $selected . '>' . $name . '</option>';
    }
    echo '</select>
                   ' . faI('arrow double') . '
                   </label>
                <div id="catSub" style="' . ((isset($nid) && ($firstCat != 0)) ? '' : 'display:none;') . '">
                   <label for="category" class="field prepend-icon">
                  <select id="category" name="category[]" class="select-single form-control" style="width: 416px; min-width: 240px; max-width: 440px; height: 124px; margin: 0 auto" multiple >';
    foreach ($cats_arr as $cid => $name) {
        if ($catttt) $selected = in_array($cid, $catttt) ? "selected" : "";
        echo '<option value="' . $cid . '" ' . $selected . ' id="cat_' . $cid . '">' . $name . '</option>';
    }
    echo '</select>
                   ' . faI('arrow double') . '
                   </label>
               </div>
            </div>
            </div>
            <div class="form-group">
               <label for="sourse" class="col-lg-3 col-sm-3 control-label">' . $lang['f_sourse'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="url" class="field prepend-icon">
                  <input id="sourse" type="text" name="sourse" onkeyup="count_down(this, \'sourse\', 200)" maxlength="200" value="' . $sourse . '" placeholder="' . $lang['feed_sourse'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="sourse" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
                  </label>
                    <div class="text-right" style="text-align:right;">
                     <span id="char_sourse"></span>
                 </div>
               </div>
            </div>
            <div class="form-group">
               <label for="url" class="col-lg-3 col-sm-3 control-label">' . $lang['f_url'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="url" class="field prepend-icon">
                  <input id="url" type="text" name="url" value="' . $url . '" placeholder="' . $lang['feed_url'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="url" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
                  </label>
               </div>
            </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['f_date_format'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="date_format" class="field prepend-icon">
                     <input id="date_format" type="text" name="date_format" value="' . $date_format . '" placeholder="' . $lang['feed_date_format'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change" class="gui-input" style="width:137px;height: 45px;">
                     <label for="date_format" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                     <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['f_tinfo_date_format']) . '</span>
                  </div>
                     <span class="col-sm-1 input-group-addon"> ' . info_modal('date_format') . '</span>
               </div>
           <div class="form-group">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['feed_tpl'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label class="field select">
                        <select id="templ" name="templ" class="form-control" onchange="loadtpl(this.value)">
                         <option value="default.tpl">' . $lang['feed_tpl_default'] . '</option>
                         <option value="new">' . $lang['feed_tpl_new'] . '</option>';
    foreach (glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/informer/*.tpl') as $inFile) {
        $name = explode('usr/tpl/' . $config['tpl'] . '/', $inFile);
        $name = $name[1];
        $subDir = explode('/', $name);
        $inDirs[$subDir[0]][] = $inFile;
    }
    $count_folder = 0;
    if (isset($inDirs)) {
        foreach ($inDirs as $catalog => $files) {
            $count_folder++;
            $count_files = 0;
            foreach ($files as $file) {
                $count_files++;
                $name = explode('/', $file);
                $name = end($name);
                $_a = explode('usr/tpl/' . $config['tpl'] . '/informer/', $file);
                $absolute = str_replace('/', '=', end($_a));
                if ($name == 'default.tpl') {
                } else {
                    $selected = ($templ == ($_names[$absolute] ?? $name)) ? "selected" : "";
                    echo '<option value="' . ($_names[$absolute] ?? $name) . '" ' . $selected . '>' . ($_names[$absolute] ?? $name) . '</option>';
                }
            }
        }
    }
    echo '</select>
                        ' . faI('arrow double') . '
                     </label>
                  </div>
               </div>
            <div class="form-group">
               <label for="nmax" class="col-lg-3 col-sm-3 control-label">' . $lang['feed_max'] . '</label>
             <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="nmax" class="field prepend-icon">
                  <div class="input-group">
                  <input id="nmax" type="text" name="nmax" value="' . $nmax . '"  class="form-control ui-spinner-input" data-parsley-required="true" data-parsley-trigger="change" style="width:137px;height: 45px;">
                 </div>
                  <label for="nmax" class="field-icon"></label>
                  </label>
                  <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['feed_null']) . '</span>
               </div>
                    <span class="col-sm-1 input-group-addon">  ' . info_modal('max') . '</span>
            </div>
            <div class="form-group">
               <label for="tmax" class="col-lg-3 col-sm-3 control-label">' . $lang['feed_tmax'] . '</label>
              <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="tmax" class="field prepend-icon">
                  <div class="input-group">
                  <input id="tmax" type="text" name="tmax" value="' . $tmax . '" class="form-control ui-spinner-input" data-parsley-required="true" data-parsley-trigger="change" style="width:137px;height: 45px;">
                 </div>
                  <label for="tmax" class="field-icon"></label>
                  </label>
                  <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['feed_null']) . '</span>
               </div>
                   <span class="col-sm-1 input-group-addon">  ' . info_modal('tmax') . '</span>
            </div>
            <div class="form-group">
               <label for="dmax" class="col-lg-3 col-sm-3 control-label">' . $lang['feed_dmax'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="dmax" class="field prepend-icon">
                  <div class="input-group">
                  <input id="dmax" type="text" name="dmax" value="' . $dmax . '" class="form-control ui-spinner-input" data-parsley-required="true" data-parsley-trigger="change" style="width:137px;height: 45px;">
                  </div>
                  <label for="dmax" class="field-icon"></label>
                  </label>
                  <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['feed_null']) . ' </span>
               </div>
                   <span class="col-sm-1 input-group-addon">  ' . info_modal('dmax') . '</span>
            </div>
            <div class="form-group">
               <div class="col-xs-6">
                  <label class="field option">
                  <input type="checkbox" name="active" ' . ($active ? 'checked' : '') . ' value="1" checked><span class="checkbox mr10"></span>' . $lang['feed_on'] . '</label><br>
                  <hr class="alt short mv15">
               </div>
            </div>
      </div>
    </div>
      <div class="panel-footer">
      <button name="submit" type="submit" id="sub" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
      </div>';
    modal_form_text('date_format', $lang['info'], 'fa-desktop', $lang['f_tinfo_date_format'], $lang['f_info_date_format']);
    modal_form_text('dmax', $lang['info'], 'fa-desktop', $lang['feed_dmax'], $lang['feed_info_dmax']);
    modal_form_text('tmax', $lang['info'], 'fa-desktop', $lang['feed_tmax'], $lang['feed_info_tmax']);
    modal_form_text('max', $lang['info'], 'fa-desktop', $lang['feed_max'], $lang['feed_info_max']);
    if (isset($id)) {
        echo '<input type="hidden" name="edit" value="1">
              <input type="hidden" name="id" value="' . $eid . '">';
    }
    echo '</form>
   </div>
</div>';
    $adminTpl->admin_foot();
}

function feed_save(): void
{
    global $core, $db, $cats, $config, $lang;
    $id = isset($_POST['id']) ? intval($_POST['id']) : '';
    $title = isset($_POST['title']) ? filter($_POST['title']) : '';
    $sourse = isset($_POST['sourse']) ? filter($_POST['sourse']) : '';
    $desc = isset($_POST['desc']) ? filter($_POST['desc']) : '';
    $cat = isset($_POST['category']) ? array_unique($_POST['category']) : '0';
    $url = isset($_POST['url']) ? filter($_POST['url']) : '';
    $date_format = isset($_POST['date_format']) ? filter($_POST['date_format']) : '';
    $nmax = isset($_POST['nmax']) ? intval($_POST['nmax']) : '';
    $tmax = isset($_POST['tmax']) ? intval($_POST['tmax']) : '';
    $dmax = isset($_POST['dmax']) ? intval($_POST['dmax']) : '';
    $templ = isset($_POST['templ']) ? filter($_POST['templ']) : '';
    $find = array("<", ">");
    $replace = array("&lt;", "&gt;");
    $tags = $db->safesql(str_replace($find, $replace, $_POST['translit']));
    $active = isset($_POST['active']) ? filter($_POST['active']) : '';
    if (is_array($cat)) {
        $firstCat = $cat[0];
        unset($cat[0]);
        $deleteCat = array_search($firstCat, $cat);
        unset($cat[$deleteCat]);
        $cat[0] = $firstCat;
        ksort($cat);
        foreach ($cat as $cid) {
            $cats .= intval($cid) . ",";
        }
    } else {
        $cats = $cat . ',';
    }
    $cats = ',' . $cats;
    if ($tags && $desc) {
        if (isset($_POST['edit'])) {
            $core->upd_data('feed', '`title` ="' . $title . '", `tags` ="' . $tags . '",`desc` ="' . $desc . '",`cat` ="' . $cats . '",`url` ="' . $url . '",`templ` ="' . $templ . '",`nmax` ="' . $nmax . '",`tmax` ="' . $tmax . '",`nmax` ="' . $nmax . '",`dmax` ="' . $dmax . '",`date_format` ="' . $date_format . '", `active` ="' . $active . '", `date` ="' . time() . '", `sourse` ="' . $sourse . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_edit_feed'], 1, false, false, $desc);
            action_alert('urs', 'success', 'feed', false, 'feed_edit_ok');
        } else {
            if ($templ == 'new') {
                file_put_contents(ROOT . 'usr/tpl/' . $config['tpl'] . '/informer/' . $tags . '.tpl', '[' . $tags . '] {%' . $tags . '%} [/' . $tags . ']');
                $templ = $tags . '.tpl';
            }

            $core->ins_data('feed', 'id,title,tags,desc,cat,url,templ,nmax,tmax,dmax,date_format,date,sourse', 'NULL,"' . $title . '","' . $tags . '","' . $desc . '","' . $cats . '","' . $url . '","' . $templ . '","' . $nmax . '","' . $tmax . '","' . $dmax . '","' . $date_format . '","' . time() . '","' . $sourse . '"');
            $core->ins_log(false, $lang['logs_add_feed'], 1, false, false, $desc);
            action_alert('urs', 'success', 'feed', false, 'feed_add_ok');
        }
    } else {
        action_alert('urs', 'danger', 'feed', 'add', 'not_field');
    }
}

function delfeed($id): void
{
    global $core, $config;
    $feed = $core->row_data('feed', 'id ="' . $id . '"');
    unlink(ROOT . 'usr/tpl/' . $config['tpl'] . '/informer/' . $feed['tags'] . '.tpl');
    $core->del_data('feed', 'id ="' . $feed['id'] . '"');

}