<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfig('feed');
loadLang('feed');
global $core, $db, $config, $feed_conf, $lang;
require ROOT . 'etc/global.config.php';
switch ($url[1] ?? null) {
    default:
        set_title(array($lang['feed']));
        $query = $core->select_data('feed', 'active = 1', 'id ASC');
        if ($db->numRows($query) > 0) {
            while ($feed = $db->getRow($query)) {
                $tags = '[' . $feed['tags'] . '] {%' . $feed['tags'] . '%} [/' . $feed['tags'] . ']';
                $dir = 'usr/tpl/' . $config['tpl'] . '/informer/' . $feed['templ'] . '';
                if (!search_tags($dir, $tags)) {
                    $core->tpl->info(str_replace('[template]', $feed['templ'], $lang['feed_tags_false']));
                } else {
                    $templ = str_replace(".tpl", "", $feed['templ']);
                    $result = getFeed($feed['url'], $feed['nmax'], $feed['tmax'], $feed['dmax'], $feed['date_format']);
                    $core->tpl->loadFile('informer/' . $templ . '');
                    $core->tpl->setVar($feed['tags'], $result);
                    if ($feed['tags']) $core->tpl->setVar('SOURSE', $feed['sourse']);
                    if ($_SERVER['QUERY_STRING'] == 'url=feed') {
                        $core->tpl->setVar('ID', '');
                        $core->tpl->setVar('DATE', '');
                    }
                    $core->tpl->end();
                }
            }
        } else {
            $core->tpl->info($lang['feed_null']);
        }
        break;
    case 'rss':
        global $db, $config, $core, $feed_conf, $lang;
        $type = $url[2] ?? '';
        $cid = isset($url[3]) ? intval($url[3]) : '';
        $where = '';
        if ($type == 'cat') {
            $where = " AND n.cat like '%," . $cid . ",%'";
        }
        $no_head = true;
        $where .= ' AND c.lang = \'' . $core->InitLang() . '\'';
        $query = $core->select_data('news', 'n.active!=0' . $where, 'n.date DESC', 'n.*, c.*, cat.name', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news") LEFT JOIN ' . DB_PREFIX . '_categories as cat on(n.cat = cat.id)');
        if ($feed_conf['rss_2_0_on']) {
            if ($db->numRows($query) > 0) {
                header('Content-Type: application/xml; charset=' . $config['charset']);
                echo '<?xml version="1.0" encoding="' . $config['charset'] . '" ?> ' . "\n";
                echo '<rss version="2.0">' . "\n";
                echo '<channel>' . "\n";
                echo '<title>' . $config['name'] . '</title>' . "\n";
                echo '<link>' . $config['url'] . '</link>' . "\n";
                echo '<language>' . $config['lang'] . '</language>' . "\n";
                echo '<description>' . $config['description'] . '</description>' . "\n";
                while ($news = $db->getRow($query)) {
                    $description = $core->bbDecode($news['short'], $news['id']);
                    $news_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
                    $link = $news_link . $news['altname'] . ".html";
                    echo '<item>' . "\n";
                    echo '<title>' . $news['title'] . '</title>' . "\n";
                    echo '<guid isPermaLink="true">' . $config['url'] . '/' . $link . '</guid>' . "\n";
                    echo '<link>' . $config['url'] . '/' . $link . '</link>' . "\n";
                    echo '<description><![CDATA[' . $description . ']]></description>' . "\n";
                    echo '<category><![CDATA[' . $news['name'] . ']]></category>' . "\n";
                    echo '<pubDate>' . date('D, j M Y H:i:s O', $news['date']) . '</pubDate>' . "\n";
                    echo '</item>' . "\n";
                }
                echo '</channel>' . "\n";
                echo '</rss>';
            }
        } else {
            location($config['url'] . '/404.html');
        }
        break;
    case 'turbo_rss':
        global $db, $config, $core, $feed_conf, $lang;
        $type = $url[2] ?? '';
        $cid = isset($url[3]) ? intval($url[3]) : '';
        $where = '';
        if ($type == 'cat') {
            $where = " AND n.cat like '%," . $cid . ",%'";
        }
        $no_head = true;
        $where .= ' AND c.lang = \'' . $core->InitLang() . '\'';
        $query = $core->select_data('news', 'n.active!=0' . $where, 'n.date DESC', 'n.*, c.*, cat.name', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news") LEFT JOIN ' . DB_PREFIX . '_categories as cat on(n.cat = cat.id)');
        if ($feed_conf['yandex_turbo_rss_on']) {
            if ($db->numRows($query) > 0) {
                header('Content-Type: application/xml; charset=' . $config['charset']);
                echo '<?xml version="1.0" encoding="' . $config['charset'] . '"?>' . "\n";
                echo '<rss xmlns:yandex="http://news.yandex.ru"' . "\n";
                echo 'xmlns:media="http://search.yahoo.com/mrss/"' . "\n";
                echo 'xmlns:turbo="http://turbo.yandex.ru"' . "\n";
                echo 'version="2.0">' . "\n";
                echo '<channel>' . "\n";
                echo '<!-- Информация о сайте-источнике -->' . "\n";
                echo '<title>' . $config['name'] . '</title>' . "\n";
                echo '<link>' . $config['url'] . '</link>' . "\n";
                echo '<description>' . $config['description'] . '</description>' . "\n";
                echo '<language>' . $config['lang'] . '</language>' . "\n";
                if ($feed_conf['yandex_metrics_code']) {
                    echo '<turbo:analytics id="' . $feed_conf['yandex_metrics_code'] . '" type="Yandex" params=""></turbo:analytics>' . "\n";
                } else {
                    echo "\n";
                }
                while ($news = $db->getRow($query)) {
                    $description = $core->bbDecode($news['short'], $news['id']);
                    $news_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
                    $link = $news_link . $news['altname'] . ".html";
                    $text = str_replace(array('<p>', '<\p>', '\n', '\r', '<br>', '<br/>', '&nbsp;', '/<!--(.|\s)*?-->/', '/(<img\s(.+?)\/?>)/is', '/^\s*\/\/<!\[CDATA\[([\s\S]*)\/\/\]\]>\s*\z/'), array('', '', '', '', '', '', '', '', '<figure>$1</figure>', '$1'), $description);
                    echo '<item turbo="' . (($feed_conf['block_yandex_turbo']) ? 'false' : 'true') . '">' . "\n";
                    echo '<link>' . $config['url'] . '/' . $link . '</link>' . "\n";
                    echo '<turbo:content>' . "\n";
                    echo '<![CDATA[' . "\n";
                    echo '<header>' . "\n";
                    echo '<h1>' . $news['title'] . '</h1>' . "\n";
                    echo '<menu>' . "\n";
                    echo '<a href="' . $config['url'] . '/' . $link . '">' . $news['title'] . '</a>' . "\n";
                    echo '</menu>' . "\n";
                    echo '</header>' . "\n";
                    echo $text . "\n";
                    echo ']]>' . "\n";
                    echo '</turbo:content>' . "\n";
                    echo '</item>' . "\n";
                }
                echo '</channel>' . "\n";
                echo '</rss>' . "\n";
            }
        } else {
            location($config['url'] . '/404.html');
        }
        break;
    case 'atom':
        global $db, $config, $core, $feed_conf, $lang;
        $type = $url[2] ?? '';
        $cid = isset($url[3]) ? intval($url[3]) : '';
        $where = '';
        if ($type == 'cat') $where = " AND n.cat like '%," . $cid . ",%'";
        $no_head = true;
        $where .= ' AND c.lang = \'' . $core->InitLang() . '\'';
        $query = $core->select_data('news', 'n.active!=0' . $where, 'n.date DESC', 'n.*, c.*, cat.name', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news") LEFT JOIN ' . DB_PREFIX . '_categories as cat on(n.cat = cat.id)');
        if ($db->numRows($query) > 0) {
            header('Content-Type: application/xml; charset=' . $config['charset']);
            echo '<?xml version="1.0" encoding="' . $config['charset'] . '"?> ' . "\n";
            echo '<feed xmlns="http://www.w3.org/2005/Atom">' . "\n";
            echo '<title>' . $config['name'] . '</title>' . "\n";
            echo '<link href="' . $config['url'] . '"/>' . "\n";
            echo '<updated>' . date('D, j M Y H:i:s O', time()) . '</updated>' . "\n";
            while ($news = $db->getRow($query)) {
                $description = $core->bbDecode($news['short'], $news['id']);
                $news_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
                $link = $news_link . $news['altname'] . ".html";
                echo '<author> ' . "\n";
                echo '<name>' . $news['author'] . '</name>' . "\n";
                echo '</author> ' . "\n";
                echo '<entry>' . "\n";
                echo '<title>' . $news['title'] . '</title>' . "\n";
                echo '<link href="' . $config['url'] . '/' . $link . '"/>' . "\n";
                echo '<updated>' . date('D, j M Y H:i:s O', $news['date']) . '</updated>' . "\n";
                echo '<summary><![CDATA[' . $description . ']]></summary>' . "\n";
                echo '</entry>' . "\n";
            }
            echo '</feed>';
        }
        break;
    case 'opensearch':
        $no_head = true;
        header('Content-Type: application/xml; charset=' . $config['charset']);
        echo '<?xml version="1.0" encoding="' . $config['charset'] . '" ?> ' . "\n";
        echo '<OpenSearchDescription xmlns="http://a9.com/-/spec/opensearch/1.1/">';
        echo '<ShortName>' . $config['name'] . '</ShortName>' . "\n";
        echo '<Description>' . $config['description'] . '</Description>' . "\n";
        echo '<Tags>' . $config['keywords'] . '</Tags>' . "\n";
        echo '<Contact>' . $config['support_mail'] . '</Contact>' . "\n";
        echo '<Url type="application/atom+xml" template="' . $config['url'] . '/feed/opensearch/{searchTerms}"/>' . "\n";
        echo '<Url type="application/rss+xml" template="' . $config['url'] . '/feed/opensearch/{searchTerms}"/>' . "\n";
        echo '<Url type="application/turbo_rss+xml" template="' . $config['url'] . '/feed/opensearch/{searchTerms}"/>' . "\n";
        echo '<Url type="text/html" template="' . $config['url'] . '/search/{searchTerms}"/>' . "\n";
        echo '<LongName>JMYCMS Search</LongName>' . "\n";
        echo '<Image height="16" width="16" type="image/vnd.microsoft.icon">' . $config['url'] . '/media/favicon.ico</Image>' . "\n";
        echo '<Developer>' . $lang['jmy_core'] . '</Developer>' . "\n";
        echo '<Attribution>' . $lang['license_copyright'] . D_YEAR . ' </Attribution>' . "\n";
        echo '<SyndicationRight>open</SyndicationRight>' . "\n";
        echo '<AdultContent>false</AdultContent>' . "\n";
        echo '<Language>' . $config['lang'] . '</Language>' . "\n";
        echo '<OutputEncoding>' . mb_strtoupper($config['charset']) . '</OutputEncoding>' . "\n";
        echo '<InputEncoding>' . mb_strtoupper($config['charset']) . '</InputEncoding>' . "\n";
        echo '</OpenSearchDescription>' . "\n";
        break;
}