<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_SWITCH')) {
    header('Location: /');
    exit;
}
global $adminTpl, $admin_conf, $db, $core, $config, $url, $guestbook_conf, $lang;
switch ($url[3] ?? null) {
    default:
        guestbook_main();
        break;
    case 'reply':
        $id = intval($url[4]);
        reply_edit($id);
        break;

    case 'save':
        require(ROOT . 'etc/guestbook.config.php');
        $act = isset($_POST['act']) ? filter($_POST['act']) : '';
        $id = isset($_POST['id']) ? intval($_POST['id']) : '';
        if (isset($id)) {
            if ((!empty($act) && $act == 'edit')) {
                $gender = isset($_POST['gender']) ? intval($_POST['gender']) : '';
                $website = isset($_POST['website']) ? filter($_POST['website']) : '';
                $text = isset($_POST['text']) ? filter($_POST['text']) : '';
                $name = isset($_POST['name']) ? filter($_POST['name']) : '';
                $email = isset($_POST['email']) ? filter($_POST['email']) : '';
                if (!empty($text) && !empty($name) && !empty($email) && !empty($gender)) {
                    $core->upd_data('guestbook', '`website` ="' . $db->safesql(processText($website)) . '",`comment` ="' . $db->safesql(parseBB($text)) . '",`email` ="' . $email . '",`name` ="' . $db->safesql(processText($name)) . '",`gender` ="' . $gender . '"', 'id ="' . $id . '"');
                    action_alert('urs', 'success', 'guestbook', false, 'com_update');
                } else {
                    action_alert('urs', 'danger', 'guestbook', false, 'unknown_error');
                }
            } else {
                $reply = isset($_POST['reply']) ? filter($_POST['reply']) : '';
                if ($guestbook_conf['reply_mail'] == 1) {
                    $message = str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '&lt;', '&gt;'), array('""', '""', '""', '\n', '\n', '\n', '<', '>'), $reply);
                    mailSMTP($config['support_mail'], $reply, $lang['guestbook_reply_text'] . $config['name'], parseBB(processText($message)) . '<br/>' . $config['url'] . '/guestbook');
                }
                $core->upd_data('guestbook', '`reply` ="' . $db->safesql(parseBB(processText($reply), $id, true)) . '"', 'id ="' . $id . '"');
                action_alert('urs', 'success', 'guestbook', false, 'guestbook_reply_update');
            }
        } else {
            action_alert('urs', 'danger', 'guestbook', false, 'unknown_error');
        }

        break;
    case 'edit':
        $id = intval($url[4]);
        guestbook_add($id);
        break;
    case 'view':
        init_count_text();
        $id = isset($url[4]) ? intval($url[4]) : 0;
        $query = $core->select_data('guestbook', 'id ="' . $id . '"');
        $adminTpl->admin_head($lang['guestbook'] . '| ' . $lang['view']);
        if ($db->numRows($query) > 0) {
            while ($guestbook = $db->getRow($query)) {
                $comment = decoder('d', (isset($guestbook['comment']) ? internoetics_mb_strimwidthd($guestbook['comment'], 0, 30, $trimmarker = '...') : ''));
                $text = decoder('d', $guestbook['comment']);
                $reply = decoder('d', $guestbook['reply']);
                echo '<div id="content" class="table-layout animated fadeIn">
			<div class="tray tray-center">
		    	<div class="panel panel-yellow panel-border top">
				<div class="panel-heading br-b-ddd"><span class="panel-title">' . $lang['view'] . '</span>
				</div>
						<div class="heading-hr"></div>
					 <div class="panel-body pn table-responsive"><br/>
						<p class="text-left">&emsp;&emsp;' . $lang['title'] . '&emsp;' . $comment . '</p>
						<p class="text-left">&emsp;&emsp;' . $lang['date'] . '&emsp;' . formatDate($guestbook['date'], true) . '</p>
						<p class="text-left">&emsp;&emsp;' . $lang['author'] . '&emsp;' . str($guestbook['name'], 20) . '</p>
						<p class="text-left">&emsp;&emsp;' . $lang['guestbook_reply'] . '&emsp;' . (!empty($guestbook['reply']) ? str($reply, 40) : $lang['no']) . '</p>
						<p class="text-left">&emsp;&emsp;' . $lang['status'] . '&emsp;' . status_icon('guestbook', $guestbook['id'], 'guestbook') . '</p>
                        <p class="text-left">&emsp;&emsp;' . $lang['emails'] . '&emsp; ' . $guestbook['email'] . '</p>
						<div class="panel-body">
						<hr class="short alt">
								<p class="text-left">&emsp;&emsp; ' . $text . '</p>
						  </div>
						  <div class="panel-footer text-right">
						  <select id ="dropDownId" class="btn bg-success btn-sm btn-raised legitRipple">
                           <option value="/{MOD_LINK}/letter/mail/' . $guestbook['id'] . '\" >' . faSpan('fa-envelope-o', true, $lang['mails']) . '</option>
                           <option value="/{MOD_LINK}/letter/pm/' . $guestbook['id'] . '\">' . faSpan('fa-user-o', true, $lang['pms']) . '</option>
                        </select>
                        <button name="submit" type="submit" id="sub"  class="SubmitButton btn bg-system btn-sm btn-raised legitRipple">' . faSpan('fa-trash-o fa-arrow-right', true, $lang['next']) . '</button>
                        <button name="submit" type="submit" id="sub" onclick="location.href = \'{MOD_LINK}/edit/' . $guestbook['id'] . '\'" class="btn bg-info btn-sm btn-raised legitRipple">' . faSpan('fa-edit', true, $lang['edit']) . '</button>
                        <button name="submit" type="submit" id="sub" onclick="location.href = \'{MOD_LINK}/delete/' . $guestbook['id'] . '\'" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-trash-o', true, $lang['delete']) . '</i></button>
						  </div>
						  <script src ="//code.jquery.com/jquery-3.0.0.min.js"></script> <!-- add jquery library-->
                          <script type ="text/javascript">
                                 $(\'.SubmitButton\').click(function(){
                                 var urldata = $(\'#dropDownId :selected\').val();
                                 window.open("' . $config['url'] . '"+urldata+"")
                          });
                          </script>';
            }
            echo '</div>
			</div>';
        } else {
            $adminTpl->info($lang['nothing_found'], 'error', null, $lang['error'], $lang['go_back'], 'javascript:history.go(-1)');
        }
        echo '</div>
     </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'moderation':
        $id = intval($url[4]);
        if (!empty($id)) {
            $row = $core->row_data('guestbook', 'id ="' . $id . '"');
            $core->upd_data('guestbook', 'active = 2', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_guestbook'], 1, false, false, $row['name']);
            action_alert('urs', 'success', 'guestbook');
        } else {
            action_alert('urs', 'danger', 'guestbook', false, 'unknown_error');
        }
        break;
    case 'moder_moderation':
        $id = intval($url[4]);
        if (!empty($id)) {
            $row = $core->row_data('guestbook', 'id ="' . $id . '"');
            $core->upd_data('guestbook', 'active = 1', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_guestbook_1'], 1, false, false, $row['name']);
            location(ADMIN . '/moderation/mod/guestbook');
        } else {
            action_alert('urs', 'danger', 'guestbook', false, 'unknown_error');
        }
        break;
    case 'letter':
        method_letter('urs', 'guestbook', 'guestbook', $url[4]);
        break;
    case 'send_letter':
        method_send('urs', 'guestbook', $url[4], 'guestbook', $admin_conf['user_mail'], '2', $_POST['message']);
        break;
    case 'retivate':
        $id = intval($url[4]);
        if (!empty($id)) {
            $rows = $core->row_data('guestbook', 'id ="' . $id . '"');
            $active = $rows['active'] == 0 || $rows['active'] == 2 ? 1 : 0;
            $core->upd_data('guestbook', 'active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_guestbook'], 1, false, false, $rows['comment']);
            action_alert('urs', 'success', 'guestbook');
        } else {
            action_alert('urs', 'danger', 'guestbook', false, 'unknown_error');
        }
        break;
    case 'delete':
        $id = intval($url[4]);
        if ($id) {
            delete($id);
            action_alert('urs', 'success', 'guestbook');
        } else {
            action_alert('urs', 'danger', 'guestbook', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('guestbook', 'active = 1', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'guestbook');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('guestbook', 'active = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'guestbook');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $rows = $core->row_data('guestbook', 'id ="' . $id . '"');
                        $active = $rows['active'] == 0 ? 1 : 0;
                        $core->upd_data('guestbook', 'active ="' . $active . '"', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'guestbook');
                    }
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        delete(intval($id));
                        action_alert('urs', 'success', 'guestbook');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('urs', 'danger', 'guestbook');
        }
        break;
    case 'config':
        init_count_text();
        require(ROOT . 'etc/guestbook.config.php');
        $configBox = array(
            'guestbook' => array(
                'varName' => 'guestbook_conf',
                'title' => $lang['guestbook'],
                'groups' => array(
                    'main' => array(
                        'title' => $lang['config_main'],
                        'vars' => array(
                            'commentModeration' => array(
                                'title' => $lang['guestbook_pre_mod'],
                                'description' => $lang['guestbook_pre_mod_desc'],
                                'content' => radio("commentModeration", $guestbook_conf['commentModeration']),
                            ),
                            'comments_num' => array(
                                'title' => $lang['guestbook_num'],
                                'description' => $lang['guestbook_num_desc'],
                                'content' => int_cong('input', '{varName}', '{var}', '{varName}'),
                            ),
                            'reply_mail' => array(
                                'title' => $lang['guestbook_send'],
                                'description' => $lang['guestbook_send_desc'],
                                'content' => radio("reply_mail", $guestbook_conf['reply_mail']),
                            ),
                            'del_time' => array(
                                'title' => $lang['guestbook_message_delete'],
                                'description' => $lang['guestbook_message_delete_desc'],
                                'content' => radio("del_time", $guestbook_conf['del_time']),
                            ),
                            'del_time_num' => array(
                                'title' => $lang['guestbook_num_day'],
                                'description' => $lang['guestbook_num_day_desc'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'seo' => array(
                        'title' => $lang['seo'],
                        'vars' => array(
                            'keywords' => array(
                                'title' => $lang['seo_keywords'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'keywords'),
                            ),
                            'description' => array(
                                'title' => $lang['seo_description'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'description'),
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'guestbook', '{MOD_LINK}/config', $ok);
        break;
}
function guestbook_main(): void
{
    global $adminTpl, $admin_conf, $core, $url, $db, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $where = 'active != 2';
    $whereC = $where;
    $order = '';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : '';
    $s_web = isset($_POST['s_web']) ? filter($_POST['s_web'], 'a') : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
    $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
    $s_day = isset($_POST['s_day']) ? intval($_POST['s_day']) : '';
    $s_active = isset($_POST['s_active']);
    $s_search = isset($_POST['s_search']);
    if ($s_active) {
        if ($_POST['s_active'] == 1) {
            $where = '`active` = 1 ';
        } else {
            $s_active = false;
            $where = '`active` = 0 ';
        }
    } else {
        $s_active = true;
    }
    if ($s_id) {
        $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
        $s_id = '';
    }
    if ($s_day) $where .= "AND `date`>='" . mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")) . "'";
    if ($s_author) $where .= "AND `name` LIKE '%" . $db->safesql($s_author) . "%'";
    if ($s_web) $where .= "AND `website` LIKE '%" . $db->safesql($s_web) . "%'";
    if ($s_desc) $where .= "AND `comment` LIKE '%" . $db->safesql($s_desc) . "%'";
    if ($startdate) $where .= "AND `date` >= '" . intval($startdate) . "'";
    if ($enddate) $where .= "AND `date` <= '" . intval($enddate) . "'";
    if (isset($url[3]) && $url[3] == 'order') {
        switch ($url[4]) {
            case 'abc':
                $order .= 'comment ASC';
                break;
            case 'last':
                $order .= 'date DESC';
                break;
            case 'id':
                $order .= 'id ASC';
                break;
        }
    } else {
        $order .= 'id DESC';
    }
    $query = $core->select_data('guestbook', $where, $order . ' LIMIT ' . limit_page());
    $adminTpl->admin_head($lang['guestbook']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
        onmoder('guestbook', 'active', 'guestbook_moder');
        alert_info('guestbook');
        echo '<div class="panel panel-dark panel-border top">
            <div class="panel-heading">
               <span class="panel-title">' . $lang['guestbook_list'] . ' (' . $core->sum_data('guestbook') . '):</span>
               ' . sort_head('urs', 4, 'last') . '            
            </div>
            <div class="heading-hr"></div>
            <div class="panel-body pn table-responsive">
               <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/action" onclick="lihtTable(getSource(event))">
                  <table class="table table-xs table-striped">
                     <thead>
                        <tr>
                           <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                           <th></th>
                           <th class="col-md-8">' . $lang['titles'] . '</th>
                           <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($guestbook = $db->getRow($query)) {
            $users = $core->row_data('users', 'email ="' . $guestbook['email'] . '"');
            $comment = decoder('d', trimtitle($guestbook['comment'], 50));
            $reply = decoder('d', trimtitle($guestbook['reply'], 50));

            $rows = $core->row_data('users', 'nick ="' . $guestbook['name'] . '"');

            $sname = !$rows['surname'] && !$rows['name'] && !$rows['ochestvo'] ? $lang['unspecif'] : ($rows['surname'] ?? '') . ' ' . ($rows['name'] ?? '') . ' ' . ($rows['ochestvo'] ?? '');

            echo '<tr>
                           <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $guestbook['id'] . '</td>
                          <td>
                           <div class="media media-list"><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-formu-' . $rows['id'] . '\')">
                           <img src="' . avatar($rows['id']) . '" class="img-responsive mw60 ib br4"' . toggle($sname) . ' alt=""></a></div>
                           </td>
                            <td>
                              <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['comment'] . ':' . $comment . '</ol>
                              <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['answer'] . ': ' . (!empty($guestbook['reply']) ? $reply : $lang['no']) . '</ol>
                              <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($guestbook['date'], true) . '</ol>
                              <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ':<a href="profile/' . $guestbook['name'] . '"> ' . str($guestbook['name'], 20) . ' </a></ol>
                           </td>
                           <td class="text-center">' . status_icon('guestbook', $guestbook['id'], 'guestbook') . '</td>';

            init_checkbox('td', $guestbook['id'], false, '<li><a href="{MOD_LINK}/view/' . $guestbook['id'] . '\">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
					<li><a href="{MOD_LINK}/edit/' . $guestbook['id'] . '\">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
					' . (($guestbook['active'] != 2) ? '<li><a href="{MOD_LINK}/moderation/' . $guestbook['id'] . '\">' . faSpan('fa-share-square-o', true, $lang['do_moderation']) . '</a></li>' : '') . '
					<li><a href="{MOD_LINK}/retivate/' . $guestbook['id'] . '\">' . faSpan('fa-power-off', true, (($guestbook['active'] == 0) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
				    <li><a href="{MOD_LINK}/reply/' . $guestbook['id'] . '\">' . faSpan('fa-share-square-o', true, $lang['guestbook_replys']) . '</a></li>
            ' . (($admin_conf['user_pm'] && $users['nick']) ? '<li><a href="{MOD_LINK}/letter/pm/' . $guestbook['id'] . '\">' . faSpan('fa-user-o', true, $lang['pm']) . '</a></li>' : '') . '
            ' . (($admin_conf['user_mail']) ? '<li><a href="{MOD_LINK}/letter/mail/' . $guestbook['id'] . '\">' . faSpan('fa-envelope-o', true, $lang['mail']) . '</a></li>' : '') . '
                   <li class="divider"></li>
                   <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $guestbook['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete($guestbook['id'], $comment, $lang['guestbook_delete_title'], 'guestbook', $lang['guestbook_delete_text'], '{MOD_LINK}/delete/' . $guestbook['id']);
        }
        echo '</tbody>';
        init_tfoot('<option value="activate">' . $lang['do_activation'] . '</option>
       				<option value="deActivate">' . $lang['do_deactivation'] . '</option>
        			<option value="reActivate">' . $lang['do_reactivation'] . '</option>
        			<option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
               </form>
            </div>
         </div>';
        page_list('urs', 'guestbook', 'guestbook', $where);
        echo '</div>
     <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">';
        echo '<option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = ($users_list['nick'] == $guestbook['author']) ? "selected" : "";
                echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                      ' . faI('arrow double') . '
                   </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['guestbook_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_web" class="field prepend-icon">
               <input id="s_web" type="text" name="s_web" placeholder="' . $lang['guestbook_website'] . '" class="form-control" value="' . $s_web . '">
               <label for="s_web" class="field-icon">' . faI('fa-globe', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['guestbook_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 pl10">
               <h5><small>' . $lang['static_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-md-6">
                     <label for="startdate" class="field prepend-icon">
                     <input id="startdate" type="text" name="startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-md-6">
                     <label for="enddate" class="field prepend-icon">
                     <input id="enddate" type="text" name="enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_day" value="0">
               <input type="checkbox" name="s_day" ' . ($s_day ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['guestbook_day'] . '</label>
            </div>
              <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['guestbook_active'] . '</label>
            </div>
             ' . init_sfoot(true, true, false, '{MOD_LINK}') . '         
         </div>
      </form>
   </aside>
</div>';
    } else {
        onmoder('guestbook', 'active', 'guestbook_moder');
        list_empty('urs', 'guestbook', 'moder', $s_search, false, true, $s_search, true);
    }
    echo '</div>
</div>';
    $adminTpl->admin_foot();
}

function guestbook_add($id = null): void
{
    global $adminTpl, $core, $lang;
    $guestbook = $core->row_data('guestbook', 'id ="' . $id . '"');
    initDir('guestbook', $id);
    $adminTpl->admin_head($lang['guestbook'] . ' | ' . $lang['edit']);
    echo '<div id="content" class="table-layout animated fadeIn">
			<div class="tray tray-center">
		    	<div class="panel panel-dark panel-border top">
				<div class="panel-heading br-b-ddd"><span class="panel-title">' . $lang['guestbook_sendingmess'] . '</span>
				</div>
				  <div class="heading-hr"></div>
					<div class="panel-body admin-form">
					<form class="form-horizontal parsley-form" role="form" action="{MOD_LINK}/save" onsubmit="return caa(false);" method="post" data-parsley-validate>
						<div class="form-group">
							<label for="name" class="col-lg-3 col-sm-3 control-label">' . $lang['username'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="name" class="field prepend-icon">
									<input id="name" type="text" name="name" value="' . $guestbook['name'] . '" placeholder="' . $lang['author'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
									<label for="name" class="field-icon">' . faI('fa-user-o', false, false, true) . '</label>
								</label>
							</div>
						</div>
	                   <div class="form-group">
							<label for="email" class="col-lg-3 col-sm-3 control-label">' . $lang['user_email'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="email" class="field prepend-icon">
									<input id="email" type="text" name="email" value="' . $guestbook['email'] . '" placeholder="' . $lang['user_email'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
									<label for="email" class="field-icon">' . faI('fa-envelope-o', false, false, true) . '</label>
								</label>
							</div>
						</div>
						<div class="form-group">
							<label for="website" class="col-lg-3 col-sm-3 control-label">' . $lang['guestbook_website'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="website" class="field prepend-icon">
									<input id="website" type="text" name="website" value="' . (!empty($guestbook['website']) ? $guestbook['website'] : $lang['no']) . '" placeholder="' . $lang['guestbook_website'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
									<label for="website" class="field-icon">' . faI('fa-globe', false, false, true) . '</label>
								</label>
							</div>
						</div>
						<div class="form-group">
							<label for="gender"	class="col-lg-3 col-sm-3 control-label">' . $lang['sex'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="gender" class="field select">
									 <select class="form-control" name="gender" >' . Gender($guestbook['gender']) . '</select>
                              ' . faI('arrow double') . '
                           </label>
							</div>
						</div>
						<div class="col-xs-12">
                           <div class="tab-block mb25">
                        <div class="form-group admin-form">
                     <div class="tab-content_editor">
						 <label for="text" class="field prepend-icon">
                             ' . adminArea('text', $guestbook['comment'], 5, 'textarea', 'onchange="caa(this);"', true) . '
                         </label>
                     </div>
				 </div>
					</div>
						</div>
					       </div>
                          <div class="panel-footer">
						<input name="id" value="' . $id . '" type="hidden">
			            <input name="act" value="edit" type="hidden">
			            <button  type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
						 </div>
					 </form>
				   </div>
	              </div>
	            </div>';
    $adminTpl->admin_foot();
}

function reply_edit($id = null): void
{
    global $adminTpl, $core, $lang;
    init_count_text();
    $guestbook = $core->row_data('guestbook', 'id ="' . $id . '"');
    $id = $guestbook['id'];
    $text = decoder('d', $guestbook['comment']);
    $reply = decoder('d', $guestbook['reply']);
    initDir('guestbook', $id);
    $adminTpl->admin_head($lang['modules'] . ' | ' . $lang['guestbook_sendingmess']);
    echo '<div id="content" class="table-layout animated fadeIn">
	<div class="tray tray-center">
            <div class="panel panel-dark panel-border top">
				<div class="panel-heading">
				<span class="panel-title">' . $lang['guestbook_sendingmess'] . '</span>
		</div>
		<div class="heading-hr"></div>
				<div class="panel-body p20 pb10">
					<form class="form-horizontal parsley-form" role="form" action="{MOD_LINK}/save" onsubmit="return caa(false);" method="post" data-parsley-validate>
						<div class="form-group admin-form">
							<label for="name"	class="col-lg-3 col-sm-3 control-label">' . $lang['author'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="name" class="field prepend-icon">
									<input id="name" type="text" name="name" value="' . $guestbook['name'] . '" placeholder="' . $lang['author'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
									<label for="name" class="field-icon">' . faI('fa-user-o', false, false, true) . '</label>
								</label>
							</div>
						</div>
	                   <div class="form-group admin-form">
							<label for="email"	class="col-lg-3 col-sm-3 control-label">' . $lang['user_email'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="email" class="field prepend-icon">
									<input id="email" type="text" name="email" value="' . $guestbook['email'] . '" placeholder="' . $lang['user_email'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
									<label for="email" class="field-icon">' . faI('fa-envelope-o', false, false, true) . '</label>
								</label>
							</div>
						</div>
						<div class="form-group admin-form">
							<label for="website"	class="col-lg-3 col-sm-3 control-label">' . $lang['guestbook_website'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="website" class="field prepend-icon">
									<input id="website" type="text" name="website" value="' . (!empty($guestbook['website']) ? $guestbook['website'] : $lang['no']) . '" placeholder="' . $lang['guestbook_website'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
									<label for="website" class="field-icon">' . faI('fa-globe', false, false, true) . '</label>
								</label>
							</div>
						</div>
						<div class="form-group admin-form">
							<label for="gender"	class="col-lg-3 col-sm-3 control-label">' . $lang['sex'] . '</label>
							<div class="col-lg-5 col-md-5 col-sm-8">
								<label for="gender" class="field prepend-icon">
									<input id="gender" type="text" name="gender" value="' . ($guestbook['gender'] == 2 ? $lang['female'] : $lang['male']) . '" placeholder="' . $lang['sex'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
									<label for="gender" class="field-icon">' . faI('fa-venus-mars', false, false, true) . '</label>
								</label>
							</div>
						</div>
						<div class="panel-body">
							<hr class="short alt">
								<p class="text-left">&emsp;' . $lang['guestbook_text'] . '</br>&emsp;<pre><code>' . $text . '</code></pre></p>
								</div>
								<div class="col-xs-12">
                           <div class="tab-block mb25">
                        <div class="form-group admin-form">
                     <div class="tab-content_editor">
						 <label for="reply" class="field prepend-icon">
							' . adminArea('reply', (!empty($guestbook['reply']) ? $reply : ''), 10, 'textarea', 'onchange="caa(this);"', true) . '
                         </label>
                     </div>
				 </div>
					</div>
						</div>
					       </div>
                          <div class="panel-footer">
						<input name="id" value="' . $id . '" type="hidden">
			            <input name="act" value="reply" type="hidden">
			            <button  type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
						 </div>
					 </form>
				   </div>
			</div>';
    $adminTpl->admin_foot();
}

function delete($id): void
{
    global $core;
    $core->del_data('guestbook', 'id ="' . $id . '"');
    full_rmdir(ROOT . initDC('guestbook', '', '', $id));
}