<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

global $adminTpl, $db, $core, $lang;
if (empty($url[3])) {
    onmoder('guestbook', 'active', 'guestbook_moder');
} else {
    guestbook_main();
}
function guestbook_main(): void
{
    global $adminTpl, $admin_conf, $core, $url, $db, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $where = 'active = 2';
    $whereC = $where;
    $order = '';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : '';
    $s_web = isset($_POST['s_web']) ? filter($_POST['s_web'], 'a') : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
    $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
    $s_day = isset($_POST['s_day']) ? intval($_POST['s_day']) : '';
    $s_active = isset($_POST['s_active']);
    $s_search = isset($_POST['s_search']);
    if ($s_active) {
        if ($_POST['s_active'] == 1) {
            $where = 'WHERE `active` = 1 ';
        } else {
            $s_active = false;
            $where = 'WHERE `active` = 0 ';
        }
    } else {
        $s_active = true;
    }
    if ($s_id) {
        $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
        $s_id = '';
    }
    if ($s_day) $where .= "AND `date`>='" . mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")) . "'";
    if ($s_author) $where .= "AND `name` LIKE '%" . $db->safesql($s_author) . "%'";
    if ($s_web) $where .= "AND `website` LIKE '%" . $db->safesql($s_web) . "%'";
    if ($s_desc) $where .= "AND `comment` LIKE '%" . $db->safesql($s_desc) . "%'";
    if ($startdate) $where .= "AND `date` >= '" . intval($startdate) . "'";
    if ($enddate) $where .= "AND `date` <= '" . intval($enddate) . "'";
    if (isset($url[4]) && $url[4] == 'order') {
        switch ($url[5]) {
            case 'abc':
                $order .= 'comment ASC';
                break;
            case 'last':
                $order .= 'date DESC';
                break;
            case 'id':
                $order .= 'id ASC';
                break;
        }
    } else {
        $order .= 'id DESC';
    }
    $query = $core->select_data('guestbook', $where, $order . ' LIMIT ' . limit_page());
    $adminTpl->admin_head($lang['guestbook_onmoder']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        onmoder('guestbook', 'active', 'guestbook_moder');
        alert_info('guestbook');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['guestbook_list'] . ' (' . $core->sum_data('guestbook') . '):</span>
            ' . sort_head('moder', 5, 'last') . '            
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ACT_MODER_LINK}" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-8">' . $lang['titles'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo ' </tr>
                  </thead>
                  <tbody>';
        while ($guestbook = $db->getRow($query)) {
            $users = $core->row_data('users', 'email ="' . $guestbook['email'] . '"');
            $comment = str_replace(array('""', '""', '""', '&nbsp;', '&quot;', '&lt;', '&gt;', '&raquo;', '&laquo;'), array('\p', '\n', '\r', ' ', '', '<', '>', '»', '«'), isset($guestbook['comment']) ? trimtitle($guestbook['comment'], 30) : '');
            $reply = str_replace(array('""', '""', '""', '&nbsp;', '&quot;', '&lt;', '&gt;', '&raquo;', '&laquo;'), array('\p', '\n', '\r', ' ', '', '<', '>', '»', '«'), isset($guestbook['reply']) ? trimtitle($guestbook['reply'], 40) : '');
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $guestbook['id'] . '</td>
                        <td>
                           <div class="media media-list"></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['comment'] . ':' . $comment . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['answer'] . ': ' . (!empty($guestbook['reply']) ? $reply : $lang['no']) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($guestbook['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ':<a href="profile/' . $guestbook['name'] . '"> ' . str($guestbook['name'], 20) . ' </a></ol>
                        </td>
                        <td class="text-center">' . status_icon('guestbook', $guestbook['id'], 'guestbook') . '</td>';
            init_checkbox('td', $guestbook['id'], false, '<li><a href="{LI_MODER_LINK}/view/' . $guestbook['id'] . '\">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href="{LI_MODER_LINK}/edit/' . $guestbook['id'] . '\">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 ' . (($guestbook['active'] != 2) ? '<li><a href="{LI_MODER_LINK}/moderation/' . $guestbook['id'] . '\">' . faSpan('fa-share-square-o', true, $lang['do_moderation']) . '</a></li>' : '') . '
                                 <li><a href="{LI_MODER_LINK}/retivate/' . $guestbook['id'] . '">' . faSpan('fa-power-off', true, (($guestbook['active'] <> 1) ? $lang['do_active'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="{LI_MODER_LINK}/reply/' . $guestbook['id'] . '\">' . faSpan('fa-share-square-o', true, $lang['guestbook_replys']) . '</a></li>
                                 ' . (($admin_conf['user_pm'] && $users['nick']) ? '<li><a href="{LI_MODER_LINK}/letter/pm/' . $guestbook['id'] . '\">' . faSpan('fa-user-o', true, $lang['pm']) . '</a></li>' : '') . '
                                 ' . (($admin_conf['user_mail']) ? '<li><a href="{LI_MODER_LINK}/letter/mail/' . $guestbook['id'] . '\">' . faSpan('fa-envelope-o', true, $lang['mail']) . '</a></li>' : '') . '
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $guestbook['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete($guestbook['id'], $comment, $lang['guestbook_delete_title'], 'guestbook', $lang['guestbook_delete_text'], '{MOD_LINK}/delete/' . $guestbook['id']);
        }
        echo '</tbody>';
        init_tfoot('<option value="activate">' . $lang['do_activation'] . '</option>
                    <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                    <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                    <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('umoder', 'guestbook', 'guestbook', $where);
        echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">
                     <option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = ($users_list['nick'] == $guestbook['author']) ? "selected" : "";
                echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                  <i class="arrow double"></i>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['guestbook_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_web" class="field prepend-icon">
               <input id="s_web" type="text" name="s_web" placeholder="' . $lang['guestbook_website'] . '" class="form-control" value="' . $s_web . '">
               <label for="s_web" class="field-icon">' . faI('fa-globe', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['guestbook_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 pl10">
               <h5><small>' . $lang['static_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-md-6">
                     <label for="startdate" class="field prepend-icon">
                     <input id="startdate" type="text" name="startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-md-6">
                     <label for="enddate" class="field prepend-icon">
                     <input id="enddate" type="text" name="enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_day" value="0">
               <input type="checkbox" name="s_day" ' . ($s_day ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['guestbook_day'] . '</label>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['guestbook_active'] . '</label>
            </div>
            ' . init_sfoot(true, true, false, '{MODER_LINK}') . '         
         </div>
      </form>
   </aside>
</div>';
    } else {
        list_empty('urs', 'guestbook', 5, $s_search, 'mod');
    }
    echo '</div>
</div>';
    $adminTpl->admin_foot();
}