<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $core, $db, $guestbook_conf, $lang;
$order = $order == 'date_reply' ? 'reply DESC, date' : 'id';
if (($short != 'DESC') & ($short != 'ASC')) $short = 'DESC';
$core->loadModLang('guestbook');
$core->tempModule = 'guestbook';
$queryDB = $core->select_data('guestbook', false, $order . ' ' . $short . ' LIMIT ' . $core->site_limit_page($guestbook_conf, $limit));
$custom = '';
if ($db->numRows($queryDB) > 0) {
    while ($guestbook = $db->getRow($queryDB)) {
        if (isset($guestbook['uid'])) $user_info = $core->row_data('users', 'id ="' . $guestbook['uid'] . '"');
        ob_start();
        $core->tpl->loadFile($template);
        $core->tpl->setVar('ID', $guestbook['id']);
        $core->tpl->setVar('AVATAR', (empty($guestbook['uid']) ? 'media/avatar/' . (($guestbook['gender'] == 1) ? 'male.jpg' : 'female.jpg') : avatar($user_info['id'] ?? '')));
        $core->tpl->setVar('NAME', (empty($guestbook['uid']) ? $guestbook['name'] : $user_info['nick'] ?? ''));
        $core->tpl->setVar('EMAIL', (empty($guestbook['uid']) ? $guestbook['email'] : $user_info['email'] ?? ''));
        $core->tpl->setVar('DATE', formatDate($guestbook['date'], true));
        $core->tpl->setVar('WEBSITE', (!empty($guestbook['website']) ? $lang['guestbook_website'] . ':' . $guestbook['website'] : $lang['absent']));
        $core->tpl->setVar('REPLY', $guestbook['reply']);
        $array_replace["#\\[reply\\](.*?)\\[/reply\\]#is"] = (!empty($guestbook['reply']) ? '\\1' : '');
        $core->tpl->setVar('REPLY_FLAG', (!empty($guestbook['reply']) ? $lang['guestbook_reply_1'] : $lang['absent']));
        $core->tpl->setVar('COMMENT', $guestbook['comment']);
        $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
        $core->tpl->end();
        $custom .= ob_get_contents();
        ob_end_clean();
    }
}