<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfig('guestbook');
global $config, $core, $db, $lang, $page, $guestbook_conf;
switch ($url[1] ?? null) {
    default:
        set_title(array($lang['guestbook']));
        if (!empty($guestbook_conf['keywords'])) $core->tpl->keywords = $guestbook_conf['keywords'];
        if (!empty($guestbook_conf['description'])) $core->tpl->description = $guestbook_conf['description'];
        $where = '';
        $file = 'index';
        $link = '';
        $query = $core->select_data('guestbook', 'active = 1', 'id DESC LIMIT ' . $core->site_limit_page($guestbook_conf, $guestbook_conf['comments_num']));
        if ($db->numRows($query) > 0) {
            $core->tpl->open('g_up');
            $core->tpl->loadFile('guestbook/g_up');
            $core->tpl->end();
            $core->tpl->close();
            while ($guestbook = $db->getRow($query)) {
                if (isset($guestbook['uid'])) {
                    $user_info = $core->row_data('users', 'id ="' . $guestbook['uid'] . '"');
                }
                $text = isset($guestbook['comment']) ? decoder('d', $guestbook['comment']) : '';
                $reply = isset($guestbook['reply']) ? decoder('d', $guestbook['reply']) : '';
                $replys = decoder('d', $guestbook['reply']);
                $core->tpl->loadFile('guestbook/guestbook_view');
                $core->tpl->setVar('ID', $guestbook['id']);
                $core->tpl->setVar('AVATAR', (empty($guestbook['uid']) ? 'media/avatar/' . (($guestbook['gender'] == 1) ? 'male.jpg' : 'female.jpg') : avatar($user_info['id'] ?? '')));
                $core->tpl->setVar('AUTHOR', (empty($guestbook['uid']) ? $guestbook['name'] : $user_info['nick'] ?? ''));
                $core->tpl->setVar('EMAIL', (empty($guestbook['uid']) ? $guestbook['email'] : $user_info['email'] ?? ''));
                $core->tpl->setVar('DATE', formatDate($guestbook['date'], true));
                $core->tpl->setVar('WEBSITE', (!empty($guestbook['website']) ? $guestbook['website'] : $lang['absent']));
                $core->tpl->setVar('REPLY', $replys);
                $core->tpl->setVar('REPLY_FLAG', (!empty($guestbook['reply']) ? $lang['guestbook_reply_1'] : $lang['absent']));
                $core->tpl->setVar('COMMENT', $text);
                $core->tpl->setVar('ONLINE', ($core->isOnline($user_info['id'] ?? '') ? $lang['online'] : formatDate($user_info['last_visit'] ?? '', true)));
                $core->tpl->setVar('OFFLINE', ($core->isOffline($user_info['id'] ?? '') ? $lang['offline'] : formatDate($user_info['last_visit'] ?? '', true)));
                $core->tpl->setVar('REPLY_SEND', ($core->auth->isModer || $core->auth->isAdmin) ? '<span id="msgNo' . $guestbook['id'] . '"><a href="javascript://" onclick="ajaxSimple(\'index.php?url=guestbook/into_basket/' . $guestbook['id'] . '/\', \'msgNo' . $guestbook['id'] . '\', true)">' . $lang['delete'] . '</a></span> <a href="guestbook/letter/' . $guestbook['id'] . '">' . $lang['guestbook_replys'] . '</a> ' : '');
                $core->tpl->setVar('REPLY_DEL', ($core->auth->isModer || $core->auth->isAdmin) ? '<span id="msgNo' . $guestbook['id'] . '"><a href="javascript://" onclick="ajaxSimple(\'index.php?url=guestbook/into_basket/' . $guestbook['id'] . '/\', \'msgNo' . $guestbook['id'] . '\', true)">' . $lang['delete'] . '</a></span>' : '');
                $core->tpl->sources = preg_replace_callback("#\\[online\\](.*?)\\[/online\\]#is", function ($matches) use ($user_info) {
                    if ($user_info['last_visit'] + 500 >= time()) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[offline\\](.*?)\\[/offline\\]#is", function ($matches) use ($core, $user_info) {
                    if ($core->isOffline($user_info['id'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[reply\\](.*?)\\[/reply\\]#is", function ($matches) use ($guestbook) {
                    if (!empty($guestbook['reply'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[not_reply\\](.*?)\\[/not_reply\\]#is", function ($matches) use ($guestbook) {
                    if (empty($guestbook['reply'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("@\\[status\=0\\](.*?)\\[else\\](.*?)\\[/status\\]@is", function ($matches) use ($guestbook) {
                    if (!$guestbook['reply']) return $matches[1]; else return $matches[2];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("@\\[user_check\=0\\](.*?)\\[else\\](.*?)\\[/user_check\\]@is", function ($matches) use ($user_info) {
                    if (!$user_info['nick']) return $matches[1]; else return $matches[2];
                }, $core->tpl->sources);
                $core->tpl->end();
                if ($guestbook_conf['del_time'] && $guestbook['del_time'] <= time()) $core->del_data('guestbook', 'active = 3');
            }
            $core->tpl->open('g_down');
            $core->tpl->loadFile('guestbook/g_down');
            $core->tpl->end();
            $core->tpl->close();
            $core->site_page_list('guestbook', 'guestbook', 'active = 1', $guestbook_conf['comments_num']);
        } else {
            if (isset($core->auth->user_info['nick']) && $guestbook_conf['commentModeration'] == 1 && ($core->auth->user_info['group'] != $guestbook_conf['commentModeration'])) {
                $core->tpl->info($lang['guestbook_moderation']);
            } else {
                $core->tpl->info($lang['guestbook_null']);
            }
        }
        $core->tpl->open('guestbook_entry');
        $core->tpl->loadFile('guestbook/guestbook_entry');
        $core->tpl->setVar('UID', ($core->auth->isUser ? $core->auth->user_info['id'] : ''));
        $core->tpl->setVar('UNAME', ($core->auth->isUser ? $core->auth->user_info['nick'] : ''));
        $core->tpl->setVar('CAPTCHA', captcha_image());
        $core->tpl->end();
        $core->tpl->close();
        break;
    case 'into_basket':
        ajaxInit();
        $no_head = true;
        $del_day = $guestbook_conf['del_time_num'] * 86400;
        $d = intval(log10(abs(time() / $del_day)) / 3);
        $del_time = time() + $d;
        if (!empty($url[2])) {
            $core->upd_data('guestbook', '`active` = 3, `del_time` ="' . $del_time . '"', 'id ="' . $db->safesql($url[2]) . '"');
            $core->tpl->info(colorSpan('red', 'Сообщение удалено ') . '<span id="msgNo' . $db->safesql($url[2]) . '"><a href="javascript://" onclick="ajaxSimple(\'index.php?url=guestbook/into_return/' . $db->safesql($url[2]) . '/\', \'msgNo' . $db->safesql($url[2]) . '\', true)">' . colorSpan('green', 'Восстановить ') . '</a></span>');
            header("refresh: 10; url=" . $config['url'] . "/guestbook/into_delete" . $db->safesql($url[2]));
        }
        break;
    case 'into_delete':
        ajaxInit();
        $no_head = true;
        if (!empty($url[2])) {
            $core->del_data('guestbook', 'id ="' . $db->safesql($url[2]) . '"');
            $core->tpl->info(colorSpan('red', 'Сообщение удалено ! '));
            header("refresh: 0; url=" . $config['url'] . "/guestbook");
        }
        break;
    case 'into_return':
        ajaxInit();
        $no_head = true;
        if (!empty($url[2])) {
            $core->upd_data('guestbook', '`active` = 1,`del_time` =""', 'id ="' . $db->safesql($url[2]) . '"');
            $core->tpl->info(colorSpan('green', '<b>Сообщение восстановлено</b>'));
            header("refresh: 0; url=" . $config['url'] . "/guestbook");
        }
        break;
    case 'letter':
        set_title(array($lang['pmprivate'], $lang['write']));
        $core->tpl->open('guestbook_entry');
        $core->tpl->loadFile('guestbook/guestbook_entry');
        $core->tpl->setVar('ID', $url[2] ?? '');
        $core->tpl->setVar('UID', ($core->auth->isUser ? $core->auth->user_info['id'] : ''));
        $core->tpl->setVar('UNAME', ($core->auth->isUser ? $core->auth->user_info['nick'] : ''));
        $core->tpl->setVar('CAPTCHA', captcha_image());
        $core->tpl->end();
        $core->tpl->close();
        break;
    case 'send':
        set_title(array($lang['guestbook'], $lang['guestbook_sendingmess']));
        $uid = isset($_POST['uid']) ? intval($_POST['uid']) : 0;
        $reply_id = isset($_POST['reply_id']) ? intval($_POST['reply_id']) : '';
        $message = isset($_POST['message']) ? parseBB(processText(filter($_POST['message'], 'html'))) : '';
        if (captcha_check('securityCode')) {
            if (!$reply_id) {
                if (empty($uid)) {
                    $website = isset($_POST['site']) ? filter($_POST['site']) : '';
                    $gender = isset($_POST['gender']) ? intval($_POST['gender']) : '1';
                    $email = isset($_POST['email']) ? filter($_POST['email']) : '';
                    $name = isset($_POST['name']) ? filter($_POST['name']) : '';
                    if (!empty($name) && !empty($message)) {
                        $core->ins_data('guestbook', 'id,uid,date,name,email,website,gender,comment,reply,active,del_time', 'NULL,"' . $uid . '","' . time() . '","' . $name . '","' . $email . '","' . $website . '","' . $gender . '","' . $message . '","",2,""');
                        $core->tpl->info($lang['guestbook_sendok']);
                    } else {
                        $core->tpl->info($lang['guestbook_sendfalse'], 'warning');
                    }
                } else {
                    if ($uid == $core->auth->user_info['id']) {
                        $name = $core->auth->user_info['nick'];
                        $email = $core->auth->user_info['email'];
                        if (!empty($name) && !empty($message)) {
                            if ($guestbook_conf['commentModeration'] == 1 && ($core->auth->user_info['group'] != $guestbook_conf['commentModeration'])) {
                                $core->ins_data('guestbook', 'id,uid,date,name,email,website,gender,comment,reply,active,del_time', 'NULL,"' . $uid . '","' . time() . '","' . $name . '","' . $email . '","","","' . $message . '","",2,""');
                                $core->tpl->info($lang['guestbook_moderation_1']);
                            } else {
                                $core->ins_data('guestbook', 'id,uid,date,name,email,website,gender,comment,reply,active,del_time', 'NULL,"' . $uid . '","' . time() . '","' . $name . '","' . $email . '","","","' . $message . '","",1,""');
                                $core->tpl->info($lang['guestbook_sendok']);
                            }
                            header("refresh: 5; url=" . $config['url'] . "/guestbook");
                        } else {
                            $core->tpl->info($lang['guestbook_sendfalse'], 'warning');
                        }
                    } else {
                        $core->tpl->info($lang['guestbook_sendfalse_0'], 'warning');
                    }
                }
            } else {
                if ($guestbook_conf['reply_mail'] == 1) {
                    $message = str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '&lt;', '&gt;'), array('""', '""', '""', '\n', '\n', '\n', '<', '>'), $message);
                    mailSMTP($config['support_mail'], $message, $lang['guestbook_reply_text'] . $config['name'], parseBB(processText($message)) . '<br/>' . $config['url'] . '/guestbook');
                }
                $core->upd_data('guestbook', '`reply` ="' . $db->safesql(parseBB(processText($message), $reply_id, true)) . '"', 'id ="' . $reply_id . '"');
                $core->tpl->info($lang['guestbook_reply_add']);
                header("refresh: 5; url=" . $config['url'] . "/guestbook");
            }
        } else {
            $core->tpl->info($lang['guestbook_captchafalse'], 'warning');
        }
        break;
}