<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
require_once ROOT . 'etc/help.config.php';
global $core, $url, $core, $db, $help_conf, $lang;
$mod = $url[0];
switch (isset($url[1]) ? $url[1] : null) {
    default:
        set_title(array($lang['faq']));
        menu();
        $order = (isset($_GET['rated']) ? 'replies' : 'time');
        $query = $core->select_data('help', false, $order . ' LIMIT ' . $core->site_limit_page($help_conf, $help_conf['num']), 'q.*, u.nick', 'AS q LEFT JOIN ' . DB_PREFIX . '_users AS u ON (q.uid = u.id)');
        if ($db->numRows($query) > 0) {
            while ($rows = $db->getRow($query)) {
                $id = $rows['id'];
                $row = $core->row_data('users');
                $replies = $core->row_data('help_replies', 'r.to="' . $rows['id'] . '"', false, 'r.*, u.nick', 'AS r LEFT JOIN ' . DB_PREFIX . '_users AS u ON (r.uid = u.id)');
                list($r_num) = $db->fetchRow($db->query("SELECT COUNT(*)  FROM" . DB_PREFIX ."_help_replies AS r LEFT JOIN" . DB_PREFIX ."_users AS u ON (r.uid = u.id) WHERE r.to = '" . $rows['id'] ."'"));
                $r_numb = declension($r_num, array($lang['answer1'], $lang['answer2'], $lang['answer3']));
                $rep_numb = ($r_num == 0) ? '' : $r_num;
                $core->tpl->loadFile('help/main');
                $core->tpl->setVar('AVATAR', avatar($rows['uid']));
                $core->tpl->setVar('NICK', $rows['nick']);
                $core->tpl->setVar('TIME', formatDate($rows['time'], true));
                $core->tpl->setVar('TITLE', $rows['title']);
                $core->tpl->setVar('QUESTION', $rows['question']);
                $core->tpl->setVar('REPLIES', (!empty($rows['replies']) ? $replies['text'] : ''));
                $core->tpl->setVar('NUM_REPLIES', $rows['replies']);
                $core->tpl->setVar('REPLY_FLAG', (!empty($rep_numb) ? $lang['there'] . $r_numb . '!' : $lang['reply_0']));
                $core->tpl->setVar('ONLINE', ($core->isOnline($row['id']) ? $lang['online'] : formatDate($row['last_visit'], true)));
                $core->tpl->setVar('OFFLINE', ($core->isOffline($row['id']) ? $lang['offline'] : formatDate($row['last_visit'], true)));
                $core->tpl->setVar('EDIT', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '<a href="' . $mod . '/edit/' . $rows['id'] . '">' . $lang['edit'] . '</a>' : '');
                $core->tpl->setVar('DELETE', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '<a href="' . $mod . '/delete/' . $rows['id'] . '" onclick="return confirm(\'Уверены что хотите удалить вопрос?\');">' . $lang['delete'] . '</a>' : '');
                $core->tpl->setVar('D_URL', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '/' . $mod . '/delete/' . $rows['id'] . '"' : '');
                $core->tpl->setVar('E_URL', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '/' . $mod . '/edit/' . $rows['id'] . '"' : '');
                $core->tpl->sources = preg_replace_callback("#\\{%MORE%\\}(.*?)\\{/%MORE%\\}#is",
                    function ($matches) use ($mod, $id) {
                        if ($mod && $id) return format_link($matches[1], $mod . '/view/' . $id);
                    }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[online\\](.*?)\\[/online\\]#is", function ($matches) use ($row) {
                    if ($row['last_visit'] + 500 >= time()) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[offline\\](.*?)\\[/offline\\]#is", function ($matches) use ($core, $row) {
                    if ($core->isOffline($row['id'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[reply\\](.*?)\\[/reply\\]#is", function ($matches) use ($rows) {
                    if (!empty($rows['replies'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[not_reply\\](.*?)\\[/not_reply\\]#is", function ($matches) use ($rows) {
                    if (empty($rows['replies'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->end();
            }
        } else {
            $core->tpl->info($lang['question_list_empty']);
        }
        $core->site_page_list('help', 'help', false, $help_conf['num']);
        break;
    case 'view':
        $id = isset($url[2]) ? intval($url[2]) : '';
        $order = (isset($_GET['rated']) ? 'replies' : 'time');
        $query = $core->select_data('help', 'q.id ="' . $id . '"', $order . ' LIMIT ' . $core->site_limit_page($help_conf, $help_conf['num']), 'q.*, u.nick', 'AS q LEFT JOIN ' . DB_PREFIX . '_users AS u ON (q.uid = u.id)');
        if ($db->numRows($query) > 0) {
            $rows = $db->getRow($query);
            $id = $rows['id'];
            if (isset($rows['uid'])) {
                $user_info = $core->row_data('users', 'id ="' . $rows['uid'] . '"');
            }
            $replies = $core->row_data('help_replies', 'r.to="' . $rows['id'] . '"', $order, 'r.*, u.nick', 'AS r LEFT JOIN ' . DB_PREFIX . '_users AS u ON (r.uid = u.id)');
            list($r_num) = $db->fetchRow($db->query("SELECT COUNT(*)  FROM" . DB_PREFIX ."_help_replies AS r LEFT JOIN" . DB_PREFIX ."_users AS u ON (r.uid = u.id) WHERE r.to = '" . $rows['id'] ."'"));
            $r_numb = declension($r_num, array($lang['answer1'], $lang['answer2'], $lang['answer3']));
            $rep_numb = ($r_num == 0) ? '' : $r_num;
            set_title(array($lang['question'] . ': ' . $rows['title']));
            menu($rows['title']);
            $core->tpl->loadFile('help/view');
            $core->tpl->setVar('AVATAR', avatar($rows['uid']));
            $core->tpl->setVar('NICK', $rows['nick']);
            $core->tpl->setVar('TIME', formatDate($rows['time'], true));
            $core->tpl->setVar('TITLE', $rows['title']);
            $core->tpl->setVar('QUESTION', $rows['question']);
            $core->tpl->setVar('REPLIES', (!empty($rows['replies']) ? $replies['text'] : ''));
            $core->tpl->setVar('NUM_REPLIES', $rows['replies']);
            $core->tpl->setVar('REPLY_FLAG', (!empty($rep_numb) ? $lang['there'] . $r_numb . '!' : $lang['reply_0']));
            $core->tpl->setVar('ONLINE', ($core->isOnline($user_info['id']) ? $lang['online'] : formatDate($user_info['last_visit'], true)));
            $core->tpl->setVar('OFFLINE', ($core->isOffline($user_info['id']) ? $lang['offline'] : formatDate($user_info['last_visit'], true)));
            $core->tpl->setVar('EDIT', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '<a href="' . $mod . '/edit/' . $rows['id'] . '">' . $lang['edit'] . '</a>' : '');
            $core->tpl->setVar('DELETE', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '<a href="' . $mod . '/delete/' . $rows['id'] . '" onclick="return confirm(\'Уверены что хотите удалить вопрос?\');">' . $lang['delete'] . '</a>' : '');
            $core->tpl->setVar('D_URL', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '/' . $mod . '/delete/' . $rows['id'] . '"' : '');
            $core->tpl->setVar('E_URL', ($core->auth->isAdmin == true OR $core->auth->user_id == $rows['uid']) ? '/' . $mod . '/edit/' . $rows['id'] . '"' : '');
            $core->tpl->sources = preg_replace_callback("#\\{%MORE%\\}(.*?)\\{/%MORE%\\}#is",
                function ($matches) use ($mod, $id) {
                    if ($mod && $id) return format_link($matches[1], $mod . '/view/' . $id);
                }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[online\\](.*?)\\[/online\\]#is", function ($matches) use ($user_info) {
                if ($user_info['last_visit'] + 500 >= time()) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[offline\\](.*?)\\[/offline\\]#is", function ($matches) use ($core, $user_info) {
                if ($core->isOffline($user_info['id'])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[reply\\](.*?)\\[/reply\\]#is", function ($matches) use ($rows) {
                if (!empty($rows['replies'])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[not_reply\\](.*?)\\[/not_reply\\]#is", function ($matches) use ($rows) {
                if (empty($rows['replies'])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("@\\[status\=0\\](.*?)\\[else\\](.*?)\\[/status\\]@is", function ($matches) use ($rows) {
                if ($rows['replies'] == false) return $matches[1]; else return $matches[2];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("@\\[user_check\=0\\](.*?)\\[else\\](.*?)\\[/user_check\\]@is", function ($matches) use ($user_info) {
                if ($user_info['nick'] == false) return $matches[1]; else return $matches[2];
            }, $core->tpl->sources);
            $core->tpl->end();
            $query_reply = $db->query("SELECT r.*, u.nick FROM" . DB_PREFIX ."_help_replies AS r LEFT JOIN" . DB_PREFIX ."_users AS u ON (r.uid = u.id) WHERE r.to = '" . $id ."'");
            if ($db->numRows($query_reply) > 0) {
                while ($reply_row = $db->getRow($query_reply)) {
                    $core->tpl->loadFile('help/reply-body');
                    $core->tpl->setVar('AVATAR', avatar($reply_row['uid']));
                    $core->tpl->setVar('NICK', $reply_row['nick']);
                    $core->tpl->setVar('TIME', formatDate($reply_row['time'], true));
                    $core->tpl->setVar('REPLIES', (!empty($rows['replies']) ? $reply_row['text'] : ''));
                    $core->tpl->setVar('NUM_REPLIES', $rows['replies']);
                    $core->tpl->setVar('QUESTION', (!empty($rows['question']) ? $rows['question'] : ''));
                    $core->tpl->setVar('ONLINE', ($core->isOnline($user_info['id']) ? $lang['online'] : formatDate($user_info['last_visit'], true)));
                    $core->tpl->setVar('OFFLINE', ($core->isOffline($user_info['id']) ? $lang['offline'] : formatDate($user_info['last_visit'], true)));
                    $core->tpl->sources = preg_replace_callback("#\\{%MORE%\\}(.*?)\\{/%MORE%\\}#is",
                        function ($matches) use ($mod, $id) {
                            if ($mod && $id) return format_link($matches[1], $mod . '/view/' . $id);
                        }, $core->tpl->sources);
                    $core->tpl->sources = preg_replace_callback("#\\[online\\](.*?)\\[/online\\]#is", function ($matches) use ($user_info) {
                        if ($user_info['last_visit'] + 500 >= time()) return $matches[1];
                    }, $core->tpl->sources);
                    $core->tpl->sources = preg_replace_callback("#\\[offline\\](.*?)\\[/offline\\]#is", function ($matches) use ($core, $user_info) {
                        if ($core->isOffline($user_info['id'])) return $matches[1];
                    }, $core->tpl->sources);
                    $core->tpl->sources = preg_replace_callback("#\\[reply\\](.*?)\\[/reply\\]#is", function ($matches) use ($rows) {
                        if (!empty($rows['replies'])) return $matches[1];
                    }, $core->tpl->sources);
                    $core->tpl->end();
                }
            } else {
                $noRepl = true;
            }
            if ($core->auth->isUser) {
                if (isset($noRepl)) {
                    $core->tpl->info($lang['user_help']);
                }
                $core->tpl->open();
                $core->tpl->loadFile('help/reply');
                $core->tpl->setVar('ID', $rows['id']);
                $core->tpl->setVar('CAPTCHA', captcha_image());
                $core->tpl->end();
                $core->tpl->close();
            } else {
                $core->tpl->info($lang['user_auth_answer']);
            }
        } else {
            header('refresh: 5; url="/help/');
        }
        break;
    case 'add':
        menu('');
        set_title(array($lang['faq'], $lang['add_question']));
        if ($core->auth->isUser) {
            $core->tpl->open();
            $core->tpl->loadFile('help/add');
            $core->tpl->setVar('CAPTCHA', captcha_image());
            $core->tpl->end();
            $core->tpl->close();
        } else {
            $core->tpl->info($lang['user_auth_question']);
        }
        break;
    case 'send':
        menu('');
        set_title(array($lang['faq'], $lang['sending']));
        if ($core->auth->isUser) {
            $title = !empty($_POST['title']) ? filter($_POST['title'], 'title') : '';
            $question = !empty($_POST['question']) ? filter($_POST['question']) : '';
            if (!empty($question) && !empty($title)) {
                $core->ins_data('help', 'id,title,question,uid,time,replies,lock', 'NULL,"' . $title . '","' . $question . '","' . $core->auth->user_id . '","' . time() . '", 0, 0');
                $core->tpl->info($lang['question_added']);
                header('refresh: 5; url="/help/');
            } else {
                $core->tpl->info($lang['form_error'] . ' <a href="javascript:history.back()" onclick="/' . $mod . '" >' . $lang['back'] . '</a>');
            }
        } else {
            $core->tpl->info($lang['user_auth_question']);
        }
        break;
    case 'reply':
        menu('');
        set_title(array($lang['faq'], $lang['answer']));
        if ($core->auth->isUser) {
            $id = intval($_POST['rid']);
            $reply = filter($_POST['reply'], 'a');
            if ($core->sum_data('help') > 0) {
                if (empty($reply)) {
                    $core->tpl->info($lang['answer_error'] . ' <a href="' . $mod . '/view/' . $id . '">' . $lang['back'] . '</a>.');
                } else {
                    $core->upd_data('help', 'replies = replies + 1', 'id ="' . $id . '"');
                    $core->ins_data('help_replies', 'rid,to,text,time,uid', 'NULL,"' . $id . '","' . $reply . '","' . time() . '","' . $core->auth->user_id . '"');
                    $core->tpl->info($lang['answer_added'] . ' <a href="' . $mod . '/view/' . $id . '">' . $lang['back'] . '</a>.');
                    header('refresh: 5; url="/help/');
                }
            } else {
                header('refresh: 5; url="/help/');
            }
        } else {
            $core->tpl->info($lang['user_auth_question']);
        }
        break;
    case 'delete':
        $id = intval($url[2]);
        set_title(array($lang['faq'], $lang['remove']));
        if ($core->auth->isUser) {
            $query = $core->select_data('help', 'id ="' . $id . '"', false, 'uid');
            list($uid) = $core->fetch_data('help', 'id ="' . $id . '"', 'uid');
            if ($db->numRows($query) == 1) {
                if ($core->auth->isAdmin OR $core->auth->user_id == $uid) {
                    menu('');
                    $core->del_data('help', 'id ="' . $id . '"');
                    $core->del_data('help_replies', '`to` ="' . $id . '"');
                    $core->tpl->info($lang['remove_success']);
                    header('refresh: 5; url="/help/');
                }
            } else {
                header('refresh: 5; url="/help/');
            }
        } else {
            header('refresh: 5; url="/help/');
        }
        break;
    case 'edit':
        $id = isset($_POST['id']) ? intval($_POST['id']) : intval($url[2]);
        if ($core->auth->isUser) {
            $query = $core->select_data('help', 'id ="' . $id . '"');
            if ($db->numRows($query) == 1) {
                $rows = $db->getRow($query);
                if ($core->auth->isAdmin OR $core->auth->user_id == $rows['uid']) {
                    menu('');
                    set_title(array($lang['faq'], $lang['editing']));
                    if (isset($_POST['title'])) {
                        $title = !empty($_POST['title']) ? filter($_POST['title']) : '';
                        $question = !empty($_POST['question']) ? filter($_POST['question']) : '';
                        if (!empty($question) && !empty($title)) {
                            $core->upd_data('help', 'title ="' . $db->safesql($title) . '", question ="' . $db->safesql($question) . '"', 'id ="' . $id . '"');
                            $core->tpl->info($lang['question_updated'] . ' <a href="' . $mod . '/view/' . $id . '">' . $lang['back'] . '</a>');
                        } else {
                            $core->tpl->info($lang['subject_error'] . ' <a href="' . $mod . '/edit/' . $id . '">' . $lang['back'] . '</a>');
                        }
                    } else {
                        $core->tpl->open();
                        $core->tpl->loadFile('help/edit');
                        $core->tpl->setVar('ID', $rows['id']);
                        $core->tpl->setVar('TITLE', $rows['title']);
                        $core->tpl->setVar('QUESTION', $rows['question']);
                        $core->tpl->setVar('CAPTCHA', captcha_image());
                        $core->tpl->end();
                        $core->tpl->close();
                    }
                }
            } else {
                header('refresh: 5; url="/help/');
            }
        } else {
            header('refresh: 5; url="/help/');
        }
        break;
}
function menu()
{
    global $url, $core;
    $mod = $url[0];
    $core->tpl->open('menu');
    $core->tpl->loadFile('help/menu');
    $core->tpl->end();
}