<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $db, $config, $core, $includ_chart_conf, $lang;
loadConfig('includ_chart');
loadLang('includ_chart');
switch (isset($url[1]) ? $url[1] : null) {
    default:
        global $db, $config, $core;
        $external = isset($_SERVER['REMOTE_ADDR']) ? getenv('HTTP_X_FORWARDED_FOR') : false;
        $strdir = isset($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : false;
        $redirs = str_replace(array('url='), array($config['url'] . '/'), $strdir);
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : false;
        $ips = $core->row_data('counter_ip', 'redir ="' . $redirs . '"');
        $error = $_SERVER['QUERY_STRING'] == 'url=404.php' ? 1 : 0;
        $rows = $core->row_data('counter_ip');
        if (isset($rows['id']) && ($rows['redir'] == false || $rows['time'] == false)) $core->del_data('counter_ip');
        $ips = $core->row_data('counter_ip', 'redir ="' . $redirs . '"');
        if (isset($redirs)) {
            if (isset($ips['redir']) && $redirs != false && $redirs != '') {
                if (time() - $ips['time'] < 86400) {
                    if ($redirs <> $ips['redir']) {
                        $core->ins_data('counter_ip', false, 'NULL,"' . $redirs . '", 1,"' . time() . '","' . $error . '"');
                    } else {
                        $core->upd_data('counter_ip', 'clicks = clicks + 1, time ="' . time() . '", error ="' . $error . '"', 'id ="' . $ips['id'] . '"');
                    }
                } else {
                    $core->ins_data('counter_ip', false, 'NULL,"' . $redirs . '", 1,"' . time() . '","' . $error . '"');
                }
            } else {
                if ($redirs != false && $redirs != '') $core->ins_data('counter_ip', false, 'NULL,"' . $redirs . '", 1,"' . time() . '","' . $error . '"');
            }
        }
        $check_date = $core->row_data('counter_stat', 'user ="' . md5($external) . '" AND date ="' . date('d.m.Y') . '"');
        if ($check_date <> null) {
            $core->upd_data('counter_stat', 'views = views + 1', 'user="' . md5($external) . '" AND date="' . date('d.m.Y') . '"');
        } else {
            $core->ins_data('counter_stat', false, 'NULL,"' . date('d.m.Y') . '","' . time() . '","' . md5($external) . '", 1', 'IGNORE');
        }
        break;
    case 'counter':
        global $db, $config, $core, $includ_chart_conf, $lang;
        set_title(array($lang['counter_visits'] . $lang['counter_visits']));
        $array_day = array();
        $array_views = array();
        $array_people = array();
        $array_all = array();
        $array_date = array();
        $final_array = array();
        $date_del = $includ_chart_conf['time'];
        $del_time = $core->row_data('counter_stat');
        $d_time = $del_time['del_date'] + $date_del;
        $core->del_data('counter_stat', 'del_date ="' . $d_time . '"');
        $get_info_stats = $core->select_data('counter_stat', 'date >="' . date('d.m.Y') . '"', 'date DESC');
        while ($row = $db->getRow($get_info_stats)) {
            $array_date[] = $row["date"];
            $array_all[] = $row;
        }
        $new_array_date = array_unique($array_date);
        foreach ($new_array_date as $key_date) {
            $i = 0;
            $sum = 0;
            foreach ($array_all as $key_all) {
                if ($key_date == $key_all["date"]) {
                    $sum = $sum + $key_all["views"];
                    $i++;
                }
            }
            $final_array[] = array($key_date, $i, $sum);
        }
        function sort_date($a_new, $b_new)
        {
            $a_new = strtotime($a_new[0]);
            $b_new = strtotime($b_new[0]);
            return $a_new - $b_new;
        }

        usort($final_array, "sort_date");
        foreach ($final_array as $rows) {
            $name_date = $rows[0] == date('d . m . Y') ? $lang['ctodays'] : substr($rows[0], 0, -5);
            $array_day = "'" . $name_date . "',";
            $array_views = $rows[2];
            $array_people = $rows[1];
        }
        $core->tpl->loadFile('counter');
        $core->tpl->setVar('counter_date', date('d . m . Y', time()));
        $core->tpl->setVar('counter_views', $array_views);
        $core->tpl->setVar('counter_people', $array_people);
        $core->tpl->end();
        break;
}