<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_SWITCH')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $url, $core, $news_conf, $lang;
require(ROOT . 'etc/news.config.php');
switch ($url[3] ?? null) {
    default:
        news_main();
        break;
    case 'tags':
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        UniClass('selectList');
        $where = 'WHERE `module` ="news"';
        $s_tag = isset($_POST['s_tag']) ? filter($_POST['s_tag'], 'a') : '';
        $s_search = isset($_POST['s_search']) ? 1 : 0;
        if ($s_search) {
            if ($_POST['s_search'] == 1) {
                location(ADMIN . '/module/news/tag/' . $s_tag);
            } else {
                $s_search = false;
            }
        } else {
            $s_search = true;
        }
        if ($s_tag) $where .= 'AND `tag` LIKE"%' . $db->safesql($s_tag) . '%"';
        $query = $core->select_data('tags', $where, 'id DESC LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['modules'] . ' | ' . $lang['news_tags']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('tags');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['news_tags_list'] . '</span>
            <div class="widget-menu pull-right">
               <div class="btn-group popup-basic admin-form">
                  <button onclick="modal_o(\'#modal-form-add\')" type="button" class="btn btn-system btn-sm btn-raised legitRipple">' . $lang['news_tags_add'] . '</button>
               </div>
            </div>
         </div>
        <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-9 text-left">' . $lang['title'] . '</th>
                        <th class="text-center">' . faSpan('fa-newspaper-o', true, false, false, $lang['news_tags_numb']) . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($tag = $db->getRow($query)) {
                $tags[] = $tag['tag'];
            }
            $tag_cloud = new TagsCloud;
            $tag_cloud->tags = $tags;
            $cloud = array();
            $tags_list = $tag_cloud->tags_cloud($tag_cloud->tags);
            $min_count = $tag_cloud->get_min_count($tags_list);
            foreach ($tags_list as $tag => $count) {
                echo '<tr>
                        <td class="text-center"><span class="pd-l-sm"></span></td>
                        <td></td>
                        <td class="text-left">' . $tag . '</td>
                        <td class="text-center">' . $count . '</td>';
                init_checkbox('td', $tag, false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $tag . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
                modal_form_delete($tag, $tag, $lang['news_tags_delete_title'], 'tag', $lang['news_tags_delete_text'], '{MOD_LINK}/tagDelete/' . $tag);
            }
            echo '</tbody>
                  <tfoot class="footer-menu">
                     <tr>
                        <td colspan="9">
                           <nav class="text-right">
                              <button name="submit" type="submit" id="sub" value="delete" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>
                           </nav>
                        </td>
                     </tr>
                  </tfoot>
               </table>
            </form>
         </div>
      </div>';
            page_list('urs', 'news', 'tags', $where, 'tags');
        } else {
            list_empty('root', 'news_tags', 'modal', $s_search, false, true);
        }
        modal_form_add('add', $lang['news_tags_add'], 'fa-tags', 'tag', $lang['news_tags_name'], '{MOD_LINK}/addTag');
        echo '</div>
   <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
              <label for="s_tag" class="field prepend-icon">
               <input id="s_tag" type="text" name="s_tag" placeholder="' . $lang['title'] . '" class="form-control" value="' . $s_tag . '">
               <label for="s_tag" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_search" value="0">
               <input type="checkbox" name="s_search" ' . ($s_search ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news_for_search'] . '</label>
            </div>
             ' . init_sfoot(true, true, 'tags', '{MOD_LINK}') . '
         </div>
      </form>
   </aside>
</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'addTag':
        if (!empty($_POST['tag'])) {
            $core->ins_data('tags', 'id,tag,module', 'NULL,"' . $db->safesql($_POST['tag']) . '","news"');
            action_alert('urs', 'success', 'news', 'tags', 'news_tags_add_ok');
        } else {
            action_alert('urs', 'danger', 'news', 'tags', 'news_tags_add_error');
        }
        break;
    case 'tagDelete':
        if (isset($url[4])) {
            $tag = filter(utf_decode($url[4]));
            $core->del_data('tags', 'tag ="' . $tag . '"');
            action_alert('urs', 'success', 'news', 'tags', 'news_tags_delete_ok');
        } else {
            action_alert('urs', 'danger', 'news', 'tags', 'news_tags_delete_error');
        }
        break;
    case 'actionTag':
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        $core->del_data('tags', 'tag ="' . $id . '"');
                        action_alert('urs', 'success', 'news', 'tags');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('urs', 'danger', 'news', 'tags');
        }
        break;
    case 'add':
        news_add();
        break;
    case 'save':
        news_save();
        break;
    case 'edit':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        news_add($id);
        break;
    case 'tags_add':
        init_count_text();
        $adminTpl->admin_head($lang['modules'] . ' | ' . $lang['news_tags']);
        echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">
<div class="panel panel-dark panel-border top">
<div class="panel-heading">
   <span class="panel-title">' . $lang['news_tags'] . '</span>
</div>
<div class="heading-hr"></div>
<div class="panel-body">
   <form class="form-horizontal parsley-form" role="form" action="{MOD_LINK}/addTag" method="post" data-parsley-validate>
      <div class="form-group admin-form">
         <label class="col-sm-3 control-label">' . $lang['news_tags_name'] . '</label>
         <div class="col-lg-5 col-md-5 col-sm-8">
            <label for="tag" class="field prepend-icon">
            <input id="tag" type="text" name="tag" value="" placeholder="' . $lang['news_tags_name_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
            <label for="tag" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
            </label>
         </div>
      </div>
</div>
<div class="panel-footer">
<button name="submit" type="submit" id="sub" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'xfields_add':
        location(ADMIN . '/xfields/add/');
        break;
    case 'delete':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        delete($id);
        if (isset($_GET['moderate'])) {
            location(ADMIN . '/moderation/mod/news');
        } else {
            action_alert('urs', 'success', 'news');
        }
        break;
    case 'retivate':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $active = $rows['active'] == 0 || $rows['active'] == 2 ? 1 : 0;
            $core->upd_data('news', 'active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_news'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'cats':
        $cat_id = isset($url[4]) ? ',' . $url[4] . ',' : 0;
        $id = isset($url[5]) ? intval($url[5]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $active = $rows['active'] == 0 || $rows['active'] == 2 ? 1 : 0;
            $core->upd_data('news', 'cat ="' . $cat_id . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_news'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'index':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $allow_index = $rows['allow_index'] == 0 ? 1 : 0;
            $core->upd_data('news', 'allow_index ="' . $allow_index . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_news'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'inrating':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $allow_rating = $rows['allow_rating'] == 0 ? 1 : 0;
            $core->upd_data('news', 'allow_rating ="' . $allow_rating . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_news'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'fix':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $fixed = $rows['fixed'] == 0 ? 1 : 0;
            $core->upd_data('news', 'fixed ="' . $fixed . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_news'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'cleanccomm':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $core->upd_data('news', 'comments = 0', 'id ="' . $id . '"');
            $core->del_data('comments', 'post_id ="' . $id . '" AND module ="news"');
            $core->ins_log(false, $lang['logs_change_clearcounter_news_comm'], 1, false, false, $rows['description'], false);
            if (isset($_GET['moderate'])) {
                location(ADMIN . '/moderation/mod/news');
            } else {
                action_alert('urs', 'success', 'news');
            }
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'cleancounter':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $core->upd_data('news', 'views = 0', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_clearcounter_news_views'], 1, false, false, $row['title'], false);
            if (isset($_GET['moderate'])) {
                location(ADMIN . '/moderation/mod/news');
            } else {
                action_alert('urs', 'success', 'news');
            }
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'activate':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $core->upd_data('news', 'active = 1', 'id ="' . $id . '"');
            $core->upd_data('users', 'user_news = user_news+1', 'nick ="' . $rows['author'] . '"');
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'moderation':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $row = $core->row_data('langs', 'postid ="' . $id . '"');
            $core->upd_data('news', 'active = 2', 'id ="' . $id . '"');
            $core->upd_data('users', 'user_news = user_news-1', 'nick ="' . $rows['author'] . '"');
            $core->ins_log(false, $lang['logs_change_moderation_news'], 1, false, false, $row['title'], false);
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'moder_moderation':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        $rows = $core->row_data('news', 'id ="' . $id . '"');
        $core->upd_data('news', 'active = 1', 'id ="' . $id . '"');
        $core->upd_data('users', 'user_news = user_news+1', 'nick ="' . $rows['author'] . '"');
        location(ADMIN . '/moderation/mod/news');
        break;
    case 'deactivate':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('news', 'id ="' . $id . '"');
            $core->upd_data('news', 'active = 0', 'id ="' . $id . '"');
            $core->upd_data('users', 'user_news = user_news-1', 'nick ="' . $rows['author'] . '"');
            action_alert('urs', 'success', 'news');
        } else {
            action_alert('urs', 'danger', 'news', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'active = 1', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'active = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'active = NOT `active`', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'nowDate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'date ="' . time() . '"', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'blockIndex':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'allow_index = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'setIndex':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'allow_index = 1', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'blockComment':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'allow_comments = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'allowComment':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'allow_comments = 1', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'blockRating':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'allow_rating = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'allowRating':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'allow_rating = 1', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'cleancounter':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('news', 'views = 0', 'id ="' . intval($id) . '"');
                        action_alert('urs', 'success', 'news');
                    }
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        delete(intval($id));
                        action_alert('urs', 'success', 'news');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('urs', 'danger', 'news');
        }
        if (isset($_GET['moderate'])) {
            location(ADMIN . '/moderation/mod/news');
        } else {
            location(ADMIN . '/module/news');
        }
        break;
    case 'ajax':
        global $adminTpl, $core, $url, $db;
        ajaxInit();
        $status = $url[1] == 'module';
        $module = $status ? $url[2] : $url[1];
        $type = $status ? $url[4] : $url[3];
        $count = $status ? $url[5] : $url[4];
        $id = $status ? $url[6] : $url[5];
        $u7 = $url[7] ?? '';
        $where = $status ? ' WHERE ' . $u7 : ' WHERE ' . $url[6];
        $swhere = str_replace(array('WHERE'), array(''), $where);
        $rows = $core->row_data($module, $where);
        $counter = $count == 'core' ? $core->sum_data($module, $swhere) : $rows[$count];
        switch ($type) {
            case 'isurl':
                if (isset($_POST['translit'])) {
                    if (!preg_match("/^[a-zA-Z0-9_-]+$/", $_POST['translit'])) {
                        echo(json_encode($lang['news_add_url_err_2']));
                    } else {
                        $query = $core->select_data('news', 'altname ="' . $db->safesql($_POST['translit']) . '"');
                        $result = ($db->numRows($query) > 0) && ($url[5] != 'update') ? 'false' : 'true';
                    }
                }
                break;
            case 'date':
                echo formatDate($counter, true);
                break;
            case 'count':
                echo formatCounter($counter);
                break;
        }
        break;
    case 'config':
        init_count_text();
        require(ROOT . 'etc/news.config.php');
        init_count_text();
        $configBox = array(
            'news' => array(
                'varName' => 'news_conf',
                'title' => $lang['news_config'],
                'groups' => array(
                    'main' => array(
                        'title' => $lang['config_main'],
                        'vars' => array(
                            'num' => array(
                                'title' => $lang['news_config_main_numt'],
                                'description' => $lang['news_config_main_numd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'comments_num' => array(
                                'title' => $lang['news_config_main_comments_numt'],
                                'description' => $lang['news_config_main_comments_numd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'fullLink' => array(
                                'title' => $lang['news_config_main_fulllinkt'],
                                'description' => $lang['news_config_main_fulllinkd'],
                                'content' => radio("fullLink", $news_conf['fullLink']),
                            ),
                            'noModer' => array(
                                'title' => $lang['news_config_main_nomoder'],
                                'description' => $lang['news_config_main_nomoder_desc'],
                                'content' => changeuGroup('noModer'),
                            ),
                            'preModer' => array(
                                'title' => $lang['news_config_main_premodert'],
                                'description' => $lang['news_config_main_premoderd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'addNews' => array(
                                'title' => $lang['news_config_main_addnewst'],
                                'description' => $lang['news_config_main_addnewsd'],
                                'content' => radio("addNews", $news_conf['addNews']),
                            ),
                            'editNews' => array(
                                'title' => $lang['news_config_main_editnewst'],
                                'description' => $lang['news_config_main_editnewsd'],
                                'content' => radio("editNews", $news_conf['editNews']),
                            ),
                        )
                    ),
                    'related' => array(
                        'title' => $lang['news_config_related'],
                        'vars' => array(
                            'related' => array(
                                'title' => $lang['news_config_relatedt'],
                                'description' => $lang['news_config_relatedd'],
                                'content' => radio("related", $news_conf['related']),
                            ),
                            'related_news_img' => array(
                                'title' => $lang['news_config_related_imgt'],
                                'description' => $lang['news_config_related_imgd'],
                                'content' => radio("related_news_img", $news_conf['related_news_img']),
                            ),
                            'related_news_img_thumbs' => array(
                                'title' => $lang['news_config_related_thumbst'],
                                'description' => $lang['news_config_related_thumbsd'],
                                'content' => radio("related_news_img_thumbs", $news_conf['related_news_img_thumbs']),
                            ),
                            'related_news_img_height' => array(
                                'title' => $lang['news_config_related_heightt'],
                                'description' => $lang['news_config_related_heightd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'related_news_img_widtht' => array(
                                'title' => $lang['news_config_related_widthtt'],
                                'description' => $lang['news_config_related_widthtd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'related_news' => array(
                                'title' => $lang['news_config_main_relatedt'],
                                'description' => $lang['news_config_main_relatedd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'bookmarks' => array(
                        'title' => $lang['news_config_bookmarks'],
                        'vars' => array(
                            'bookmarks' => array(
                                'title' => $lang['news_config_main_bookmarkst'],
                                'description' => $lang['news_config_main_bookmarksd'],
                                'content' => radio("bookmarks", $news_conf['bookmarks']),
                            ),
                            'numbookmarks' => array(
                                'title' => $lang['news_config_numbookmarks'],
                                'description' => $lang['news_config_numbookmarksd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'bookmarks_block' => array(
                                'title' => $lang['news_config_main_bookmarks_blockt'],
                                'description' => $lang['news_config_main_bookmarks_blockd'],
                                'content' => radio("bookmarks_block", $news_conf['bookmarks_block']),
                            ),
                            'bookmarks_news_img_height' => array(
                                'title' => $lang['news_config_bookmarks_heightt'],
                                'description' => $lang['news_config_bookmarks_heightd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'bookmarks_news_img_widtht' => array(
                                'title' => $lang['news_config_bookmarks_widthtt'],
                                'description' => $lang['news_config_bookmarks_widthtd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'bookmarks_num_block' => array(
                                'title' => $lang['news_config_numbookmarks_block'],
                                'description' => $lang['news_config_numbookmarksd_block'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'tags' => array(
                        'title' => $lang['news_config_tags'],
                        'vars' => array(
                            'tags' => array(
                                'title' => $lang['news_config_tags_tagst'],
                                'description' => $lang['news_config_tags_tagsd'],
                                'content' => radio("tags", $news_conf['tags']),
                            ),
                            'tags_num' => array(
                                'title' => $lang['news_config_tags_tags_numt'],
                                'description' => $lang['news_config_tags_tags_numd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'tagIll' => array(
                                'title' => $lang['news_config_tags_tagillt'],
                                'description' => $lang['news_config_tags_tagilld'],
                                'content' => radio("tagIll", $news_conf['tagIll']),
                            ),
                            'illFormat' => array(
                                'title' => $lang['news_config_tags_illformatt'],
                                'description' => $lang['news_config_tags_illformatd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'cats' => array(
                        'title' => $lang['news_config_cats'],
                        'vars' => array(
                            'showCat' => array(
                                'title' => $lang['news_config_cats_showcatt'],
                                'description' => $lang['news_config_cats_showcatd'],
                                'content' => radio("showCat", $news_conf['showCat']),
                            ),
                            'subLoad' => array(
                                'title' => $lang['news_config_cats_subloadt'],
                                'description' => $lang['news_config_cats_subloadd'],
                                'content' => radio("subLoad", $news_conf['subLoad']),
                            ),
                            'catCols' => array(
                                'title' => $lang['news_config_cats_catcolst'],
                                'description' => $lang['news_config_cats_catcolsd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'showBreadcumb' => array(
                                'title' => $lang['news_config_cats_showbreadcumbt'],
                                'description' => $lang['news_config_cats_showbreadcumbd'],
                                'content' => radio("showBreadcumb", $news_conf['showBreadcumb']),
                            ),
                        )
                    ),
                    'files' => array(
                        'title' => $lang['news_config_file'],
                        'vars' => array(
                            'fileEditor' => array(
                                'title' => $lang['news_config_file_feditort'],
                                'description' => $lang['news_config_file_feditord'],
                                'content' => radio("fileEditor", $news_conf['fileEditor']),
                            ),
                            'imgFormats' => array(
                                'title' => $lang['news_config_file_imgformatst'],
                                'description' => $lang['news_config_file_imgformatsd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'attachFormats' => array(
                                'title' => $lang['news_config_file_attachformatst'],
                                'description' => $lang['news_config_file_attachformatsd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'max_size' => array(
                                'title' => $lang['news_config_file_max_sizet'],
                                'description' => $lang['news_config_file_max_sized'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'thumb_width' => array(
                                'title' => $lang['news_config_file_thumb_widtht'],
                                'description' => $lang['news_config_file_thumb_widthd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'seo' => array(
                        'title' => $lang['seo'],
                        'vars' => array(
                            'keywords' => array(
                                'title' => $lang['seo_keywords'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'keywords'),
                            ),
                            'description' => array(
                                'title' => $lang['seo_description'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'description'),
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'news', '{MOD_LINK}/config', $ok);
        break;
}
function news_main()
{
    global $adminTpl, $core, $db, $admin_conf, $news_conf, $url, $lang;
    InitCheck();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $order = '';
    $cats_arr = $core->aCatList('news');
    $cats = (isset($url[3]) && $url[3] == 'cat') ? '/' . $url[4] : '';
    if (isset($url[3]) && $url[3] == 'cat') {
        if (isset($url[4])) {
            foreach ($cats_arr as $cid => $name) {
                if (in_array($cid, $cats_arr)) {
                    if ($cid == $url[4]) $where = '`cat` =",' . $cid . ',"';
                } else {
                    $where = '`cat` =",' . $url[4] . ',"';
                }
            }
        } else {
            $where = '`cat` =",' . $url[4] . ',"';
        }
    } else {
        $where = 'n.id != 0';
    }
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : ((isset($url[3]) && $url[3] == 'user_news') ? (isset($url[4]) ? $url[4] : '') : '');
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_tags = (isset($url[3]) ? $url[3] == 'tag' : '') ? $url[4] : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_cat = isset($_POST['s_cat']) ? intval($_POST['s_cat']) : '';
    $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
    $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
    $s_day = isset($_POST['s_day']) ? intval($_POST['s_day']) : '';
    $s_active = isset($_POST['s_active']) ? 1 : 0;
    $s_search = isset($_POST['s_search']) ? 1 : 0;
    $where .= (isset($url[3]) && $url[3] == 'users_news_delete') ? 'AND active = 3' : ($s_active ? ($_POST['s_active'] == 1 ? 'AND n.active = 1' : 'AND n.active = 0') : 'AND n.active != 2');
    $whereC = str_replace(array('n.'), array(''), $where);
    $where .= 'AND l.lang ="' . $core->InitLang() . '"';
    if ($s_day) $where .= 'AND n.`date`>="' . mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")) . '"';
    if ($s_id) $where .= 'AND n.`id` LIKE"%' . $db->safesql($s_id) . '%"';
    if (!$s_id) $s_id = '';
    if ($s_author || isset($url[3]) && $url[3] == 'user_news') $where .= 'AND n.`author` LIKE"%' . $db->safesql($s_author) . '%"';
    if ($s_title) $where .= 'AND l.`title` LIKE"%' . $db->safesql($s_title) . '%"';
    if ($s_tags) $where .= 'AND n.`tags` LIKE"%' . $db->safesql($s_tags) . '%"';
    if ($s_desc) $where .= 'AND l.`full` LIKE"%' . $db->safesql($s_desc) . '%"';
    if ($s_cat && ($s_cat !== ',0,')) $where .= 'AND n.`cat` =",' . $db->safesql($s_cat) . ',"';
    if ($startdate) $where .= 'AND n.`date` >="' . intval($startdate) . '"';
    if ($enddate) $where .= 'AND n.`date` <="' . intval($enddate) . '"';
    if (isset($url[3]) && $url[3] == 'order') {
        switch ($url[4]) {
            case 'abc':
                $order .= 'n.altname ASC';
                break;
            case 'last':
                $order .= 'n.date DESC';
                break;
            case 'id':
                $order .= 'n.id ASC';
                break;
        }
    } else {
        $order .= 'n.date DESC';
    }
    $query = $core->select_data('news', $where, $order . ' LIMIT ' . limit_page(), 'n.*, l.*, c.id as cid, c.name, c.altname as alturl', 'AS n LEFT JOIN ' . DB_PREFIX . '_categories AS c ON (n.cat=c.id) LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=n.id and l.module="news")');
    $adminTpl->admin_head($lang['news']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        onmoder('news', 'active', 'news_moder');
        alert_info('news');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . (isset($url[3]) && $url[3] == 'tag' ? str_replace(array('[tag]', '[num]'), array($s_tags, '(' . $core->sum_data('news', 'active != 2 AND `tags` LIKE"%' . $db->safesql($s_tags) . '%"') . ')'), $lang['news_search_tags']) : $lang['news_list']) . '</span>
            ' . sort_head('urs', 4, 'last') . '
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-6">' . $lang['titles'] . '</th>
                        <th class="text-center">' . faSpan('fa-comments-o', true, false, false, $lang['commentes']) . '</th>
                        <th class="text-center">' . faSpan('fa-eye', true, false, false, $lang['views']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($news = $db->getRow($query)) {
            $rel_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
            $patch = !$news_conf['related_news_img_thumbs'] ? 'files/news/' . $news['id'] . '/' : 'files/thumbs/files/news/' . $news['id'] . '/';
            $images = array();
            $dir = news_image($patch);
            $all_files = !empty($dir) ? scandir($dir) : null;
            if (!$all_files) initDir('news', $news['id']);
            for ($i = 0; $i < count_($all_files); $i++) {
                if (!str_contains($all_files[$i], ".png") and !str_contains($all_files[$i], ".jpg") and !str_contains($all_files[$i], ".gif")) continue;
                $images[] = $all_files[$i];
            }
            $dir = news_image($patch);
            $img_random = $images ? $images[rand(0, sizeof($images) - 1)] : 'media/cats/no_image.png';
            $img_src = $images ? $dir . $img_random : $img_random;
            $select_cat = '';
            foreach ($cats_arr as $cid => $name) {
                $select_cat = '<option value="{MOD_LINK}/cats/' . $cid . '/' . $news['id'] . '">' . $name . '</option>';
            };
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $news['id'] . '</td>
                        <td>
                           <div class="media media-list text-right"><a href="' . $rel_link . $news['altname'] . '.html"><img src="' . $img_src . '" class="img-responsive mw60 ib br4" alt=""></a></p></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto"><a href="' . $rel_link . $news['altname'] . '.html" target="_blank" data-toggle="tooltip" data-original-title="' . $news['title'] . '">' . trimtitle($news['title'], 50) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($news['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['cats'] . ': ' . ($news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'short', 3) : $lang['no']) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ':<a href="profile/' . $news['author'] . '"> ' . $news['author'] . ' </a></ol>
                        </td>';
            init_Ajax_count('urs', 'news', $news['id'], 'comments', 'id=' . $news['id']);
            init_Ajax_count('urs', 'news', $news['id'], 'views', 'id=' . $news['id']);
            echo '<td class="text-center">' . status_icon('news', $news['id'], 'news', $news['users_del_data']) . '</td>';
            init_checkbox('td', $news['id'], false, '<li><a href="' . $rel_link . $news['altname'] . '.html" target="_blank">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href ="{MOD_LINK}/edit/' . $news['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a>
                                      ' . faSpan('fa-list', false) . '
                                       <select style="display: inline-block;" class="bootstrap-select" onChange="if(this.options&#91;this.selectedIndex&#93;.value!=\'\'){window.location=this.options&#91;this.selectedIndex&#93;.value}else{this.options&#91;selectedIndex=0&#93;;}">
                                       <option value="{MOD_LINK}/cats/' . $news['id'] . '">' . $lang['select_cats'] . '</option>
                                       <option value="{MOD_LINK}/cats/0/' . $news['id'] . '">' . $lang['default_cats'] . '</option>
                                       ' . $select_cat . '
                                       </select>
                                    </a>
                                 </li>
  ' . (($news['active'] != 2) ? '<li><a href="{MOD_LINK}/moderation/' . $news['id'] . '">' . faSpan('fa-share-square-o', false, $lang['do_moderation']) . '</a></li>' : '') . '
                                 <li><a href="{MOD_LINK}/retivate/' . $news['id'] . '">' . faSpan('fa-power-off', true, (($news['active'] != 1) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="{MOD_LINK}/index/' . $news['id'] . '">' . faSpan('fa-newspaper-o', false, (($news['allow_index'] == 0) ? $lang['news_action_index'] : $lang['news_action_noindex'])) . '</a></li>
                                 <li><a href="{MOD_LINK}/fix/' . $news['id'] . '">' . faSpan('fa-toggle-on', false, (($news['fixed'] == 0) ? $lang['news_action_fix'] : $lang['news_action_nofix'])) . '</a></li>
                                 <li><a href="{MOD_LINK}/inrating/' . $news['id'] . '">' . faSpan('fa-star-half-o', false, (($news['allow_rating'] == 0) ? $lang['news_action_rating'] : $lang['news_action_norating'])) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-cleanccomm' . $news['id'] . '\')">' . faSpan('fa-eraser', true, $lang['action_ccleancom']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-cleancounter' . $news['id'] . '\')">' . faSpan('fa-eraser', true, $lang['news_action_clean']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $news['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete($news['id'], $news['title'], $lang['news_delete_title'], 'news', $lang['news_delete_text'], '{ADMIN}/module/news/delete/' . $news['id']);
            modal_form_delete('cleanccomm' . $news['id'], $news['title'], $lang['news_ccleancom_title'], 'news', $lang['news_ccleancom_text'], '{ADMIN}/module/news/cleanccomm/' . $news['id'], false, 'clear');
            modal_form_delete('cleancounter' . $news['id'], $news['title'], $lang['news_cleancounter_title'], 'news', $lang['news_cleancounter_text'], '{ADMIN}/module/news/cleancounter/' . $news['id'], false, 'clear');
        }
        echo '</tbody>';
        init_tfoot('<option value="allowComment">' . $lang['news_allow_comment'] . '</option>
                    <option value="blockComment">' . $lang['news_block_comment'] . '</option>
                    <option value="allowRating">' . $lang['news_action_rating'] . '</option>
                    <option value="blockRating">' . $lang['news_action_norating'] . '</option>
                    <option value="blockIndex">' . $lang['news_remove_main'] . '</option>
                    <option value="setIndex">' . $lang['news_set_main'] . '</option>
                    <option value="nowDate">' . $lang['news_set_nowdate'] . '</option>
                    <option value="cleancounter">' . $lang['news_action_clean'] . '</option>
                    <option value="activate">' . $lang['do_activation'] . '</option>
                    <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                    <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                    <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('urs', 'news', 'news', $whereC);
        echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">
                     <option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = (isset($news['author']) && ($users_list['nick'] == $news['author'])) ? "selected" : "";
                echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                  ' . faI('arrow double') . '
               </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['news_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
           <div class="section mb5">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['news_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
          <div class="section mb5">
               <h5><small>' . $lang['news_search_date'] . '</small></h5>
               <div class="section row">
                   <div class="col-lg-6 col-md-6 col-sm-9">
                     <label for="startdate" class="field prepend-icon">
                     <input id="startdate" type="text" name="startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                   <div class="col-lg-6 col-md-6 col-sm-9">
                     <label for="enddate" class="field prepend-icon">
                     <input id="enddate" type="text" name="enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_day" value="0">
               <input type="checkbox" name="s_day" ' . ($s_day ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news_day'] . '</label>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news_active'] . '</label>
            </div>
             ' . init_sfoot(true, true, false, '{MOD_LINK}') . '
         </div>
      </form>
   </aside>
</div>';
    } else {
        onmoder('news', 'active', 'news_moder');
        list_empty('urs', 'news', true, $s_search, false, true);
    }
    $adminTpl->admin_foot();
}

function news_add($nid = null)
{
    global $adminTpl, $core, $db, $url, $config, $lang;
    if (isset($nid)) {
        $news = $core->row_data('news', 'id = ' . $nid);
        $id = $news['id'];
        $author = $news['author'];
        $actives = $news['active'];
        $date = gmdate('d.m.Y H:i', $news['date']);
        $tags = $news['tags'];
        $source = $news['source'];
        $groups = $news['groups'];
        $altname = $news['altname'];
        $keywords = $news['keywords'];
        $description = $news['description'];
        $allow_comments = $news['allow_comments'];
        $allow_rating = $news['allow_rating'];
        $allow_index = $news['allow_index'];
        $allow_fix = $news['fixed'];
        $score = $news['score'];
        $votes = $news['votes'];
        $preview = $news['preview'];
        $views = $news['views'];
        $comments = $news['comments'];
        $fields = $news['fields'] ? unserialize($news['fields']) : '';
        $active = ($news['active'] == 2 ? 0 : $news['active']);
        $cat = $news['cat'];
        $cat_array = explode(',', $cat);
        $catttt = explode(',', $cat);
        $edit = true;
        $grroups = explode(',', $groups);
        $firstCat = $catttt[1];
        $deleteKey = array_search($firstCat, $catttt);
        unset($catttt[$deleteKey]);
        $langMassiv = $core->getLangList(true);
        $query = $core->select_data('langs', 'postId ="' . $id . '" AND module ="news"');
        while ($langs = $db->getRow($query)) {
            $title[$langs['lang']] = prepareTitle($langs['title']);
            $fulltitle[$langs['lang']] = prepareTitle($langs['fulltitle']);
            $short[$langs['lang']] = stripslashes($core->bbDecode(parseBB($langs['short'])));
            $full[$langs['lang']] = stripslashes($core->bbDecode(parseBB($langs['full'])));
        }
        $admhead = $lang['news_edits'];
        $remote = ADMIN . '/module/news/ajax/isurl/update';
    } else {
        $id = false;
        $fulltitle = false;
        $title = false;
        $short = false;
        $full = false;
        $author = $core->auth->user_info['nick'];
        $actives = false;
        $date = gmdate('d.m.Y H:i');
        $tags = false;
        $source = false;
        $cat = isset($url[4]) ? "'," . $url[4] . ",'" : false;
        $cat_array = isset($url[4]) ? explode(',', $cat) : false;
        $catttt = isset($url[4]) ? explode(',', $cat) : false;
        $firstCat = isset($url[4]) ? $catttt[1] : false;
        $altname = false;
        $keywords = false;
        $description = false;
        $allow_comments = 1;
        $allow_rating = 1;
        $allow_index = 1;
        $allow_fix = false;
        $active = 1;
        $score = false;
        $votes = false;
        $views = false;
        $preview = false;
        $comments = false;
        $fields = false;
        $edit = false;
        $grroups = array();
        $admhead = $lang['news_adds'];
        $remote = ADMIN . '/module/news/ajax/isurl';
    }
    $queryXF = $core->select_data('xfields', 'module ="news"');
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['news_add_name_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
        'translit' => array(
            'required' => array('true', $lang['news_add_url_err_1'])/*,
            'remote' => array($remote, $lang['cats_url_err_2'])*/
        ),
        'date' => array(
            'required' => array('true', $lang['news_add_date_err']),
        ),
        'author' => array(
            'required' => array('true', $lang['news_add_author_err']),
        )
    );
    validationInit($validation_array);
    init_count_text();
    datetimepickerInit('date');
    ajaxInit();
    fancyboxInit();
    UniClass('selectList');
    $cats_arr = $core->aCatList('news');
    $adminTpl->admin_head($lang['modules'] . ' | ' . $admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">
   <form id="admin-form" class="form-horizontal parsley-form" enctype="multipart/form-data" role="form" method="POST" action="{MOD_LINK}/save" data-parsley-validate>
      <div class="panel panel-default panel-border top">
         <div class="panel-heading br-b-ddd pt20">
            <span class="panel-title hidden-xs">' . $lang['news_add'] . '</span>
            <ul class="nav panel-tabs-border panel-tabs">
               <li class="active"><a href="#tab1_1" data-toggle="tab">' . $lang['news_add_tab_general'] . '</a></li>
               <li><a href="#tab1_2" data-toggle="tab">' . $lang['news_add_tab_settings'] . '</a></li>
               <li><a href="#tab1_3" data-toggle="tab">' . $lang['news_add_tab_access'] . '</a></li>
               ' . (($db->numRows($queryXF) > 0) ? '<li><a href="#tab1_4" data-toggle="tab">' . $lang['news_add_tab_xfields'] . '</a></li>' : '') . '
            </ul>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body p20 pb10">
            <div class="tab-content pn br-n">
               <div id="tab1_1" class="tab-pane active admin-form">
                  <div class="section row mbn">
                     <div class="col-md-9 pl15">
                        <div class="section row mb15">
                           <div class="col-xs-6">
                              <label for="title" class="field prepend-icon">
                              <input id="title" type="text" name="title" maxlength="200" placeholder="' . $lang['news_add_name'] . '"' . (isset($nid) ? '' : 'onkeyup="getTranslit(gid(\'title\').value, \'translit\'),getRelates(gid(\'title\').value, \'related_news\'),count_down(this, \'title\', 200);"') . ' value="' . ($title[$config['lang']] ?? '') . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                              <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                              </label>
                              <div align="right" class="text-right">
                                  <span id="char_title"></span>
                              </div>
                              <span id="related_news"></span>
                           </div>
                           <div class="col-xs-6">
                              <label for="translit" class="field prepend-icon">
                              <input id="translit" type="text" name="translit" placeholder="' . $lang['news_add_url'] . '" class="event-name form-control" value="' . $altname . '">
                              <label for="translit" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
                              </label>
                           </div>
                        </div>
                        <div class="section row mb15">
                           <div class="col-xs-6">
                              <label for="author" class="field prepend-icon">
                              <select name="author" class="select2-single form-control">';
    $query_users_list = $core->select_data('users');
    if ($db->numRows($query_users_list) > 0) {
        while ($users_list = $db->getRow($query_users_list)) {
            $selected = ($users_list['nick'] == $author) ? "selected" : "";
            echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
        }
    }
    echo '</select>
                              <label for="author" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
                              </label>
                           </div>
                           <div class="col-xs-6">
                              <label for="date" class="field prepend-icon">
                              <input id="date" type="text" name="date" placeholder="' . $lang['news_add_date'] . '" class="form-control" value="' . $date . '">
                              <label for="date" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                              </label>
                           </div>
                        </div>
                        <div class="section mb8">
                           <label for="source" class="field prepend-icon">
                           <input id="source" type="text" name="source" placeholder="' . $lang['news_add_source'] . '" class="event-name form-control" value="' . $source . '">
                           <label for="source" class="field-icon">' . faI('fa-newspaper-o', false, false, true) . '</label>
                           </label>
                        </div>
                        <div class="section mb10">
                           <label for="tags" class="field mb15">' . $lang['news_add_tags'] . ':</label>
                           <input id="tagsinput" name="tags" type="text" value="' . $tags . '" class="event-name form-control">
                        </div>
                        <div class="section row mb15">
                           <div class="col-xs-6">
                              <label for="category" class="field select mb15">
                                 <select class="select-single form-control" name="category[]" id="maincat" onchange="if(this.value != \'0\') {show(\'catSub\');}" >
                                    <option value="0">' . $lang['news_add_nocat'] . '</option>';
    foreach ($cats_arr as $cid => $name) {
        $selected = ($cid == $firstCat) ? "selected" : "";
        echo '<option value="' . $cid . '" ' . $selected . '>' . $name . '</option>';
    }
    echo ' </select>
                  ' . faI('arrow double') . '
                  </label>
                           </div>
                           <div class="col-xs-6" id="catSub" style="' . ((isset($nid) && ($firstCat != 0)) ? '' : 'display:none;') . '">
                              <label class="field select">
                              <select class="select2-single form-control"  name="category[]" id="category"  multiple>';
    foreach ($cats_arr as $cid => $name) {
        if ($catttt) $selected = in_array($cid, $catttt) ? "selected" : "";
        echo '<option value="' . $cid . '" ' . $selected . ' id="cat_' . $cid . '">' . $name . '</option>';
    }
    echo ' </select>
                  </label>
                           </div>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div data-provides="fileupload" class="fileupload fileupload-' . ($preview ? 'exists' : 'new') . ' admin-form">
                           <div class="fileupload-preview thumbnail mb15">
                              <img ' . ($preview ? 'src="' . $config['url'] . $preview . '"' : 'data-src="holder.js/100%x147/text:' . $lang['news_add_mini'] . '"') . ' alt="holder">
                           </div>
                           <span class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple">
                           <span class="fileupload-new">' . $lang['upload'] . '</span>
                           <span class="fileupload-exists">' . $lang['upload_again'] . '</span>
                           <input name="preview" type="file">
                           </span>
                        </div>
                        <div class="checkbox-custom checkbox-warning mb5 mt15 text-center">
                           <input id="preview_del" name="preview_del" type="checkbox">
                           <label for="preview_del">' . $lang['news_add_mini_del'] . '</label>
                        </div>
                     </div>
                  </div>
               </div>
               <div id="tab1_2" class="tab-pane admin-form">
                  <div class="section row mbn">
                     <div class="col-xs-6 pr15">
                        <div class="section mb10">
                           <label class="field mb5">' . $lang['news_add_fulltitle'] . ':</label>
                           <label for="fulltitle" class="field prepend-icon">
                           <input id="fulltitle" type="text" name="fulltitle" placeholder="' . $lang['news_add_fulltitle_pre'] . '" class="event-name form-control" value="' . (isset($fulltitle[$config['lang']]) ? $fulltitle[$config['lang']] : '') . '">
                           <label for="fulltitle" class="field-icon">' . faI('fa-code', false, false, true) . '</label>
                           </label>
                        </div>
                        <div class="section mb10">
                           <label class="field mb5">' . $lang['news_add_keywords'] . ':</label>
                           <label for="keywords" class="field prepend-icon">
                           <input id="keywords" type="text" name="keywords" placeholder="' . $lang['news_add_keywords_pre'] . '" class="event-name form-control" value="' . $keywords . '">
                           <label for="keywords" class="field-icon">' . faI('fa-edit', false, false, true) . '</label>
                           </label>
                        </div>
                        <div class="section mb10">
                           <label class="field mb5">' . $lang['news_add_description'] . ':</label>
                           <label for="description" class="field prepend-icon">
                           <input id="description" type="text" name="description" placeholder="' . $lang['news_add_description_pre'] . '" class="event-name form-control" value="' . $description . '">
                           <label for="description" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                           </label>
                        </div>
                        <hr class="alt short mv15">
                        <p class="text-muted">' . faSpan('fa-exclamation-circle text-warning fs15 pr5', false, $lang['news_add_seo']) . '</p>
                     </div>
                     <div class="col-xs-6">
                        <label class="field option">
                        ' . checkbox('status', $active, $lang['news_add_activate']) . '
                        </label><br>
                        <label class="field option mt15">
                        ' . checkbox('allow_rating', $allow_rating, $lang['news_add_raiting']) . '
                        </label><br>
                        <label class="field option mt15">
                        ' . checkbox('allow_comments', $allow_comments, $lang['news_add_comments']) . '
                        </label><br>
                        <label class="field option mt15">
                        ' . checkbox('allow_fix', $allow_fix, $lang['news_add_fix']) . '
                        </label><br>
                        <label class="field option mt15">
                        ' . checkbox('allow_index', $allow_index, $lang['news_add_index']) . '
                        </label>
                     </div>
                  </div>
               </div>
               <div id="tab1_3" class="tab-pane admin-form">
                  <div class="row">
                     <div class="section">
                 <b>' . $lang['news_add_accsess_title'] . '</b>
                        <p>' . $lang['news_add_accsess'] . '</p>
                        <hr class="alt short mv15">
               <div class="col-lg-7 col-md-7 col-sm-10">
                <label class="field option">
                     ' . CheckGroups($grroups) . '
                </label>
               </div>
            </div>
          </div>
       </div>';
    if ($db->numRows($queryXF) > 0) {
        echo '<div id="tab1_4" class="tab-pane form-horizontal">';
        while ($xfield = $db->getRow($queryXF)) {
            echo '<div class="form-group">
                     <label class="col-sm-3 control-label">' . $xfield['title'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">';
            if ($xfield['type'] == 6) {
                $xfieldChange = radio($xfield['id'], $xfield['content']);
            } elseif ($xfield['type'] == 5) {
                $xfieldChange = checkbox($xfield['id'], $xfield['content']);
            } elseif ($xfield['type'] == 4) {
                $xfieldChange = '<textarea class="form-control" name="xfield[' . $xfield['id'] . ']" >' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '</textarea>';
            } elseif ($xfield['type'] == 3) {
                $dxfield = array_map('trim', explode("\n", $xfield['content']));
                $xfieldChange = '<select class="form-control" name="xfield[' . $xfield['id'] . ']">';
                foreach ($dxfield as $xfiled_content) {
                    $xfieldChange .= '<option value="' . $xfiled_content . '" ' . (isset($fields[$xfield['id']][1]) && $fields[$xfield['id']][1] == $xfiled_content ? 'selected' : '') . '>' . $xfiled_content . '</option>';
                }
                $xfieldChange .= '</select>';
            } elseif ($xfield['type'] == 2) {
                $xfieldChange = '<textarea class="form-control" name="xfield[' . $xfield['id'] . ']" >' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : ($id ? '' : $xfield['content'])) . '</textarea>';
            } else {
                $xfieldChange = '<input type="text" class="form-control" name="xfield[' . $xfield['id'] . ']" value="' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : ($id ? '' : $xfield['content'])) . '">';
            }
            echo $xfieldChange;
            echo '</div>
                  </div>
                  <input type="hidden" name="xfieldT[' . $xfield['id'] . ']" value="' . $xfield['title'] . '">';
        }
        echo '</div>';
    }
    echo '</div>';
    initDir('news', $id);
    echo '<div class="row">
  <div class="col-xs-12">
             <div class="tab-block mb25">
            <ul class="nav nav-tabs_editor nav-tabs-right">
               <li class="active">
                  <a href="#tab1" data-toggle="tab" aria-expanded="true">' . $lang['news_add_short'] . '</a>
               </li>
               <li class="">
                  <a href="#tab2" data-toggle="tab" aria-expanded="false">' . $lang['news_add_full'] . '</a>
               </li>
               <li class="">
                  <a id="fbox" data-fancybox-type="iframe" href="usr/plugins/filemanager/dialog.php?type=2">' . faSpan('fa-folder-open-o', false, $lang['news_add_upload']) . '</a>
               </li>
            </ul>
            <div class="tab-content_editor">
               <div id="tab1" class="tab-pane active">' . adminArea('short[' . $config['lang'] . ']', (isset($short[$config['lang']]) ? $short[$config['lang']] : ''), 5, 'textarea', 'onchange="caa(this);"', true) . '
               </div>
               <div id="tab2" class="tab-pane">' . adminArea('full[' . $config['lang'] . ']', (isset($full[$config['lang']]) ? $full[$config['lang']] : ''), 5, 'textarea', 'onchange="caa(this);"', true) . '
               </div>
            </div>
         </div>
      </div>
        </div>
            </div>
            <div class="panel-footer">
               <button type="button" class="p7 btn bg-success btn-sm btn-preview btn-raised legitRipple" onclick="genPreview(\'title\', \'date\', \'maincat\', \'short[' . $config['lang'] . ']\', \'full[' . $config['lang'] . ']\');">' . faSpan('fa-television', true, false, false, $lang['view']) . '</button>
               <button  type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
            </div>
         </div>
      </div>';
    if ($edit) {
        echo '<script type="javascript">
         $(\'#admin-form\').submit(function (e) {
         	var form = this;
         	e.preventDefault();
         	setTimeout(function () {
         		form.submit();
         	}, 1000); // in milliseconds
         });
      </script>
      <input type="hidden" name="edit" value="1">
      <input type="hidden" name="edit_id" value="' . $id . '">';
        if ($actives == 2) echo '<input type="hidden" name="from_user" value="1">';
    }
    if (isset($nid)) echo '<input type="hidden" name="oldAltName" value="' . $altname . '">';
    echo '</form>
</div>';
    $adminTpl->admin_foot();
}

function news_save()
{
    global $adminTpl, $core, $db, $cats, $config, $news_conf, $lang;
    $bb = new bb;
    $word_counter = new Counter();
    $title = isset($_POST['title']) ? $_POST['title'] : '';
    $langTitle = array();
    $langTitle[$config['lang']] = $title;
    $fulltitle[$config['lang']] = isset($_POST['fulltitle']) ? $_POST['fulltitle'] : '';
    $author = filter($_POST['author'], 'nick');
    $ttime = 'UNIX_TIMESTAMP(NOW())';
    $date = !empty($_POST['date']) ? $_POST['date'] : $ttime;
    $oldAltName = !empty($_POST['oldAltName']) ? filter($_POST['oldAltName']) : '';
    $source = isset($_POST['source']) ? $_POST['source'] : '';
    $translit = ($_POST['translit'] !== '') ? mb_strtolower(str_replace(array('-', ' '), array('_', '_'), $_POST['translit']), 'UTF-8') : translit($title);
    $full = isset($_POST['full']) ? $_POST['full'] : '';
    $short = isset($_POST['short']) ? $_POST['short'] : '';
    $xfield = isset($_POST['xfield']) ? $_POST['xfield'] : '';
    $xfieldT = isset($_POST['xfieldT']) ? ($_POST['xfieldT']) : '';
    $category = isset($_POST['category']) ? array_unique($_POST['category']) : false;
    $groups = isset($_POST['groups']) ? $_POST['groups'] : false;
    $allow_comments = isset($_POST['allow_comments']) ? 1 : 0;
    $allow_rating = isset($_POST['allow_rating']) ? 1 : 0;
    $allow_index = isset($_POST['allow_index']) ? 1 : 0;
    $status = isset($_POST['status']) ? 1 : 0;
    $allow_fix = isset($_POST['allow_fix']) ? 1 : 0;
    $edit_id = isset($_POST['edit_id']) ? intval($_POST['edit_id']) : '';
    $cnt = (($full[$config['lang']] != '') ? $full[$config['lang']] : $short[$config['lang']]);
    $gen_tag = $word_counter->get_keywords(mb_substr($cnt, 0, 500));
    $tags = isset($_POST['tags']) ? mb_strtolower(filter($_POST['tags'], 'a'), 'UTF-8') : mb_strtolower(filter($gen_tag, 'a'), 'UTF-8');
    $keywords = !empty($_POST['keywords']) ? $_POST['keywords'] : $word_counter->get_keywords(mb_substr($cnt, 0, 500));
    $newcnt = $bb->parse(processText(filter(fileInit('news', $edit_id, 'content', $cnt), 'html')), $edit_id, true);
    $description = !empty($_POST['description']) ? $_POST['description'] : mb_substr(strip_tags($newcnt), 0, 150);
    $groupss = false;
    $admhead = isset($_POST['edit']) ? $lang['news_edits'] : $lang['news_adds'];
    if ($edit_id > 0) $old_data = $core->row_data('news', 'id ="' . $edit_id . '"');
    if ($date != $ttime) {
        $parseDate = explode(' ', $date);
        $subDate = explode('.', $parseDate[0]);
        if (isset($parseDate[1])) {
            $subTime = explode(':', $parseDate[1]);
        } else {
            $subTime[0] = 12;
            $subTime[1] = 0;
        }
        $date = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
    }
    if (is_array($category)) {
        $firstCat = $category[0];
        unset($category[0]);
        $deleteCat = array_search($firstCat, $category);
        unset($category[$deleteCat]);
        $category[0] = $firstCat;
        ksort($category);
        foreach ($category as $cid) {
            $cats .= intval($cid) . ",";
        }
    } else {
        $cats = $category . ',';
    }
    $fieldsSer = '';
    if (!empty($xfield)) {
        foreach ($xfield as $xId => $xContent) {
            if (!empty($xContent) && $xId > 0 && !empty($xfieldT[$xId])) {
                $xContent = processText(filter($xContent, 'html'));
                $xId = intval($xId);
                $xfieldT[$xId] = filter($xfieldT[$xId], 'title');
                $fileds[$xId] = array($xfieldT[$xId], $xContent);
            }
        }
        $fieldsSer = serialize($fileds);
    }
    $cats = ',' . $cats;
    if (is_array($groups)) {
        foreach ($groups as $gid) {
            $groupss .= intval($gid) . ",";
        }
    } else {
        $groupss = $groups . ',';
    }
    $groupss = ',' . $groupss;
    $adminTpl->admin_head($lang['news'] . ' | ' . $admhead);
    if ($title && $short[$config['lang']] && $author && $translit) {
        if (isset($_POST['edit'])) {
            foreach ($langTitle as $k => $v) {
                $ntitle = filter(trim(htmlspecialchars_decode($v, ENT_QUOTES)), 'title');
                $ftitle = filter(trim(htmlspecialchars_decode($fulltitle[$k], ENT_QUOTES)), 'title');
                $nshort = $bb->parse(processText(filter(fileInit('news', $edit_id, 'content', $short[$k]), 'html')), $edit_id, true);
                $nfull = $bb->parse(processText(filter(fileInit('news', $edit_id, 'content', $full[$k]), 'html')), $edit_id, true);
                if (isset($_POST['empty'][$k]) && trim($v) != '' && trim($short[$k]) != '') {
                    $core->ins_data('langs', '_id,postId,module,title,fulltitle,short,full,lang', 'NULL,"' . $edit_id . '","news","' . $db->safesql(processText($ntitle)) . '","' . $db->safesql(processText($ftitle)) . '","' . $db->safesql($nshort) . '","' . $db->safesql($nfull) . '","' . $k . '"');
                } elseif (!isset($_POST['empty'][$k]) && (trim($v) == '' or trim($short[$k]) == '')) {
                    $core->del_data('langs', 'postId ="' . $edit_id . '" AND module ="news" AND lang ="' . $k . '"');
                } elseif (!isset($_POST['empty'][$k]) && trim($v) != '' && trim($short[$k]) != '') {
                    $core->upd_data('langs', 'title ="' . $db->safesql(processText($ntitle)) . '",fulltitle ="' . $db->safesql(processText($ftitle)) . '",short ="' . $db->safesql($nshort) . '",full ="' . $db->safesql($nfull) . '"', 'postId ="' . $edit_id . '" AND module ="news" AND lang ="' . $k . '"');
                }
            }
            if (!empty($tags) && $status == 1) {
                if ($old_data['tags'] != $tags) {
                    workTags($edit_id, $old_data['tags'], 'delete');
                    workTags($edit_id, $tags, 'add');
                }
            }
            if (isset($_POST['from_user']) && $status == 0) $status = 2;
            $access = $core->row_data('users', 'nick ="' . $db->safesql($author) . '"');
            if (($old_data['active'] == 2 && $status == 1) || ($old_data['active'] == 0 && $status == 1)) {
                $core->upd_data('users', 'user_news = user_news+1', 'nick ="' . $db->safesql($author) . '"');
                user_points($author, 'add_news');
                delcache('userInfo_' . $access['id']);
            }
            if ($old_data['active'] == 1 && $status == 0) {
                $core->upd_data('users', 'user_news = user_news-1', 'nick ="' . $db->safesql($author) . '"');
                delcache('userInfo_' . $access['id']);
            }
            if (isset($_POST['edit']) && $edit_id) {
                $news = $core->row_data('news', 'id ="' . $edit_id . '"');
                $rel_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
                $core->upd_data('news', '`author` ="' . $author . '",`date` ="' . $date . '",`tags` ="' . $tags . '",`source` ="' . $source . '",`cat` ="' . $cats . '", `altname` ="' . $translit . '", `keywords` ="' . $keywords . '", `description` ="' . $description . '", `allow_comments` ="' . $allow_comments . '", `allow_rating` ="' . $allow_rating . '", `allow_index` ="' . $allow_index . '",`fields` ="' . $fieldsSer . '", `groups` ="' . $groupss . '", `fixed` ="' . $allow_fix . '", `active` ="' . $status . '"', 'id ="' . $edit_id . '"');
                $core->ins_log('<a href="' . $rel_link . $news['altname'] . '.html" target="_blank">' . $db->safesql(processText($title)) . '</a>', $lang['logs_edit_news']);
                action_alert('urs', 'success', 'news', false, 'news_edit_ok');
            }
            $nnid = $edit_id;
            clearcache();
        } else {
            $rows = $core->row_data('news');
            if ($translit <> $rows['altname']) {
                $core->ins_data('news', 'id,author,date,tags,cat,altname,source,preview,keywords,description,allow_comments,allow_rating,allow_index,score,votes,views,comments,fields,groups,fixed,active,users_delete,users_del_data,fulltitle', 'NULL,"' . $author . '","' . $date . '","' . $tags . '","' . $cats . '","' . $db->safesql($translit) . '","' . $source . '","","' . $keywords . '","' . $description . '","' . $allow_comments . '","' . $allow_rating . '","' . $allow_index . '",0,0,0,0,"' . $fieldsSer . '","' . $groupss . '","' . $allow_fix . '","' . $status . '","",0,""');
                if ($status == 1) {
                    $core->upd_data('users', 'user_news = user_news+1', 'nick ="' . $db->safesql($author) . '"');
                    user_points($author, 'add_news');
                    $access = $core->row_data('users', 'nick ="' . $db->safesql($author) . '"');
                    delcache('userInfo_' . $access['id']);
                }
                $news = $core->row_data('news', 'altname ="' . $db->safesql($translit) . '"');
                $nnid = $news['id'];
                foreach ($langTitle as $k => $v) {
                    if (trim($v) != '' && trim($short[$k]) != '') {
                        $ntitle = filter(trim(htmlspecialchars_decode($v, ENT_QUOTES)), 'title');
                        $ftitle = filter(trim(htmlspecialchars_decode($fulltitle[$k], ENT_QUOTES)), 'title');
                        $nshort = fileInit('news', $nnid, 'content', $bb->parse(processText(filter($short[$k], 'html')), $nnid, true));
                        $nfull = fileInit('news', $nnid, 'content', $bb->parse(processText(filter($full[$k], 'html')), $nnid, true));
                        $core->ins_data('langs', '_id,postId,module,title,fulltitle,short,full,lang', 'NULL,"' . $nnid . '","news","' . $db->safesql(processText($ntitle)) . '","' . $db->safesql(processText($ftitle)) . '","' . $db->safesql($nshort) . '","' . $db->safesql($nfull) . '","' . $k . '"');
                    }
                }
                $rel_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
                $core->upd_data('news', '`author` ="' . $author . '",`date` ="' . $date . '",`tags` ="' . $tags . '",`source` ="' . $source . '",`cat` ="' . $cats . '", `altname` ="' . $translit . '", `keywords` ="' . $keywords . '", `description` ="' . $description . '", `allow_comments` ="' . $allow_comments . '", `allow_rating` ="' . $allow_rating . '", `allow_index` ="' . $allow_index . '",`fields` ="' . $fieldsSer . '", `groups` ="' . $groupss . '", `fixed` ="' . $allow_fix . '", `active` ="' . $status . '"', 'id ="' . $edit_id . '"');
                $core->ins_log('<a href="' . $rel_link . $news['altname'] . '.html" target="_blank">' . $db->safesql(processText($title)) . '</a>', $lang['logs_add_news']);
                action_alert('urs', 'success', 'news', false, 'news_add_ok');
                fileInit('news', $nnid);
                workTags($nnid, $tags, 'add');
                clearcache();
            } else {
                $adminTpl->info($lang['base_error_2'], 'error', null, $lang['error'], $lang['go_back'], 'javascript:history.go(-1)');
            }
        }
        if (isset($_POST['preview_del'])) {
            if (isset($_POST['edit'])) {
                $newsPR = $core->row_data('news', 'id = ' . $nnid);
                if (file_exists(ROOT . $newsPR['preview'])) unlink(ROOT . $newsPR['preview']);
                $core->upd_data('news', 'preview = NOT `preview`', 'id ="' . $nnid . '"');
            }
        } else {
            if (isset($_FILES['preview']) && $_FILES['preview']['size'] > 0) {
                $purl = 'files/news/' . $nnid . '/';
                $path_info = pathinfo($_FILES['preview']['name']);
                $ext = $path_info['extension'];
                $file_full = $purl . 'preview_' . $nnid . '.' . $ext;
                if (file_exists(ROOT . $file_full)) @unlink(ROOT . $file_full);
                if ($foo = new Upload($_FILES['preview'])) {
                    $foo->file_new_name_body = 'preview_' . $nnid;
                    $foo->image_resize = false;
                    $foo->image_x = $news_conf['thumb_width'];
                    $foo->image_ratio_y = true;
                    $foo->file_overwrite = true;
                    $foo->file_auto_rename = false;
                    $foo->Process(ROOT . $purl);
                    $foo->allowed = array("image/*");
                    if ($foo->processed) $foo->Clean();
                }
                $core->upd_data('news', 'preview ="/' . $file_full . '"', 'id ="' . $nnid . '"');
            }
        }
    } else {
        $adminTpl->info($lang['base_error_0'], 'error', null, $lang['error'], $lang['go_back'], 'javascript:history.go(-1)');
    }
    $adminTpl->admin_foot();
}

function delete($id)
{
    global $core, $lang;
    $rows = $core->row_data('news', 'id ="' . $id . '"');
    $row = $core->row_data('langs', 'postid ="' . $id . '"');
    $core->del_data('news', 'id ="' . $id . '"');
    $core->del_data('langs', 'postId ="' . $id . '" AND module ="news"');
    $core->upd_data('users', 'user_news = user_news-1', 'nick ="' . $rows['author'] . '"');
    $core->ins_log(false, $lang['logs_delete_news'], 1, false, false, $row['title'], false);
    workTags($id, $rows['tags'], 'delete');
    full_rmdir(ROOT . initDC('news', '', '', $rows['id']));
    deleteComments($id, 'news', $rows['id'], $core->auth->user_id);
    clearcache();
}

function workTags($id, $tags, $do = 'add')
{
    global $db, $core;
    if (!empty($tags)) {
        $tag = array_map('trim', explode(',', $tags));
        foreach ($tag as $t) {
            if ($do == 'add') {
                $core->ins_data('tags', 'id,tag,module', 'NULL,"' . $db->safesql($t) . '","news"');
            } elseif ($do == 'delete') {
                $core->del_data('tags', 'tag ="' . $t . '" AND module ="news"');
            }
        }
    }
}

function changeuGroup($var)
{
    global $core, $db, $news_conf;
    $content = '<select class="form-control" name="{varName}">';
    $query = $core->select_data('groups');
    while ($rows = $db->getRow($query)) {
        $sel = ($news_conf[$var] == $rows['id']) ? 'selected' : '';
        $content .= '<option value="' . $rows['id'] . '" ' . $sel . '>' . $rows['name'] . '</option>';
    }
    $content .= '</select>';
    return $content;
}
