<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

global $adminTpl, $db, $core, $lang;
if (empty($url[2])) {
    onmoder('news', 'active', 'news_moder');
} else {
    news_main();
}
function news_main(): void
{
    global $adminTpl, $news_conf, $core, $url, $db, $lang;
    ConfigMod('news');
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $where = '';
    $order = '';
    $cats_arr = $core->aCatList('news');
    $cats = (isset($url[3]) && $url[3] == 'cat') ? '/' . $url[4] : '';
    if (isset($url[3]) && $url[3] == 'cat') {
        if ($url[4]) {
            foreach ($cats_arr as $cid => $name) {
                if ($cid == $url[4]) $where .= 'WHERE `cat` =",' . $cid . ',"';
            }
        }
    }
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : ((isset($url[3]) && $url[3] == 'user_news') ? (isset($url[4]) ? $url[4] : '') : '');
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_tags = (isset($url[3]) ? $url[3] == 'tag' : '') ? $url[4] : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_cat = isset($_POST['s_cat']) ? intval($_POST['s_cat']) : '';
    $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
    $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
    $s_day = isset($_POST['s_day']) ? intval($_POST['s_day']) : '';
    $s_active = isset($_POST['s_active']) ? 1 : 0;
    $s_search = isset($_POST['s_search']) ? 1 : 0;
    $where = (isset($url[3]) && $url[3] == 'users_news_delete') ? 'WHERE active = 3' : ($s_active ? ($_POST['s_active'] == 1 ? 'WHERE n.active = 1' : 'WHERE n.active = 0') : 'WHERE n.active = 2');
    $whereC = str_replace(array('n.'), array(''), $where);
    $where .= 'AND l.lang ="' . $core->InitLang() . '"';
    if ($s_day) $where .= 'AND n.`date`>="' . mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")) . '"';
    if ($s_id) $where .= 'AND n.`id` LIKE"%' . $db->safesql($s_id) . '%"';
    if (!$s_id) $s_id = '';
    if ($s_author || isset($url[3]) && $url[3] == 'user_news') $where .= 'AND n.`author` LIKE"%' . $db->safesql($s_author) . '%"';
    if ($s_title) $where .= 'AND l.`title` LIKE"%' . $db->safesql($s_title) . '%"';
    if ($s_tags) $where .= 'AND n.`tags` ="' . $db->safesql($s_tags) . "'";
    if ($s_desc) $where .= 'AND l.`full` LIKE"%' . $db->safesql($s_desc) . '%"';
    if ($s_cat) {
        if ($s_cat !== ',0,') $where .= 'AND n.`cat` =",' . $db->safesql($s_cat) . ',"';
    }
    if ($startdate) $where .= 'AND n.`date` >="' . intval($startdate) . '"';
    if ($enddate) $where .= 'AND n.`date` <="' . intval($enddate) . '"';
    if (isset($url[4]) && $url[4] == 'order') {
        switch ($url[5]) {
            case 'abc':
                $order .= 'n.altname ASC';
                break;
            case 'last':
                $order .= 'n.date DESC';
                break;
            case 'id':
                $order .= 'n.id ASC';
                break;
        }
    } else {
        $order .= 'n.date DESC';
    }
    $query = $core->select_data('news', $where, $order . ' LIMIT ' . limit_page(), 'n.*, l.*, c.id as cid, c.name, c.altname as alturl', 'AS n LEFT JOIN ' . DB_PREFIX . '_categories AS c ON (n.cat=c.id) LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=n.id and l.module="news")');
    $adminTpl->admin_head($lang['news_onmoder']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('news');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . ((isset($url[3]) ? $url[3] == 'tag' : '') ? str_replace('[tag]', $s_tags, $lang['news_search_tags']) : $lang['news_list']) . ' (' . $core->sum_data('news', 'active=2') . '):</span>
            ' . sort_head('moder', 5, 'last') . '
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ACT_MODER_LINK}" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-6">' . $lang['titles'] . '</th>
                        <th class="text-center">' . faSpan('fa-comments-o', true, false, false, $lang['commentes']) . '</th>
                        <th class="text-center">' . faSpan('fa-eye', true, false, false, $lang['views']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($news = $db->getRow($query)) {
            $rel_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
            $patch = $news_conf['related_news_img_thumbs'] ? 'files/thumbs/files/news/' . $news['id'] . '/' : 'files/news/' . $news['id'] . '/';
            $images = array();
            $all_files = scandir(news_image($patch));
            for ($i = 0; $i < count($all_files); $i++) {
                if (!str_contains($all_files[$i], ".png") and !str_contains($all_files[$i], ".jpg") and
                    !str_contains($all_files[$i], ".gif")
                ) continue;
                $images[] = $all_files[$i];
            }
            $dir = news_image($patch);
            $img_random = $images ? $images[rand(0, sizeof($images) - 1)] : 'media/cats/no_image.png';
            $img_src = $images ? $dir . $img_random : $img_random;
            $name = $core->row_data('users', 'nick ="' . $news['author'] . '"');
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $news['id'] . '</td>
                        <td>
                           <div class="media media-list text-right"><a href="' . $rel_link . $news['altname'] . '.html"><img src="' . $img_src . '" class="img-responsive mw60 ib br4" alt=""></a></p></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0px;font-size: 14px;font-family: verdana; margin: 0 auto"><a href="' . $rel_link . $news['altname'] . '.html" target="_blank" data-toggle="tooltip" data-original-title="' . $news['title'] . '">' . trimtitle($news['title'], 50) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0px;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($news['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0px;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['cats'] . ': ' . ($news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'short', 3) : $lang['no']) . '</ol>
                           <ol class="timeline-list" style=" padding:0px;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ':<a href="profile/' . $name['nick'] . '"> ' . $news['author'] . ' </a></ol>
                        </td>';
            init_Ajax_count('urs', 'news', $news['id'], 'comments', 'id=' . $news['id']);
            init_Ajax_count('urs', 'news', $news['id'], 'views', 'id=' . $news['id']);
            echo '<td class="text-center">' . status_icon('news', $news['id'], 'news', $news['users_del_data']) . '</td>';
            init_checkbox('td', $news['id'], false, '<li><a href="' . $rel_link . $news['altname'] . '.html" target="_blank">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href="{LI_MODER_LINK}/edit/' . $news['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 ' . (($news['active'] != 2) ? '<li><a href="{LI_MODER_LINK}/moderation/' . $news['id'] . '">' . faSpan('fa-share-square-o', true, $lang['do_moderation']) . '</a></li>' : '') . '
                                 <li><a href="{LI_MODER_LINK}/retivate/' . $news['id'] . '">' . faSpan('fa-power-off', true, (($news['active'] <> 1) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="{LI_MODER_LINK}/index/' . $news['id'] . '">' . faSpan('fa-newspaper-o', true, (($news['allow_index'] == 0) ? $lang['news_action_index'] : $lang['news_action_noindex'])) . '</a></li>
                                 <li><a href="{LI_MODER_LINK}/fix/' . $news['id'] . '">' . faSpan('fa-toggle-on', true, (($news['fixed'] == 0) ? $lang['news_action_fix'] : $lang['news_action_nofix'])) . '</a></li>
                                 <li><a href="{LI_MODER_LINK}/inrating/' . $news['id'] . '">' . faSpan('fa-star-half-o', true, (($news['allow_rating'] == 0) ? $lang['news_action_rating'] : $lang['news_action_norating'])) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-cleanccomm' . $news['id'] . '\')">' . faSpan('fa-eraser', true, $lang['action_ccleancom']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-cleancounter' . $news['id'] . '\')">' . faSpan('fa-eraser', true, $lang['news_action_clean']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $news['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete($news['id'], $news['title'], $lang['news_delete_title'], 'news', $lang['news_delete_text'], '{ADMIN}/module/news/delete/' . $news['id']);
            modal_form_delete('cleanccomm' . $news['id'], $news['title'], $lang['news_ccleancom_title'], 'news', $lang['news_ccleancom_text'], '{ADMIN}/module/news/cleanccomm/' . $news['id'], false, 'clear');
            modal_form_delete('cleancounter' . $news['id'], $news['title'], $lang['news_cleancounter_title'], 'news', $lang['news_cleancounter_text'], '{ADMIN}/module/news/cleancounter/' . $news['id'], false, 'clear');
        }
        echo '</tbody>';
        init_tfoot('<option value="allowComment">' . $lang['news_allow_comment'] . '</option>
                    <option value="blockComment">' . $lang['news_block_comment'] . '</option>
                    <option value="allowRating">' . $lang['news_action_rating'] . '</option>
                    <option value="blockRating">' . $lang['news_action_norating'] . '</option>
                    <option value="blockIndex">' . $lang['news_remove_main'] . '</option>
                    <option value="setIndex">' . $lang['news_set_main'] . '</option>
                    <option value="nowDate">' . $lang['news_set_nowdate'] . '</option>
                    <option value="cleancounter">' . $lang['news_action_clean'] . '</option>
                    <option value="activate">' . $lang['do_activation'] . '</option>
                    <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                    <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                    <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('urs', 'news', 'news', $whereC);
        echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
			 <h4 class="pl20">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">
                     <option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = (isset($news['author']) && ($users_list['nick'] == $news['author'])) ? "selected" : "";
                echo '<option value="' . $users_list['nick'] . '" ' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                  ' . faI('arrow double') . '
               </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['news_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
           <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['news_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 pl10">
               <h5><small>' . $lang['news_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-md-6">
                     <label for="startdate" class="field prepend-icon">
                     <input id="startdate" type="text" name="startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-md-6">
                     <label for="enddate" class="field prepend-icon">
                     <input id="enddate" type="text" name="enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_day" value="0">
               <input type="checkbox" name="s_day" ' . ($s_day ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news_day'] . '</label>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active" ' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news_active'] . '</label>
            </div>
            ' . init_sfoot(true, true, false, '{MODER_LINK}') . '
         </div>
      </form>
   </aside>
</div>';
    } else {
        onmoder('news', 'active', 'news_moder');
        list_empty('urs', 'news', 5, $s_search, 'mod');
    }
    $adminTpl->admin_foot();
}