<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $db, $config, $core, $tags, $news_conf, $url, $headTag, $cache, $lang;
require(ROOT . 'etc/news.config.php');
$where = '';
if ($category != 'all') {
    $catsArr = array_map('trim', explode(',', $category));
    $i = 0;
    foreach ($catsArr as $cat) {
        $i++;
        $where .= $i == 1 ? ' AND ' : ' OR ';
        $where .= 'cat like"%,' . $cat . ',%"';
    }
}
if (!empty($notin)) {
    $notcatsArr = array_map('trim', explode(',', $notin));
    foreach ($notcatsArr as $cat) {
        $where .= ' AND cat NOT LIKE"%,' . $cat . ',%"';
    }
}
$where .= 'AND c.lang ="' . $core->InitLang() . '"';

if (($order != 'date') && ($order != 'views') && ($order != 'votes') && ($order != 'comments') && ($order != 'allow_index')) $order = 'date';
if (($short != 'DESC') && ($short != 'ASC')) $short = 'DESC';
$core->loadModLang('news');
$core->tempModule = 'news';
$queryDB = $core->select_data('news', 'active = 1' . $where, $order . ' ' . $short . ' LIMIT ' . $core->site_limit_page($news_conf, $limit, false), 'n.*, c.*', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news")');
$custom = '';
if ($db->numRows($queryDB) > 0) {
    $news = '';
    while ($news = $db->getRow($queryDB)) {
        $tag_list = explode(',', $news['tags']);
        $tag_count = 0;
        $tags = false;
        foreach ($tag_list as $tag) {
            $tag_count++;
            if ($tag_count < ($news_conf['tags_num'] + 1)) $tags .= '<a href="news/tags/' . $tag . '" title="' . $tag . '">' . ($headTag == $tag ? '<strong>' . $tag . '</strong>' : $tag) . '</a>';
        }
        $catInfo = $news['cat'] !== ',0,' ? $core->catInfo('news', $news['cat']) : '';
        $cat = $news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'short', 3) : '';
        $news_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
        $cat_one = $news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'altname', 1) : 'index';
        $short = $core->bbDecode($news['short'], $news['id']);
        $miniImg = _getCustomImg($short);
        ob_start();
        $core->tpl->loadFile($template);
        include(loadTag('news'));
        $custom .= $core->tpl->return_end();
        unset($tags);
        ob_end_clean();
    }
}