<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $db, $config, $core, $url, $news_conf, $headTag, $lang;
loadConfig('news');
$core->loadModLang('news');
$core->tempModule = 'news';
$query = isset($_REQUEST['query']) ? filter(utf_decode(urldecode($_REQUEST['query'])), 'query') : $url[1];
$news = $core->select_data('news ', 'title LIKE"%' . $db->safesql($query) . '%" AND active=1', false, 'n.*, c.*', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news")');
if ($db->numRows($news) > 0 && $query) {
    $where = 'AND title LIKE"%' . $db->safesql($query) . '%" OR short LIKE"%' . $db->safesql($query) . '%" OR short LIKE"%' . $db->safesql($query) . '%"';
    $where .= 'AND c.lang ="' . $core->InitLang() . '"';
    $query_news = $core->select_data('news ', 'active!=0 ' . $where . ' LIMIT  ' . $core->site_limit_page($news_conf, $news_conf['num']), false, 'n.*, c.*', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news")');
    list($all) = $core->fetch_data('news ', 'active!=0 ' . $where, 'count(n.id)', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news")');
    if ($db->numRows($query_news) > 0) {
        $core->tpl->title($lang['news'] . ': ' . $all);
        while ($news = $db->getRow($query_news)) {
            $tag_list = explode(', ', $news['tags']);
            $tag_count = 0;
            $tags = false;
            foreach ($tag_list as $tag) {
                $tag_count++;
                if ($tag_count < ($news_conf['tags_num'] + 1)) $tags .= '<a href="news/tags/' . $tag . '" title="' . $tag . '">' . ($headTag == $tag ? '<strong>' . $tag . '</strong>' : $tag) . '</a>, ';
            }
            $catInfo = $news['cat'] !== ',0,' ? $core->catInfo('news', $news['cat']) : '';
            $cat = $news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'short', 3) : '';
            $news_link = $news['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $news['cat'], 'development') . '/' : 'news/';
            $cat_one = $news['cat'] !== ',0,' ? $core->getCat('news', $news['cat'], 'altname', 1) : 'index';
            $short = $core->bbDecode($news['short'], $news['id']);
            $core->tpl->loadFile('news/news-main');
            include(loadTag('news'));
            $core->tpl->end();
            unset($tags);
        }
        $core->tpl->pages(init_page(), $news_conf['num'], $all, 'search/' . $query . '/{page}');
    }
} else {
    if ($db->numRows($news) < 0) $core->tpl->info($lang['news_empty']);
    if (strlen($query) > 30) $core->tpl->info($lang['search_error']);
}