<?php
/*
 * @name            JMY CMS
 * @link            http://jmy.su/
 * @copyright       Copyright (C) 2012-2021 JMY LTD
 * @license         LICENSE.txt (see attached file)
 * @version         VERSION.txt (see attached file)
 * @author          Komarov Ivan
 */
if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $config, $core, $db, $url, $user, $news_conf, $files_conf, $cache, $lang;
require(ROOT . 'etc/news.config.php');
if ($news['id'] == false) require(ROOT . 'usr/modules/news/index.php');
$userInfo = $core->row_data('users', 'nick ="' . $news['author'] . '"');
$avatar = isset($userInfo['nick']) && $news['author'] == $userInfo['nick'] && $userInfo['id'] != $news['id'] ? avatar($userInfo['id']) : $config['url'] . '/' . $user['noAvatar'];
$filelist = glob("*.'" . $files_conf['attachFormats'] . "'");
$flinks = $filelist ? str_replace(array($config['url'] . '/files/news/' . $news['id'] . '/' . $filelist), array($filelist), $news['full']) : $news['full'];
$altname = $news['altname'];
$news_fields = $news['fields'];

if ($news['id'] && $core->auth->isUser && $core->auth->group_info['addPost'] == 1 && ($config['url'] . '/files/news/' . $news['id'] . '/' . $flinks)) {
    $fulls = str_replace(array($config['url'] . '/files/news/' . $news['id'] . '/' . $flinks), array($config['url'] . '/files/news/' . $news['id'] . '/' . $flinks), $news['full']);
} else {
    if (strpos($news['full'], $lang['attach_download']) == false) {
        $atlang = $lang['attach_version_download'];
    } elseif (strpos($news['full'], $lang['attach_version_download']) == false) {
        $atlang = $lang['attach_version_download'];
    } elseif (strpos($news['full'], $lang['download']) == false) {
        $atlang = $lang['download'];
    } else {
        $atlang = '';
    }
    $urls = strpos($news['full'], $config['url']) == false ? '' : $config['url'];
    if ($files_conf['download_file'] == 'enable_all') {
        $fulls = str_replace(array('', ''), array('', ''), $news['full']);
    } elseif ($files_conf['download_file'] == "enable_reg") {
        $fulls = str_replace(array($urls . '/files/news/' . $news['id'] . '/' . $flinks, $atlang), array('', '<a href="' . $config['url'] . '/profile/register" title="' . $lang['attach_derror'] . '">' . $atlang . '</a>'), $news['full']);
    } else {
        $fulls = str_replace(array($urls . '/files/news/' . $news['id'] . '/' . $flinks, $atlang), array('', ''), $news['full']);
    }

}
$core->tpl->setVar('TITLE', $news['title']);
$core->tpl->setVar('SHORT', $short);
$core->tpl->setVar('FULL', '<div id="full-' . $news['id'] . '">' . $core->bbDecode($fulls, $news['id']) . '</div>');
$core->tpl->setVar('CATEGORY', $cat);
$core->tpl->setVar('CAT_ONE', $cat_one);
$core->tpl->setVar('ALTNAME', $altname);
$core->tpl->setVar('ICON', isset($catInfo['icon']) ? $core->getCatImg($news_link, $catInfo['icon'], $catInfo['title']) : '');
$core->tpl->setVar('AUTHOR', '<a href="profile/' . $news['author'] . '" title="' . $lang['page'] . ': ' . $news['author'] . '">' . $news['author'] . '</a>');
$core->tpl->setVar('VIEWS', formatCounter($news['views']));
$core->tpl->setVar('AUTHOR_AVATAR', $avatar);
$core->tpl->setVar('PREVIEW', $news['preview'] ? $news['preview'] : '');
$core->tpl->setVar('BOOKMARKS', BookmarksInit($news['id'], 'news', $news['title']));
$core->tpl->setVar('COMMENTS', formatCounter($news['comments']));
$core->tpl->setVar('TAGS', mb_substr($tags, 0, -2));
$core->tpl->setVar('SOURCE', '<a href="' . $news['source'] . '" target="_blank" title="' . $lang['source_page'] . '" rel="nofollow">' . $news['source'] . '</a>');
$core->tpl->setVar('FULL_LINK', $news_link . $altname . ".html");
$miniImg = _getCustomImg($short);
$core->tpl->sources = preg_replace_callback("#\\[rating\\](.*?)\\[/rating\\]#is", function ($matches) use ($news) {
    if ($news['allow_rating']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[breadcumb\\](.*?)\\[/breadcumb\\]#is", function ($matches) use ($news_conf) {
    if ($news_conf['showBreadcumb']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[tags\\](.*?)\\[/tags\\]#is", function ($matches) use ($news) {
    if ($news['tags']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[source\\](.*?)\\[/source\\]#is", function ($matches) use ($news) {
    if ($news['source']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[bookmarks\\](.*?)\\[/bookmarks\\]#is", function ($matches) use ($news_conf) {
    if ($news_conf['bookmarks']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[preview\\](.*?)\\[/preview\\]#is", function ($matches) use ($news) {
    if ($news['preview']) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[category\\](.*?)\\[/category\\]#is", function ($matches) use ($cat) {
    if ($cat) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[mini_img\\](.*?)\\[/mini_img\\]#is", function ($matches) use ($miniImg) {
    if (!empty($miniImg[0])) return $matches[1];
}, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\[more\\](.*?)\\[/more\\]#is",
    function ($match) use ($news_link, $altname) {
        return format_link($match[1], $news_link . $altname . '.html');
    }, $core->tpl->sources);
$news_date = $news['date'];
$core->tpl->sources = preg_replace_callback("#\\{%MYDATE:(.*?)%\\}#is",
    function ($match) use ($news_date) {
        return date($match[1], $news_date);
    }, $core->tpl->sources);
$news_title = $news['title'];
$core->tpl->sources = preg_replace_callback("#\\{%TITLE:(.*?)%\\}#is",
    function ($match) use ($news_title) {
        return short($match[1], $news_title);
    }, $core->tpl->sources);
$core->tpl->sources = preg_replace_callback("#\\{%SHORT:(.*?)%\\}#is",
    function ($match) use ($short) {
        return short($match[1], processText($short));
    }, $core->tpl->sources);
$array_replace = array(
    "#\\[rating\\](.*?)\\[/rating\\]#is" => (($core->auth->user_id) ? "\${1}" : ''),
    "#\\[breadcumb\\](.*?)\\[/breadcumb\\]#is" => (($core->auth->user_id) ? "\${1}" : ''),
    "#\\[titleErr\\](.*?)\\[/titleErr\\]#is" => (($core->auth->user_id) ? "\${1}" : ''),
    "#\\[editmenu\\](.*?)\\[/editmenu\\]#is" => ((isset($core->auth->user_info['nick']) && ($news['author'] == $core->auth->user_info['nick']) && $news_conf['editNews'] == 1 || $core->auth->isModer || $core->auth->isAdmin) ? "\${1}" : ''),
    "#\\[edit\\](.*?)\\[/edit\\]#is" => ((isset($core->auth->user_info['nick']) && $core->auth->isModer || isset($core->auth->user_info['nick']) && $core->auth->isAdmin) ? "\${1}" : ''),
    "#\\[editshort\\](.*?)\\[/editshort\\]#is" => ((isset($core->auth->user_info['nick']) && $news['author'] == $core->auth->user_info['nick'] && $news_conf['editNews'] == 1 || isset($core->auth->user_info['nick']) && $core->auth->isModer || isset($core->auth->user_info['nick']) && $core->auth->isAdmin) ? "\${1}" : ''),
    "#\\[del_news\\](.*?)\\[/del_news\\]#is" => ((isset($core->auth->user_info['nick']) && $news['author'] == $core->auth->user_info['nick'] && $news_conf['editNews'] == 1 || $core->auth->isModer || $core->auth->isAdmin) ? "\${1}" : ''),
    "#\\[full_del_news\\](.*?)\\[/full_del_news\\]#is" => (($core->auth->isAdmin) ? "\${1}" : ''),
    "#\\[notaut\\](.*?)\\[/notaut\\]#is" => ((isset($core->auth->user_info['nick']) && $news['author'] !== $core->auth->user_info['nick'] && $news_conf['editNews'] == 1 || isset($core->auth->user_info['nick']) && $news['author'] !== $core->auth->user_info['nick'] && $core->auth->isModer || isset($core->auth->user_info['nick']) && $news['author'] !== $core->auth->user_info['nick'] && $core->auth->isAdmin) ? "\${1}" : ''),
    "#\\[img:([0-9]*?)\\]#is" => (!empty($miniImg[0]) ? '<img src="' . $miniImg[0] . '" border="0" width="\\1">' : ''),
);
$xfield = '';
if (!empty($news_fields) && $news_fields != 'N;') {
    $fields = unser_base($news_fields);
    if (is_array($fields)) {
        foreach ($fields as $xId => $xData) {
            if (!empty($xData[1])) {
                $xfqwery = $core->row_data('_xfields', 'id ="' . $xId . '" and module="profile" and to_user=1');
                if ($xfqwery['type'] == 6 && $xfqwery['content'] == 1) {
                    $array_replace["#\\[xfield_value:" . $xId . "\\]#is"] = $lang['yes'];
                } elseif ($xfqwery['type'] == 6 && $xfqwery['content'] == 0) {
                    $array_replace["#\\[xfield_value:" . $xId . "\\]#is"] = $lang['no'];
                } else {
                    $array_replace["#\\[xfield_value:" . $xId . "\\]#is"] = $xData[1];
                }
                $xfield .= '<b>' . $xData[0] . '</b>: ' . $xData[1] . '<br/>';
            }
        }
    }
}
$core->tpl->sources = preg_replace_callback("#\\[xfield:([0-9]*?)\\](.*?)\\[/xfield:([0-9]*?)\\]#is",
    function ($match) use ($news_fields) {
        return ifFields($news_fields, $match[1], $match[2]);
    }, $core->tpl->sources);

if ($news_conf['showBreadcumb'] == '1') {
    $catId = explode(',', $news['cat']);
    $core->tpl->setVar('BREADCUMB', $core->getCat('news', ($catId[1] != 0) ? $catId[1] : '', 'breadcrumb', 1));
} else {
    $core->tpl->setVar('BREADCUMB', '');
}
$core->tpl->setVar('ID', $news['id']);
$core->tpl->setVar('DATE', formatDate($news['date']));
$core->tpl->setVar('RATING', $news['allow_rating'] ? draw_rating($news['id'], 'news', $news['score'], $news['votes']) : '');
$core->tpl->setVar('EDIT', (isset($core->auth->user_info['nick']) && $core->auth->isModer || isset($core->auth->user_info['nick']) && $core->auth->isAdmin) ? '<a href="news/edit/' . $news['id'] . '">' . $lang['menu_full'] . '</a>' : '');
$core->tpl->setVar('EDITSHORT', (isset($core->auth->user_info['nick']) && $news['author'] == $core->auth->user_info['nick'] && $news_conf['editNews'] == 1 || isset($core->auth->user_info['nick']) && $core->auth->isModer || isset($core->auth->user_info['nick']) && $core->auth->isAdmin) ? '<a href="news/editshort/' . $news['id'] . '">' . $lang['menu_short'] . '</a>' : '');
$core->tpl->setVar('NOTAUT', (isset($core->auth->user_info['nick']) && $news['author'] !== $core->auth->user_info['nick'] && $news_conf['editNews'] == 1 || isset($core->auth->user_info['nick']) && $news['author'] !== $core->auth->user_info['nick'] && $core->auth->isModer || isset($core->auth->user_info['nick']) && $news['author'] !== $core->auth->user_info['nick'] && $core->auth->isAdmin) ? '<a href="pm/notaut/' . $news['author'] . '/' . $news['id'] . '">' . $lang['not_author'] . '</a>' : '');
$core->tpl->setVar('DEL_NEWS', (isset($core->auth->user_info['nick']) && $news['author'] == $core->auth->user_info['nick'] && $news_conf['editNews'] == 1 || $core->auth->isModer || $core->auth->isAdmin) ? '<a href="news/del_news/' . $news['id'] . '" onclick="return confirm(\'' . $lang['posts_sure_delete'] . '\');">' . ($core->auth->isAdmin ? $lang['archive_it'] : $lang['delete']) . '</a>' : '');
$core->tpl->setVar('FULL_DEL_NEWS', $core->auth->isAdmin ? '<a href="news/delete/' . $news['id'] . '" onclick="return confirm(\'' . $lang['posts_sure_delete'] . '\');">' . $lang['delete'] . '</a>' : '');
$related_cache = $cache->do_get('related_' . $news['id']);
if (empty($related_cache) && $news_conf['related_news'] > 0) {
    $body_text = $news['title'] . strip_tags(stripslashes("" . (!empty($news['full']) ? $news['full'] : $news['short'])));
    if (!empty($body_text)) {
        $where = 'WHERE MATCH (`title`, `short`, `full`) AGAINST ("+(' . $db->safesql($body_text) . ')" IN BOOLEAN MODE) AND n.id !="' . $news['id'] . '" AND n.active = 1';
        $order = 'n.date DESC';
        $rel_query = $core->select_data('news', $where, $order . ' LIMIT ' . $news_conf['related_news'], 'n.*, l.*', 'AS n LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=n.id and l.module="news")');
        $related_cache = '';
        if ($db->numRows($rel_query) > 0) {
            while ($related = $db->getRow($rel_query)) {
                $related_cache .= related_images('news', $news_conf, $related);
            }
        }
        $cache->do_put('related_' . $news['id'], $related_cache, 3600);
    }
}
$core->tpl->setVar('RELATED', $related_cache);
$array_replace["#\\[related\\](.*?)\\[/related\\]#is"] = (!empty($related_cache) ? '\\1' : '');
$core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
$core->tpl->sources = preg_replace("#\\{%IMG:(.*?):(.*?)%\\}#is", (!empty($miniImg[(int)"\${1}"]) ? $miniImg[(int)"\${1}"] : "\${2}"), $core->tpl->sources);
$core->tpl->sources = preg_replace("#\\{%IMG:(.*?)%\\}#is", (!empty($miniImg[(int)"\${1}"]) ? $miniImg[(int)"\${1}"] : ''), $core->tpl->sources);
