<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_SWITCH')) {
    header('Location: /');
    exit;
}
global $adminTpl, $core, $db, $admin_conf, $lang;
switch ($url[3] ?? null) {
    default:
    case 'ping':
        ping();
        break;
    case 'add':
        ping_add();
        break;
    case 'edit':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        ping_add($id);
        break;
    case 'action':
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            if ($type == 'delete') {
                foreach ($_POST['checks'] as $id) {
                    delete(intval($id));
                    action_alert('urs', 'success', 'ping');
                }
            }
        } else {
            if (empty($_POST['checks'])) action_alert('urs', 'danger', 'ping');
        }
        break;
    case 'save':
        global $adminTpl, $core, $db, $lang;
        $adminTpl->admin_head($lang['ping']);
        $fid = isset($_POST['id']) ? intval($_POST['id']) : 0;
        $dir = isset($_POST['dir']) ? filter($_POST['dir']) : '';
        $port = isset($_POST['port']) ? filter($_POST['port']) : '';
        $desc = isset($_POST['desc']) ? filter($_POST['desc']) : '';
        $dir = str_ireplace(array('document.cookie'), array('d&#111;cument.cookie'), $dir);
        $dir = preg_replace(array('/javascript:/i'), array('j&#1072;vascript:'), $dir);
        $dir = preg_replace(array('/data:/i'), array('d&#1072;ta:'), $dir);
        $dir = str_replace(array('<br>'), array('\n'), $dir);
        $dir = str_replace(array('<br/>'), array('\n'), $dir);
        $port = str_ireplace(array('document.cookie'), array('d&#111;cument.cookie'), $port);
        $port = preg_replace(array('/javascript:/i'), array('j&#1072;vascript:'), $port);
        $port = preg_replace(array('/data:/i'), array('d&#1072;ta:'), $port);
        $port = str_replace(array('<br>'), array('\n'), $port);
        $port = str_replace(array('<br/>'), array('\n'), $port);
        if (!empty($dir) && !empty($port)) {
            if (isset($_POST['edit'])) {
                $core->upd_data('ping', '`dir` ="' . $db->safesql($dir) . '", `port` ="' . $db->safesql($port) . '", `desc` ="' . $db->safesql($desc) . '"', 'id ="' . $fid . '"');
                action_alert('urs', 'success', 'ping', false, 'ping_edit_ok');
                header("refresh: 5; url=" . ADMIN . "/module/ping");
            } else {
                list($check) = $core->fetch_data('ping', 'dir ="' . $dir . '" AND port ="' . $port . '"');
                if ($check > 0) {
                    action_alert('urs', 'danger', 'ping', 'add', 'ping_alt_dir');
                } else {
                    $core->ins_data('ping', 'id,dir,port,desc,active', 'NULL,"' . $db->safesql(processText($dir)) . '","' . $db->safesql(processText($port)) . '","' . $db->safesql(processText($desc)) . '",0');
                    action_alert('urs', 'success', 'ping', false, 'ping_add_ok');
                }
            }
        } else {
            $adminTpl->info($lang['base_error_1'], 'error', null, $lang['error'], $lang['go_back'], 'javascript:history.go(-1)');
        }
        $adminTpl->admin_foot();
        break;
    case 'delete':
        $id = isset($url[4]) ? intval($url[4]) : 0;
        delete($id);
        break;
}
function ping()
{
    global $adminTpl, $core, $db, $lang;
    InitCheck();
    init_count_text();
    init_refresh(true, 60);
    Scroll('search');
    Clearform('search');
    $where = 'id <> 0';
    $order = '';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_dir = isset($_POST['s_dir']) ? filter($_POST['s_dir'], 'a') : '';
    $s_port = isset($_POST['s_port']) ? filter($_POST['s_port'], 'a') : '';
    $s_desc = isset($_POST['s_desc']) ? filter($_POST['s_desc'], 'a') : '';
    $s_active = isset($_POST['s_active']);
    $s_search = isset($_POST['s_search']);
    if ($s_search) $s_search = $_POST['s_search'] == 1;
    if ($s_active) {
        if ($_POST['s_active'] == 1) {
            $where = 'active = 1';
        } else {
            $s_active = false;
            $where = 'active = 0';
        }
    } else {
        $s_active = true;
    }
    if (isset($url[3]) && $url[3] == 'order') {
        switch ($url[4]) {
            case 'abc':
                $order .= '`dir` ASC';
                break;
            case 'id':
                $order .= 'id ASC';
                break;
        }
    } else {
        $order .= 'id DESC';
    }
    if ($s_id) {
        $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
        $s_id = '';
    }
    if ($s_dir) $where .= "AND `dir` LIKE '%" . $db->safesql($s_dir) . "%'";
    if ($s_port) $where .= "AND `port` LIKE '%" . $db->safesql($s_port) . "%'";
    if ($s_desc) $where .= "AND `desc` LIKE '%" . $db->safesql($s_desc) . "%'";
    $query = $core->select_data('ping', $where, $order . ' LIMIT ' . limit_page());
    $adminTpl->admin_head($lang['ping']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
        alert_info('ping');
        echo '<div class="panel panel-dark panel-border top">
      <div class="panel-heading">
         <span class="panel-title">' . $lang['ping'] . '</span>
         ' . sort_head('urs', 4, false, true) . '
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body pn table-responsive">
         <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{MOD_LINK}/action" onclick="lihtTable(getSource(event))">
            <table class="table table-xs table-striped">
               <thead>
                  <tr>
                     <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                     <th class="col-md-4">' . $lang['ping_dir'] . '</th>
                     <th class="col-md-1 text-center">' . $lang['ping_port'] . '</th>
                     <th class="col-md-4">' . $lang['ping_desc'] . '</th>
                     <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
               </thead>
               <tbody>';
        while ($ping = $db->getRow($query)) {
            $core->upd_data('ping', 'active ="' . ping_dir($ping['dir'], $ping['port']) . '"', 'id ="' . $ping['id'] . '"');
            echo '<tr>
                     <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $ping['id'] . '</td>
                     <td>' . $ping['dir'] . '</td>
                     <td class="text-center">' . $ping['port'] . '</td>
                     <td ' . toggle($ping['desc']) . '>' . trimtitle($ping['desc'], 50) . '</td>
                     <td class="text-center">' . status_icon('ping', $ping['id']) . '</td>';
            modal_form_delete($ping['id'], $ping['dir'], $lang['ping_delete_title'], 'ping', $lang['ping_delete_text'], '{MOD_LINK}/delete/' . $ping['id']);
            init_checkbox('td', $ping['id'], false, '<li><a href = \'{MOD_LINK}/edit/' . $ping['id'] . '\'">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                              <li class="divider"></li>
                              <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $ping['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
        }
        echo '</tbody>
            </table>
            <div class="panel-footer text-right">
               <button name="submit" type="submit" id="sub" value="delete" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>
            </div>
         </form>
      </div>
   </div>';
        page_list('urs', 'ping', 'ping', $where);
        echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10";>' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['ping_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_dir" class="field prepend-icon">
               <input id="s_dir" type="text" name="s_from" placeholder="' . $lang['ping_dir'] . '" class="form-control" value="' . $s_dir . '">
               <label for="s_dir" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_port" class="field prepend-icon">
               <input id="s_port" type="text" name="s_port" placeholder="' . $lang['ping_port'] . '" class="form-control" value="' . $s_port . '">
               <label for="s_port" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['ping_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 pt10">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['ping_active'] . '</label>
            </div>
            ' . init_sfoot(true, true,false,'{MOD_LINK}') . '        
         </div>
      </form>
   </aside>
</div>';
    } else {
        list_empty('urs', 'ping', 'url', $s_search, false, true, $s_search);
    }
    $adminTpl->admin_foot();
}

function ping_add($id = null)
{
    global $adminTpl, $core, $lang;
    if (isset($id)) {
        $ping = $core->row_data('ping', 'id ="' . $id . '"');
        $dir = $ping['dir'];
        $port = $ping['port'];
        $desc = $ping['desc'];
        $admhead = $lang['edit'];
    } else {
        $dir = false;
        $port = false;
        $desc = false;
        $admhead = $lang['add'];
    }
    $adminTpl->admin_head($admhead);
    $validation_array = array(
        'dir' => array(
            'required' => array('true', $lang['add_title_err']),
            'maxlength' => array(49, str_replace('[count]', '50', $lang['count_text_err_2']))
        ),
        'port' => array(
            'required' => array('true', $lang['add_descr_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
        'desc' => array(
            'required' => array('true', $lang['add_descr_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($lang['ping']);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
    alert_info('ping');
    echo '<div class="panel panel-dark panel-border top">
   <div class="panel-heading"><span class="panel-title">' . $admhead . '</span>
   </div>
   <div class="heading-hr"></div>
   <div class="panel-body admin-form">
      <form id="admin-form" class="form-horizontal parsley-form" role="form" action="{MOD_LINK}/save" method="post">
                    <div class="form-group">
                        <label for="dir" class="col-lg-3 col-sm-3 control-label">' . $lang['title'] . '</label>
                        <div class="col-lg-5 col-md-5 col-sm-8">
                           <label for="dir" class="field prepend-icon">
                           <input id="dir" type="text" name="dir" value="' . $dir . '" onkeyup="count_down(this, \'dir\', 50)" maxlength="50" placeholder="' . $lang['ping_dir_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                           <label for="dir" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                           </label>
                           <div align="right" class="text-right">
                              <span id="char_dir"></span>
                           </div>
                           <span id="related_tag"></span>
                           <span class="input-footer text-left">' . faI('fa-bell') . $lang['ping_dir_pre1'] . '</span>
                        </div>
                     </div>
         <div class="form-group">
            <label for="port" class="col-lg-3 col-sm-3 control-label">' . $lang['ping_port'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label for="port" class="field prepend-icon">
               <input id="port" type="text" name="port" value="' . $port . '" placeholder="' . $lang['ping_port_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
               <label for="port" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
               <span class="input-footer text-left">' . faI('fa-bell') . $lang['ping_port_pre1'] . '</span>
            </div>
         </div>
          <div class="form-group">
                  <label for="desc" class="col-lg-3 col-sm-3 control-label">' . $lang['ping_desc'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="desc" class="field prepend-icon">
                     <textarea id="desc" name="desc" onkeyup="count_down(this, \'desc\', 200)" maxlength="200" placeholder="' . $lang['ping_desc_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $desc . '</textarea>
                     <label for="desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                  <div style="text-align:right;" class="text-right">
                      <span id="char_desc"></span>
                  </div>
                   <span class="input-footer text-left">' . faI('fa-bell') . $lang['tagcode_desc_alert'] . '</span>
                  </div>
                  </div>
                  </div>
   ' . init_dfoot(true, 'fa-floppy-o', 'save', 'system');
    if (isset($id)) {
        echo '<input type="hidden" name="edit" value="1">
   <input type="hidden" name="id" value="' . $id . '">';
    }
    echo '</form>
</div>';
    $adminTpl->admin_foot();
}

function delete($id)
{
    global $core;
    if (isset($id)) {
        $core->del_data('ping', 'id ="' . $id . '"');
        action_alert('urs', 'success', 'ping');
    } else {
        action_alert('urs', 'danger', 'ping', false, 'unknown_error');
    }
}