<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfig('user');
loadConfig('email');
global $db, $config, $core, $url, $user, $email_conf, $social, $smiles, $lang;
if ($config['plugin']) $plugin = new plugin;
if (!$core->auth->isUser) {
    switch ($url[1] ?? null) {
        default:
            if ($url[1] ?? '') {
                main();
            } else {
                set_title(array($lang['welcom_profile']));
                $core->tpl->loadFile('profile/login');
                $core->tpl->sources = preg_replace_callback("#\\[login\\](.*?)\\[/login\\]#is", function ($matches) use ($access_auth) {
                    if ($access_auth['twofactor'] == 0) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[twofactor\\](.*?)\\[/twofactor\\]#is", function ($matches) use ($access_auth) {
                    if ($access_auth['twofactor'] == 1) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->end();
            }
            break;
        case 'login':
            $stop = '';
            $message = '';
            $stop_info = true;
            $pin = generate_pin();
            $ip = getRealIpAddr();
            if (isset($_POST['nick']) && $user['auth_open'] > 0) {
                $nick = $user['auth_metod'] == 'nick' ? filter($_POST['nick'], 'nick') : '';
                $email = !empty($_POST['nick']) ? filter($_POST['nick'], 'email') : '';
                $where = ($user['auth_metod'] == 'nick') ? 'nick ="' . $nick . '"' : 'email ="' . $email . '"';
                $auth_metod = ($user['auth_metod'] == 'nick') ? $nick : $email;
                $access_auth = $core->row_data('users', $where);
                $password = $_POST['password'] ?? '';
                $key_pin = isset($_POST['key_pin']) ? intval($_POST['key_pin']) : '';
                $ua = getBrowser();
                $browser = $lang['browser'] . $ua['name'] . ' ' . $ua['version'] . $lang['in'] . $ua['platform'] . $lang['reports'] . $ua['userAgent'];
                $link = $config['url'] . '/profile/login';
                $ch = curl_init('https://ip-api.com/json/?lang=ru');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_HEADER, false);
                $res = curl_exec($ch);
                curl_close($ch);
                $geo = json_decode($res, true);
                $country = $geo['country'] ?? '';
                $regionName = $geo['regionName'] ?? '';
                $title = str_replace(array('[device]', '[browser]', '[geo]'), array(detect_device(), false, $country . ', ' . $regionName), $lang['email_title_text']);
                $month_list = array(null, $lang['januarys'], $lang['februarys'], $lang['marchs'], $lang['aprils'], $lang['mays'], $lang['junes'], $lang['julys'], $lang['augusts'], $lang['septembers'], $lang['octobers'], $lang['novembers'], $lang['decembers']);
                $geo = $country . ', ' . $regionName;
                $dates = date('d') . '&nbsp;' . $month_list[date('n')] . '&nbsp;' . date('Y H:i');
                if ($email_conf['access_mail'] == 1) {
                    $query = $core->select_data('email', false, 'id ASC');
                    while ($result = $db->getRow($query)) {
                        if (is_array($access_auth)) $message = $result['html_access_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%sitename%}', '{%date%}', '{%browser%}', '{%geo%}', '{%link%}', '{%url%}'), array('<', '>', $access_auth['nick'], $config['name'], $dates, $browser, $geo, $link, $config['url']), $result['access_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%sitename%}', '{%date%}', '{%browser%}', '{%geo%}', '{%link%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $access_auth['nick'], $config['name'], $dates, $browser, $geo, $link, $config['url']), $result['access_mail_text']);
                        mailSMTP($email, $result['access_mail_text'], $title, $message);
                    }
                }
                if (strlen($auth_metod) <= 0) $stop .= $lang['input_not_' . $user['auth_metod']];
                if (strlen($password) > 0) {
                    if (strlen($password) < 5 || strlen($password) > 72) $stop .= $lang['error_limit_password'];
                } else {
                    $stop .= $lang['input_not_password'];
                }
                if ($user['auth_metod'] == 'email' && (empty($email) || strlen($email) > 50 || count(explode("@", $email)) != 2)) $stop .= $lang['error_email'];
                if ($access_auth['twofactor'] == 1) {
                    if ($core->auth->pin_key($auth_metod, $password)) {
                        if ($email_conf['twofactor_mail'] == 1) {
                            $query = $core->select_data('email', false, 'id ASC');
                            while ($result = $db->getRow($query)) {
                                if (is_array($access_auth)) $message = $result['html_twofactor_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%pin%}', '{%ip%}', '{%url%}'), array('<', '>', $access_auth['nick'], $pin, $ip, $config['url']), $result['twofactor_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%pin%}', '{%ip%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $access_auth['nick'], $pin, $ip, $config['url']), $result['twofactor_mail_text']);
                                mailSMTP($access_auth['email'], $result['twofactor_mail_text'], $title, $message);
                            }
                            $core->tpl->info($lang['twofactor_alert_info']);
                            $core->upd_data('users', 'key_pin ="' . $pin . '"', 'id ="' . $access_auth['id'] . '"');
                        }
                        set_title(array($lang['welcom_profile']));
                        $core->tpl->loadFile('profile/login');
                        $core->tpl->setVar('TWOFACTOR', '<input name="nick" type="hidden" value="' . $nick . '" /><input name="password" type="hidden" value=" ' . $password . '" />');
                        $core->tpl->sources = preg_replace_callback("#\\[login\\](.*?)\\[/login\\]#is", function ($matches) use ($access_auth) {
                            if ($access_auth['twofactor'] == 0) return $matches[1];
                        }, $core->tpl->sources);
                        $core->tpl->sources = preg_replace_callback("#\\[twofactor\\](.*?)\\[/twofactor\\]#is", function ($matches) use ($access_auth) {
                            if ($access_auth['twofactor'] == 1) return $matches[1];
                        }, $core->tpl->sources);
                        $core->tpl->end();
                        $stop_info = false;
                    } elseif ($key_pin && $access_auth['key_pin'] <> $key_pin) {
                        $core->upd_data('users', 'key_pin ="' . $pin . '"', 'id ="' . $access_auth['id'] . '"');
                        if ($email_conf['twofactor_mail'] == 1 && $access_auth['twofactor'] == 1) {
                            $query = $core->select_data('email', false, 'id ASC');
                            while ($result = $db->getRow($query)) {
                                if (is_array($access_auth)) $message = $result['html_twofactor_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%pin%}', '{%url%}'), array('<', '>', $access_auth['nick'], $pin, $config['url']), $result['twofactor_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%pin%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $access_auth['nick'], $pin, $config['url']), $result['twofactor_mail_text']);
                                mailSMTP($email, $result['twofactor_mail_text'], $title, $message);
                            }
                        }
                        $stop .= $lang['input_false_pin'];
                        header("refresh: 5; url=/profile");
                    } elseif ($core->auth->pin_key($auth_metod, $password) && !$key_pin) {
                        $stop .= $lang['input_not_pin'];
                        header("refresh: 5; url=/profile");
                    } elseif ($auth_metod && $password && $access_auth['key_pin'] == $key_pin) {
                        $password = str_replace(' ', '', $password);
                        if ($core->auth->login($auth_metod, $password)) {
                            if ($email_conf['access_mail'] == 1) {
                                $query = $core->select_data('email', false, 'id ASC');
                                while ($result = $db->getRow($query)) {
                                    if (is_array($access_auth)) $message = $result['html_access_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%sitename%}', '{%date%}', '{%browser%}', '{%geo%}', '{%link%}', '{%url%}'), array('<', '>', $access_auth['nick'], $config['name'], $dates, $browser, $geo, $link, $config['url']), $result['access_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%sitename%}', '{%date%}', '{%browser%}', '{%geo%}', '{%link%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $access_auth['nick'], $config['name'], $dates, $browser, $geo, $link, $config['url']), $result['access_mail_text']);
                                    mailSMTP($email, $result['access_mail_text'], $title, $message);
                                }
                            }
                            $stop .= $config['redicret'] == 1 ? $lang['input_successfully'] : $lang['authorization_success'];
                            header("refresh: 3; url=" . $_SERVER['HTTP_REFERER'] . "/");
                            if ($config['plugin']) $plugin->login($auth_metod, $password);
                            $core->upd_data('users', 'key_pin ="' . $pin . '"', 'id ="' . $access_auth['id'] . '"');
                        } else {
                            $stop .= $config['redicret'] == 1 ? $lang['input_not_soc_succes'] : $lang['input_not_succes'];
                        }
                    }
                } else {
                    $stop .= $config['redicret'] == 1 ? $lang['input_not_soc_succes'] : $lang['input_not_succes'];
                }
                if ($stop_info) $core->tpl->info($stop);
            } else {
                $core->tpl->info($lang['auth_closed']);
            }
            break;

        case 'social_auth':
            require ROOT . 'etc/social.config.php';
            $user_auth = loadUserAuth();
            $s_key = '';
            $stop = '';
            if (isset($user_auth->provider)) {
                switch ($user_auth->provider) {
                    case 'vk':
                        $s_key = "vk_is";
                        break;
                    case 'odnoklassniki':
                        $s_key = "ok_is";
                        break;
                    case 'mailru':
                        $s_key = "mm_is";
                        break;
                    case 'yandex':
                        $s_key = "ya_is";
                        break;
                    case 'google':
                        $s_key = "gg_is";
                        break;
                    case 'facebook':
                        $s_key = "fb_is";
                        break;
                }
            } else {
                header("refresh: 0; url=" . $config['url']);
            }
            if (isset($social[$s_key]) != '0') {
                if (!($user_auth == false)) {
                    $result = $core->select_data('users', 'email ="' . $user_auth->email . '" OR provider ="' . $user_auth->provider . '" AND social_id ="' . $user_auth->socialId . '"');
                    while ($results = $db->getRow($result)) {
                        $nick = $results['nick'] ?? '';
                        if (!$results['signature'] || !$results['birthday']) {
                            $core->upd_data('users', 'avatar_auth ="' . $user_auth->avatar . '", place ="' . $user_auth->city . '", signature ="' . $user_auth->about . '", birthday ="' . $user_auth->birthday . '"', 'email ="' . $user_auth->email . '" OR provider ="' . $user_auth->provider . '" AND social_id ="' . $user_auth->socialId . '"');
                        } else {
                            $core->upd_data('users', 'avatar_auth ="' . $user_auth->avatar . '", place ="' . $user_auth->city . '"', 'email ="' . $user_auth->email . '" OR provider ="' . $user_auth->provider . '" AND social_id ="' . $user_auth->socialId . '"');
                        }
                    }
                    if ($db->numRows($result) <= 0) {
                        $core->tpl->info($lang['user_not_registered']);
                        $core->tpl->loadFile('profile/register_social');
                        $core->tpl->setVar('AVATAR', !is_null($user_auth->avatar) ? $user_auth->avatar : '');
                        $core->tpl->setVar('CAPTCHA', captcha_image());
                        $core->tpl->setVar('NAME', !is_null($user_auth->name) ? $user_auth->name : '');
                        $core->tpl->setVar('FNAME', !is_null($user_auth->first_name) ? $user_auth->first_name : '');
                        $core->tpl->setVar('LNAME', !is_null($user_auth->last_name) ? $user_auth->last_name : '');
                        $core->tpl->setVar('CITY', !is_null($user_auth->city) ? $user_auth->city : '');
                        $core->tpl->setVar('SID', !is_null($user_auth->socialId) ? $user_auth->socialId : '');
                        $core->tpl->setVar('SURL', !is_null($user_auth->socialPage) ? $user_auth->socialPage : '');
                        $core->tpl->setVar('BDAY', !is_null($user_auth->birthday) ? $user_auth->birthday : '');
                        $core->tpl->setVar('SOCIAL_ID', !is_null($user_auth->socialId) ? $user_auth->socialId : '');
                        $core->tpl->setVar('PROVIDER', !is_null($user_auth->provider) ? $user_auth->provider : '');
                        $core->tpl->setVar('WEBSITE', !is_null($user_auth->website) ? $user_auth->website : '');
                        $core->tpl->setVar('SIGNATURE', !is_null($user_auth->about) ? $user_auth->about : '');
                        $core->tpl->setVar('EMAIL', !is_null($user_auth->email) ? $user_auth->email : '');
                        $core->tpl->setVar('PHONE', !is_null($user_auth->phone) ? $user_auth->phone : '');
                        $core->tpl->setVar('SEX_1', (($user_auth->sex == 'male') ? 'selected' : ''));
                        $core->tpl->setVar('SEX_2', (($user_auth->sex == 'famale') ? 'selected' : ''));
                        $core->tpl->setVar('SEX', (($user_auth->sex == '1') ? '1' : '0'));
                        $core->tpl->setvar('DAY_LIST', Bday($userInfo['birthday']));
                        $core->tpl->setvar('MONTH_LIST', Bmonth($userInfo['birthday']));
                        $core->tpl->setvar('YEAR_LIST', Byear($userInfo['birthday']));
                        $array_replace = array("#\\[email\\](.*?)\\[/email\\]#ies" => (empty($user_auth->email) ? '"\\1"' : ''),);
                        $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
                        $core->tpl->end();
                    } else {
                        if ($social['switch'] == '0') {
                            if ($core->auth->login_social($user_auth->provider, $user_auth->socialId)) {
                                header('Location: /profile');
                            } else {
                                $no_head = true;
                                header("refresh: 0; url=" . $config['url']);
                            }
                        } else {
                            if (empty($_POST['password']) && isset($_POST['password']) && $user_auth->provider) {
                                $core->tpl->info($lang['input_not_password']);
                                header("refresh: 5; url=" . $_SERVER['HTTP_REFERER']);
                            } elseif (empty($_POST['password'])) {
                                set_title(array($lang['welcom_profile']));
                                $core->tpl->loadFile('profile/login_social');
                                $core->tpl->setVar('AVATAR', !is_null($user_auth->avatar) ? $user_auth->avatar : '');
                                $core->tpl->setVar('CAPTCHA', captcha_image());
                                $core->tpl->setVar('NAME', !is_null($user_auth->name) ? $user_auth->name : '');
                                $core->tpl->setVar('FNAME', !is_null($user_auth->first_name) ? $user_auth->first_name : $nick);
                                $core->tpl->setVar('LNAME', !is_null($user_auth->last_name) ? $user_auth->last_name : '');
                                $core->tpl->setVar('CITY', !is_null($user_auth->city) ? $user_auth->city : '');
                                $core->tpl->setVar('SID', !is_null($user_auth->socialId) ? $user_auth->socialId : '');
                                $core->tpl->setVar('SURL', !is_null($user_auth->socialPage) ? $user_auth->socialPage : '');
                                $core->tpl->setVar('BDAY', !is_null($user_auth->birthday) ? $user_auth->birthday : '');
                                $core->tpl->setVar('SOCIAL_ID', !is_null($user_auth->socialId) ? $user_auth->socialId : '');
                                $core->tpl->setVar('PROVIDER', !is_null($user_auth->provider) ? $user_auth->provider : '');
                                $core->tpl->setVar('WEBSITE', !is_null($user_auth->website) ? $user_auth->website : '');
                                $core->tpl->setVar('SIGNATURE', !is_null($user_auth->about) ? $user_auth->about : '');
                                $core->tpl->setVar('EMAIL', !is_null($user_auth->email) ? $user_auth->email : '');
                                $core->tpl->setVar('PHONE', !is_null($user_auth->phone) ? $user_auth->phone : '');
                                $core->tpl->setVar('SEX_1', (($user_auth->sex == 'male') ? 'selected' : ''));
                                $core->tpl->setVar('SEX_2', (($user_auth->sex == 'famale') ? 'selected' : ''));
                                $core->tpl->setVar('SEX', (!is_null($user_auth->sex) ? (($user_auth->sex == 'famale') ? 2 : 1) : 0));
                                $core->tpl->end();
                            } else {
                                $access_auth = $core->row_data('users', 'email ="' . $user_auth->email . '" OR provider ="' . $db->safesql($user_auth->provider) . '" AND social_id ="' . $db->safesql($user_auth->socialId) . '"', false, '`nick`,`email`, `group`');
                                $acc_auth = ($user['auth_metod'] == 'nick') ? $access_auth['nick'] : $user_auth->email;
                                if (!(($access_auth['group'] == '1') && ($social['admin'] == '0'))) {
                                    if ($core->auth->login($acc_auth, $_POST['password'])) {
                                        if ($config['plugin']) $plugin->login($acc_auth, $_POST['password']);
                                        $core->tpl->info($lang['authorization_success']);
                                        header("refresh: 3; url=" . $_SERVER['HTTP_REFERER']);
                                    } else {
                                        unset($_SESSION['user_auth']);
                                        $core->tpl->info($lang['input_not_password']);
                                        header("refresh: 5; url=" . $config['url']);
                                    }
                                } else {
                                    unset($_SESSION['user_auth']);
                                    header("refresh: 0; url=" . $config['url']);
                                }
                            }
                        }
                    }
                } else {
                    header("refresh: 0; url=" . $config['url']);
                }
            } else {
                $no_head = true;
                unset($_SESSION['user_auth']);
                header("refresh: 0; url=" . $config['url']);
            }
            break;
        case 'register':
            if ($user['off_reg'] == 1) {
                $stop = '';
                set_title(array($lang['registration']));
                require ROOT . 'etc/user.config.php';
                if (!isset($_POST['user_login'])) {
                    $core->tpl->loadFile('profile/register');
                    $core->tpl->setVar('AVATAR', avatar($core->auth->user_id));
                    $core->tpl->setVar('CAPTCHA', captcha_image());
                    $core->tpl->end();
                } else {
                    $user_login = !empty($_POST['user_login']) ? filter($_POST['user_login'], 'nick') : '';
                    $password = !empty($_POST['password']) ? $_POST['password'] : '';
                    $repassword = !empty($_POST['repassword']) ? $_POST['repassword'] : '';
                    $email = !empty($_POST['email']) ? filter($_POST['email'], 'mail') : '';
                    $avatar_auth = !empty($_POST['avatar']) ? $_POST['avatar'] : '';
                    $birthDay = !empty($_POST['birthDay']) ? intval($_POST['birthDay']) : '';
                    $birthMonth = !empty($_POST['birthMonth']) ? intval($_POST['birthMonth']) : '';
                    $birthYear = !empty($_POST['birthYear']) ? intval($_POST['birthYear']) : '';
                    $social_id = !empty($_POST['social_id']) ? $_POST['social_id'] : '';
                    $provider = !empty($_POST['provider']) ? $_POST['provider'] : '';
                    $icq = !empty($_POST['icq']) ? filter($_POST['icq'], 'a') : '';
                    $skype = !empty($_POST['skype']) ? filter($_POST['skype'], 'a') : '';
                    $surname = !empty($_POST['surname']) ? filter($_POST['surname'], 'a') : '';
                    $name = !empty($_POST['name']) ? filter($_POST['name'], 'a') : '';
                    $place = !empty($_POST['place']) ? filter($_POST['place'], 'a') : '';
                    $phone = !empty($_POST['phone']) ? filter($_POST['phone'], 'a') : '';
                    $ochestvo = !empty($_POST['ochestvo']) ? filter($_POST['ochestvo'], 'a') : '';
                    $sex = !empty($_POST['sex']) ? intval($_POST['sex']) : '';
                    $hobby = !empty($_POST['hobby']) ? filter($_POST['hobby'], 'a') : '';
                    $signature = !empty($_POST['signature']) ? stripslashes($core->bbDecode(html2bb(parseBB($_POST['signature'])))) : '';
                    $activate = ($user['with_activate'] == 1) ? '0' : '1';
                    if (jmy_strlen($user_login) > 100) $stop .= $lang['error_long_login'];
                    if (preg_match("/[\||\'|\<|\>|\"|\!|\]|\?|\$|\@|\/|\\\|\&\~\*\+]/", $user_login)) $stop .= $lang['error_characters_login'];
                    if (jmy_strlen($surname) > 100) $stop .= $lang['error_long_surname'];
                    if (preg_match("/[\||\'|\<|\>|\"|\!|\]|\?|\$|\@|\/|\\\|\&\~\*\+]/", $surname)) $stop .= $lang['error_characters_surname'];
                    if (jmy_strlen($place) > 100) $stop .= $lang['error_long_place'];
                    if (preg_match("/[\||\'|\<|\>|\"|\!|\]|\?|\$|\@|\/|\\\|\&\~\*\+]/", $place)) $stop .= $lang['error_characters_place'];
                    if (jmy_strlen($email) > 50) $stop .= $lang['error_long_email'];
                    if (!preg_match("/^(?:[a-z0-9]+(?:[-_.]?[a-z0-9]+)?@[a-z0-9_.-]+(?:\.?[a-z0-9]+)?\.[a-z]{2,5})$/i", $email)) $stop .= $lang['error_characters_email'];
                    if ($birthDay && $birthMonth && $birthYear) {
                        $birthDate = $birthDay . '.' . $birthMonth . '.' . $birthYear;
                        $unixBirth = gmmktime(0, 0, 0, $birthMonth, $birthDay, $birthYear);
                        $age = mb_substr((time() - $unixBirth) / 31536000, 0, 2);
                    } else {
                        $birthDate = '';
                        $age = '';
                    }
                    if (strlen($password) > 0) {
                        if (strlen($password) < 5 || strlen($password) > 72) {
                            $stop .= $lang['error_limit_password'];
                        } else {
                            if (!empty($user_login) && !empty($password) && !empty($repassword) && !empty($email) && ($password == $repassword)) {
                                if (eregStrt('/', $user_login)) $error = $lang['profile_error1'];
                                if (captcha_check('securityCode') && empty($error)) {
                                    list($check) = $core->fetch_data('users', 'nick ="' . $db->safesql($user_login) . '" OR email ="' . $db->safesql($email) . '"');
                                    if ($check > 0) {
                                        $stop .= $lang['profile_error2'];
                                        if (!isset($_SESSION)) session_start();
                                        unset($_SESSION['user_auth']);
                                    } else {
                                        $tail = gencode(rand(6, 11));
                                        if (empty($social_id)) {
                                            $core->auth->register($user_login, $password, $tail, $email, $icq, $skype, $phone, $surname, $name, $ochestvo, $age, $sex, $birthDate, $hobby, $signature, 2, $activate, filter($_SERVER['REMOTE_ADDR']));
                                        } else {
                                            $core->auth->register_social($user_login, $password, $tail, $email, $social_id, $provider, $birthDate, $avatar_auth, $icq, $skype, $surname, $name, $ochestvo, $age, $sex, $hobby, $signature, 1, 2, $phone, getRealIpAddr());
                                        }
                                        if ($config['plugin']) $plugin->registration($user_login, $password, $tail, $email, $icq, $skype, $surname, $name, $ochestvo, $age, $sex, $hobby, $signature, $activate, filter($_SERVER['REMOTE_ADDR']));
                                        $stop .= $lang['welcom_profile'];
                                        if (($user['with_activate'] == 1) && (empty($social_id))) {
                                            $formatemail = str_replace(array('@', '.'), array('@', '.'), $email);
                                            $validationlink = $config['url'] . '/profile/activate/' . $formatemail . '/' . mb_substr(md5($formatemail . 'eduard_laas_loh'), 0, 10);
                                            $stop .= $lang['letter_instructions'];
                                            if ($email_conf['reg_mail'] == 1) {
                                                $query = $core->select_data('email', false, 'id ASC');
                                                while ($result = $db->getRow($query)) {
                                                    $message = $result['html_reg_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%date%}', '{%password%}', '{%validationlink%}', '{%url%}'), array('<', '>', $user_login, formatDate(time(), true), $password, $validationlink, $config['url']), $result['reg_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%date%}', '{%password%}', '{%validationlink%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $user_login, formatDate(time(), true), $password, $validationlink, $config['url']), $result['reg_mail_text']);
                                                    if (!empty($email)) {
                                                        mailSMTP($email, $result['html_reg_mail'], $lang['reg_confirm'] . $config['name'], $message);
                                                    } else {
                                                        $stop .= $lang['sendfalse_back'];
                                                    }
                                                }
                                            }
                                        } else {
                                            list($uid) = $core->fetch_data('users', 'nick ="' . $db->safesql($user_login) . '"');
                                            user_points($user_login, 'register');
                                            $core->ins_data('board_users', 'uid', '"' . $uid . '"');
                                        }
                                        if (isset($_FILES['avatar']) && $_FILES['avatar']['size'] > 0) {
                                            if ($foo = new Upload($_FILES['avatar'])) {
                                                $foo->file_new_name_body = 'av' . $uid;
                                                $foo->image_resize = true;
                                                $foo->image_x = $user['avatar_width'];
                                                $foo->image_ratio_y = true;
                                                $foo->file_overwrite = true;
                                                $foo->file_auto_rename = false;
                                                $foo->Process(ROOT . 'files/avatars/users/');
                                                $foo->allowed = array("image/*");
                                                if ($foo->processed) $foo->Clean();
                                            }
                                        }
                                    }
                                } else {
                                    if (empty($error)) $stop .= $lang['error_captcha'];
                                }
                            } else {
                                $stop .= $lang['error_not_filled'];
                            }
                        }
                    } else {
                        $stop .= $lang['input_not_password'];
                    }
                }
            } else {
                $core->tpl->info($lang['off_reg']);
            }
            if (isset($stop) && $stop <> '') $core->tpl->info($stop);
            break;
        case 'forgot_pass':
            set_title(array($lang['lost_pas']));
            if (!isset($_POST['email'])) {
                $core->tpl->loadFile('profile/password');
                $core->tpl->setVar('CAPTCHA', captcha_image());
                $core->tpl->end();
            } else {
                $where = '';
                if (filter($_POST['email'], 'mail')) {
                    $email = filter($_POST['email'], 'mail');
                    $where = "WHERE email='" . $db->safesql($email) . "'";
                    $not_found = $lang['error_email_not_found'];
                } else {
                    $email = filter($_POST['email'], 'nick');
                    $where = "WHERE nick='" . $db->safesql($email) . "'";
                    $not_found = $lang['error_nick_not_found'];
                }
                if (!empty($email)) {
                    list($uid, $nick, $email) = $core->fetch_data('users', $where, 'id, nick, email');
                    if ($uid > 0) {
                        if (captcha_check('securityCode')) {
                            $formatemail = str_replace(array('@', '.'), array('@', '.'), $email);
                            $lostlink = '<a href="' . $config['url'] . '/profile/forgotPass/' . $formatemail . '/' . mb_substr(md5($formatemail . 'eduard_laas_loh'), 0, 10) . '">' . $config['url'] . '/profile/forgotPass/' . $formatemail . '/' . mb_substr(md5($formatemail . 'eduard_laas_loh'), 0, 10) . '</a>';
                            if ($email_conf['lost_mail'] == 1) {
                                require_once ROOT . '/boot/mail.class.php'; // подключаем класс
                                $query = $core->select_data('email', false, 'id ASC');
                                while ($result = $db->getRow($query)) {
                                    $message = $result['html_lost_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%date%}', '{%lostlink%}', '{%url%}'), array('<', '>', $nick, formatDate(time(), true), $lostlink, $config['url']), $result['lost_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%date%}', '{%lostlink%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $nick, formatDate(time(), true), $lostlink, $config['url']), $result['lost_mail_text']);
                                    mailSMTP($email, $result['lost_mail_text'], $lang['lost_pass'], $message);
                                }
                            }
                            $core->tpl->info($lang['letter_confirmation']);
                        } else {
                            $core->tpl->info($lang['error_captcha']);
                        }
                    } else {
                        $core->tpl->info($not_found);
                    }
                } else {
                    location('profile/forgot_pass');
                }
            }
            break;
        case 'forgotPass':
            if (isset($url[1]) && isset($url[2])) {
                $email = $url[2];
                $formatemail = filter(str_replace(array('[gav]', '[dot]'), array('@', '.'), $email), 'mail');
                if (!empty($formatemail)) {
                    $md5 = $url[3];
                    list($uid, $nick) = $core->fetch_data('users', 'email ="' . $db->safesql($formatemail) . '"', 'id, nick');
                    if ($md5 == mb_substr(md5($email . 'eduard_laas_loh'), 0, 10) && $nick) {
                        $new_pass = gencode(10);
                        $tail = gencode(rand(6, 11));
                        $core->auth->forgotPass($new_pass, $tail, $uid);
                        if ($config['plugin']) $plugin->forgot_pass($new_pass, $tail, $uid);
                        require_once ROOT . '/boot/mail.class.php'; // подключаем класс
                        $query = $core->select_data('email', false, 'id ASC');
                        while ($result = $db->getRow($query)) {
                            $message = $result['html_lost_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%date%}', '{%password%}', '{%url%}'), array('<', '>', $nick, formatDate(time(), true), $new_pass, $config['url']), $result['new_password_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%date%}', '{%password%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $nick, formatDate(time(), true), $new_pass, $config['url']), $result['new_password_mail_text']);
                            mailSMTP($email, $result['new_password_mail_text'], $lang['lost_pass'], $message);
                        }
                        $core->tpl->info($lang['letter_new_password']);
                    } else {
                        location();
                    }
                } else {
                    location('profile');
                }
            } else {
                location();
            }
            break;
        case 'activate':
            if (isset($url[1]) && isset($url[2])) {
                $email = $url[2];
                $md5 = $url[3];
                if ($md5 == mb_substr(md5($email . 'eduard_laas_loh'), 0, 10)) {
                    $formatemail = filter(str_replace(array('[gav]', '[dot]'), array('@', '.'), $email), 'mail');
                    if (!empty($formatemail)) {
                        $core->auth->activate($formatemail);
                        list($uid) = $core->fetch_data('users', 'email ="' . $db->safesql($formatemail) . '"');
                        user_points($uid, 'register');
                        $core->ins_data('board_users', 'uid,thanks,messages,specStatus,lastUpdate', '"' . $uid . '",0,0,0,0');
                        $core->tpl->info($lang['account_activated']);
                    } else {
                        location('profile');
                    }
                } else {
                    $core->tpl->info($lang['account_not_activated']);
                }
            }
            break;
    }
} else {
    switch ($url[1] ?? null) {
        default:
            main();
            break;
        case 'edit':
            set_title(array($lang['edit_profile']));
            if (isset($_POST['surname'])) {
                $surname = !empty($_POST['surname']) ? filter($_POST['surname'], 'a') : '';
                $name = !empty($_POST['name']) ? filter($_POST['name'], 'a') : '';
                $ochestvo = !empty($_POST['ochestvo']) ? filter($_POST['ochestvo'], 'a') : '';
                $timezones = !empty($_POST['timezones']) ? filter($_POST['timezones']) : '';
                $birthDay = !empty($_POST['birthDay']) ? intval($_POST['birthDay']) : 0;
                $birthMonth = !empty($_POST['birthMonth']) ? intval($_POST['birthMonth']) : 0;
                $birthYear = !empty($_POST['birthYear']) ? intval($_POST['birthYear']) : 0;
                $bday_visibility = !empty($_POST['bday_visibility']) ? intval($_POST['bday_visibility']) : 0;
                $gender = !empty($_POST['gender']) ? intval($_POST['gender']) : 0;
                $no_mail = !empty($_POST['no_mail']) ? intval($_POST['no_mail']) : 0;
                $audio_alert = !empty($_POST['audio_alert']) ? intval($_POST['audio_alert']) : 0;
                $phone = !empty($_POST['phone']) ? $_POST['phone'] : '';
                $avatar_link = !empty($_POST['avatar_link']) ? filter($_POST['avatar_link'], 'url') : '';
                $pimage_link = !empty($_POST['pimage_link']) ? filter($_POST['pimage_link'], 'url') : '';
                $deleteAvatar = !empty($_POST['deleteAvatar']) ? $_POST['deleteAvatar'] : '';
                $deletePimage = !empty($_POST['deletePimage']) ? $_POST['deletePimage'] : '';
                $signature = !empty($_POST['signature']) ? stripslashes($core->bbDecode(html2bb(parseBB($_POST['signature'])))) : '';
                $mail = !empty($_POST['mail']) ? filter($_POST['mail'], 'mail') : '';
                $hobby = !empty($_POST['hobby']) ? filter($_POST['hobby'], 'a') : '';
                $icq = !empty($_POST['icq']) ? filter($_POST['icq'], 'a') : '';
                $skype = !empty($_POST['skype']) ? filter($_POST['skype'], 'a') : '';
                $place = !empty($_POST['place']) ? filter($_POST['place'], 'a') : '';
                $oldpass = !empty($_POST['oldpass']) ? $_POST['oldpass'] : '';
                $newpass = !empty($_POST['newpass']) ? $_POST['newpass'] : '';
                $renewpass = !empty($_POST['renewpass']) ? $_POST['renewpass'] : '';
                $xfield = $_POST['xfield'] ?? '';
                $xfieldT = isset($_POST['xfieldT']) ? ($_POST['xfieldT']) : '';

                $twofactor = !empty($_POST['twofactor']) ? $_POST['twofactor'] : '';
                $key_pin = false;
                $attempt = false;
                $banned_time = false;

                if ($birthDay && $birthMonth && $birthYear) {
                    $birthDate = $birthDay . '.' . $birthMonth . '.' . $birthYear;
                    $unixBirth = gmmktime(0, 0, 0, $birthMonth, $birthDay, $birthYear);
                    $age = mb_substr((time() - $unixBirth) / 31536000, 0, 2);
                } else {
                    $birthDate = '';
                    $age = '';
                }
                $access = $core->row_data('users', 'id=' . $core->auth->user_id . ' AND active= 1', false, 'id, password, tail');
                if (isset($oldpass) && $oldpass <> '') {
                    if (md5(mb_substr(md5(md5($oldpass)), 0, -mb_strlen($access['tail'])) . $access['tail']) == $access['password']) {
                        if ($newpass && $renewpass) {
                            if ($newpass == $renewpass) {
                                $core->auth->updatePassword($newpass);
                                if ($config['plugin']) $plugin->updatePassword($newpass);
                            } else {
                                $error[] = $lang['error_password_match'];
                            }
                        } else {
                            $error[] = $lang['error_new_password'];
                        }
                    } else {
                        $error[] = $lang['error_old_password'];
                    }
                } else {
                    $error[] = $lang['profile_saved'];
                }
                if (isset($_POST['deleteAvatar'])) deleteAvatar($core->auth->user_id);
                if (isset($_POST['deletePimage'])) deletePimage($core->auth->user_id);
                if (empty($mail)) {
                    $mail = '';
                    $error[] = $lang['error_email_format'];
                }
                $fieldsSer = '';
                if (!empty($xfield)) {
                    foreach ($xfield as $xId => $xContent) {
                        if (!empty($xContent) && $xId > 0 && !empty($xfieldT[$xId])) {
                            $xContent = processText(filter($xContent, 'html'));
                            $xId = intval($xId);
                            $xfieldT[$xId] = processText(filter($xfieldT[$xId], 'title'));
                            $fileds[$xId] = array($xfieldT[$xId], $xContent);
                        }
                    }
                    $fieldsSer = serialize($fileds);
                }
                $groups = $core->row_data('users', 'id=' . $core->auth->user_id);
                $core->auth->updateProfile($mail, $timezones, $icq, $skype, $phone, $surname, $name, $no_mail, $audio_alert, $ochestvo, $place, $age, $gender, $birthDate, $hobby, $signature, '', $bday_visibility, $twofactor, $key_pin, $attempt, $banned_time, $avatar_link, $deleteAvatar, $pimage_link, $deletePimage, $groups['group']);
                if ($config['plugin']) $plugin->updateProfile($mail, $timezones, $icq, $skype, $phone, $surname, $name, $no_mail, $audio_alert, $ochestvo, $place, $age, $gender, $birthDate, $hobby, $signature, '', $bday_visibility, $twofactor, $key_pin, $attempt, $banned_time, $avatar_link, $deleteAvatar, $pimage_link, $deletePimage, $groups['group']);
                if (isset($_FILES['avatar']) && $_FILES['avatar']['size'] > 0) {
                    deleteAvatar($core->auth->user_id);
                    if ($foo = new Upload($_FILES['avatar'])) {
                        $foo->file_new_name_body = 'av' . $core->auth->user_id;
                        $foo->image_resize = true;
                        $foo->image_x = $user['avatar_width'];
                        $foo->image_ratio_y = true;
                        $foo->file_overwrite = true;
                        $foo->file_auto_rename = false;
                        $foo->Process(ROOT . 'files/avatars/users/');
                        $foo->allowed = array("image/*");
                        if ($foo->processed) $foo->Clean();
                    }
                    $error[] = $lang['profile_saved'];
                }
                if (isset($_FILES['pimage']) && $_FILES['pimage']['size'] > 0) {
                    deletePimage($core->auth->user_id);
                    if ($foo = new Upload($_FILES['pimage'])) {
                        $foo->file_new_name_body = 'pi' . $core->auth->user_id;
                        $foo->image_resize = true;
                        $foo->image_x = $user['pimage_width'];
                        $foo->image_ratio_y = true;
                        $foo->file_overwrite = true;
                        $foo->file_auto_rename = false;
                        $foo->Process(ROOT . 'files/avatars/profile_image/');
                        $foo->allowed = array("image/*");
                        if ($foo->processed) $foo->Clean();
                    }
                } elseif (!empty($pimage_link) && eregStrt('http://', $pimage_link) && file_get_contents($pimage_link)) {
                    $error[] = $lang['profile_saved'];
                }
                if (isset($error)) {
                    $txt = '';
                    foreach ($error as $msg) {
                        $txt .= $msg . '<br/>';
                    }
                    $core->tpl->info($txt);
                }
            }
            $userInfo = $core->auth->user_info ?: $core->row_data('users', 'id ="' . $core->auth->user_info['id'] . '"');
            $bb = bb_area('signature', $userInfo['signature'] ? stripslashes($core->bbDecode(html2bb(parseBB($userInfo['signature'])))) : '', 5, 'textarea', 'onchange="caa(this);"', true, true);
            $core->tpl->loadFile('profile/edit');
            $core->tpl->sources = preg_replace_callback("#\\{%AVATAR_LOAD%\\}(.*?)\\{%/AVATAR_LOAD%\\}#is",
                function ($matches) use ($user) {
                    if ($user['avatar_load']) return $matches[1];
                }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\{%PIMAGE_LOAD%\\}(.*?)\\{%/PIMAGE_LOAD%\\}#is",
                function ($matches) use ($user) {
                    if ($user['pimage_load']) return $matches[1];
                }, $core->tpl->sources);
            $core->tpl->setvar('BB_AREA', $bb);
            preg_match("#\\[xfield_tpl\\](.*?)\\[/xfield_tpl\\]#is", $core->tpl->sources, $matchEmpty);
            if (isset($matchEmpty[1])) {
                $xfiled_tpl = $matchEmpty[1];
                $fields = unserialize($core->auth->user_info['fields']);
//$core->tpl->sources = preg_replace(array("#\\[xfield_tpl\\](.*?)\\[/xfield_tpl\\]#is","#\\[list\\](.*?)\\[/list\\]#is"), array(($numRes == 0 ? '\\1' : ''), $messList), $core->tpl->sources);
                $xfileds = '';
                $queryF = $core->select_data('xfields', 'module ="profile" AND to_user = 1');
                if ($db->numRows($queryF) > 0) {
                    while ($xfield = $db->getRow($queryF)) {
                        if ($xfield['type'] == 3) {
                            $dxfield = array_map('trim', explode("\n", $xfield['content']));
                            $xfieldChange = '<select class="form-control" name="xfield[' . $xfield['id'] . ']">';
                            foreach ($dxfield as $xfiled_content) {
                                $xfieldChange .= '<option value="' . $xfiled_content . '" ' . (isset($fields[$xfield['id']][1]) && $fields[$xfield['id']][1] == $xfiled_content ? 'selected' : '') . '>' . $xfiled_content . '</option>';
                            }
                            $xfieldChange .= '</select>';
                        } elseif ($xfield['type'] == 6) {
                            $xfieldChange = '<div class="form-control">
   <input id="xfield[' . $xfield['id'] . ']" name="xfield[' . $xfield['id'] . ']" type="radio" ' . ($xfield['content'] == 0 ? 'checked' : '') . ' value="0">
   <label for="xfield[' . $xfield['id'] . ']" class="padding inputTitle">' . $lang['no'] . '</label>
   <input id="xfield[' . $xfield['id'] . ']" name="xfield[' . $xfield['id'] . ']" type="radio" ' . ($xfield['content'] == 1 ? 'checked' : '') . ' value="1">
   <label for="xfield[' . $xfield['id'] . ']" class="padding inputTitle">' . $lang['yes'] . '</label>
</div>';
                        } elseif ($xfield['type'] == 5) {
                            $xfieldChange = '<input id="xfield[' . $xfield['id'] . ']" name="xfield[' . $xfield['id'] . ']" ' . ($xfield['content'] ? 'checked' : '') . ' type="checkbox"  value="' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '">';
                        } elseif ($xfield['type'] == 4) {
                            $xfieldChange = '<textarea class="form-control" name="xfield[' . $xfield['id'] . ']" >' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '</textarea>';
                        } elseif ($xfield['type'] == 2) {
                            $xfieldChange = '<textarea class="form-control" name="xfield[' . $xfield['id'] . ']" >' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '</textarea>';
                        } else {
                            $xfieldChange = '<input type="text" class="form-control" name="xfield[' . $xfield['id'] . ']" value="' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '">';
                        }
                        $xfileds .= preg_replace(array('@{%XTITLE%}@', '@{%XBODY:\[(.*?)\]%}@ise'), array($xfield['title'], "str_replace('{addition}', stripslashes('\\1'), '<input type=\"hidden\" name=\"xfieldT[" . $xfield['id'] . "]\" value=\"" . $xfield['title'] . "\">'.\$xfieldChange);"), $xfiled_tpl);
                    }
                    $yesField = true;
                    $core->tpl->setVar('XFIELDS', $xfileds);
                }
            }
            $geoip = geo_ip::getInstance(ROOT . 'media/geo_ip.dat');
            $flag = $geoip->lookupCountryCode(!empty($userInfo['ip']) ? $userInfo['ip'] : '127.0.0.1');
            foreach ($smiles as $tag => $param) {
                if ($param['cat'] == 'flags') {
                    $saurl = str_replace($config['url'] . '/', '', $param['url']);
                    $surl = trimtitle($param['url'], 30);
                    $abridged = isset($param['abridged']) ? ' ( ' . $param['abridged'] . ' )' : '';
                    if ($flag == $param['abridged']) $url_flags = '<img src="' . $param['url'] . '" title="' . $param['title'] . $abridged . '" class="img-responsive mw30 ib br4" border="0" alt=""/>';
                } else {
                    $url_flags = '';
                }
            }
            $uflag = ($flag != 'UN') ? $url_flags : '<img src="media/smiles/flags/UN.png" border="0" class="img-responsive mw30 ib br4"  title="' . $lang['undefined'] . '" alt="">';
            $birthday = explode('.', $userInfo['birthday']);
            $core->tpl->sources = preg_replace(array("#\\[fields\\](.*?)\\[/fields\\]#is", "#\\[xfield_tpl\\](.*?)\\[/xfield_tpl\\]#is"), array((isset($yesField) ? '\\1' : ''), ''), $core->tpl->sources);
            $core->tpl->setvar('AWIDTH', $user['avatar_width']);
            $core->tpl->setvar('AHEIGHT', $user['avatar_height']);
            $core->tpl->setVar('AVATAR', avatar($userInfo['id']));
            $core->tpl->setVar('NICK', $userInfo['nick'] ?: $lang['unspecif']);
            $core->tpl->setVar('PIMAGE', pimage($userInfo['id']));
            $core->tpl->setvar('HOBBY', $userInfo['hobby']);
            $core->tpl->setvar('GENDER_LIST', Gender($userInfo['sex']));
            $core->tpl->setvar('DAY_LIST', Bday($birthday[0]));
            $core->tpl->setvar('MONTH_LIST', Bmonth($birthday[1]));
            $core->tpl->setvar('YEAR_LIST', Byear($birthday[2]));
            $core->tpl->setvar('TIMEZONES', TimeZoneList($userInfo['timezones']));
            $core->tpl->setvar('SURNAME', $userInfo['surname']);
            $core->tpl->setvar('PLACE', $userInfo['place']);
            $core->tpl->setvar('NAME', $userInfo['name']);
            $core->tpl->setvar('OCH', $userInfo['ochestvo']);
            $core->tpl->setvar('EMAIL', $userInfo['email']);
            $core->tpl->setvar('ICQ', $userInfo['icq']);
            $core->tpl->setvar('SKYPE', $userInfo['skype']);
            $core->tpl->setvar('phone', $userInfo['phone'] == '0' ? '' : $userInfo['phone']);
            $core->tpl->setvar('ASIZE', formatfilesize($user['avatar_size']));
            $core->tpl->setvar('TWOFACTOR', Twofactor($userInfo['twofactor']));
            $core->tpl->setVar('NO_MAIL', '<div class="form-group"><div class="col-lg-5 col-md-5 col-sm-8"><input type="checkbox" class="checkbox mr10" name="no_mail" ' . ($userInfo['no_mail'] ? 'checked' : '') . ' value="1"><label class="col-sm-3 control-label"> ' . (($userInfo['no_mail'] != 1) ? $lang['no_n_mail'] : $lang['n_mail']) . '</label></div></div>');
            $core->tpl->setVar('AUDIO_ALERT', '<div class="form-group"><div class="col-lg-5 col-md-5 col-sm-8"><input type="checkbox" class="checkbox mr10" name="audio_alert" ' . ($userInfo['audio_alert'] ? 'checked' : '') . ' value="1"><label class="col-sm-3 control-label"> ' . (($userInfo['audio_alert'] != 1) ? $lang['audio_alert_off'] : $lang['audio_alert_on']) . '</label></div></div>');
            $core->tpl->setVar('bday_visibility', Bday_visibility($userInfo['bday_visibility']));
            $core->tpl->setVar('COUNTRICON', $uflag);
            $core->tpl->setVar('COUNTRY', $userInfo['place'] ?: $lang['unspecif']);
            $core->tpl->sources = preg_replace_callback("#\\[country\\](.*?)\\[/country\\]#is", function ($matches) use ($flag) {
                if (!empty($flag)) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->end();
            break;
        case 'online_friends_list':
        case 'friends_list':
        case 'friends_outbox':
        case 'friends_inbox':
            friends_requests();
            break;
        case 'logout':
            $core->auth->logout();
            if (!isset($_SESSION)) session_start();
            if ($core->auth->isAdmin) $core->ins_log($core->auth->user_info['nick'], $lang['exit_login']);
            unset($_SESSION['user_auth']);
            $no_head = true;
            if ($config['plugin']) $plugin->logout();
            header("refresh: 0; url=" . $config['url']);
            break;
        case 'cleanGuests':
            $core->del_data('user_visitors', 'id ="' . $core->auth->user_id . '"');
            location('profile');
            break;
    }
}
function friends_requests(): void
{
    global $core, $db, $config, $lang, $user, $url, $user;
    $uid = $core->auth->user_id;
    $date = '';
    $title = '';
    $who = '';
    $num_inbox = 0;
    $num_outbox = 0;
    $confirmed = '0';
    $no_online = '';
    $where = "WHERE (f.who_invite = '" . $uid . "' OR f.whom_invite = '" . $uid . "')";
    if (isset($url[1])) {
        switch ($url[1]) {
            case 'friends_inbox':
                $where = "WHERE f.whom_invite = '" . $uid . "'";
                $who = 'who_invite';
                $title = array($lang['friends_inbox'], $lang['friends_sub']);
                $confirmed = '0';
                break;
            case 'friends_outbox':
                $where = "WHERE f.who_invite = '" . $uid . "'";
                $who = 'whom_invite';
                $title = array($lang['friends_outbox'], $lang['friends_sub']);
                $confirmed = '0';
                break;
            case 'friends_list':
                $where = "WHERE (f.who_invite = '" . $uid . "' OR f.whom_invite = '" . $uid . "')";
                $title = array($lang['friends'], $lang['list']);
                $who = 'who_invite';
                $confirmed = '1';
                break;
            case 'online_friends_list':
                $where = "WHERE f.whom_invite = '" . $uid . "'";
                $title = array($lang['friends'] . $lang['in_online']);
                $who = 'who_invite';
                $confirmed = '1';
                break;
        }
    }
    $query = $core->select_data('users', $where . 'AND u.id !="' . $uid . '" AND f.confirmed ="' . $confirmed . '"', false, 'u.id as uuid, u.nick, u.last_visit, u.regdate, f.*', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on(u.id = f.who_invite OR u.id = f.whom_invite)');
    if ($db->numRows($query) > 0) {
        list($num_friends) = $core->fetch_data('users', 'WHERE (f.who_invite ="' . $uid . '" OR f.whom_invite ="' . $uid . '") AND u.id !="' . $uid . '" AND f.confirmed = 1', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.id = f.who_invite OR u.id = f.whom_invite)');
        list($num_onfriends) = $core->fetch_data('online', 'WHERE (f.who_invite ="' . $uid . '" OR f.whom_invite ="' . $uid . '") AND u.uid !="' . $uid . '" AND f.confirmed = 1', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.uid = f.who_invite OR u.uid = f.whom_invite)');
        list($num_inbox) = $core->fetch_data('users', 'WHERE  f.whom_invite ="' . $uid . '" AND u.id !="' . $uid . '" AND f.confirmed = 0', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.id = f.who_invite OR u.id = f.whom_invite)');
        list($num_outbox) = $core->fetch_data('users', 'f.who_invite ="' . $uid . '"  AND u.id !="' . $uid . '" AND f.confirmed = 0', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.id = f.who_invite OR u.id = f.whom_invite)');
        list($num_faalr) = $core->fetch_data('users', 'WHERE (f.who_invite ="' . $uid . '" OR f.whom_invite ="' . $uid . '") AND u.id !="' . $uid . '" AND f.confirmed = 0', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.id = f.who_invite OR u.id = f.whom_invite)');
        $onfriends = $core->row_data('online', $where . 'AND u . uid !="' . $uid . '" AND f . confirmed = 1', false, false, 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on(u . uid = f . who_invite OR u . uid = f . whom_invite)');
        $core->tpl->loadFile('profile/friends_top');
        $core->tpl->setVar('URL_INBOX', $num_inbox ? '<a href="profile/friends_inbox">' : '<a href="profile">');
        $core->tpl->setVar('URL_OUTBOX', $num_outbox ? '<a href="profile/friends_outbox">' : '<a href="profile">');
        $core->tpl->setVar('URL_LBOX', ($num_inbox ? '<a href="profile/friends_inbox">' : '<a href="profile">') ? '<a href="profile/friends_outbox">' : '<a href="profile">');
        $core->tpl->setVar('NUM_FALLR', $num_faalr);
        $core->tpl->setVar('NUM_FINBOX', $num_inbox);
        $core->tpl->setVar('NUM_FOUTBOX', $num_outbox);
        $core->tpl->setVar('URL_FRIENDS', $num_friends ? '<a href="profile/friends_list">' : '<a href="profile">');
        $core->tpl->setVar('URL_ONFRIENDS', $num_onfriends ? '<a href="profile/online_friends_list">' : '<a href="profile">');
        $core->tpl->setVar('NUM_FRIENDS', $num_friends);
        $core->tpl->setVar('NUM_ONFRIENDS', $num_onfriends);
        $core->tpl->setVar('URL_END', '</a>');
        $core->tpl->sources = preg_replace_callback("#\\[menu\\](.*?)\\[/menu\\]#is", function ($matches) use ($uid, $user) {
            if (isset($uid) && ($uid && $user['userFriends'] == 1)) return $matches[1];
        }, $core->tpl->sources);
        $core->tpl->sources = preg_replace_callback("#\\[requests\\](.*?)\\[/requests\\]#is", function ($matches) use ($url) {
            if (isset($url[1]) && ($url[1] == 'friends_inbox' || $url[1] == 'friends_outbox')) return $matches[1];
        }, $core->tpl->sources);
        $core->tpl->sources = preg_replace_callback("#\\[friends\\](.*?)\\[/friends\\]#is", function ($matches) use ($url) {
            if (isset($url[1]) && ($url[1] == 'friends_list' || $url[1] == 'online_friends_list')) return $matches[1];
        }, $core->tpl->sources);
        $core->tpl->end('profile/friends_top');
        while ($rows = $db->getRow($query)) {
            if (($url[1] != 'online_friends_list') ? ($rows[$who] != $uid) : $core->isOnline($rows['uuid']) && $rows['uuid'] != $uid && $onfriends['uid'] == $core->isOnline($rows['uuid']) && $rows['who_invite'] == $core->isOnline($rows['uuid']) && $user['userFriends'] == 1) {
                $date = $core->isOnline($rows['uuid']) ? $lang['online'] : formatDate($rows['last_visit'], true);
                if (mb_strlen($rows['nick'], 'utf-8') > 80) $rows['nick'] = mb_substr($rows['nick'], 0, 80, $config['charset']) . '..';
                $nick = $rows['nick'];
                $from = $core->row_data('users', 'id ="' . $rows['uuid'] . '"', 'nick');
                $urlf = 'profile/' . $rows['nick'] . '"';
                $favatar = avatar($rows['uuid']);
                $uFr = getUserFriends($rows['uuid']);
                set_title($title);
                $core->tpl->loadFile('profile/friends');
                $core->tpl->setVar('ID', $uid);
                $core->tpl->setVar('NICK', $nick);
                $core->tpl->setVar('FROM', $from['nick']);
                $core->tpl->setVar('FAVATAR', $favatar);
                $core->tpl->setVar('URLF', $urlf);
                $core->tpl->setVar('LASTVIZIT', $date);
                $core->tpl->setVar('ADD_FRIEND', '<span class="_userfriends" id="friendDo' . $rows['uuid'] . '">' . ($rows['who_invite'] == $uid ? '<a href="javascript:void(0)" onclick="delFriend(' . $rows['uuid'] . ', \'friendDo' . $rows['uuid'] . '\');">' . $lang['withdraw_invitation'] . '</a>' : '<a href="javascript:void(0)" onclick="acceptFriend(' . $rows['uuid'] . ', \'friendDo' . $rows['uuid'] . '\');">' . $lang['accept_invitation'] . '</a><li><a href="javascript:void(0)" onclick="delFriend(' . $rows['uuid'] . ', \'friendDo' . $rows['uuid'] . '\');">' . $lang['give_up_friendship'] . '</a>') . '</span>');
                $core->tpl->end();
            } else {
                $no_online = true;
            }
        }
        $core->tpl->loadFile('profile/friends_down');
        $core->tpl->end('profile/friends_down');
    } else {
        set_title($title);
        $core->tpl->info($lang['no_friends'] . '<a href="javascript:history.back()" onclick="/' . $url[0] . '" >' . $lang['back'] . '</a>');
    }
    if ($no_online) $core->tpl->info($lang['no_online_friends'] . '<a href="javascript:history.back()" onclick="/' . $url[0] . '" >' . $lang['back'] . '</a>');
}

function main(): void
{
    global $db, $config, $core, $url, $user, $smiles, $lang;
    $abridged = '';
    $nF = '';
    $friends = false;
    $newFriends = false;
    $not_res = array('register', 'forgot_pass', 'login', 'activate');
    $num_inbox = 0;
    $num_outbox = 0;
    if (isset($core->auth->user_info['nick']) && isset($url[1]) && $core->auth->user_info['nick'] !== $url[1] && !in_array($url[1], $not_res)) {
        $wher = is_numeric($url[1]) ? 'id' : 'nick';
        $rows = $core->row_data('users', 'u.' . $wher . ' ="' . $db->safesql($url[1]) . '" AND u.active=1', false, 'u.*, g.name as gname, g.user as isUser, g.moderator as isModer, g.admin as isAdmin, g.showAttach, g.showHide, g.loadAttach, g.addPost, g.addComment, g.allowRating, g.maxWidth, g.maxPms, g.control, g.color, g.icon', 'as u LEFT JOIN ' . DB_PREFIX . '_groups as g ON(u.group = g.id)');
        $nick = $rows['nick'] ?? '';
    } else {
        if ($core->auth->isUser) {
            foreach ($not_res as $c) {
                if (str_contains(strtolower($c), strtolower($url[1] ?? $url[0]))) location('profile/');
            }
            $nick = $core->auth->user_info['nick'];
            $rows = $core->auth->user_info;
        }
    }
    if (isset($nick)) set_title(array($lang['welcom_profile'], $nick));
    if (isset($nick)) {
        if ($rows ?? '') {
            if ($core->auth->isUser && $core->auth->user_info['nick'] != $nick) {
                $gQuery = $core->select_data('user_visitors', 'id ="' . $rows['id'] . '" AND visitor ="' . $core->auth->user_id . '"');
                if ($db->numRows($gQuery) == 1) {
                    $core->upd_data('user_visitors', 'time ="' . time() . '"', 'id ="' . $rows['id'] . '" AND visitor ="' . $core->auth->user_id . '"');
                } else {
                    $core->ins_data('user_visitors', 'id,visitor,time', '"' . $rows['id'] . '","' . $core->auth->user_id . '","' . time() . '"');
                }
            } elseif ($core->auth->isUser && $core->auth->user_info['nick'] == $nick && $user['userFriends'] == 1) {
                $newFriends = $core->select_data('users', 'WHERE (f.who_invite ="' . $rows['id'] . '" OR f.whom_invite ="' . $rows['id'] . '") AND u.id !="' . $rows['id'] . '" AND f.confirmed = 0', false, 'u.id as uuid, u.nick, u.last_visit, u.regdate, f.*', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on(u.id = f.who_invite OR u.id = f.whom_invite)');
                if ($db->numRows($newFriends) > 0) {
                    list($num_inbox) = $core->fetch_data('users', 'WHERE  f.whom_invite ="' . $rows['id'] . '" AND u.id !="' . $rows['id'] . '" AND f.confirmed = 0', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.id = f.who_invite OR u.id = f.whom_invite)');
                    list($num_outbox) = $core->fetch_data('users', 'f.who_invite ="' . $rows['id'] . '"  AND u.id !="' . $rows['id'] . '" AND f.confirmed = 0', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.id = f.who_invite OR u.id = f.whom_invite)');
                    while ($newFr = $db->getRow($newFriends)) {
                        $nF .= '<br/>';
                        if ($newFr['who_invite'] == $rows['id']) {
                            $nF .= '<img src="' . avatar($newFr['uuid']) . '" style="width: 100px; height: 100px;"><span class="_userfriends" id="friendDo' . $newFr['uuid'] . '"><a href="profile/' . $newFr['nick'] . '" title="' . $lang['guest_page'] . '">' . $newFr['nick'] . '</a><i>' . $lang['invitation_from_your'] . '</i>  [ <a href="javascript:void(0)" onclick="delFriend(' . $newFr['uuid'] . ', \'friendDo' . $newFr['uuid'] . '\');">' . $lang['withdraw_invitation'] . '</a> ]</span>';
                            $friends = false;
                        } else {
                            $nF .= '<img src="' . avatar($newFr['uuid']) . '" style="width: 100px; height: 100px;"><span class="_userfriends" id="friendDo' . $newFr['uuid'] . '"><a href="profile/' . $newFr['nick'] . '" title="' . $lang['guest_page'] . '">' . $newFr['nick'] . '</a><i>' . $lang['invitation_to_friend'] . '</i>  [ <a href="javascript:void(0)" onclick="acceptFriend(' . $newFr['uuid'] . ', \'friendDo' . $newFr['uuid'] . '\');"><i>' . $lang['accept_invitation'] . '</i></a> - <a href="javascript:void(0)" onclick="delFriend(' . $newFr['uuid'] . ', \'friendDo' . $newFr['uuid'] . '\');"><i>' . $lang['give_up_friendship'] . '<i></a> ]</span>';
                            $friends = true;
                        }
                    }
                }
            }
            if ($core->auth->isUser && isset($nF) && $friends) $core->tpl->info($lang['friend_requests']);
            $profile_link = '';
            if ($core->auth->isUser && $core->auth->user_info['nick'] == $nick) {
                foreach (glob(ROOT . 'usr/modules/*/profile_link.php') as $fileLink) {
                    $arr = explode('/', $fileLink);
                    if (modAccess($arr[count($arr) - 2]) == 'groupOk') require_once($fileLink);
                }
                if (!empty($link)) {
                    $i = count($link);
                    $width = ceil(100 / $i);
                    $profile_link .= '<table  style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;"><tr>';
                    $d = 0;
                    foreach ($link as $id => $href) {
                        $d++;
                        $profile_link .= '<td style="width=:' . $width . ';"><div align="center">' . ($linkIcon[$id] ?? '') . ' ' . $href . '</div></td>';
                        if ($d > 5) {
                            echo '</tr><tr>';
                            $d = 0;
                        }
                    }
                    $profile_link .= '</tr></table>';
                }
                unset($link);
            }
            $user_wall = '';
            if ($user['userWall'] == 1) {
                ob_start();
                show_user_wall('profile', $rows['id'], $user['userWallNum'], false, false, false, '_US', $rows['id']);
                $user_wall = ob_get_contents();
                ob_end_clean();
            }
            carmaInit($rows['id'], $rows['nick']);
            $uFr = getUserFriends($rows['id']);
            $uGu = getUserGuests($rows['id']);
            $readBlog = $core->checkModule('blog') ? readBlog($rows['nick']) : '';
            if ($rows['user_comments'] < 0) $core->upd_data('users', 'user_comments = 0', 'id ="' . $rows['id'] . '"');
            if ($rows['user_news'] < 0) $core->upd_data('users', 'user_news = 0', 'id ="' . $rows['id'] . '"');
            $from = $core->row_data('users', 'id ="' . $rows['id'] . '"', false, 'nick');
            $exgroup = get_exgroup($rows['points'], $rows['exgroup']);
            $geoip = geo_ip::getInstance(ROOT . 'media/geo_ip.dat');
            $flag = $geoip->lookupCountryCode(!empty($rows['ip']) ? $rows['ip'] : '127.0.0.1');
            foreach ($smiles as $param) {
                if ($param['cat'] == 'flags') {
                    $saurl = str_replace($config['url'] . '/', '', $param['url']);
                    trimtitle($param['url'], 30);
                    $abridged = isset($param['abridged']) ? ' ( ' . $param['abridged'] . ' )' : '';
                    if ($flag == $param['abridged']) $url_flags = '<img src="' . $param['url'] . '" title="' . $param['title'] . $abridged . '" class="img-responsive mw30 ib br4" border="0" alt=""/>';
                } else {
                    $url_flags = '';
                }
            }
            $uflag = ($flag != 'UN') ? $url_flags : '<img src="media/smiles/flags/UN.png" border="0" class="img-responsive mw30 ib br4"  title="' . $lang['undefined'] . '" alt="">';
            $core->tpl->loadFile('profile/profile');
            $core->tpl->setVar('AVATAR', avatar($rows['id']));
            $core->tpl->setVar('PIMAGE', pimage($rows['id']));
            $core->tpl->setVar('FROM', $from['nick'] ?: $lang['unspecif']);
            $core->tpl->setVar('NICK', $rows['nick'] ?: $lang['unspecif']);
            $core->tpl->setVar('UID', $rows['id']);
            $core->tpl->setVar('SURNAME', $rows['surname']);
            $core->tpl->setVar('CARMA', ($rows['carma'] > 0) ? '+' . $rows['carma'] : $rows['carma']);
            $core->tpl->setVar('NAME', $rows['name'] ?: $lang['unspecif']);
            $core->tpl->setVar('POINTS', $rows['points']);
            $core->tpl->setVar('COUNTRICON', $uflag);
            $core->tpl->setVar('COUNTRY', $rows['place'] ?: $lang['unspecif']);
            $core->tpl->setVar('ICQ', $rows['icq'] ?: $lang['unspecif']);
            $core->tpl->setVar('SKYPE', $rows['skype'] ?: $lang['unspecif']);
            $core->tpl->setVar('HOBBY', $rows['hobby'] ?: $lang['unspecif']);
            $core->tpl->setVar('SIGNATURE', $rows['signature'] ? stripslashes($core->bbDecode(html2bb(parseBB($rows['signature'])))) : $lang['unspecif']);
            $core->tpl->setVar('SEX', Gender_stat($rows['sex']));
            $core->tpl->setVar('LASTVIZIT', formatDate($rows['last_visit'], true));
            $core->tpl->setVar('OTCH', $rows['ochestvo'] ? $rows['ochestvo'] . '<br/>' : '');
            $core->tpl->setVar('AGE', $rows['age'] ?: $lang['unspecif']);
            $core->tpl->setVar('EXGROUP', isset($exgroup['color']) ? colorSpan($exgroup['color'], $exgroup['name']) : '');
            $core->tpl->setVar('GROUP', isset($rows['color']) ? colorSpan($rows['color'], $rows['gname']) : '');
            $core->tpl->setVar('GROUP_ICON', $rows['icon'] ?? '');
            $core->tpl->setVar('EXGROUP_ICON', $exgroup['icon'] ?? '');
            $core->tpl->setVar('FRIENDS', $user['userFriends'] == 1 ? $uFr[0] : '');
            $core->tpl->setVar('GUESTS', $user['userFriends'] == 1 ? $uGu : '');
            $core->tpl->setVar('BLOG_READ', $user['readBlog'] == 1 ? ($core->checkModule('blog') ? $readBlog : '') : '');
            $core->tpl->setVar('NEWFRIENDS', $nF ?? '');
            $core->tpl->setVar('USER_COMMENTS', $rows['user_comments']);
            $core->tpl->setVar('USER_WALL', $user_wall);
            $core->tpl->setVar('PROFILE_LINK', $profile_link);
            $core->tpl->setVar('USER_NEWS', $rows['user_news']);
            $core->tpl->setVar('REGDATE', formatDate($rows['regdate'], true));
            $core->tpl->setVar('BDATE', (($rows['bday_visibility'] == '1') ? date('d.m.Y', strtotime($rows['birthday'])) : date('d', strtotime($rows['birthday'])) . '&nbsp;' . con_month(date('m', strtotime($rows['birthday'])))));
            $core->tpl->setVar('CLEAN_GUESTS', isset($core->auth->user_info['nick']) && $core->auth->user_info['nick'] == $nick ? '<a href="profile/cleanGuests" title="' . $lang['clear_list'] . '"><strong>' . $lang['clear_guest_list'] . '</strong></a>' : '');
            $core->tpl->setVar('NEWFRIENDSNUM', isset($nF) ? $db->numRows($newFriends) : '');
            $core->tpl->setVar('ADD_FRIEND', ($core->auth->isUser && $user['userFriends'] == 1 && $core->auth->user_info['nick'] != $nick) ? (in_array($core->auth->user_id, $uFr[1]) ? '<div class="line" id="friendDo"><a href="javascript:void(0)" onclick="delFriend(' . $rows['id'] . ', \'friendDo\');">' . $lang['remove_from_friends'] . '</a></div>' : '<div class="line" id="friendDo"><a href="javascript:void(0)" onclick="addFriend(' . $rows['id'] . ');">' . $lang['add_from_friends'] . '</a></div>') : '');
            $core->tpl->setVar('TIMEZONES', $rows['timezones'] ?: $lang['unspecified']);
            $core->tpl->setVar('ONLINE', ($core->isOnline($rows['id']) ? $lang['online'] : formatDate($rows['last_visit'], true)));
            $core->tpl->setVar('OFFLINE', ($core->isOffline($rows['id']) ? $lang['offline'] : formatDate($rows['last_visit'], true)));
            $core->tpl->setVar('carma_plus', '<a href="javascript:void(0)" rel="tooltip" alt="' . $lang['carma_raise_reputation'] . '" title="' . $lang['carma_raise_reputation'] . '" onclick="javascript:modal_box(\'carma\')">');
            $core->tpl->setVar('carma_story', '<a href="javascript:void(0)" alt="' . $lang['carma_history_user'] . '" title="' . $lang['carma_history_user'] . '" onclick="carmaHistory();">');
            $core->tpl->setVar('carma_minus', '<a href="javascript:void(0)" rel="tooltip" alt="' . $lang['carma_omit_reputation'] . '" title="' . $lang['carma_omit_reputation'] . '" onclick="javascript:modal_box(\'carma\')">');
            $core->tpl->setVar('rcarma', '</a>');
            $core->tpl->setVar('URL_INBOX', '<a href="profile/friends_inbox">');
            $core->tpl->setVar('URL_OUTBOX', '<a href="profile/friends_outbox">');
            $core->tpl->setVar('NUM_FINBOX', $num_inbox);
            $core->tpl->setVar('NUM_FOUTBOX', $num_outbox);
            $core->tpl->setVar('URL_END', '</a>');
            $core->tpl->sources = preg_replace_callback("#\\[menu](.*?)\\[/menu]#is", function ($matches) use ($rows, $user) {
                if ($user['userFriends'] == 1 && $rows['id']) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[exgroup](.*?)\\[/exgroup]#is", function ($matches) use ($exgroup) {
                if (!empty($exgroup)) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[group_icon](.*?)\\[/group_icon]#is", function ($matches) use ($rows) {
                if (!empty($rows['icon'])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[exgroup_icon](.*?)\\[/exgroup_icon]#is", function ($matches) use ($exgroup) {
                if (!empty($exgroup['icon'])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[friends](.*?)\\[/friends]#is", function ($matches) use ($uFr, $user) {
                if ($user['userFriends'] == 1 && $uFr[0] != '') return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[userGuests](.*?)\\[/userGuests]#is", function ($matches) use ($uGu, $user) {
                if ($user['userGuests'] == 1 && $uGu != '') return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[newFriends](.*?)\\[/newFriends]#is", function ($matches) use ($nF, $user) {
                if ($user['userFriends'] == 1 && $nF != '') return $matches[1];
            }, $core->tpl->sources);
            $mblog = modAccess('blog');
            $core->tpl->sources = preg_replace_callback("#\\[blog](.*?)\\[/blog]#is", function ($matches) use ($mblog) {
                if (modAccess('blog') == 'groupOk') return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[blogRead](.*?)\\[/blogRead]#is", function ($matches) use ($user, $core, $readBlog) {
                if ($user['readBlog'] == 1 && ($core->checkModule('blog') ? $readBlog : '')) return $matches[1];
            }, $core->tpl->sources);
            $mgallery = modAccess('gallery');
            $core->tpl->sources = preg_replace_callback("#\\[gallery](.*?)\\[/gallery]#is", function ($matches) use ($mgallery) {
                if (modAccess('gallery') == 'groupOk') return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[name](.*?)\\[/name]#is", function ($matches) use ($rows) {
                if (!empty($rows['name'])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[country](.*?)\\[/country]#is", function ($matches) use ($flag) {
                if (!empty($flag)) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[online](.*?)\\[/online]#is", function ($matches) use ($rows) {
                if (($rows['last_visit'] + 1200 >= time())) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[isuser](.*?)\\[/isuser]#is", function ($matches) use ($url) {
                if (empty($url[1])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[nouser](.*?)\\[/nouser]#is", function ($matches) use ($url) {
                if (!empty($url[1])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[wall](.*?)\\[/wall]#is", function ($matches) use ($user) {
                if ($user['userWall'] == 1) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[editmenu](.*?)\\[/editmenu]#is", function ($matches) use ($core) {
                if ($core->auth->user_id) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[offline](.*?)\\[/offline]#is", function ($matches) use ($rows, $core) {
                if ($core->isOffline($rows['id'])) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[carma](.*?)\\[/carma]#is", function ($matches) use ($core) {
                if ($core->auth->user_id) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[carma_plus](.*?)\\[/carma_plus]#is", function ($matches) use ($core) {
                if ($core->auth->user_id) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[carma_minus](.*?)\\[/carma_minus]#is", function ($matches) use ($core) {
                if ($core->auth->user_id) return $matches[1];
            }, $core->tpl->sources);
            $core->tpl->sources = preg_replace_callback("#\\[userViews](.*?)\\[/userViews]#is", function ($matches) use ($rows) {
                if ($rows['bday_visibility']) return $matches[1];
            }, $core->tpl->sources);
            $xfield = '';
            $array_replace = array();
            if (!empty($rows['fields'])) {
                $fields = unserialize($rows['fields']);
                foreach ($fields as $xId => $xData) {
                    if (!empty($xData[1])) {
                        $xfqwery = $core->row_data('xfields', 'id ="' . $xId . '" AND module="profile" AND to_user= 1');
                        if ($xfqwery['type'] == 6 && $xfqwery['content'] == 1) {
                            $array_replace["#\\[xfield_value:" . $xId . "\\]#is"] = $lang['yes'];
                        } elseif ($xfqwery['type'] == 6 && $xfqwery['content'] == 0) {
                            $array_replace["#\\[xfield_value:" . $xId . "\\]#is"] = $lang['no'];
                        } else {
                            $array_replace["#\\[xfield_value:" . $xId . "\\]#is"] = $xData[1];
                        }
                        $xfield .= '<b>' . $xData[0] . '</b>: ' . $xData[1] . '<br/>';
                    }
                }
                $core->tpl->sources = preg_replace(array_keys($array_replace), array_values($array_replace), $core->tpl->sources);
            }
            $profile_fields = $rows['fields'];
            $core->tpl->sources = preg_replace_callback("#\\[xfield:([0-9]*?)](.*?)\\[/xfield:([0-9]*?)]#is",
                function ($match) use ($profile_fields) {
                    return ifFields($profile_fields, $match[1], $match[2]);
                }, $core->tpl->sources);
            $editmenu = '<head>
<script type="text/javascript">
   function editmenu(id)
   {
   var menu = document.getElementById(\'menu_\' + id).style;
   if (menu.display == \'none\')
   {
   menu.display = \'block\';
   }
   else
   {
   menu.display = \'none\';
   }
   }
</script>
</head>
<a href="javascript:void(0);" onclick="javascript:editmenu(\'1\'); return false;" class="btn btn-xs btn-primary"><i class="flaticon-edit"></i>' . $lang['edit'] . '</a>
<ul id="menu_1" style="display:none;">
<div id="dropmenudiv" class="ui-menu">
<ul class="ui-menu">
<li>{%AFLAG%}{%AIP%}</li>
<li>{%ADMIN%}</li>
<li>{%EDIT%}</li>
<li>{%MESSAGE%}</li>
<li>{%ABAN%}</li>
</ul>
</div>
</ul>';
            $core->tpl->setVar('XFIELDS', $xfield);
            $core->tpl->setVar('EDITMENU', $editmenu);
            $core->tpl->setVar('EDIT', $core->auth->user_info['nick'] == $nick ? ' <a href="profile/edit">' . $lang['edit_profile'] . '</a>' : '');
            $core->tpl->setVar('MESSAGE', $core->auth->user_info['nick'] == $nick || $core->auth->isUser ? '<a href="pm/write/' . $nick . '">' . $lang['pm_send'] . '</a> ' : '');
            $core->tpl->setVar('ADMIN', $core->auth->isAdmin ? '<a href="' . ADMIN . '/user/edit/' . $rows['id'] . '">' . $lang['edit_profile_full'] . '</a>' : '');
            $core->tpl->setVar('ABAN', $core->auth->isAdmin ? '<a href="' . ADMIN . '/user/ban/' . $rows['id'] . '">' . $lang['user_ban'] . '</a>' : '');
            $core->tpl->setVar('AIP', $core->auth->isAdmin ? 'IP: ' . $rows['ip'] : '');
            $core->tpl->setVar('AFLAG', $core->auth->isAdmin ? $uflag : '');
            $core->tpl->end();
        } else {
            $core->tpl->info($lang['user_not_found']);
            header("refresh: 5; url=" . $config['url']);
        }
    } elseif (isset($wher) && empty($nick)) {
        set_title(array($lang['user_not_found']));
        $core->tpl->info($lang['user_not_found']);
        header("refresh: 5; url=" . $config['url']);
    } else {
        set_title(array($lang['welcom_profile']));
        $core->tpl->loadFile('profile/login');
        $core->tpl->end();
    }
}