<?php
/*
 * @name        JMY CORE
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2022 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 */
if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
function show_poll($type = false, $pollId = false)
{
    global $db, $core, $lang;
    $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : getenv('HTTP_X_FORWARDED_FOR');
    $query = $core->select_data('polls', ($pollId ? 'p.id = "' . $pollId . '" AND p.active = 1 GROUP BY q.pid' : ''), ($pollId ? '' : 'GROUP BY q.pid ORDER BY p.title'), 'p.id as poll_id, p.title, p.votes, p.max, p.active, GROUP_CONCAT(q.id) as var_ids, GROUP_CONCAT(q.variant) as variants, GROUP_CONCAT(q.vote) as var_votes, GROUP_CONCAT(DISTINCT v.uid) as uid, GROUP_CONCAT(DISTINCT v.ip) as ip', 'AS p INNER JOIN  ' . DB_PREFIX . '_poll_questions AS q ON (p.id = q.pid) LEFT JOIN ' . DB_PREFIX . '_poll_voting as v ON (' . ($core->auth->isUser ? 'v.uid = ' . $core->auth->user_id : 'v.ip = "' . getRealIpAddr() . '"') . ' and v.pid = p.id)');
    $var_vote = array();
    if ($db->numRows($query) > 0) {
        $poll = $db->getRow($query);
        $var_ids = explode(',', $poll['var_ids']);
        $variants = explode(',', $poll['variants']);
        $var_votes = explode(',', $poll['var_votes']);
        $vars = array();
        $list = '';
        foreach ($var_ids AS $key => $val) {
            $vars[$val] = str_replace('||', ',', $variants[$key]);
            $var_vote[$val] = $var_votes[$key];
        }
        unset ($var_ids, $variants, $var_votes);
        $core->tpl->loadFile('blocks/poll');
        preg_match("#\\[viewList\\](.*?)\\[/viewList\\]#si", $core->tpl->sources, $matches);
        $viewList = !empty($matches[1]) ? $matches[1] : $matches[2];
        $core->tpl->sources = preg_replace_callback("#\\[viewList\\](.*?)\\[/viewList\\]#is", function ($matches) use ($viewList) {
            if ($viewList == false) return $matches[1]; else return;
        }, $core->tpl->sources);
        $core->tpl->setVar('TITLE', $poll['title']);
        $core->tpl->setVar('ID', $poll['poll_id']);
        $core->tpl->setVar('VOTES', $poll['votes']);
        $result = false;
        ksort($vars);
        switch ($type) {
            default:
                if (($core->auth->isUser && $poll['uid'] == $core->auth->user_id) || $poll['ip'] == getRealIpAddr()) {
                    $voted = true;
                    $nvoted = false;
                } else {
                    $voted = false;
                    $nvoted = true;
                }
                $i = 0;
                foreach ($vars as $id => $variant) {
                    $i++;
                    if (($core->auth->isUser && $poll['uid'] == $core->auth->user_id) || $poll['ip'] == $ip) {
                        $percent[$id] = $poll['votes'] > 0 ? round(($var_vote[$id] / $poll['votes']) * 100) : 0;
                        $list .= str_replace(array('{%VARIANT%}', '{%VARVOTE%}', '{%PERCENT%}', '{%NUMB%}', '{%PERCENTWIDTH%}'), array($variant, $var_vote[$id], $percent[$id], $i, ($percent[$id] == 0 ? 2 : ($percent[$id] - 5))), $viewList);
                        $poll_voting = $core->row_data('poll_voting', 'ip = "' . $ip . '" and uid = "' . $core->auth->user_id . '"');
                        if (isset($poll_voting['qid'])) {
                            $poll_questions = $core->row_data('poll_questions', 'id = "' . $poll_voting['qid'] . '"');
                            $user_votes = $poll_voting['qid'] ? $lang['poll_for'] . colorSpan('blue', $poll_questions['variant']) : '';
                        } else {
                            $user_votes = '';
                        }
                    } else {
                        $list .= $poll['max'] > 1 ? '<div class="poll_check"><input type="checkbox" name="check[]" value="' . $id . '"  onclick="check(this, \'' . $poll['max'] . '\');" /> ' . $variant . ' </div>' : '<div class="poll_check"><input type="radio" name="check[]" value="' . $id . '" /> ' . $variant . ' </div>';
                        $user_votes = '';
                    }
                    if ($i == 5) $i = 0;
                }
                break;
            case 'results':
                $result = true;
            case 'voted':
                $voted = true;
                $nvoted = false;
                $i = 0;
                foreach ($vars as $id => $variant) {
                    $i++;
                    $percent[$id] = $poll['votes'] > 0 ? round(($var_vote[$id] / $poll['votes']) * 100) : 0;
                    $list .= str_replace(array('{%VARIANT%}', '{%VARVOTE%}', '{%PERCENT%}', '{%NUMB%}', '{%PERCENTWIDTH%}'), array($variant, $var_vote[$id], $percent[$id], $i, ($percent[$id] == 0 ? 2 : ($percent[$id] - 5))), $viewList);
                    $user_votes = '';
                    if ($i == 5) $i = 0;
                }
                break;
        }
        $core->tpl->setVar('LIST', $list);
        $core->tpl->setVar('CHECKS', $user_votes);
        $core->tpl->sources = preg_replace_callback("#\\[voted\\](.*?)\\[/voted\\]#is", function ($matches) use ($voted) {
            if ($voted) return $matches[1];
        }, $core->tpl->sources);
        $core->tpl->sources = preg_replace_callback("#\\[novoted\\](.*?)\\[/novoted\\]#is", function ($matches) use ($nvoted) {
            if ($nvoted) return $matches[1];
        }, $core->tpl->sources);
        $core->tpl->sources = preg_replace_callback("#\\[result\\](.*?)\\[/result\\]#is", function ($matches) use ($result) {
            if ($result) return $matches[1];
        }, $core->tpl->sources);
        $core->tpl->sources = preg_replace_callback("#\\[poll_check\\](.*?)\\[/poll_check\\]#is", function ($matches) use ($user_votes) {
            if ($user_votes) return $matches[1];
        }, $core->tpl->sources);
        $core->tpl->end();
    } else {
        $core->tpl->info($lang['block_poll_empty']);
    }
}