<?php

/*
 * @name           JMY CORE
 * @link           https://jmy.su/
 * @copyright      Copyright (C) 2012-2025 JMY LTD
 * @license        LICENSE.txt (see attached file)
 * @version        VERSION.txt (see attached file)
 * @author         Orlov Alexsey
 */
require_once($_SERVER['DOCUMENT_ROOT'] . '/define.php');
if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}

function choice_emoticons($cat): void
{
    require ROOT . 'etc/global.config.php';
    require ROOT . 'etc/smiles.config.php';
    global $config, $smiles;
    $plugin_semo = '/usr/plugins/tinymce/plugins/emoticons/smiles';
    echo '<div style="position: fixed; height: 42px; width: 100%; left: 0; top: 0; z-index: 120; direction: ltr;">
		<div style="position: absolute; width: 100%; background: #fafafa; height: 42px; box-sizing: border-box; border-bottom: 1px solid #999;">
		  <div style="margin: 8px; padding-left: 10px; display: -webkit-box; display: -ms-flexbox; display: flex; -ms-flex-wrap: wrap; flex-wrap: wrap;">
		    <a href="' . $plugin_semo . '/smile.php" data-target="smileys-emotion" aria-controls="smileys-emotion" role="tab" data-toggle="tab" title="' . Glang('Смайлы и эмоции') . '"><img src="/media/smiles/smile/1f6031.png" style="width:30px; height: 30px;" alt="' . Glang('Смайлы и эмоции') . '"></a>
			<a href="' . $plugin_semo . '/people.php" data-target="people-body" aria-controls="people-body" role="tab" data-toggle="tab" title="' . Glang('Люди и тело') . '"><img src="/media/smiles/people/270c.png" style="width:30px; height: 30px;" alt="' . Glang('Люди и тело') . '"></a>
			<a href="' . $plugin_semo . '/animals.php" data-target="animals-nature" aria-controls="animals-nature" role="tab" data-toggle="tab" title="' . Glang('Животные и природа') . '"><img src="/media/smiles/animals/1f43f.png" style="width:30px; height: 30px;" alt="' . Glang('Животные и природа') . '"></a>
			<a href="' . $plugin_semo . '/food.php" data-target="food-drink" aria-controls="food-drink" role="tab" data-toggle="tab" title="' . Glang('Еда и напитки') . '"><img src="/media/smiles/food/1f32d.png" style="width:30px; height: 30px;" alt="' . Glang('Еда и напитки') . '"></a>
			<a href="' . $plugin_semo . '/activities.php" data-target="activities" aria-controls="activities" role="tab" data-toggle="tab" title="' . Glang('Активность') . '"><img src="/media/smiles/activities/26bd.png" style="width:30px; height: 30px;" alt="' . Glang('Активность') . '"></a>
			<a href="' . $plugin_semo . '/travel.php" data-target="travel-places" aria-controls="travel-places" role="tab" data-toggle="tab" title="' . Glang('Путешествия и местности') . '"><img src="/media/smiles/travel/2708.png" style="width:30px; height: 30px;" alt="' . Glang('Путешествия и местности') . '"></a>
			<a href="' . $plugin_semo . '/objects.php" data-target="objects" aria-controls="objects" role="tab" data-toggle="tab" title="' . Glang('Предметы') . '"><img src="/media/smiles/objects/1f380.png" style="width:30px; height: 30px;" alt="' . Glang('Предметы') . '"></a>
			<a href="' . $plugin_semo . '/symbols.php" data-target="symbols" aria-controls="symbols" role="tab" data-toggle="tab" title="' . Glang('Символы') . '"><img src="/media/smiles/symbols/1f4b1.png" style="width:30px; height: 30px;" alt="' . Glang('Символы') . '"></a>
			<a href="' . $plugin_semo . '/flags.php" data-target="flags" aria-controls="flags" role="tab" data-toggle="tab" title="' . Glang('Флаги') . '"><img src="/media/smiles/flags/1f3f3.png" style="width:30px; height: 30px;"alt="' . Glang('Флаги') . '"></a>
          </div>
		</div>
	</div>
		 <hr>
		<html>
		<head>
		<base href="' . $config['url'] . '/" />
		</head>
		<body style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;">
		<div style="padding-top: 26px;">';
    foreach ($smiles as $smile => $info) {
        if ($info['cat'] == $cat) echo '<td><img src="' . $info['url'] . '" style="margin: 1px; padding-left: 5px; width:36px; height: 36px;" border="0" title="' . Glang($info['title']) . '" onclick="smiley(\'' . $smile . '\');" class="_pointer" alt="" /></td>';
    }
    echo '</div></body></html>';
    echo '<html>

<script>
	 function smiley(finalImage) {
		parent.tinyMCE.execCommand("mceInsertContent",false,finalImage);
		parent.tinyMCE.activeEditor.windowManager.close();
	}
</script>
</html>';
}

function Glang($text)
{
    global $config;
    return Gtranslate($text, ($config['lang'] == 'ru' ? 'en' : 'ru'), $config['lang']);
}

function Gtranslate($text, $old, $new)
{
    $res = file_get_contents("https://translate.googleapis.com/translate_a/single?client=gtx&ie=UTF-8&oe=UTF-8&dt=bd&dt=ex&dt=ld&dt=md&dt=qca&dt=rw&dt=rm&dt=ss&dt=t&dt=at&sl=" . $old . "&tl=" . $new . "&hl=hl&q=" . urlencode($text), $_SERVER['DOCUMENT_ROOT'] . "/transes.html");
    $res = json_decode($res);
    return $res[0][0][0] ?? null;
    return $res;
}