<!DOCTYPE html>
<html lang="ru">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="HandheldFriendly" content="true">
    <meta name="format-detection" content="telephone=no">
    <meta name="viewport" content="user-scalable=no, initial-scale=1.0, maximum-scale=1.0, width=device-width">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    {%META%}
    <link rel="shortcut icon" href="{%THEME%}/assest/images/favicon.ico">
    <link rel="stylesheet" href="{%THEME%}/assest/css/font-awesome.min.css">
    <link rel="stylesheet" href="{%THEME%}/assest/css/flatWeatherPlugin.css" type="text/css"/>
    <link rel="stylesheet" href="{%THEME%}/assest/css/swiper.css" type="text/css"/>
    <link rel="stylesheet" href="{%THEME%}/assest/css/engine.css" type="text/css"/>
    <link rel="stylesheet" href="{%THEME%}/assest/css/style.css" type="text/css"/>
    <!--[if lte IE 7]>
    <link rel="stylesheet" href="{%THEME%}/assest/css/style-ie.css" type="text/css"/>
    <![endif]-->
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,400i,700&amp;subset=cyrillic,cyrillic-ext,latin-ext" rel="stylesheet"/>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" integrity="sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp" crossorigin="anonymous">
    <script type="text/javascript" src="{%THEME%}/assest/js/jquery.flatWeatherPlugin.min.js"></script>
    <script type="text/javascript" src="{%THEME%}/assest/js/jquery.ttabs.js"></script>
    <script type="text/javascript" src="{%THEME%}/assest/js/jquery.cookie.js"></script>
    <script type="text/javascript" src="{%THEME%}/assest/js/swiper.jquery.min.js"></script>
    <script type="text/javascript" src="{%THEME%}/assest/js/active.js"></script>
    [guest]
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    [/guest]
    <script type="text/javascript" src="{%THEME%}/assest/js/jquery.ihavecookies.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('body').ihavecookies({
                title: 'Разрещить сайту принимать Cookie?',
                message: 'Сайт использует файлы cookies для хранения информации. «Cookies» представляют собой файлы, которые могут использоваться сайтом для идентификации посетителей, соглашаясь вы предоставите возможность принимать файли куки, или можете их настроить самостоятельно<br/>',
                delay: 600,
                expires: 1,
                link: 'http://jmycms.ru/obrabotka_personal.html',
                onAccept: function () {
                    const myPreferences = $.fn.ihavecookies.cookie();
                    console.log('Yay! The following preferences were saved...');
                    console.log(myPreferences);
                },
                uncheckBoxes: true,
                acceptBtnLabel: 'Соглашаюсь',
                moreInfoLabel: 'Больше информации',
                cookieTypesTitle: 'Выберите, файлы куки которые хотите принимать:',
                fixedCookieTypeLabel: 'Основное',
                fixedCookieTypeDesc: 'Они необходимы для правильной работы сайта.'
            });

            if ($.fn.ihavecookies.preference('marketing') === true) {
                console.log('This should run because marketing is accepted.');
            }
        });
    </script>
    <title></title>
</head>
<body class="zoom-news">
<div class="head-line">
    <div class="head-right">
        <div class="search-block">
            [search_bloks]
            {%BLOCKS:FILE:search%}
            [/search_bloks]
        </div>
        [user]
        <div class="new-news-count" rel="{%URL_UNEWS%}">
            <i class="flaticon-image"></i>
            <a href="{%URL_UNEWS%}" title="Ваши новости"><span>{%NUM_NEWS_ON%}</span></a>
        </div>
        <div class="new-comments-count" rel="{%URL_COMMENTS%}">
            <i class="flaticon-chat-1"></i>
            <a href="{%URL_COMMENTS%}" title="Ваши комментарии"><span>{%NUM_COMMENTS%}</span></a>
        </div>
        <div class="new-bookmarks-count" rel="{%URL_BOOKMARKS%}">
            <i class="flaticon-favorites"></i>
            <a href="{%URL_BOOKMARKS%}" title="Ваши закладки"><span>{%NUM_BOOKMARKS%}</span></a>
        </div>
        [/user]
        {%tpl:profile/login%}
    </div>
</div>
{%tpl:module/lpanel%}
<div class="main-center-block">
    <div class="left-col">
        [banners_left] {%banners_left%} [/banners_left]
        <div class="main-block topchik">
            <div class="main-block-title">
                Популярные посты
            </div>
            <div class="main-block-content">
                [custom category="all" template="topnews" aviable="all" limit="3" module="news" order="views" short="DESC"]
            </div>
        </div>
        {%tpl:blockbar%}
        <div class="chiken"></div>
    </div>
    <div class="center-col">
        {%tpl:module/header%}
        <div class="content-block">
            {%module%}
            <div style="clear: both;"></div>
        </div>
    </div>
    <div class="right-col">
        [banners_right] {%banners_right%} [/banners_right]
        [outpro] [user]
        <div class="main-block">
            <div class="main-block-title">
                Лента комментариев
            </div>
            <div class="main-block-content">
                {%BLOCKS:FILE:lastcom%}
            </div>
        </div>
        <div class="main-block">
            <div class="main-block-title">
                Закладки
                <a href="{%URL_BOOKMARKS%}" title="Перейти в закладки"  class="main-block-title-link"><i>.</i><span style="text-decoration: underline;">.</span>.</a>
            </div>
            <div class="main-block-content">
                {%BLOCKS:FILE:bookmarks%}
            </div>
        </div>
        [/user][/outpro]
        [calendar_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Календарь
            </div>
            {%BLOCKS:FILE:calendar%}
        </div>
        [/calendar_bloks]
        [rss_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Новости партнеров
                <a href="/feed" title="Новости партнеров" class="main-block-title-link"><i>.</i><span style="text-decoration: underline;">.</span>.</a>
            </div>
            <div class="main-block-content bookmarks-block">
                {%BLOCKS:FILE:rss%}
            </div>
        </div>
        [/rss_bloks]
        [guestbook_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Гостевая книга
                <a href="/guestbook" title="Все отзывы" class="main-block-title-link"><i>.</i><span style="text-decoration: underline;">.</span>.</a>
            </div>
            <div class="main-block-content bookmarks-block">
                {%BLOCKS:FILE:guest%}
            </div>
        </div>
        [/guestbook_bloks]
        [topnews_bloks]
        <div class="main-block">
            <div class="main-block-title">
                ТОП Новостей сайта
                <a href="/news" title="Все новости сайта" class="main-block-title-link"><i>.</i><span style="text-decoration: underline;">.</span>.</a>
            </div>
            <div class="main-block-content">
                {%BLOCKS:FILE:topnews%}
            </div>
        </div>
        [/topnews_bloks]
        [themes_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Изменить оформление
            </div>
            <div class="main-block-content">
                {%BLOCKS:FILE:themes%}
            </div>
        </div>
        [/themes_bloks]
        [question_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Ждут Вашей помощи
                <a href="/help" title="Все вопросы" class="main-block-title-link"><i>.</i><span style="text-decoration: underline;">.</span>.</a>
            </div>
            <div class="main-block-content">
                {%BLOCKS:FILE:question%}
            </div>
        </div>
        [/question_bloks]
        [statistics_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Статистика по сайту
            </div>
            <div class="main-block-content bookmarks-block">
                {%BLOCKS:FILE:statistics%}
            </div>
        </div>
        [/statistics_bloks]
        [system_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Статистика системы
            </div>
            <div class="main-block-content bookmarks-block">
                {%BLOCKS:FILE:system%}
            </div>
        </div>
        [/system_bloks]
        [board_bloks]
        <div class="main-block">
            <div class="main-block-title">
               Форум
            </div>
            <div class="main-block-content bookmarks-block">
                {%BLOCKS:FILE:board%}
            </div>
        </div>
        [/board_bloks]
        [online_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Кто в сети
            </div>
            <div class="main-block-content bookmarks-block">
                {%BLOCKS:FILE:online%}
            </div>
        </div>
        [/online_bloks]
        [cats_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Категории
                <a href="news/cats" title="Все категории" class="main-block-title-link"><i>.</i><span style="text-decoration: underline;">.</span>.</a>
            </div>
            <div class="main-block-content bookmarks-block">
                {%BLOCKS:FILE:cats%}
            </div>
        </div>
        [/cats_bloks]
        [auth_bloks]
        <div class="main-block">
            {%BLOCKS:FILE:auth%}
        </div>
        [/auth_bloks]
        [inpro] [user]
        <div class="main-block">
            [friends_bloks]
            <div class="main-block-title">
                Друзья <a href="{%URL_FLIST%}">({%NUM_FRIENDS%})</a>
            </div>
            <div class="main-block-content">
                {%BLOCKS:FILE:friends%}
            </div>
            [/friends_bloks]
            [onlinfriends_bloks]
            <div class="main-block-title">
                Друзья онлайн <a href="{%URL_ONFLIST%}">({%NUM_ONFRIENDS%})</a>
            </div>
            <div class="main-block-content">
                {%BLOCKS:FILE:onlinfriends%}
            </div>
            [/onlinfriends_bloks]
        </div>
        [/user][/inpro]
        <div class="banner-block nmob">
            {%BLOCKS:TYPE:bannertop%}
        </div>
        [tags_bloks]
        <div class="main-block">
            <div class="main-block-title">
                Метки новостей <a href="{%URL_TAGS%}" class="main-block-title-link"><i>.</i><span style="text-decoration: underline;">.</span>.</a>
            </div>
            <div class="main-block-content tags-block">
                {%BLOCKS:FILE:tags%}
            </div>
        </div>
        [/tags_bloks]
    </div>
    <div style="clear: both;"></div>
    {%tpl:module/rpanel%}
    <div class="dark">
        {%tpl:module/footer%}
    </div>
    <!--[if IE 6]>
    <a href="http://www.microsoft.com/rus/windows/internet-explorer/worldwide-sites.aspx" class="alert"></a>
    <![endif]-->
</div>
</body>
</html>