[open]
<article class="inform hentry">
    <div class="register">
        <header class="entry-header">
            <h3 class="entry-title">[lang_tpl:registration]</h3>
        </header>
        </hr>
    </div>
    <div class="register">
        <div class="leftreg"></div>
        <div class="rightreg"></div>
    </div>
    [guest]
    <div class="register">
        [lang_tpl:registration_info1]
    </div>
    [/guest]
    [user]
    <div class="register">
        [lang_tpl:registration_info2]
    </div>
    [/user]
    <form action="profile/register" method="post" enctype="multipart/form-data">
        <div class="register">
            <div class="leftreg">[lang_tpl:login]</div>
            <div class="rightreg">
                <label for="user_login"></label><input name="user_login" id="user_login" class="inputreg" type="text" value="" onchange="check_login(gid('user_login').value, 'check_result');"/>
                <div class="descreg">
                    [lang_tpl:allow_characters]
                    <div id="check_result"></div>
                </div>
            </div>
        </div>
        <div class="register">
            <div class="leftreg">[lang_tpl:password]</div>
            <div class="rightreg">
                <label for="password"></label><input name="password" id="password" type="password" class="inputreg" value="" onblur="check_password(this.value, 'repassword');" onkeyup="return passwordChanged();"/><span toggle="#password-field" class="fa fa-fw fa-eye field_icon toggle-password login-repass form-line-tt-right"></span>
                <div class="passwordChanged">
                    <span id="strength" align="center"></span> <br>
                </div>
                <div class="descreg">
                    [lang_tpl:password_info]
                </div>
            </div>
        </div>
        <div class="register">
            <div class="leftreg">[lang_tpl:repassword]</div>
            <div class="rightreg">
                <label for="repassword"></label><input name="repassword" id="repassword" type="password" class="inputreg" value="" onblur="check_password(this.value, 'password');" required/><span toggle="#repassword-field" class="fa fa-fw fa-eye field_icon toggle-repassword login-repass form-line-tt-right"></span>
                <div class="descreg">
                    [lang_tpl:repassword_info]
                </div>
            </div>
        </div>
        <div class="register">
            <div class="leftreg">[lang_tpl:email]</div>
            <div class="rightreg">
                <label for="email"></label><input name="email" id="email" type="text" class="inputreg" value="" onchange="check_email(gid('email').value, 'check_email');" required/><br/>
                <div id="check_email" class="descreg"></div>
                <div class="descreg">
                    [lang_tpl:email_info]
                </div>
            </div>
        </div>
        <div class="register">
            <div class="leftreg"></div>
        <div class="descreg">
            <div class="l-link descreg">
            <div class="login-line">
                <div style="text-align:center;"
                    <a href="javascript:void(0)" onclick="showhide('addition')">[lang_tpl:fill_in_data]</a><br/>
                </div>
            </div>
            </div>
        </div>
        </div>
        <div id="addition" class="register" style="display:none;">
            <div class="register">
                <div class="leftreg">[lang_tpl:your_isq]</div>
                <div class="rightreg">
                    <label>
                        <input name="icq" type="text" maxlength="40" value="" class="inputreg"/>
                    </label>
                    <div class="descreg">[lang_tpl:your_isq_info]</div>
                </div>
            </div>
            <div class="register">
                <div class="leftreg">[lang_tpl:your_surname]</div>
                <div class="rightreg">
                    <label>
                        <input name="family" type="text" maxlength="40" value="" class="inputreg"/>
                    </label>
                    <div class="descreg">[lang_tpl:your_surname_info]</div>
                </div>
            </div>
            <div class="register">
                <div class="leftreg">[lang_tpl:your_name]</div>
                <div class="rightreg">
                    <label>
                        <input name="name" type="text" maxlength="40" value="" class="inputreg"/>
                    </label>
                    <div class="descreg">[lang_tpl:your_name_info]</div>
                </div>
            </div>
            <div class="register">
                <div class="leftreg">[lang_tpl:your_patronymic]</div>
                <div class="rightreg">
                    <label>
                        <input name="ochestvo" type="text" maxlength="40" value="" class="inputreg"/>
                    </label>
                    <div class="descreg">[lang_tpl:your_patronymic_info]</div>
                </div>
            </div>
            <div class="register">
                <div class="leftreg">[lang_tpl:your_gender]</div>
                <div class="rightreg">
                    <label>
                        <select name="sex">
                            <option value="0">[lang_tpl:hidden]</option>
                            <option value="1">[lang_tpl:gender_male]</option>
                            <option value="2">[lang_tpl:gender_female]</option>
                        </select>
                    </label>
                    <div class="descreg">[lang_tpl:gender_info]</div>
                </div>
            </div>
        </div>
        <div class="register">
            <div class="leftreg"></div>
            <div class="rightreg">
                <div class="descreg">[lang_tpl:registration_info3]</div>
            </div>
        </div>
        </br>
        [captcha]
        <div class="register">
            <div class="leftreg"></div>
            <div class="rightreg descreg">[lang_tpl:security_code]</br>{%CAPTCHA%}</div>
            [recaptcha:0]<br/>
            <div class="rightreg">
                <input placeholder="[lang_tpl:repeat_captcha_code]" title="[lang_tpl:pre_security_code]" type="text" name="securityCode" id="securityCode" required>
            </div>
            [/recaptcha]
        </div>
        [/captcha]</br></br></br>
        <br/>
        <div class="register">
            <div class="leftreg"></div>
            <div class="rightreg"><br/><input type="submit" value="[lang_tpl:register]" id="submit"/></div>
        </div>
    </form>
    <br style="clear:both;"/>
</article>
[/open]
<script type="text/javascript">
    function check_password(repass, id){password=gid(id).value;if(password.length>0&&repass.length>0){if(password==repass){text='[lang_tpl:repassword_ok]';gid('submit').disabled=false}else{text='[lang_tpl:repassword_error]';gid('submit').disabled=true}gid('checkPassword').innerHTML=text}else{gid('checkPassword').innerHTML=''}}
    function check_login(val, id){if(val.length>3){AJAXEngine.setPostVar('nick',encodeURI(val,true));AJAXEngine.sendRequest('ajax.php?do=check_login',id)}}
    function check_email(val, id){if(val.length>3){AJAXEngine.setPostVar('email',encodeURI(val,true));AJAXEngine.sendRequest('ajax.php?do=check_email',id)}}
    $(document).on('click', '.toggle-password', function() {
        $(this).toggleClass("fa-eye fa-eye-slash");
        const input = $("#password");
        input.attr('type') === 'password' ? input.attr('type','text') : input.attr('type','password')
    });
    $(document).on('click', '.toggle-repassword', function() {
        $(this).toggleClass("fa-eye fa-eye-slash");
        const input = $("#repassword");
        input.attr('type') === 'password' ? input.attr('type','text') : input.attr('type','password')
    });
    function passwordChanged() {
        const strength = document.getElementById('strength');
        const strongRegex = new RegExp("^(?=.{14,})(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])(?=.*\\W).*$", "g");
        const mediumRegex = new RegExp("^(?=.{10,})(((?=.*[A-Z])(?=.*[a-z]))|((?=.*[A-Z])(?=.*[0-9]))|((?=.*[a-z])(?=.*[0-9]))).*$", "g");
        const enoughRegex = new RegExp("(?=.{8,}).*", "g");
        const pwd = document.getElementById("password");
        if (pwd.value.length == 0) {
            strength.innerHTML = '[lang_tpl:type_password]';
        } else if (false == enoughRegex.test(pwd.value)) {
            strength.innerHTML =  '[lang_tpl:too_short]';
        } else if (strongRegex.test(pwd.value)) {
            strength.innerHTML = '[lang_tpl:hard]';
        } else if (mediumRegex.test(pwd.value)) {
            strength.innerHTML = '[lang_tpl:medium]';
        } else {
            strength.innerHTML = '[lang_tpl:easy]';
        }
    }
</script>