<!DOCTYPE html>
<html lang="{LANG}" xml:lang="{LANG}">
<head>
    {META}
    <meta name="theme-color" content="#535a6c">
    <meta name="format-detection" content="telephone=no">
    <meta name="viewport" content="width=device-width, height=device-height, initial-scale=0.5, maximum-scale=1.0, user-scalable=yes">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <link rel="icon" href="{ADM_THEME}/assets/images/favicon.ico" type="image/x-icon">
    <!-- Stylesheets-->
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/admin-forms.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/summernote.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/bootstrap-editable.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/bootstrap-switch.min.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/address.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/magnific-popup.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/typeahead.js-bootstrap.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/theme.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/tagmanager.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/daterangepicker.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/bootstrap-datetimepicker.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/bootstrap-colorpicker.min.css">
    <link rel="stylesheet" type="text/css" href="{ADM_THEME}/assets/css/core.css">
    {CSS}
    <!-- Fonts-->
    <link rel="stylesheet" type="text/css"
          href="//fonts.googleapis.com/css?family=Lato:300,400,600,700%7CMontserrat:400,700">
    <title></title>
    <!--[if lt IE 10]>
    <div style="background: #212121; padding: 10px 0; box-shadow: 3px 3px 5px 0 rgba(0,0,0,.3); clear: both; text-align:center; position: relative; z-index:1;">
        <a href="http://windows.microsoft.com/en-US/internet-explorer">
            <img src="{ADM_THEME}/assets/images/ie8-panel/warning_bar_0000_us.jpg" style="border:0;" height="42" width="820"                 alt="You are using an outdated browser. For a faster, safer browsing experience, upgrade for free today.">
        </a>
    </div>
    <script src="{ADM_THEME}/assets/js/html5shiv.min.js"></script>
    <![endif]-->
</head>
<body data-spy="scroll" data-target="#nav-spy" data-offset="300" class="form-editors-page {BODY_CLASS}">
<div id="main">
    <header class="navbar navbar-fixed-top bg-colorPanel sidebar-light">
        <div class="navbar-branding bg-colorPanel">
            <a href="{ADMIN}" class="navbar-brand text-uppercase">
                <i class="fa fa-check-circle fa-lg mg-r-xs"></i>
                <span class="sidebar-title pl5">JMY<b>CMS</b></span>
            </a>
            <span id="toggle_sidemenu_l" class="fa fa-bars"></span>
        </div>
        <ul class="nav navbar-nav navbar-left"></ul>
        <form enctype="multipart/form-data"
              class="navbar-form navbar-left navbar-search alt animated animated-short fadeInUp" role="form"
              action="{ADMIN}/search" method="post">
            <span class="hide visible-md-inline-block visible-lg-inline-block fa fa-search fs18"></span>
            <div class="form-group">
                <label>
                    <input type="text" name="search" placeholder="[alang:panel_search]" class="form-control bg-colorPanel">
                </label>
            </div>
        </form>
        <ul class="nav navbar-nav navbar-right">
            <li class="dropdown menu-merge">
                <div class="navbar-btn btn-group pt10">
                    <a href="#" class="btn btn-sm" data-toggle="dropdown" title="[alang:ap_choose_lang]"
                       aria-expanded="false">
                        <span class="fa fa-language"></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-right"> {LANG_CHANGE} </ul>
                </div>
            </li>
            <li>
                <div class="navbar-btn btn-group pt10">
                    <a href="{URL}" target="_blank" class="btn btn-sm" title="[alang:go_website]">
                        <span class="fa fa-globe fs15"></span>
                    </a>
                </div>
            </li>
            <li>
                <div class="navbar-btn btn-group pt10">
                    <button class="btn btn-sm request-fullscreen" title="[alang:full_screen]">
                        <span class="fa fa-arrows-alt fs15"></span>
                    </button>
                </div>
            </li>
            <li>
                <div class="navbar-btn btn-group pt10">
                    <a href="{URL_FULL}#" class="topbar-menu-toggle btn btn-sm">
                        <span class="fa fa-magic"></span>
                    </a>
                </div>
            </li>
            <li class="dropdown menu-merge mr20 pt10">
                <div class="navbar-btn btn-group">
                    <button data-toggle="dropdown" class="btn btn-sm dropdown-toggle">
                        <span class="fa fa-bell-o fs14 va-m"></span>
                        <span class="badge badge-danger">{NOTIF_NUMB}</span>
                    </button>
                    <div role="menu" class="dropdown-menu dropdown-persist w350 animated animated-shorter fadeIn">
                        <div class="panel mbn">
                            <div class="panel-menu">
								<span class="panel-icon">
									<i class="fa fa-clock-o"></i>
								</span>
                                <span class="panel-title fw600"> [alang:panel_sunmenu_notif]</span>
                            </div>
                            <div style="height: auto; max-height: 600px;"
                                 class="table nav navbar-nav navbar-right w100p panel-body panel-scroller scroller-navbar scroller-overlay scroller-pn pn">
                                <ol class="timeline-list"> {NOTIF} </ol>
                            </div>
                            <div style="text-align:center;" class="nav navbar-nav w100p panel-footer pt30"></div>
                        </div>
                    </div>
                </div>
            </li>
            <li class="dropdown menu-merge mr20">
                <div class="sidebar-user-material-content w150">
                    <img src="{AVATAR}" class="img-circle img-responsive" alt="">
                    <h6>{NICK}</h6>
                    <span class="text-size-small">{GROUPS}</span>
                </div>
            </li>
            <li class="dropdown menu-merge">
                <a href="#" data-toggle="dropdown" class="dropdown-toggle fw600 p15">
                    <span class="fa fa-angle-down"></span>
                </a>
                <ul role="menu" class="dropdown-menu list-group dropdown-persist w250">
                    <li class="dropdown-header clearfix pl15">
                        <div class="btn-group">
                            <button type="button" title="[alang:panel_hide_status]" style="width:120px;"
                                    class="btn btn-default btn-sm dropdown-toggle legitRipple" data-toggle="dropdown"
                                    style="max-width: 100px;" aria-expanded="false">
                                <a href="{ADMIN}/config/admin/" class="text-center" style="font-size:12px;">
                                    <i class="p1">{HIDE_STATUS}</i>
                                    <b class="caret-right"></b>
                                </a>
                            </button>
                            <b class="caret-right"></b>
                        </div>
                        <div class="btn-group">
                            <button type="button" title="[alang:profile]"
                                    class="btn btn-default btn-sm dropdown-toggle legitRipple" data-toggle="dropdown"
                                    style="max-width: 100px;" aria-expanded="false">
                                <a href="profile" class="text-center" style="font-size:12px;">
                                    <i class="p1">[alang:profile]</i>
                                    <b class="caret-right"></b>
                                </a>
                            </button>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <a href="pm" class="animated animated-short fadeInUp">
                            <span class="fa fa-envelope position-left"></span>[alang:panel_message]
                            <span class="label label-warning">{MESSAGES_NUMB}</span>
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="profile/friends_list" class="animated animated-short fadeInUp">
                            <span class="fa fa-user position-left"></span> [alang:panel_friends]
                            <span class="label label-warning">{FRIENDS_NUMB}</span>
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{ADMIN}/feedback" class="animated animated-short fadeInUp">
                            <span class="fa fa-bullhorn position-left"></span> [alang:panel_feedback]
                            <span class="label label-warning">{FEEDBACK_NUMB}</span>
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{ADMIN}/complaint" class="animated animated-short fadeInUp">
                            <span class="glyphicon glyphicon-thumbs-down position-left"></span>[alang:panel_complaint]
                            <span class="label label-warning">{COMPLAINT_NUMB}</span>
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{ADMIN}/support" class="animated animated-short fadeInUp">
                            <span class="fa fa-life-ring position-left"></span>[alang:panel_support]
                            <span class="label label-warning">{SUPPORT_NUMB}</span>
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{ADMIN}/config" class="animated animated-short fadeInUp">
                            <span class="fa fa-gear position-left"></span>
                            <span class="sidebar-title">[alang:panel_config]</span>
                        </a>
                    </li>
                    <li class="dropdown-footer">
                        <a href="profile/logout">
                            <span class="fa fa-power-off pr5 position-left"></span>
                            <span class="sidebar-title">[alang:panel_sunmenu_exit]</span>
                        </a>
                    </li>
                </ul>
            </li>
        </ul>
    </header>
    <aside id="sidebar_left" class="nano nano-light affix has-scrollbar sidebar-light">
        <div class="sidebar-left-content nano-content">
            <header class="sidebar-header">
                <div class="sidebar-widget search-widget hidden">
                    <div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-search"></i>
						</span>
                        <label for="sidebar-search"></label><input id="sidebar-search" type="text" placeholder="Search..." class="form-control"/>
                    </div>
                </div>
            </header>
            <ul class="nav sidebar-menu">
                <li {MENU_CHOOSE:main}>
                    <a href="{ADMIN}">
                        <span class="glyphicon glyphicon-home"></span>
                        <span class="sidebar-title">[alang:panel_menu_main]</span>
                    </a>
                </li>
                [ACTIVE_MODULE:news]
                <li>
                    <a href="#" class="accordion-toggle {MENU_OPEN:news,fm,xfields}">
                        <span class="glyphicon glyphicon-fire"></span>
                        <span class="sidebar-title">[alang:panel_menu_news]</span>
                        <span class="caret"></span>
                    </a>
                    <ul class="nav sub-nav">
                        <li {MENU_CHOOSE:news}>
                            <a href="{ADMIN}/module/news">
                                <span class="glyphicon glyphicon-modal-window"></span>
                                <span class="sidebar-title">[alang:panel_menu_news_manager]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:xfields}>
                            <a href="{ADMIN}/xfields">
                                <span class="glyphicon glyphicon-star"></span>
                                <span class="sidebar-title">[alang:panel_menu_news_xfields]</span>
                            </a>
                        </li>
                    </ul>
                </li>
                [/ACTIVE_MODULE]
                <li {MENU_CHOOSE:cats}>
                    <a href="{ADMIN}/cats">
                        <span class="glyphicon glyphicon-list"></span>
                        <span class="sidebar-title">[alang:panel_menu_news_cat]</span>
                    </a>
                </li>
                <li>
                    <a href="#" class="accordion-toggle {MENU_OPEN:user,groups,comments,moderation,voting}">
                        <span class="glyphicon glyphicon-user"></span>
                        <span class="sidebar-title">[alang:panel_menu_user]</span>
                        <span class="caret"></span>
                    </a>
                    <ul class="nav sub-nav">
                        <li {MENU_CHOOSE:user}>
                            <a href="{ADMIN}/user/user_activated">
                                <span class="glyphicon glyphicon-list-alt"></span>
                                <span class="sidebar-title">[alang:panel_menu_user_manager]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:groups}>
                            <a href="{ADMIN}/groups">
                                <span class="glyphicon glyphicon-tag"></span>
                                <span class="sidebar-title">[alang:panel_menu_user_group]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:comments}>
                            <a href="{ADMIN}/comments">
                                <span class="glyphicon glyphicon-comment"></span>
                                <span class="sidebar-title">[alang:panel_menu_user_comment]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:moderation}>
                            <a href="{ADMIN}/moderation">
                                <span class="glyphicon glyphicon-edit"></span>
                                <span class="sidebar-title">[alang:moder]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:voting}>
                            <a href="{ADMIN}/voting">
                                <span class="glyphicon glyphicon-plus-sign"></span>
                                <span class="sidebar-title">[alang:panel_menu_user_poll]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:complaint}>
                            <a href="{ADMIN}/complaint">
                                <span class="glyphicon glyphicon-thumbs-down"></span>
                                <span class="sidebar-title">[alang:panel_complaint]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:distribution}>
                            <a href="{ADMIN}/distribution">
                                <span class="glyphicon glyphicon-envelope"></span>
                                <span class="sidebar-title">[alang:panel_menu_distribution]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:feedback}>
                            <a href="{ADMIN}/feedback">
                                <span class="fa fa-bullhorn"></span>
                                <span class="sidebar-title">[alang:panel_menu_feedback]</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <li>
                    <a href="#" class="accordion-toggle {MENU_OPEN:board,blog,gallery,guestbook,content}">
                        <span class="glyphicon glyphicon-th-large"></span>
                        <span class="sidebar-title">[alang:panel_menu_com]</span>
                        <span class="caret"></span>
                    </a>
                    <ul class="nav sub-nav">
                        [ACTIVE_MODULE:board]
                        <li {MENU_CHOOSE:board}>
                            <a href="{ADMIN}/module/board">
                                <span class="glyphicon glyphicon-comment"></span>
                                <span class="sidebar-title">[alang:panel_menu_com_forum]</span>
                            </a>
                        </li>
                        [/ACTIVE_MODULE]
                        [ACTIVE_MODULE:blog]
                        <li {MENU_CHOOSE:blog}>
                            <a href="{ADMIN}/module/blog">
                                <span class="fa fa-rss-square"></span>
                                <span class="sidebar-title">[alang:panel_menu_com_blog]</span>
                            </a>
                        </li>
                        [/ACTIVE_MODULE]
                        [ACTIVE_MODULE:gallery]
                        <li {MENU_CHOOSE:gallery}>
                            <a href="{ADMIN}/module/gallery">
                                <span class="fa fa-camera-retro"></span>
                                <span class="sidebar-title">[alang:panel_menu_com_gallery]</span>
                            </a>
                        </li>
                        [/ACTIVE_MODULE]
                        [ACTIVE_MODULE:guestbook]
                        <li {MENU_CHOOSE:guestbook}>
                            <a href="{ADMIN}/module/guestbook">
                                <span class="fa fa-book"></span>
                                <span class="sidebar-title">[alang:panel_menu_com_guestbook]</span>
                            </a>
                        </li>
                        [/ACTIVE_MODULE]
                        [ACTIVE_MODULE:content]
                        <li {MENU_CHOOSE:content}>
                            <a href="{ADMIN}/module/content">
                                <span class="glyphicon glyphicon-edit"></span>
                                <span class="sidebar-title">[alang:panel_menu_com_static]</span>
                            </a>
                        </li>
                        [/ACTIVE_MODULE]
                    </ul>
                </li>
                <li {MENU_CHOOSE:config}>
                    <a href="{ADMIN}/config">
                        <span class="glyphicon glyphicon-cog"></span>
                        <span class="sidebar-title">[alang:panel_menu_config]</span>
                    </a>
                </li>
                <li>
                    <a href="#" class="accordion-toggle {MENU_OPEN:modules,blocks,templates}">
                        <span class="glyphicon glyphicon-send"></span>
                        <span class="sidebar-title">[alang:panel_menu_exp]</span>
                        <span class="caret"></span>
                    </a>
                    <ul class="nav sub-nav">
                        <li {MENU_CHOOSE:modules}>
                            <a href="{ADMIN}/modules">
                                <span class="fa fa-cloud"></span>
                                <span class="sidebar-title">[alang:panel_menu_exp_modules]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:blocks}>
                            <a href="{ADMIN}/blocks">
                                <span class="fa fa-code"></span>
                                <span class="sidebar-title">[alang:panel_menu_exp_blocks]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:tagcode}>
                            <a href="{ADMIN}/tagcode">
                                <span class="fa fa-random"></span>
                                <span class="sidebar-title">[alang:panel_menu_exp_tagcode]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:templates}>
                            <a href="{ADMIN}/templates">
                                <span class="fa fa-pencil-square-o"></span>
                                <span class="sidebar-title">[alang:panel_menu_exp_tpl]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:email}>
                            <a href="{ADMIN}/module/email">
                                <span class="glyphicon glyphicon-list-alt"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_email_template]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:feed}>
                            <a href="{ADMIN}/module/feed">
                                <span class="fa fa-rss"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_feed]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:language}>
                            <a href="{ADMIN}/language">
                                <span class="fa fa-language"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_language]</span>
                            </a>
                        </li>
                    </ul>
                </li>
                {MENU_MODULES}
                <li>
                    <a href="#"
                       class="accordion-toggle {MENU_OPEN:sitemap,smiles,db,log,statistic,includ_chart,update}">
                        <span class="glyphicon glyphicon-question-sign"></span>
                        <span class="sidebar-title">[alang:panel_menu_other]</span>
                        <span class="caret"></span>
                    </a>
                    <ul class="nav sub-nav">
                        <li {MENU_CHOOSE:sitemap}>
                            <a href="{ADMIN}/module/sitemap">
                                <span class="fa fa-sitemap"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_map]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:smiles}>
                            <a href="{ADMIN}/smiles/smile">
                                <span class="fa fa-smile-o"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_smiles]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:db}>
                            <a href="{ADMIN}/db">
                                <span class="glyphicon glyphicon-tasks"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_bd]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:log}>
                            <a href="{ADMIN}/log/all">
                                <span class="glyphicon glyphicon-info-sign"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_log]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:statistic}>
                            <a href="{ADMIN}/statistic">
                                <span class="glyphicon glyphicon-stats"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_statistic]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:redirects}>
                            <a href="{ADMIN}/module/redirects">
                                <span class="fa fa-redirects"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_redirects]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:ping}>
                            <a href="{ADMIN}/module/ping">
                                <span class="fa fa-ping"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_ping]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:banners}>
                            <a href="{ADMIN}/banners">
                                <span class="glyphicon glyphicon-shopping-cart"></span>
                                <span class="sidebar-title">[alang:panel_menu_banners]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:includ_chart}>
                            <a href="{ADMIN}/module/includ_chart">
                                <span class="fa fa-tachometer"></span>
                                <span class="sidebar-title">[alang:counter_visits]</span>
                            </a>
                        </li>
                        <li {MENU_CHOOSE:update}>
                            <a href="{ADMIN}/update">
                                <span class="glyphicon glyphicon-refresh"></span>
                                <span class="sidebar-title">[alang:panel_menu_other_update]</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="sidebar-label pt35"></li>
                <li>
                    <a href="{ADMIN}/support">
                        <span class="fa fa-life-ring"></span>
                        <span class="sidebar-title">[alang:panel_menu_other_support]</span>
                    </a>
                </li>
                <li>
                    <a href="{ADMIN}/module/documentation">
                        <span class="glyphicon glyphicon-paperclip"></span>
                        <span class="sidebar-title">[alang:panel_menu_other_documentation]</span>
                    </a>
                </li>
            </ul>
        </div>
    </aside>
    <section id="content_wrapper">
        <div id="topbar-dropmenu" class="alt">
            <div class="topbar-menu row">
                [ACTIVE_MODULE:news]
                <div class="col-xs-4 col-sm-2">
                    <a href="{ADMIN}/module/news" class="metro-tile bg-primary light">
                        <span class="glyphicon glyphicon-fire text-muted"></span>
                        <span class="metro-title">[alang:panel_menu_news]</span>
                    </a>
                </div>
                [/ACTIVE_MODULE]
                <div class="col-xs-4 col-sm-2">
                    <a href="{ADMIN}/user/user_activated" class="metro-tile bg-info light">
                        <span class="glyphicon glyphicon-user text-muted"></span>
                        <span class="metro-title">[alang:panel_menu_user]</span>
                    </a>
                </div>
                [ACTIVE_MODULE:content]
                <div class="col-xs-4 col-sm-2">
                    <a href="{ADMIN}/module/content" class="metro-tile bg-success light">
                        <span class="glyphicon glyphicon-edit text-muted"></span>
                        <span class="metro-title">[alang:panel_menu_com_static]</span>
                    </a>
                </div>
                [/ACTIVE_MODULE]
                [ACTIVE_MODULE:board]
                <div class="col-xs-4 col-sm-2">
                    <a href="{ADMIN}/module/board" class="metro-tile bg-system light">
                        <span class="glyphicon glyphicon-comment text-muted"></span>
                        <span class="metro-title">[alang:panel_menu_com_forum]</span>
                    </a>
                </div>
                [/ACTIVE_MODULE]
                [ACTIVE_MODULE:gallery]
                <div class="col-xs-4 col-sm-2">
                    <a href="{ADMIN}/module/gallery" class="metro-tile bg-alert light">
                        <span class="glyphicon glyphicon-picture text-muted"></span>
                        <span class="metro-title">[alang:panel_menu_com_gallery]</span>
                    </a>
                </div>
                [/ACTIVE_MODULE]
                [ACTIVE_MODULE:includ_chart]
                <div class="col-xs-4 col-sm-2">
                    <a href="{ADMIN}/module/includ_chart" class="metro-tile bg-alert light">
                        <span class="fa fa-tachometer text-muted"></span>
                        <span class="metro-title">[alang:counter_visit]</span>
                    </a>
                </div>
                [/ACTIVE_MODULE]
                <div class="col-xs-4 col-sm-2">
                    <a href="{ADMIN}/config" class="metro-tile bg-warning light">
                        <span class="fa fa-gears text-muted"></span>
                        <span class="metro-title">[alang:panel_menu_config]</span>
                    </a>
                </div>
            </div>
        </div>
        [CHECK_ACTIVE]
        <header id="topbar" class="text-center bg-white alt ph10 br-b-ddd">
            <div>
                <div class="text-center">{SUBNAV}</div>
            </div>
            {TOPBAR}
        </header>
        [/CHECK_ACTIVE]
        {MODULE}
    </section>
</div>
<!-- Core scripts-->
<script src="{ADM_THEME}/assets/js/core.min.js"></script>
<!-- Theme Javascript-->
<script src="{ADM_THEME}/assets/js/utility.js"></script>
<script src="{ADM_THEME}/assets/js/demo.js"></script>
<script src="{ADM_THEME}/assets/js/main.js"></script>
<script src="{ADM_THEME}/assets/js/widgets.js"></script>
<script src="{ADM_THEME}/assets/js/script.js"></script>
<script src="{ADM_THEME}/assets/js/jquery.maskedinput-1.2.2.js"></script>
<script src="{ADM_THEME}/assets/js/bootstrap-switch.min.js"></script>
{FOOT}
{UPBTN}
<script type="text/javascript">
    jQuery(function ($) {
        $("#phone").mask("+7(999) 999-9999");
    });
</script>
<script type="text/javascript">
    jQuery(document).ready(function () {
        "use strict";
        // Init Theme Core
        Core.init();
        // Init Demo JS
        Demo.init();
        $('input[id="switch"]').bootstrapSwitch('state', true, true);
        {JS_CODE}
    });
</script>
</body>
</html>